

/*          Alliance CAD System 3.0                                         */
/*             FpGen Package 1.05                                           */
/*                                                                          */
/*  Copyright(c) 93-95, MASI, CAO-VLSI Team                                 */
/*                                                                          */
/*  Author      :          Jean-Paul CHAPUT                                 */
/*  E-mail      :      cao-vlsi@masi.ibp.fr                                 */
/* ************************************************************************ */
/*  Header      :      "FpGenMGN.h"                                         */
/*                                                                          */
/*      This header file is installed as "fgnVRR.h" in the include          */
/*  directory of the Alliance distribution.                                 */



#ifndef  __FpGenMGN__
#define  __FpGenMGN__


/* ********************** FpGen Predefined Constants ********************** */


/* Constant name for internal use in modules "FpgenMBK" and "FpgenMGN".
 * Other FpGen constants that have not to be seen by the user are
 * defined in the header "FpgenMBK.h".
 */
#define        C_FgnMGN_ConModeEXPLICIT      2  /* Unsupported */
#define        C_FgnMGN_ConModeIMPLICIT      3  /* Unsupported */
#define        C_FgnMGN_ConModeDEFAULT       4
#define        C_FgnMGN_LSBIndexZero         0
#define        C_FgnMGN_MSBIndexZero         1
#define        C_FgnMGN_DEFAULTWidth        -2
#define        C_FgnMGN_DEFAULTSlice        -3
#define        C_FgnMGN_TraceModeOff         0
#define        C_FgnMGN_TraceModeOn          1

/* Constant name for FPGEN user C source files.
 */
#define        LSB_INDEX_ZERO              C_FgnMGN_LSBIndexZero
#define        MSB_INDEX_ZERO              C_FgnMGN_MSBIndexZero
#define          DEFAULT_WIDTH             C_FgnMGN_DEFAULTWidth
#define          DEFAULT_SLICE             C_FgnMGN_DEFAULTSlice
#define            TRACE_ON                C_FgnMGN_TraceModeOn
#define            TRACE_OFF               C_FgnMGN_TraceModeOff


/* The last argument for functions that have a variable number
   of parameters. */
#define        EOL        ((char*)NULL)


/* ****************** FpGen Macro-Functions Declarations ****************** */


#ifdef  __STDC__
#define   _FPROTO( arguments )  arguments
#else
#define   _FPROTO( arguments )  ()
#endif


#define  DP_TRACE( aMode )  FgnMGN_Trace( __FILE__, (long)__LINE__, aMode )


extern void  FgnMGN_Trace _FPROTO(( char *aFile, long aLine, long aMode ));
extern void  DP_DEFLOFIG _FPROTO(( char *aFigName ,
                                   long  aMaxWidth,
                                   long  aMsb0    ));
extern void  DP_SAVLOFIG _FPROTO(( void ));
extern void  DP_CONMODE _FPROTO(( long  aConMode ));
extern void  DP_LOCON _FPROTO(( char *aConName,
                                char  aConDir ,
                                char *aConSig ));
extern void  DP_FLATTEN _FPROTO(( void ));

extern void  DP_IMPORT    _FPROTO(( va_alist ));
extern void  DP_INV       _FPROTO(( va_alist ));
extern void  DP_BUFF      _FPROTO(( va_alist ));
extern void  DP_AND2      _FPROTO(( va_alist ));
extern void  DP_AND3      _FPROTO(( va_alist ));
extern void  DP_NAND2     _FPROTO(( va_alist ));
extern void  DP_NAND3     _FPROTO(( va_alist ));
extern void  DP_OR2       _FPROTO(( va_alist ));
extern void  DP_OR3       _FPROTO(( va_alist ));
extern void  DP_NOR2      _FPROTO(( va_alist ));
extern void  DP_NOR3      _FPROTO(( va_alist ));
extern void  DP_XOR2      _FPROTO(( va_alist ));
extern void  DP_XNOR2     _FPROTO(( va_alist ));
extern void  DP_NAND2MASK _FPROTO(( va_alist ));
extern void  DP_NOR2MASK  _FPROTO(( va_alist ));
extern void  DP_XNOR2MASK _FPROTO(( va_alist ));
extern void  DP_NMUX2CS   _FPROTO(( va_alist ));
extern void  DP_MUX2CS    _FPROTO(( va_alist ));
extern void  DP_MUX3CD    _FPROTO(( va_alist ));
extern void  DP_MUX3CS    _FPROTO(( va_alist ));
extern void  DP_MUX4CS    _FPROTO(( va_alist ));
extern void  DP_MUX5CS    _FPROTO(( va_alist ));
extern void  DP_MUX6CS    _FPROTO(( va_alist ));
extern void  DP_BUSE      _FPROTO(( va_alist ));
extern void  DP_NBUSE     _FPROTO(( va_alist ));
extern void  DP_ADD2S     _FPROTO(( va_alist ));
extern void  DP_ADD2F     _FPROTO(( va_alist ));
extern void  DP_ADSB2F    _FPROTO(( va_alist ));
extern void  DP_SHIFT     _FPROTO(( va_alist ));
extern void  DP_CONST     _FPROTO(( va_alist ));
extern void  DP_NUL       _FPROTO(( va_alist ));
extern void  DP_PLATCH1   _FPROTO(( va_alist ));
extern void  DP_NPLATCH1  _FPROTO(( va_alist ));
extern void  DP_PMSNW     _FPROTO(( va_alist ));
extern void  DP_PMSNWQ    _FPROTO(( va_alist ));
extern void  DP_PMS       _FPROTO(( va_alist ));
extern void  DP_PMSQ      _FPROTO(( va_alist ));
extern void  DP_PMST      _FPROTO(( va_alist ));
extern void  DP_PMSTQ     _FPROTO(( va_alist ));
extern void  DP_PDFFNW    _FPROTO(( va_alist ));
extern void  DP_PDFFNWQ   _FPROTO(( va_alist ));
extern void  DP_PDFF      _FPROTO(( va_alist ));
extern void  DP_PDFFR     _FPROTO(( va_alist ));
extern void  DP_PDFFT     _FPROTO(( va_alist ));
extern void  DP_PDFFRT    _FPROTO(( va_alist ));
extern void  DP_PDFFTQ    _FPROTO(( va_alist ));
extern void  DP_RFG1C0    _FPROTO(( va_alist ));
extern void  DP_RFG1CC    _FPROTO(( va_alist ));
extern void  DP_RFG2C0    _FPROTO(( va_alist ));
extern void  DP_RFG2CC    _FPROTO(( va_alist ));


#undef  _FPROTO


#endif
