/* 
   Version 1.2							1997/1/10

   makeexe.cmd : This file is part of the alliance 3.0 patch for OS/2 & WIN32

   Copyright (C) 1996 Christoph Jaeschke, jaeschke@item.uni-bremen.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

'@echo off'
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

PARSE ARG Par

/*
IF TRANSLATE(LEFT(subword(Par,1,1),5))='WIN32' THEN DO
	Target='win32'
	Z32Flag='-Zwin32'
	GENLIB_CFLAG1='-Zwin32'
	GENLIB_CFLAG2='-Zexe'
	GENLIB_CFLAG3=''
	BIND='NTBIND.EXE -strip'
	SHELLCMD=''
END
ELSE 
*/
IF TRANSLATE(LEFT(subword(Par,1,1),3))='EMX' THEN DO
	Target='emx'
	Z32Flag=''
	GENLIB_CFLAG1='-Zexe'
	GENLIB_CFLAG2=''
	GENLIB_CFLAG3=''
	BIND='EMXBIND.EXE -b -s -q'
	SHELLCMD='CMD.EXE /c '/* with space at end of string ! */
END
ELSE IF TRANSLATE(LEFT(subword(Par,1,1),3))='CYG' THEN DO
	Target='cyg'
	Z32Flag=''
	GENLIB_CFLAG1=''
	GENLIB_CFLAG2=''
	GENLIB_CFLAG3=''
	BIND='LD'
	SHELLCMD=''	/* start program.exe directly */
END
ELSE DO
	SAY 'Specify one of [EMX,CYG]'
	exit 1
END


DEBUGEXE='NO'		/* 'YES' let all *.exe files print some
		   	debugging informations when invoked */

removeFlag='-rm'	/* Remove a.out files after binding */ 
copyFromToolsBin='YES'	/* copy from tools/.../bin dirs befor binding */

/* ------------- Function : Main --------------- */


EMX_INC='E:/EMX/include'
REXX_ALLIANCE_BIN='\ALLIANCE\ARCHI\'Target'\BIN'
REXX_ALLIANCE_LIB='\ALLIANCE\ARCHI\'Target'\LIB'
REXX_ALLIANCE_TOOLS='\ALLIANCE\TOOLS'
ALLIANCE_BIN='/ALLIANCE/ARCHI/'Target'/BIN'
ALLIANCE_TCSHDIR=ALLIANCE_BIN'/TCSH'
ALLIANCE_BASHDIR=ALLIANCE_BIN'/BASH'

'md 'REXX_ALLIANCE_BIN'\BASH 2>nul'
'md 'REXX_ALLIANCE_BIN'\TCSH 2>nul'

IF removeFlag='-rm' then DO
	call SysFileTree REXX_ALLIANCE_BIN'\*.exe', 'datei', 'FO'
	do i=1 to datei.0
		'DEL 'datei.i
	end
end

IF TRANSLATE(copyFromToolsBin)='YES' then DO
	copyFirst='YES'
	call SysFileTree REXX_ALLIANCE_TOOLS'\BIN', 'dir', 'SDO'
	do i=1 to dir.0
		call SysFileTree dir.i'\*', 'from_datei', 'FO'
		do j=1 to from_datei.0			
			a_out_name=WORD(TRANSLATE(FILESPEC('name',from_datei.j),' ','.'),1)
			call SysFileTree REXX_ALLIANCE_BIN'\'a_out_name, 'to_datei', 'FO'
			IF (to_datei.0=0) & (a_out_name<>'INSTALLED') THEN DO
				IF copyFirst='YES' THEN
					SAY 'Copying all files from tools/../bin to archi/../bin'
				'CP 'from_datei.j' 'REXX_ALLIANCE_BIN
				CALL CHAROUT ,a_out_name' '
				copyFirst='NO'
			end
		end
	end
end
call SysFileTree REXX_ALLIANCE_BIN'\*', 'datei', 'FO'
do i=1 to datei.0
	IF POS('.EXE',TRANSLATE(datei.i)) = 0 THEN
		CALL DoBind( datei.i removeFlag )
end
CALL MakeGenlib( REXX_ALLIANCE_BIN'\genlib' )
REM 'CP e_dreal.cmd 'REXX_ALLIANCE_BIN'\'
REM 'CP e_graal.cmd 'REXX_ALLIANCE_BIN'\'
REM 'CP e_genview.cmd 'REXX_ALLIANCE_BIN'\'
SAY
'IF NOT EXIST 'REXX_ALLIANCE_BIN'\dreal.exe CP 'REXX_ALLIANCE_TOOLS'\dreal\archi\'Target'\bin\dreal.exe 'REXX_ALLIANCE_BIN'\'
'IF NOT EXIST 'REXX_ALLIANCE_BIN'\graal.exe CP 'REXX_ALLIANCE_TOOLS'\graal\archi\'Target'\bin\graal.exe 'REXX_ALLIANCE_BIN'\'
'RM sed.tmp'
return

/* ------------- Function : MakeGenlib --------------- */

MakeGenlib:

PARSE ARG PathAndName /* without exe */

   'echo ******** Compiling C Version of Genlib ********'
   'echo #define COMPILERNAME "gcc">define.tmp'
   'echo #define CFLAGS1 "'GENLIB_CFLAG1'">>define.tmp'
   'echo #define CFLAGS2 "'GENLIB_CFLAG2'">>define.tmp'
   'echo #define CFLAGS3 "'GENLIB_CFLAG3'">>define.tmp'
   'echo #define ALLIANCE_LIB "-L/alliance/archi/'Target'/lib">>define.tmp'
   'echo #define ALLIANCE_INCLUDE "-I/alliance/archi/'Target'/include">>define.tmp'
   'echo #define LIBLIST1 "-lMgn322 -lMlu413 -lMpu403 -lMcp402 -lMap405 ">>define.tmp'
   'echo #define LIBLIST2 "-lMmg402 -lMal404 -lMcl408 -lMel406 -lMhl403 ">>define.tmp'
   'echo #define LIBLIST3 "-lMsl611 -lMvl408 -lMph402 -lMlo404 -lMut316">>define.tmp'
   'cat define.tmp genlibos2.c > CFile.c'
   'IF EXIST genlib.exe RM genlib.exe'
   'IF EXIST genlib RM genlib'
   IF Target = 'emx' THEN DO
      'gcc -Zomf -o genlib.exe 'Z32Flag' -pipe -I'EMX_INC' CFile.def CFile.c'
   END
   ELSE IF Target = 'cyg' THEN DO
      'gcc -o genlib.exe 'Z32Flag' -pipe -I'EMX_INC' CFile.def CFile.c'
   END
   ELSE DO
      'gcc -o genlib 'Z32Flag' -pipe -I'EMX_INC' CFile.def CFile.c'
      BIND' genlib'
   END
   'CP genlib.exe 'PathAndName'.exe'
   'rm CFile.c'
   'rm define.tmp'
   'IF EXIST genlib.exe RM genlib.exe'
   'IF EXIST genlib RM genlib'
   'IF EXIST 'PathAndName' RM 'PathAndName'
return

/* ------------- Function : DoBind --------------- */

DoBind:

PARSE ARG PathAndName removeFlag

Name = FILESPEC('name',PathAndName)
IF Name ='genlib' then
	return	/***************** !!! **************/
'head -c 3 'PathAndName' > ExeHeader.tst'
call SysFileSearch 'd', 'ExeHeader.tst', found
'rm ExeHeader.tst'
IF found.0=1 THEN DO	/* Sollte a.out-Format sein */
	BIND' 'PathAndName
	'ECHO ********'Name': EXE ********'
	IF removeFlag = '-rm' THEN
		'RM 'PathAndName
END
ELSE DO		/* tcsh, bash or GenericGNg */
	'CP 'PathAndName' 'PathAndName'.tmp'
	'echo s!/bin/rm!rm!g>sed.tmp'
	'echo s!/bin/chmod!chmod!>>sed.tmp'
	'echo s!/bin/echo!echo!>>sed.tmp'
	'echo s!/dev/null!nul!>> sed.tmp'
	'echo s/\([^g]\)awk/\1gawk/>>sed.tmp'
/* genpat */
	/* compile and link	*/
	'echo /$CC.*$LOCAL_RES/s/$CC/$CC 'Z32Flag'/>> sed.tmp'
	/* appended bind after link	*/
	'echo /-o $LOCAL_RES/a\>>sed.tmp'
	'echo 	'BIND' $LOCAL_RES\>>sed.tmp'
	'echo 	rm $LOCAL_RES\>>sed.tmp'
	'echo 	touch $LOCAL_RES>>sed.tmp'
	/* execute	*/
 	'echo s!^^\( *\)$LOCAL_RES!\1'SHELLCMD'$LOCAL_RES.exe!>> sed.tmp'
	/* clean	*/
	'echo s!$RM -f $LOCAL_RES!$RM -f $LOCAL_RES.exe $LOCAL_RES!>> sed.tmp'
/* fpgen */
	/* compile 	*/
	"echo /$CC.*FITMK_FPGICP/s/$CC/$CC "Z32Flag"/>> sed.tmp"
	/* link 	*/
	"echo /$CC.*$ROOT \\/s/$CC/$CC "Z32Flag"/>> sed.tmp"
	/* appended bind after link	*/
	'echo /$ROOT.ld.log 1/a\>>sed.tmp'
	'echo 	'BIND' $ROOT\>>sed.tmp'
	'echo 	rm $ROOT\>>sed.tmp'
	'echo 	touch $ROOT>>sed.tmp'
	/* execute	*/
	'echo s!$ROOT $ARGUMENTS!'SHELLCMD'$ROOT.exe $ARGUMENTS!>> sed.tmp'
	/* clean	*/
	'echo s/$RM -f $ROOT /$RM -f $ROOT.exe $ROOT />> sed.tmp'
/* rest... */
/* not necessary ??? */
	'echo s!^^frin!'SHELLCMD'frin.exe!>>sed.tmp'
	'echo s!^^frout!'SHELLCMD'frout.exe!>>sed.tmp'
	'echo s!^^x2y!'SHELLCMD'x2y.exe!>>sed.tmp'
	'echo s!^^vticheops!'SHELLCMD'vticheops.exe!>>sed.tmp'

	'SED -f sed.tmp < 'PathAndName'.tmp > 'PathAndName
	'RM 'PathAndName'.tmp'
	'HEAD -n1 'PathAndName' > FirstLine'
	CALL CheckAndAssembleDefineTmp( Name)
	'rm FirstLine'
	CALL BuildExe( PathAndName )
END
return

/* ------------- Function : CheckAndAssembleDefineTmp --------------- */

CheckAndAssembleDefineTmp:

PARSE ARG ExeName

	call SysFileSearch 'GenericGNg', 'FirstLine', found
	IF found.0=1 THEN DO
		'ECHO ********'ExeName': GenericGNg ********'
		'echo #define EXECSHELL "GenericGNg">define.tmp'
		IF removeFlag = '-rm' THEN
			'RM 'PathAndName
	END
	ELSE DO
		call SysFileSearch 'tcsh', 'FirstLine', found
		IF found.0=1 THEN DO
			'ECHO ********'ExeName': tcsh ********'
			'echo #define EXECSHELL "tcsh">define.tmp'
			'echo #define EXPANDPATH "/TCSH">>define.tmp'
			'CP 'PathAndName' 'ALLIANCE_TCSHDIR'/'
			IF removeFlag = '-rm' THEN
				'RM 'PathAndName
		END
		ELSE DO
			'ECHO ********'ExeName': bash ********'
			'echo #define EXECSHELL "bash">define.tmp'
			'echo #define EXPANDPATH "/BASH">>define.tmp'
			'CP 'PathAndName' 'ALLIANCE_BASHDIR'/'
			IF removeFlag = '-rm' THEN
				'RM 'PathAndName
		END
	END
	'echo #define EXECNAME "'ExeName'">>define.tmp'
	IF DEBUGEXE='YES' THEN
		'echo #define DEBUG>>define.tmp'
return

/* ------------- Function : BuildExe --------------- */

BuildExe:

PARSE ARG ExePathAndName

	'cat define.tmp CFileBdyOS2.c > CFile.c'
	IF Target = 'emx' THEN DO
		'gcc -o tmp -Zomf -Zexe -pipe -I'EMX_INC' CFile.def CFile.c'
	END
	ELSE DO
		'gcc -o tmp 'Z32Flag' -pipe -I'EMX_INC' CFile.def CFile.c'
		BIND' tmp'
	END
	'mv tmp.exe 'ExePathAndName'.exe'
	'rm CFile.c'	
	'rm define.tmp'
	'rm tmp'
return
