/* 
   Version 1.2							1997/1/10

   patch.cmd : This file is part of the alliance 3.0 patch for OS2 & WIN32

   Copyright (C) 1996 Christoph Jaeschke, jaeschke@item.uni-bremen.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

"@echo off"
CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
CALL SysLoadFuncs

reallydo="YES"			/* "NO" only shows what "YES" would really do */
BuildLexYac="NO"		/* "YES" rebuild the *.lex and *.yac files */
Debug="YES"			/* Include debugging information */
WITH_FREEMEM="YES"		/* ??? */

PARSE ARG Par

SAY
IF (WORDS(Par)<2) | (WORDS(Par)>3) then DO
	CALL syntax
	exit 1
END
Par = TRANSLATE(Par)

IF LEFT(subword(Par,1,1),3)='X11' THEN DO
	IF Right(subword(Par,1,1),1)='+' THEN DO
		X11='YES'
				/* "YES" if you have the X11 lib's installed */
		CALL libcheckX11
	END
	ELSE
		X11='NO'
END
ELSE DO
	CALL syntax
	exit 1
END
IF LEFT(subword(Par,2,1),7)='LESSTIF' THEN DO
	IF Right(subword(Par,2,1),1)='+' THEN DO
		LESSTIF='YES'
				/* "YES" if you have the MOTIF or LessTif lib's installed */
		CALL libcheckLessTif
	END
	ELSE
		LESSTIF='NO'
	END
ELSE DO
	CALL syntax
	exit 1
END

/*********************** Do the target specific stuff ****************************/

IF LEFT(subword(Par,3,1),3)='CYG' THEN DO
   GRAALFLAGS		= ''
   DREALFLAGS		= ''
   Target		= 'cyg'
   Z32Flag		= ''
   BIND			= ''
   BUILD_OMF_LIBS	= 'NO'
   CC_WITH_FLAGS	= 'gcc -m486'
   OPTI_FLAG		= ''
   YACC             	= 'bison -y -by'
   LEX              	= 'flex -olexyy.c'
   HAS_STRNCASECMP  	= 'YES'
   GCC_DEF_EXE_EXT  	= 'YES'
   STRIP		= '$(TOUCH)'
   HAS_TZ_TIME 		= 'NO'
   RANDOM_LIB		= 'iberty'
   HAS_NROFF            = 'NO'
END
/*
ELSE IF LEFT(subword(Par,3,1),5)='WIN32' THEN DO
   GRAALFLAGS		= ''
   DREALFLAGS		= ''
   Target		= 'win32'
   Z32Flag		= '-Zwin32'
   BIND			= 'NTBIND -strip'
   BUILD_OMF_LIBS	= 'NO'
   CC_WITH_FLAGS	= 'gcc -m486'
   OPTI_FLAG		= ''
   YACC             	= 'bison -y -by'
   LEX              	= 'flex -olexyy.c'
   HAS_STRNCASECMP  	= 'NO'
   GCC_DEF_EXE_EXT  	= 'NO'
   STRIP		= 'strip +strip-debug'
   HAS_TZ_TIME 		= 'YES'
   RANDOM_LIB		= 'bsd'
   HAS_NROFF            = 'YES'
END
*/
ELSE IF LEFT(subword(Par,3,1),3)='EMX' THEN DO
   GRAALFLAGS		= '-Zomf -Zexe'
   DREALFLAGS		= '-Zomf -Zexe'
   Target		= 'emx'
   Z32Flag		= ''
   BIND			= 'EMXBIND -b -s -q'
   BUILD_OMF_LIBS	= 'YES'
   CC_WITH_FLAGS	= 'gcc -m486'
   OPTI_FLAG		= ''
   YACC             	= 'bison -y'
   LEX              	= 'flex -olexyy.c'
   HAS_STRNCASECMP  	= 'NO'
   GCC_DEF_EXE_EXT  	= 'NO'
   STRIP		= 'strip +strip-debug'
   HAS_TZ_TIME 		= 'YES'
   RANDOM_LIB		= 'bsd'
   HAS_NROFF            = 'YES'
END
ELSE DO
   CALL syntax
   EXIT 1
END

CALL banner
SAY 'X11 = 'X11', LessTif = 'LESSTIF' , Target = 'TARGET
SAY
REXX_TOP="\alliance"
REXX_MACHINE=Target
COMPILE_DIR="archi/"REXX_MACHINE"/obj"
archi_inc="archi/"REXX_MACHINE"/include"
archi_lib="archi/"REXX_MACHINE"/lib"
patch_src="patch"
prol_src="prol"
sedFilesCnt=0

'CALL dolink.exe 'TARGET
'CALL tutorial.cmd 'TARGET

'touch \alliance\tools\patch.started'

"cd \alliance"
/* CALL prol */
CALL genpat_script
CALL genview_cfiles
CALL pat_drv_bug_cfiles
CALL gds_parse_bug_cfiles
CALL mbk_bug_cfiles
CALL gds_drive_cfiles
CALL s2r_cfiles
CALL set_signalmodel_EMX_cfiles
CALL function_getenv_cfiles
CALL rename_for_link_in_icons_cfiles
CALL fpgen_hfiles
CALL fpgen_mkfile
IF TRANSLATE(WITH_FREEMEM)<>"YES" THEN
	CALL tools_if_MACHINE_pc_emx
CALL tools_ifdef_pc_emx
CALL replacing_adding_files
IF HAS_STRNCASECMP <> 'YES' THEN
	CALL stricmp_sub_in_lca2vbe_cfile
CALL def_file_change_lex_yac
CALL tools_makefiles
CALL edit_makefile_desb_inf
CALL edit_makefile_druc
CALL edit_makefile_tas
CALL edit_makefile_grog
CALL edit_makefile_s2r
CALL edit_makefile_ring
/* CALL edit_makefile_mbkedif -> weil stricmp standard ist */
CALL edit_makefile_rds2ps
CALL edit_makefile_fpga
CALL edit_makefile_genview_gcc
CALL edit_makefile_genview
CALL edit_makefile_graal
CALL edit_makefile_dreal
CALL edit_makefile_netoptim
CALL edit_main_makefile
"rm sed.tmp"
"rm sed.log"
"cd "patch_src
'touch \alliance\tools\patch.finished'
return

/*---------------- Procedures ------------------*/

banner:
	SAY "***************************************************************"
	SAY "*                                                             *"
IF (TARGET='cyg') then
	SAY "*     Alliance 3.0 patch for WinNT/95 ("Target") architecture      *"
ELSE IF (TARGET='win32') then
	SAY "*     Alliance 3.0 patch for WinNT/95 ("Target") architecture      *"
else
	SAY "*       Alliance 3.0 patch for OS/2 (emx) architecture        *"
	SAY "*       Christoph Jaeschke, jaeschke@item.uni-bremen.de       *"
	SAY "*                                                             *"
	SAY "***************************************************************"
RETURN

libcheckLessTif:
   env = 'OS2ENVIRONMENT'
   x11root = VALUE('X11ROOT',,env)
   IF x11root = '' THEN DO
      SAY "Warning: The environment variable X11ROOT is not set."
      SAY "Warning: Looking at /."
      SAY
   END

   LessTifTree = x11root'\lesstif-current'
   IF exists(LessTifTree) THEN DO
      SAY "Assuming the LessTif tree is located at:"
      LessTifTree = TRANSLATE(LessTifTree, '/', '\')
      SAY '    'LessTifTree
      SAY 
   END
   ELSE	do
      SAY "LessTif tree NOT found at:"
      LessTifTree = TRANSLATE(LessTifTree, '/', '\')
      SAY '    'LessTifTree
      SAY 
      EXIT 1
   END
return
   
libcheckX11:
   env = 'OS2ENVIRONMENT'
   x11root = VALUE('X11ROOT',,env)
   IF x11root = '' THEN DO
      SAY "Warning: The environment variable X11ROOT is not set."
      SAY "Warning: Looking at /."
      SAY
   END

   XFree86Tree = x11root'\XFree86'
   IF exists(XFree86Tree) THEN DO
      SAY 
      SAY "Assuming the XFree86 tree is located at:"
      XFree86Tree = TRANSLATE(XFree86Tree, '/', '\')
      SAY '    'XFree86Tree
      SAY
   END
   ELSE	do
      SAY "XFree86 tree NOT found at:"
      XFree86Tree = TRANSLATE(XFree86Tree, '/', '\')
      SAY '    'XFree86Tree
      SAY 
      EXIT 1
   END
return

syntax:
	SAY 'Invocation syntax:'
	SAY 'PATCH.CMD x11+|- LessTif+|- [ emx | cyg ] (+ installed, - not installed)'
return

prol:	
	"echo *** gunzip, untar, edit and compile prol files"
	"gzip -cd prol.tar.gz | tar -xvf -"
	"rm prol/prol"
	"echo w sed.log> sed.tmp"
	"echo 1i\>> sed.tmp"
	"echo SHELL=bash>> sed.tmp"
	"echo s/cc /gcc "Z32Flag" -Zexe />> sed.tmp"
/*
	"echo s/cc /gcc "Z32Flag" />> sed.tmp"
	"echo /cc/a\>> sed.tmp"
	"echo /"BIND" \>> sed.tmp"
*/
	"echo /rm >> sed.tmp"
	CALL BackupChangeWithSedTmp( "prol/Makefile" )
	"cd prol"
	"make | tee makeprol.log"
	"cd .."
	CALL CopyFromProl( "prol10.rds" "etc" )
	CALL CopyFromProl( "prol07.rds" "etc" )
return

genpat_script:
	"echo *** Substitute =$ALLIANCE_TMP for =/tmp, Mut316 for Mut315,"
	"echo removing /bin/ in genpat-script "
	"echo w sed.log> sed.tmp"
	"echo s!=/tmp!=$ALLIANCE_TMP!g>> sed.tmp"
	"echo s/Mut315/Mut316/>> sed.tmp"
	CALL ExpBackupChangeWithSedTmp( "genpat" "genpat" "genpat" )
return

genview_cfiles:
	"echo *** Substitute loc_sleep for sleep in genview/../v_colors.c "
	"echo w sed.log> sed.tmp"
	"echo s/sleep/loc_sleep/g>> sed.tmp"
	CALL ExpBackupChangeWithSedTmp( "genview" "@" "v_colors.c" )
return

pat_drv_bug_cfiles:
	"echo *** Remove bug: missing static before char* in pat/../ppt/pat_drvpat.c"
	"echo w sed.log> sed.tmp"
	"echo s/char *[*]signam/static char *signam/>> sed.tmp"
	CALL ExpBackupChangeWithSedTmp( "pat" "ppt" "pat_drvpat.c" )
return

gds_parse_bug_cfiles:
	"echo *** Remove bug: free on fixed char[33] in rdsgds/../gds_parse.c"
	"echo w sed.log> sed.tmp"
	"echo s!free(nom_modele);!/* free(nom_modele); */!>> sed.tmp"
	CALL ExpBackupChangeWithSedTmp( "rdsgds" "@" "gds_parse.c" )
return

gds_drive_cfiles:
	"echo *** Remove tzset() in rdsgds/../gds_drive.c"
	"echo w sed.log> sed.tmp"
	IF HAS_TZ_TIME <> 'YES' THEN
		"echo s!tzset();!/* tzset(); */!>> sed.tmp"
	CALL ExpBackupChangeWithSedTmp( "rdsgds" "@" "gds_drive.c" )
return

s2r_cfiles:
	"echo *** insert type-cast *(char*)strchr in s2r/../main.c"
	"echo w sed.log> sed.tmp"
	"echo s/[*]strchr/*(char*)strchr/>> sed.tmp"
	CALL ExpBackupChangeWithSedTmp( "s2r" "@" "main.c" )
return


mbk_bug_cfiles:
	"echo *** Remove bug: buggy for-loop overwrites locals in mbk/../mbk_lo_util.c"
	"echo w sed.log> sed.tmp"
	"echo s/BUFSIZ [^|][^|] line.p./BUFSIZ \^&\^& line[p] \^&\^& line[p] != '\\n'/>> sed.tmp"
	CALL ExpBackupChangeWithSedTmp( "mbk" "@" "mbk_lo_util.c" )
return

set_signalmodel_EMX_cfiles:
	"echo *** Changing all re-signalings in handlers to signal(...,SIG_ACK), EMX-model"
	"echo w sed.log> sed.tmp"
	"echo  1,/^^unix_trap()/s/signal(\(.*\),.*)/signal(\1, SIG_ACK)/>> sed.tmp"
	CALL ExpBackupChangeWithSedTmp( "genview" "@" "d_interp_sig.c" )
	"echo w sed.log> sed.tmp"
	"echo  1,/signal(/s/signal(\(.*\),.*)/signal(\1, SIG_ACK)/>> sed.tmp"
	CALL ExpBackupChangeWithSedTmp( "graal" "@" "GMX_view.c" )	
	"echo w sed.log> sed.tmp"
	"echo  1,/signal(/s/signal(.*,\(.*\))/signal( SIGTERM, SIG_ACK); signal(SIGTERM, \1)/>> sed.tmp"
	CALL ExpBackupChangeWithSedTmp( "graal" "@" "GRM_mbkrds.c" )
	"echo w sed.log> sed.tmp"
	"echo  1,/signal(/s/signal(\(.*\),.*)/signal(\1, SIG_ACK)/>> sed.tmp"
	CALL ExpBackupChangeWithSedTmp( "dreal" "@" "GMX_view.c" )
	"echo w sed.log> sed.tmp"
	"echo  1,/signal(/s/signal(.*,\(.*\))/signal( SIGTERM, SIG_ACK); signal(SIGTERM, \1)/>> sed.tmp"
	CALL ExpBackupChangeWithSedTmp( "dreal" "@" "GRD_rds.c" )
return

function_getenv_cfiles:
	"echo *** Substitute getenv() for /usr/tmp, nul for /dev/null"
	"echo *** in 7 graal/dreal/genview/tas c-files"
	"echo w sed.log> sed.tmp"
	"echo s!/dev/null!nul!g>> sed.tmp"
	CALL ExpBackupChangeWithSedTmp( "tas" "tas" "tas_util.c" )
	'echo s#sprintf\(.*\)"/usr/tmp\([^^,]*\),#sprintf\1"%%s\2,((getenv("ALLIANCE_TMP")!=NULL)?getenv("ALLIANCE_TMP"):""),#>> sed.tmp'
	CALL ExpBackupChangeWithSedTmp( "graal" "@" "GRM_error.c" )
	CALL ExpBackupChangeWithSedTmp( "dreal" "@" "GRD_error.c" )
	CALL ExpBackupChangeWithSedTmp( "genview" "@" "t_rl.pwet.c" )
	CALL ExpBackupChangeWithSedTmp( "genview" "@" "t_rl.c" )
	"echo s#sprintf\(.*\)/usr/tmp#sprintf\1%%s#>> sed.tmp"
	'echo s/E_LoadStr, *getpid()/E_LoadStr, ((getenv("ALLIANCE_TMP")!=NULL)?getenv("ALLIANCE_TMP"):""), getpid()/>> sed.tmp'
	CALL ExpBackupChangeWithSedTmp( "genview" "@" "e_win.c" )
	"echo w sed.log> sed.tmp"
	'echo s/getenv *("TMPDIR")/getenv ("ALLIANCE_TMP")/>> sed.tmp'
	CALL ExpBackupChangeWithSedTmp( "genview" "gcc-1.42" "gcc.c" )
return

rename_for_link_in_icons_cfiles:
	"echo *** Substitute rename() for link/unlink-Seq. in  ai/icn-drive.c "
	"echo w sed.log> sed.tmp"
	"echo /if *( *link( *filename *, *buf *)/i\>> sed.tmp"
	"echo #ifdef __EMX__\>> sed.tmp"
	"echo 		rename(filename, buf);\>> sed.tmp"
	"echo #else>> sed.tmp"
	"echo /unlink( *filename *)/a\>> sed.tmp"
	"echo #endif>> sed.tmp"
	CALL ExpBackupChangeWithSedTmp( "icones" "@" "aidrive.c" ) 
	CALL ExpBackupChangeWithSedTmp( "icones" "@" "icndrive.c" ) 
return

fpgen_hfiles:
	"echo *** Substitute va_list for ( ... ) in FpGen/FpGenMGN.h "
	"echo w sed.log> sed.tmp"
	"echo s/\(extern.*\)(( *[.][.][.] *))\(.*\)/\1(( va_alist ))\2/>> sed.tmp"
	CALL ExpBackupChangeWithSedTmp( "fitpath" "FpGen" "fpgenmgn.h" ) 
return

fpgen_mkfile:
	"echo *** Delete -s from fitpath.mk, because ld stripping is buggy"
	"echo w sed.log> sed.tmp"
	"echo s/-s / />> sed.tmp"
	CALL ExpBackupChangeWithSedTmp( "fitpath" "@" "fitpath.mk" ) 
return

replacing_adding_files:
	"CP "PATCH_SRC"/mk.head "PATCH_SRC"/mk.tmp"
	"echo X11_BIN          = "XFree86Tree"/bin >> "PATCH_SRC"/mk.tmp"
	"echo X11_LIB          = "XFree86Tree"/lib >> "PATCH_SRC"/mk.tmp"
	"echo X11_INCLUDE      = "XFree86Tree"/include >> "PATCH_SRC"/mk.tmp"
	"echo MOTIF_BIN        = "LessTifTree"/bin >> "PATCH_SRC"/mk.tmp"
	"echo MOTIF_LIB        = "LessTifTree"/libXm >> "PATCH_SRC"/mk.tmp"
	"echo MOTIF_INCLUDE    = "LessTifTree"/include >> "PATCH_SRC"/mk.tmp"
	"echo CC	       = "CC_WITH_FLAGS">> "PATCH_SRC"/mk.tmp"
	"echo BIND	       = "BIND"  >> "PATCH_SRC"/mk.tmp"
	"echo YACC             = "YACC"  >> "PATCH_SRC"/mk.tmp"
	"echo LEX              = "LEX"  >> "PATCH_SRC"/mk.tmp"
	IF BUILD_OMF_LIBS='YES' THEN
		"echo EMXOMF              = emxomf  >> "PATCH_SRC"/mk.tmp"
	IF TRANSLATE(Debug)="YES" THEN DO
		"echo STRIP		= $(TOUCH) >> "PATCH_SRC"/mk.tmp"
		"echo CFLAGS		= -pipe "Z32FLAG"-static -g >> "PATCH_SRC"/mk.tmp"
		"echo X11CFLAGS		= -pipe "Z32FLAG"-g >> "PATCH_SRC"/mk.tmp"
		"echo *** Adding "Target".mk (-g) in etc/"
	END
	ELSE DO
		"echo STRIP		= "STRIP" >> "PATCH_SRC"/mk.tmp"
		"echo CFLAGS		= -pipe "Z32FLAG" -static >> "PATCH_SRC"/mk.tmp"
		"echo X11CFLAGS		= -pipe "Z32FLAG" >> "PATCH_SRC"/mk.tmp"
		"echo *** Adding "Target".mk (strip-debug) in etc/ "
	END
	"CAT "PATCH_SRC"/mk.tmp "PATCH_SRC"/mk.tail > "PATCH_SRC"/"Target".mk"
	CALL CopyFromPatch( Target".mk" "etc/")
 	"RM "PATCH_SRC"/mk.tmp"
	"RM "PATCH_SRC"/"Target".mk"
	"echo *** Adding values.h to archi/"Target"/include "
	CALL CopyFromPatch( "values.h" archi_inc"/")
return

/*
strncase_sub_in_lca2vbe_cfile:
	"echo *** Substitute strncasecmp( , ,INT_MAX) for strcasecmp() in fpga/.../lca2vbe.c "
	"echo w sed.log> sed.tmp"
	"echo /^^#include/i\>> sed.tmp"
	"echo #include ^<limits.h^>>> sed.tmp"
	"echo s/strcasecmp(\([^^,]*,[^^)]*\)\(.*\)/strncasecmp(\1,INT_MAX\2/>> sed.tmp"
	CALL ExpBackupChangeWithSedTmp( "fpga" "lca_vbe" "lca2vbe.c" ) 
return
*/

stricmp_sub_in_lca2vbe_cfile:
	"echo *** Substitute stricmp for strcasecmp() in fpga/.../lca2vbe.c "
	"echo w sed.log> sed.tmp"
	"echo s/strcasecmp/stricmp/>> sed.tmp"
	CALL ExpBackupChangeWithSedTmp( "fpga" "lca_vbe" "lca2vbe.c" )
return

def_file_change_lex_yac:
	"echo *** Collecting all Lexer and Parsersources, changing _FILE to xyz_FILE..."
	"echo w sed.log> sed.tmp"
	"echo s/\(addhtitem.*[^^z]\)_FILE\(.*$\)/\1xyz_FILE\2/>> sed.tmp"
	'echo s/\("file".*[^^z]\)_FILE\(.*$\)/\1xyz_FILE\2/>> sed.tmp'
	CALL MaskBackupChangeWithSedTmp( "tools"  "*.lex" )
	"echo w sed.log> sed.tmp"
	"echo s/\(%token.*[^^z]\)_FILE$/\1xyz_FILE/>> sed.tmp"
	IF HAS_STRNCASECMP <> 'YES' THEN DO
		"echo *** Substitute strnicmp for strncasecmp()..."
		"echo s/strncasecmp/strnicmp/>> sed.tmp"
	END
	CALL MaskBackupChangeWithSedTmp( "tools"  "*.yac" )
	IF TRANSLATE(BuildLexYac) <> "YES" THEN DO
		"echo *** Copy all lex.yy.c to lexyy.c "
		CALL MaskCopy("lex.yy.c" "lexyy.c")
		"echo *** Collecting all lexyy.c, y.tab.c ^& y.tab.h, changing _FILE to xyz_FILE "
		"echo w sed.log> sed.tmp"
		"echo /addhtitem/s/\([^^z]\)_FILE/\1xyz_FILE/>> sed.tmp"
		"echo /^^#define._FILE/s/\([^^z]\)_FILE/\1xyz_FILE/>> sed.tmp"
		'echo s/"_FILE"/"xyz_FILE"/>> sed.tmp'
		CALL MaskBackupChangeWithSedTmp( "tools" "y.tab.c" )
		CALL MaskBackupChangeWithSedTmp( "tools" "y.tab.h" )
		CALL MaskBackupChangeWithSedTmp( "tools"  "lexyy.c" )
	END
return

tools_makefiles:
   "echo *** Insert MACHINE/TOP, substitute mv/cat for cat ^>^>, "
   "echo renaming lex.yy -^> lexyy"
   IF Target <>"cyg" THEN
      "echo cutting lib-prefixes... "
   /* removing -O flags, */
   "echo w sed.log> sed.tmp"
   "echo /include.*$(MACHINE)[.]mk/s/.*//>> sed.tmp"
   IF Target <>"cyg" THEN DO   
      "echo s/lib\([a-zA-Z0-9]\{1,8\}[.]a\)/\1/>> sed.tmp"
      "echo s/lib\([a-zA-Z0-9]\{1,8\}$(.*)[.]a\)/\1/>> sed.tmp"
      "echo s/lib\([a-zA-Z0-9]\{1,8\}${.*}[.]a\)/\1/>> sed.tmp"
   END
   "echo s/lex[.]yy/lexyy/g>> sed.tmp"
   "echo /(CAT).*^>^>.*; *[\]/s/(CAT) *\([^^ ]*\) *^>^> *\([^^;]*\)/(MV) \2 tmp.file; $(CAT) tmp.file \1 ^> \2/>> sed.tmp"
   "echo /cat .*^>^>.*; *[\]/s/cat *\([^^ ]*\) *^>^> *\([^^;]*\)/$(MV) \2 tmp.file; cat tmp.file \1 ^> \2/>> sed.tmp"
   IF TRANSLATE(BuildLexYac) = "YES" THEN DO
      "echo *** and removing lex/yac #'s  "
      "echo /^^clean *:/,/^^$/{>> sed.tmp"
      "echo /$(RM)/s/^^#//>> sed.tmp"
      "echo }>> sed.tmp"
      "echo /^^#.*lexyy[.]c *[:]/,/^^$/s/^^#//>> sed.tmp"
      "echo /^^#.*y[.]tab[.]c *[:]/,/^^$/s/^^#//>> sed.tmp"
   END
   CALL BackupChangeWithSedTmp( "etc/libraries.mk" )
   "echo *** in Makefiles..."
   "echo 1i\>> sed.tmp"
   "echo TOP=/alliance\>> sed.tmp"
   "echo MACHINE="Target"\>> sed.tmp"
   "echo include $(TOP)/etc/$(MACHINE).mk>> sed.tmp"
   "echo /^^NROFF.*=/d>> sed.tmp"
   "echo /^^SHELL.*=/d>> sed.tmp"
   "echo /^^CHMOD.*=/d>> sed.tmp"
   "echo /^^RM.*=/d>> sed.tmp"
   "echo /^^ECHO.*=/d>> sed.tmp"
   "echo s!/bin/chmod!$(CHMOD)!>> sed.tmp"
   "echo s!/bin/rm!$(RM)!>> sed.tmp"
   "echo s!/bin/echo!$(ECHO)!>> sed.tmp"
   "echo s!/dev/null!nul!>> sed.tmp"
   "echo s/-DMACHINE=$(MACHINE)/-D$(MACHINE)/>> sed.tmp"
   "echo s/MACHINE=$(MACHINE)//>> sed.tmp"
   "echo s/TOP=$(TOP)//>> sed.tmp"
   IF LEFT(OPTI_FLAG,2)='-O' THEN
      /* remove the -Ox flags */
      "echo s/-O[0-5]\{0,1\}//>> sed.tmp"
   IF GCC_DEF_EXE_EXT = 'YES' THEN DO
      /* append a point to force whithout .exe extension */
      /* 1,/^^gnulib:/ prevent the change in gcc-1.42,	 */
      /* because this file				 */
      /* has to be started	*/
      "echo 1,/^^gnulib:/s/\(cc.*-o[ ]\{1,2\}[.]\{0,2\}[^^ .;]\{3,50\}\) /\1. />> sed.tmp"
      "echo 1,/^^gnulib:/s/\(CC.*-o[ ]\{1,2\}[.]\{0,2\}[^^ .;]\{3,50\}\) /\1. />> sed.tmp"
      "echo 1,/^^gnulib:/s/\(cc.*-o[ ]\{1,2\}[.]\{0,2\}[^^ .;]\{3,50\}\)$/\1./>> sed.tmp"
      "echo 1,/^^gnulib:/s/\(CC.*-o[ ]\{1,2\}[.]\{0,2\}[^^ .;]\{3,50\}\)$/\1./>> sed.tmp"
      "echo 1,/^^gnulib:/s/\(cc.*-o[ ]\{1,2\}[.]\{0,2\}[^^ .]\{3,50\}\);/\1.;/>> sed.tmp"
      "echo 1,/^^gnulib:/s/\(CC.*-o[ ]\{1,2\}[.]\{0,2\}[^^ .]\{3,50\}\);/\1.;/>> sed.tmp"
   END
   CALL MaskBackupChangeWithSedTmp( "tools"  "Makefile" )
   CALL BackupChangeWithSedTmp( "Makefile" )
return

tools_ifdef_pc_emx:
	"echo *** Changing #if(n)def pc to emx in flop, genview, mbkal, s2r"
	"echo w sed.log> sed.tmp"
	"echo /^^#.*def.*pc/s/pc/__EMX__/>> sed.tmp"
	CALL ExpBackupChangeWithSedTmp( "flop" "@" "check.c" )
	CALL ExpBackupChangeWithSedTmp( "flop" "@" "old_check.c" )
	CALL ExpBackupChangeWithSedTmp( "flop" "@" "util.c" )
	CALL ExpBackupChangeWithSedTmp( "genview" "gcc-1.42" "c-parse.tab.c" )
	CALL ExpBackupChangeWithSedTmp( "genview" "@" "d_exec.c" )
	CALL ExpBackupChangeWithSedTmp( "genview" "@" "d_interp_fonc.c" )
	CALL ExpBackupChangeWithSedTmp( "genview" "@" "d_stdlib.c" )
	CALL ExpBackupChangeWithSedTmp( "mbkal" "@" "generic_target.h" )
	CALL ExpBackupChangeWithSedTmp( "s2r" "@" "generic.h" )
return

tools_if_MACHINE_pc_emx:
	"echo *** Changing #if MACHINE ... pc to emx in fpga, netoptim, proof, sl"
	"echo w sed.log> sed.tmp"
	"echo /^^#if MACHINE.*pc/s/ pc/ "Target"/>> sed.tmp"
	CALL ExpBackupChangeWithSedTmp( "fpga" "compil" "sl_compile.c" )
	CALL ExpBackupChangeWithSedTmp( "fpga" "compil" "sl_util.c" )
	CALL ExpBackupChangeWithSedTmp( "fpga" "fpmenu" "fp_menu.c" )
	CALL ExpBackupChangeWithSedTmp( "fpga" "mapping" "compile.c" )
	CALL ExpBackupChangeWithSedTmp( "fpga" "mapping" "generic.c" )
	CALL ExpBackupChangeWithSedTmp( "fpga" "mapping" "regles.c" )
	CALL ExpBackupChangeWithSedTmp( "fpga" "mapping" "util.c" )
	CALL ExpBackupChangeWithSedTmp( "fpga" "param" "sl_param.c" )
	CALL ExpBackupChangeWithSedTmp( "netoptim" "compil" "sl_compile.c" )
	CALL ExpBackupChangeWithSedTmp( "netoptim" "compil" "sl_util.c" )
	CALL ExpBackupChangeWithSedTmp( "netoptim" "load" "neto.c" )
	CALL ExpBackupChangeWithSedTmp( "netoptim" "load" "no_optim.c" )
	CALL ExpBackupChangeWithSedTmp( "netoptim" "load" "util.c" )
	CALL ExpBackupChangeWithSedTmp( "netoptim" "mapping" "generic.c" )
	CALL ExpBackupChangeWithSedTmp( "netoptim" "netmenu" "no_menu.c" )
	CALL ExpBackupChangeWithSedTmp( "proof" "compil" "sl_compile.c" )
	CALL ExpBackupChangeWithSedTmp( "proof" "compil" "sl_util.c" )
	CALL ExpBackupChangeWithSedTmp( "sl" "compil" "sl_compile.c" )
	CALL ExpBackupChangeWithSedTmp( "sl" "compil" "sl_util.c" )
	CALL ExpBackupChangeWithSedTmp( "sl" "mapping" "compile.c" )
	CALL ExpBackupChangeWithSedTmp( "sl" "mapping" "generic.c" )
	CALL ExpBackupChangeWithSedTmp( "sl" "mapping" "regles.c" )
	CALL ExpBackupChangeWithSedTmp( "sl" "mapping" "util.c" )
	CALL ExpBackupChangeWithSedTmp( "sl" "mbk" "sl_mbk.c" )
	CALL ExpBackupChangeWithSedTmp( "sl" "menu" "sl_corps.c" )
	CALL ExpBackupChangeWithSedTmp( "sl" "param" "sl_param.c" )
return

edit_makefile_druc:
	"echo *** Changing drucompi.c/h to _c.c/h in Makefile and copy files in druc..."
	"echo w sed.log> sed.tmp"
	"echo s/drucompi[.]\([cho]\)/drucompi_c.\1/g>> sed.tmp"
	"echo s/$(YACC)/$(YACC) -bdrucompi.yac/>> sed.tmp"
	CALL ExpEditMakefileWithSedTmp( "druc" "@" )
	CALL ExpCopy( "drucompi.c" "drucompi_c.c" "druc" "@" )
	CALL ExpCopy( "drucompi.h" "drucompi_c.h" "druc" "@" )
	"echo w sed.log> sed.tmp"
	'echo /#include *"drucompi.h"/s/drucompi/drucompi_c/g>> sed.tmp'
	CALL ExpBackupChangeWithSedTmp( "druc" "@" "drucompi_c.c" )
return

edit_makefile_desb_inf:
	"echo *** Changing inf.c to inf_c.c in Makefile and copy files in desb/inf..."
	"echo w sed.log> sed.tmp"
	"echo s/inf[.]o/inf_c.o/g>> sed.tmp"
	"echo s/inf[.]yy/inf_yy/g>> sed.tmp"
	CALL ExpCopy( "inf.c" "inf_c.c" "desb" "inf" )
	CALL ExpEditMakefileWithSedTmp( "desb" "inf" )
return

edit_makefile_tas:
	"echo *** Changing default-technology to /etc/prol10.elp in Makefile tas..."
	"echo w sed.log> sed.tmp"
	"echo s!/etc/ecpd10.elp!/etc/prol10.elp!>> sed.tmp"
	CALL ExpEditMakefileWithSedTmp( "tas" "tas" )
return

edit_makefile_grog:
	"echo *** Changing Makefile grog, adding lib-"RANDOM_LIB" entry ..."
	"echo w sed.log> sed.tmp"
	"echo s/ *-lm/ -lm -l"RANDOM_LIB"/>> sed.tmp"
	CALL ExpEditMakefileWithSedTmp( "grog" "@" )
return

edit_makefile_s2r:
	"echo *** Removing s2rps.o Target from Makefile s2r (rusage not implemented)..."
	"echo w sed.log> sed.tmp"
	"echo /OBJECTS.*=.*s2rps.o/s/s2rps.o//>> sed.tmp"
	CALL ExpEditMakefileWithSedTmp( "s2r"  "@" )
return

edit_makefile_ring:
	"echo *** changing bison prefix to drucompi.yac..."
	"echo w sed.log> sed.tmp"
	"echo s/$(YACC)/$(YACC) -binterp.yac/>> sed.tmp"
	CALL ExpEditMakefileWithSedTmp( "ring"  "@" )
return

edit_makefile_mbkedif:
	"echo *** Adding strncase.o to library-target in tools/mbkedif/../Makefile "
	"echo w sed.log> sed.tmp"
	"echo s/LOCAL_OBJ *=.*/^& strncase.o/>> sed.tmp"
	"echo /^^clean *:/i\>> sed.tmp"
	"echo strncase.o : strncase.c\>> sed.tmp"
	"echo \	$(CC) $(LOCAL_CFLAGS) -c strncase.c\>> sed.tmp"
	"echo \>> sed.tmp"
	CALL ExpEditMakefileWithSedTmp( "mbkedif" "@" )
return

edit_makefile_rds2ps:
	apostr="'"
	SEDTMP="sed.tmp"
	"echo *** Changing Makefile rds2ps due to awk problems ..."
	"echo w sed.log> sed.tmp"
	IF HAS_NROFF <> 'YES' THEN DO
	   "echo disabling nroff call, copy tmp_man.c from patch dir..."
	   rc=LINEOUT(SEDTMP, "/$(NROFF)/,/cat/s/\(.*\)/#\1/")
	   CALL ExpCopyFromPatch( "tmp_man.c" "rds2ps" "@" )
	END
	rc=LINEOUT(SEDTMP, "s/>> tmp_dict.c/> tmp.1; cat tmp_dict.c tmp.1 > tmp.2;mv tmp.2 tmp_dict.c; rm tmp.1/")
	rc=LINEOUT(SEDTMP, '/^tmp_man.o/,/$(CC).*tmp_man.c/s/[\]"/%c/g')
	rc=LINEOUT(SEDTMP, '/^tmp_man.o/,/$(CC).*tmp_man.c/s/[\][\]/\\\\\\/g')
	rc=LINEOUT(SEDTMP, '/^tmp_man.o/,/$(CC).*tmp_man.c/s/$$0/34, \\$$0, 34 /g')
	rc=LINEOUT(SEDTMP, '/^tmp_man.o/,/$(CC).*tmp_man.c/s/\([^\]\)"/\1\\"/g')
	rc=LINEOUT(SEDTMP, '/^tmp_man.o/,/$(CC).*tmp_man.c/s/'apostr'/"/g')
	rc=LINEOUT(SEDTMP, '/^tmp_dict.o/,/$(CC).*tmp_dict.c/s/[\]"/%c/g')
	rc=LINEOUT(SEDTMP, '/^tmp_dict.o/,/$(CC).*tmp_dict.c/s/[\][\]/\\\\\\/g')
	rc=LINEOUT(SEDTMP, '/^tmp_dict.o/,/$(CC).*tmp_dict.c/s/$$0/34, \\$$0, 34 /g')
	rc=LINEOUT(SEDTMP, '/^tmp_dict.o/,/$(CC).*tmp_dict.c/s/\([^\]\)"/\1\\"/g')
	rc=LINEOUT(SEDTMP, '/^tmp_dict.o/,/$(CC).*tmp_dict.c/s/'apostr'/"/g')
	rc=LINEOUT(SEDTMP)
	CALL ExpEditMakefileWithSedTmp( "rds2ps" "@" )
return

edit_makefile_fpga:
	"echo *** Changing Makefile fpga: Substitute errornous ../.. to .."
	"echo w sed.log> sed.tmp"
	"echo s![.][.]/[.][.]!..!g>> sed.tmp"
	CALL ExpEditMakefileWithSedTmp( "fpga" "@" )
return

edit_makefile_genview_gcc:
	"echo *** Changing Makefile genview/../gcc-1.42: Adding -Zexe ^& bash,"
	"echo mv make.com to makecpl.com..."
	"echo w sed.log> sed.tmp"
	"echo s!$(srcdir)/move-if-change tmp!bash $(srcdir)/move-if-change tmp!>> sed.tmp"
	"echo /^^genconfig *:/,$s/$(CFLAGS)/-Zexe/>> sed.tmp"
	"echo s/make hard-params/makecpl hard-params/>> sed.tmp"
	CALL ExpEditMakefileWithSedTmp( "genview" "gcc-1.42" )
	CALL ExpMove( "make.com" "makecpl.com" "genview" "gcc-1.42" )
return

edit_makefile_genview:
	"echo *** Changing Makefile genview: Adding -L$(X11_LIB), -Zmtd, removing -static..."
	"echo w sed.log> sed.tmp"
	"echo s/-O3/-O3 -g/>> sed.tmp"
	"echo /$(MV) genview watchdog/i\>> sed.tmp"
	"echo \	$(STRIP) genview \>> sed.tmp"
	"echo \	$(STRIP) watchdog>> sed.tmp"
	"echo /^^genview *:/,/^^grog_genview *:/s/$(CFLAGS)/-Zmtd $(X11CFLAGS)/>> sed.tmp"
	"echo /-o watchdog/s/-lX11/-L$(X11_LIB) -lX11/>> sed.tmp"
	CALL ExpEditMakefileWithSedTmp( "genview" "@" )
return

edit_makefile_graal:
	"echo *** Changing Makefile graal: Adding -Zmtd "GRAALFLAGS" -L/-I$(MOTIF), removing -static..."
	"echo w sed.log> sed.tmp"
	"echo s/$(CFLAGS)/$(CFLAGS) "GRAALFLAGS"/>> sed.tmp"
	"echo s/-L$(X11_LIB)/-L$(X11_LIB) -L$(MOTIF_LIB)/>> sed.tmp"
	"echo s/-I$(X11_INCLUDE)/-I$(X11_INCLUDE) -I$(MOTIF_INCLUDE)/>> sed.tmp"
	"echo /^^graal *:/,/^^graal.o *:/s/$(LOCAL_CFLAGS)/-Zmtd "GRAALFLAGS" $(X11CFLAGS)/>> sed.tmp"
	IF POS('-Zomf', GRAALFLAGS) > 0 THEN DO
		"echo s/[.]o/.obj/g>> sed.tmp"
	END
	ELSE DO
		"echo /$(STRIP) *graal/i\>> sed.tmp"
	        "echo         $(BIND) graal\>> sed.tmp"
	        "echo         $(RM) graal>> sed.tmp"
	END
	"echo /$(STRIP) *graal/d>> sed.tmp"
	"echo s!$(MV) *graal *[.][.]/bin/graal!$(MV) graal.exe ../bin/!>> sed.tmp"
	CALL ExpEditMakefileWithSedTmp( "graal" "@" )
return

edit_makefile_dreal:
	"echo *** Changing Makefile dreal: Adding -Zmtd "DREALFLAGS" L/-I$(MOTIF), removing -static..."
	"echo w sed.log> sed.tmp"
	"echo s/$(CFLAGS)/$(CFLAGS) "DREALFLAGS"/>> sed.tmp"
	"echo s/-L$(X11_LIB)/-L$(X11_LIB) -L$(MOTIF_LIB)/>> sed.tmp"
	"echo s/-I$(X11_INCLUDE)/-I$(X11_INCLUDE) -I$(MOTIF_INCLUDE)/>> sed.tmp"
	"echo /^^dreal *:/,/^^dreal.o *:/s/$(LOCAL_CFLAGS)/-Zmtd "DREALFLAGS" $(X11CFLAGS)/>> sed.tmp"
	IF POS('-Zomf', DREALFLAGS) > 0 THEN DO
		"echo s/[.]o/.obj/g>> sed.tmp"
	END
	ELSE DO
		"echo /$(STRIP) *dreal/i\>> sed.tmp"
	        "echo         $(BIND) dreal\>> sed.tmp"
	        "echo         $(RM) dreal>> sed.tmp"
	END
	"echo /$(STRIP) *dreal/d>> sed.tmp"
	"echo s!$(MV) *dreal *[.][.]/bin/dreal!$(MV) dreal.exe ../bin/!>> sed.tmp"
	CALL ExpEditMakefileWithSedTmp( "dreal" "@" )
return

edit_makefile_netoptim:
	"echo *** Changing Makefile netoptim: Adding -g for load/util.c compile"
	"echo w sed.log> sed.tmp"
	"echo /$(CC).*load.util.c/s/$(LOCAL_CFLAGS)/$(LOCAL_CFLAGS) -g/>> sed.tmp"
	CALL ExpEditMakefileWithSedTmp( "netoptim" "@" )
return


edit_main_makefile:
	"echo w sed.log> sed.tmp"
	"echo s!archi/$(MACHINE)/obj!"COMPILE_DIR"!g>> sed.tmp"
	IF BUILD_OMF_LIBS='YES' THEN
		"echo s/ $(RANLIB) $$i ;/ $(RANLIB) $$i ; $(EMXOMF) $$i ; />> sed.tmp"
	IF TRANSLATE(LESSTIF) <> 'YES' THEN DO
		"echo /^^all *:/,/:/s/install-graal/             />> sed.tmp"
		"echo /^^all *:/,/:/s/install-dreal/             />> sed.tmp"
		"echo /^^clean-tools *:/,/:/s/clean-graal/           />> sed.tmp"
		"echo /^^clean-tools *:/,/:/s/clean-dreal/           />> sed.tmp"
		MainMakefileRemoveInstall="install-graal, install-dreal"
		MainMakefileRemoveClean="clean-graal, clean-dreal"
		X11="YES"
	END 
	ELSE DO
		MainMakefileRemoveInstall="nothing"
		MainMakefileRemoveClean="nothing"
	END
	IF TRANSLATE(X11) <> 'YES' THEN DO
		"echo /^^all *:/,/:/s/install-genview/               />> sed.tmp"
		"echo /^^clean-tools *:/,/:/s/clean-genview/             />> sed.tmp"
		MainMakefileRemoveInstall=MainMakefileRemoveInstall", install-genview"
		MainMakefileRemoveClean=MainMakefileRemoveClean", clean-genview"
	END
	"echo *** Removing "MainMakefileRemoveInstall" from Main-Makefile..."
	"echo /^^all *:/i\>> sed.tmp"
	"echo # Removed "MainMakefileRemoveInstall"\>> sed.tmp"
	"echo \ >> sed.tmp"
	"echo /^^clean-tools *:/i\>> sed.tmp"
	"echo # Removed "MainMakefileRemoveClean"\>> sed.tmp"
	"echo \ >> sed.tmp"
	"echo s/$(RM) -f $(ALLIANCE_BIN)/$(RM) -rf $(ALLIANCE_BIN)/>> sed.tmp"
	CALL EditFileWithSedTmp( "Makefile" )
return

/*---------------- expand full path of the named tool ------------------*/

ExpObj:
PARSE ARG tool level2

IF level2="@" THEN
	RETVAL="tools/"tool"/archi/"Target"/obj"
ELSE
	RETVAL="tools/"tool"/archi/"Target"/obj/"level2
RETURN RETVAL

/*---------------- edit a changed Makefile with sed.tmp ------------------*/

ExpEditMakefileWithSedTmp:
PARSE ARG tool level2

ExpPath=ExpObj( tool  level2)
CALL EditfileWithSedTmp( ExpPath"/Makefile" )
RETURN

EditFileWithSedTmp:
PARSE ARG ExpandedPathfile

IF reallydo = "YES" THEN DO
	"CP "ExpandedPathFile" "ExpandedPathFile".tmp"
	"SED -f sed.tmp  < "ExpandedPathFile".tmp > "ExpandedPathFile
	"RM "ExpandedPathFile".tmp"
END
ELSE DO
	SAY "CP "ExpandedPathFile" "ExpandedPathFile".tmp"
	SAY"SED -f sed.tmp  < "ExpandedPathFile".tmp > "ExpandedPathFile
	SAY "RM "ExpandedPathFile".tmp"
END
RETURN

/*---------------- copy from patch-dir to expanded tool-path ------------------*/

ExpCopyFromPatch:
PARSE ARG file tool level2

IF reallydo = "YES" THEN
	"CP "PATCH_SRC"/"file" "ExpObj( tool  level2)"/"
ELSE
	SAY "CP "PATCH_SRC"/"file" "ExpObj( tool  level2)"/"
RETURN

/*---------------- copy fromfile tofile in expanded tool-path ------------------*/

ExpCopy:
PARSE ARG fromfile tofile tool level2

IF reallydo = "YES" THEN
	"CP "ExpObj( tool  level2)"/"fromfile" "ExpObj( tool  level2)"/"tofile
ELSE
	SAY "CP "ExpObj( tool  level2)"/"fromfile" "ExpObj( tool  level2)"/"tofile
RETURN

/*---------------- move fromfile tofile in expanded tool-path ------------------*/

ExpMove:
PARSE ARG fromfile tofile tool level2

IF reallydo = "YES" THEN
	"MV "ExpObj( tool  level2)"/"fromfile" "ExpObj( tool  level2)"/"tofile
ELSE
	SAY "MV "ExpObj( tool  level2)"/"fromfile" "ExpObj( tool  level2)"/"tofile
RETURN

/*---------------- Copy from patch-dir to path ------------------*/

CopyFromPatch:
PARSE ARG file pfad

IF reallydo = "YES" THEN
	"CP "PATCH_SRC"/"file" "pfad
ELSE
	SAY "CP "PATCH_SRC"/"file" "pfad
RETURN

/*---------------- Copy from prol-dir to path ------------------*/

CopyFromProl:
PARSE ARG file pfad

IF reallydo = "YES" THEN
	"CP "PROL_SRC"/"file" "pfad
ELSE
	SAY "CP "PROL_SRC"/"file" "pfad
RETURN

/*---------------- copy of files with mask-critera (sed.tmp) ------------------*/

MaskCopy:
PARSE ARG fromFile toFile

CALL SysFileTree "tools\"fromFile, 'file', 'FSO'

do i=1 to file.0
   InCompileDir = POS(TRANSLATE(TRANSLATE(COMPILE_DIR,"\","/")), TRANSLATE(file.i))
   IF InCompileDir > 1 THEN DO
	IF reallydo = "YES" THEN
		"CP "file.i" "FILESPEC("drive", file.i)""FILESPEC("path", file.i)""toFile
	ELSE
		SAY "CP "file.i" "FILESPEC("drive", file.i)""FILESPEC("path", file.i)""toFile
   END
end
RETURN

/*---------------- backup and change of files with mask-criteria (sed.tmp) ------------------*/

MaskBackupChangeWithSedTmp:
PARSE ARG dir Mask

CALL SysFileTree dir'\'Mask, 'file', 'FSO'

do i=1 to file.0
   InCompileDir = POS(TRANSLATE(TRANSLATE(COMPILE_DIR,"\","/")), TRANSLATE(file.i))
   IF InCompileDir > 1 THEN DO
	CALL checkAllSedChangedFiles(file.i)
	IF reallydo = "YES" THEN DO
		"IF NOT EXIST "file.i".org CP "file.i" "file.i".org"
		"SED -f sed.tmp  < "file.i".org > "file.i
	END
	ELSE DO
		SAY "IF NOT EXIST "file.i".org CP "file.i" "file.i".org"
		SAY "SED -f sed.tmp  < "file.i".org > "file.i
	END
   END
end
RETURN


/*---------------- backup and change of Makefiles in dir tutorials ------------------*/

BackupChangeInTutorialsWithSedTmp:

CALL SysFileTree 'tutorials\Makefile', 'file', 'FSO'

do i=1 to file.0
	CALL checkAllSedChangedFiles(file.i)
	IF reallydo = "YES" THEN DO
		"IF NOT EXIST "file.i".org CP "file.i" "file.i".org"
		"SED -f sed.tmp  < "file.i".org > "file.i
	END
	ELSE DO
		SAY "IF NOT EXIST "file.i".org CP "file.i" "file.i".org"
		SAY "SED -f sed.tmp  < "file.i".org > "file.i
	END
end
RETURN


/*---------------- backup and change of a file with sed.tmp ------------------*/

ExpBackupChangeWithSedTmp:
PARSE ARG tool level2 file

ExpPath=ExpObj(tool level2)
CALL BackupChangeWithSedTmp( ExpPath"/"file )
RETURN

BackupChangeWithSedTmp:
PARSE ARG ExpandedPathFile

CALL checkAllSedChangedFiles(ExpandedPathFile)
IF reallydo = "YES" THEN DO
	"IF NOT EXIST "ExpandedPathFile".org CP "ExpandedPathFile" "ExpandedPathFile".org"
	"SED -f sed.tmp  < "ExpandedPathFile".org > "ExpandedPathFile
END
ELSE DO
	SAY "IF NOT EXIST "ExpandedPathFile".org CP "ExpandedPathFile" "ExpandedPathFile".org"
	SAY "SED -f sed.tmp  < "ExpandedPathFile".org > "ExpandedPathFile
END
RETURN

/*---------------- check for double-changed files ------------------*/

checkAllSedChangedFiles:
PARSE ARG ExpandedPathFile

	sedFilesCnt = sedFilesCnt+1
	sedFiles.sedFilesCnt = ExpandedPathFile
	DO actSedFile = 1 TO sedFilesCnt-1
		IF sedFiles.sedFilesCnt = sedFiles.actSedFile THEN DO
			SAY ">>> double processed: "sedFiles.actSedFile
			exit 1
		END
	END
RETURN

/*---------------- used by the rexx "linkall" implementation ----------------*/

CopyHierachy:
PARSE ARG fromDir toDir
	"CP -r "fromDir"\* "toDir"\"
return

MkDirs:
PARSE ARG base machineDir
	"RM -r "base"\archi  2>nul"
	"MD "base"\archi  2>nul"
	"MD "base"\archi\"machineDir "2>nul"
	"MD "base"\archi\"machineDir"\bin 2>nul"
	"MD "base"\archi\"machineDir"\include 2>nul"
	"MD "base"\archi\"machineDir"\lib 2>nul"
return

exists:
'DIR "'arg(1)'" >nul 2>&1'
if rc = 0 THEN RETURN 1
RETURN 0
