/*
 * Psych0's Astrology Tool
 * (k) 1998, 1999 by Andrew Ziem <ziem@iex.net>
 * http://members.xoom.com/sdexter/psoft/
 *
 */

#ifndef PAT_H
#define PAT_H


/* -- compilers ------------------------------------------------------ */

/* GNU EMX/GCC v0.9c */
#if defined(__GNUC__) && defined(__EMX__)
#define COMPILER_NAME     "GNU/EMX"
#define __OS2__
#define __32__
#define __FLAT__
#define USE_FOPEN
#define MAXPATH   255     /* this is really bad */
#define MAXDRIVE  3
#define MAXDIR    200
#define MAXFILE   200
#define MAXEXT    50      /* but it'll do for now */
#define INC_DIRPORT
#define INC_FNSPLIT
#define strcmpi(a, b)     stricmp(a, b)
#define memset(a, b, c)   memset(a, c, b)
#endif

/* DJGPP (DOS) v2.8 */
#if (__DJGPP__)
#include <dir.h>
#define COMPILER_NAME     "DJGPP"
#define __DOS__
#define __32__
#define __FLAT__
#define FINDATTR          FA_ARCH|FA_RDONLY
#define ffname(a)         (a).ff_name
#define ffsize(a)         (a).ff_fsize
typedef struct ffblk DIRSTRUCT;
/* disable UNIX-like filename expansion */
char **__crt0_glob_function(char *_arg) { return 0; }
#endif

/* Borland Turbo C v3.00 */
#if defined(__TURBOC__)       
#include <dos.h>
#include <dir.h>
#define COMPILER_NAME     "Borland Turbo C"
#define __DOS__
#define __16__
#define INTERACTIVE
#define USE_FOPEN
#define FINDATTR          0
#define bzero(a, b)       memset(a, b, 0x00)
#define ffname(a)         (a).ff_name
typedef struct ffblk DIRSTRUCT;
#endif

/* GCC/EMX */
#if defined(INC_DIRPORT) && defined(__EMX__)
#include "dirport.c"           /* SNIPPETS */
typedef DOSFileData DIRSTRUCT;
#define findfirst(a,b,c)  FIND_FIRST(a,c,b)
#define findnext(a)       FIND_NEXT(a)
#define FINDATTR         FILE_NORMAL | FILE_ARCHIVED
#define ffname(a)        (a).f.d_name
#endif

#if defined(__DOS__) && defined(__16__)
#define EXECUTABLE_NAME   "pat.exe"
#elif defined(__DOS__) && defined(__32__)
#define EXECUTABLE_NAME   "pat386.exe"
#elif defined(__OS2__)
#define EXECUTABLE_NAME   "pat2.exe"
#endif


/* --- includes ------------------------------------------------------ */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "common.h"  /* mine, contact information macro */
#include "lls.c"     /* SNIPPETS, linked list support */
#include "stristr.c" /* SNIPPETS, case insenstive strstr() */

#ifdef INC_FNSPLIT
#include "fnsplit.c"
#define fnsplit(a, b, c, d, e)     fnSplit(a, b, NULL, c, NULL, d, e)
#define fnmerge(a, b, c, d, e)     fnMerge(a, b, NULL, c, NULL, d, e)
#endif


/* --- #definitions -------------------------------------------------- */

/* how long of a line we'll be reading */
#define MAX_FGETS  128
#define MAX_LINE   128

/* null terminator used for char, not==NULL */
#define NUL '\0'

#define strip_trailing(a) if (a[strlen(a)-1]=='\n') a[strlen(a)-1]=NUL;



#define PROG_BASENAME     "Psych0's Astrology Tool"
#define PROG_BASEVER      "1.20"
#include "name.h"

#define PROG_DATE         __DATE__

#define PROG_NAMEVER  PROG_NAME " v" PROG_VER

#define PROG_DISP_ONE     PROG_NAME " v" PROG_VER " -- " PROG_DATE
#define PROG_DISP_TWO     "(k) 1998, 1999 by Andrew Ziem <ziem@iex.net>"

#define BODIES 28

#define SIGNS 12 + 1  /* signs */
#define MONTHS 12 + 1

#define ERROR -1
#define FALSE 0
#define TRUE 1

#define DAT_HDR           "@PAT DATA001"


/* --- structures ---------------------------------------------------- */

typedef unsigned int bit;

typedef signed int YEAR;

typedef struct
{
     int    sign;                      /* 1= Aries...12= Pisces, 0 = off */
     int    degrees,                   /*                          0..30 */
            minutes;                   /*                          0..60 */
     bit    retrograde;                /*                         on/off */
} PLANET;

typedef struct
{
     unsigned int    mday,             /*                          1..31 */
                     month;            /*                          1..12 */
     YEAR            year;             /*               no year 0 please */
     unsigned int    hour,             /*                   24 hour form */
                     minutes;          /*                          0..60 */
     signed int      timezone;         /*          hours offset from GMT */
     unsigned int    timezone_minutes;
     bit             daylightsavings;  /*                         on/off */
     char            location[40];     /*                       location */
     signed int      longitude,        /*         neg = east; pos = west */
                     latitude;         /*       neg = south; pos = north */
     unsigned int    longitude_minutes,
                     latitude_minutes;
} BORN;

typedef struct
{
 char            name[40];         /*             nombre del hombre  */
 BORN            born;
 PLANET          planet[BODIES];
} CHART;



/* --- variables, more #definitions, and miscellaneous --------------- */

#define TXT_LINE_ONE    "*** " PROG_NAME " version " PROG_VER "\n"
#define TXT_LINE_TWO    "*** by Andrew Ziem <psych0o@juno.com>\n"
#define TXT_LINE_THREE  "*** http://members.xoom.com/sdexter/psoft/\n"

#define SIZEOF_CHART sizeof(CHART)

#define SORT_TYPE_BYSIGN       1
#define SORT_TYPE_DOUBLE       2
#define SORT_TYPE_NAME         3
#define SORT_TYPE_NUMEROLOGY   4
#define SORT_TYPE_CHINESE      5
#ifdef SORT_YMD
#define SORT_TYPE_YMD          6
#endif



#define SUN         0  
#define MOON        1  /* planets */
#define MERCURY     2
#define VENUS       3
#define MARS        4
#define JUPITER     5
#define SATURN      6
#define URANUS      7
#define NEPTUNE     8
#define PLUTO       9
#define CUPIDO     10 /* transneptunian/uranian bodies */ 
#define HADES      11
#define ZEUS       12
#define KRONOS     13
#define APOLLON    14
#define ADMETOS    15
#define VULKANUS   16
#define PROSERPINA 17
#define POSEIDO    18
#define CHIRON     19 /* asteroids */
#define CERES      20
#define PALLAS     21
#define JUNO       22
#define VESTA      23
#define NORTHNODE  24 /* imaginary */
#define SOUTHNODE  25
#define FORTUNE    26
#define VERTEX     27
#define EAST       28


/* as Astrolog has them, easier to
   define them than to manipulate their full names */
char *astbodytxt[] =
{  "Sun :",    "Moon:",    "Merc:",    "Venu:",    "Mars:",
   "Jupi:",    "Satu:",    "Uran:",    "Nept:",    "Plut:",
   "Cupi:",    "Hade:",    "Zeus:",    "Kron:",    "Apol:",
   "Adme:",    "Vulk:",    "Pros:",    "Pose:",    "Chir:",
   "Cere:",    "Pall:",    "Juno:",    "Vest:",    "Node:",
   "S.No:",    "Fort:",    "Vert:",    "East:" };

/* full names */
char *bodytxt[] =
{  "Sun",        "Moon",     "Mercury",     "Venus",     "Mars",
   "Jupiter",    "Saturn",   "Uranus",      "Neptune",   "Pluto",
   "Cupido",     "Hades",    "Zeus",        "Kronos",    "Apollon",
   "Admetos",    "Vulkanus", "Proserpina",  "Poseido",   "Chiron",
   "Ceres",      "Pallas",   "Juno",        "Vesta",     "North Node",
   "South Node", "Fortune",  "Vertex",      "East Point"};

/* hungry */
char *abv_sign_txt[] =
{  "nul", "Ari", "Tau", "Gem", "Can", "Leo", "Vir",
   "Lib", "Sco", "Sag", "Cap", "Aqu", "Pis" };

/* signs */
char *sign_txt[] =
{  "null", "Aries", "Taurus", "Gemini", "Cancer", "Leo", "Virgo",
   "Libra", "Scorpio", "Sagittarius", "Capricorn", "Aquarius", "Pisces" };

char *chinese_zodiac_txt[] =
{  "null", "Rat", "Ox", "Tiger", "Cat", "Dragon", "Snake",
   "Horse", "Goat", "Monkey", "Rooster", "Dog", "Pig" };

char *elements_txt[] =
{ "Fire", "Water", "Air", "Earth" };

char *triplicalities_txt[] =
{ "Cardinal", "Mutable", "Fixed" };

/* months */
char *abv_months_txt[] =
{  "nul", "Jan", "Feb", "Mar", "Apr", "May", "Jun",
   "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" };

/* tokens used within PAT's data file */
char *data_tokens[] =
{  "Name", "Birthdate", "Birthtime", "Timezone", "Location",
   "Latitude", "Longitude", "End" };

#define DATA_NAME      0
#define DATA_BIRTHDATE 1
#define DATA_BIRTHTIME 2
#define DATA_TIMEZONE  3
#define DATA_LOCATION  4
#define DATA_LATITUDE  5
#define DATA_LONGITUDE 6
#define DATA_END       7
#define DATA_TOKENS    8

int ListCharts = 0, charts = 0, CompareResult;
int SortFieldType, SortFieldBody, SortFieldBodySecondary;


/* --- prototypes ---------------------------------------------------- */

int locate_token(char *find, char **strarr, int objects);
char *get_seg(const char *line, int piece, char seperator);
int read(char *fname);
int read_chart(char *fname);
int read_data(char *fname);
int write_data(char *fname);
int write_bysign(char *fname);
int write_plain(char *fname);
int write_numerology(char *fname);
int CompChart(const void *C1, const void *C2);
int sort_data(int type, int body1, int body2);
void usage(void);
void exitfunc(void);


#endif /* PAT_H */


/* end of file "PAT.H" */
