## Copyright (C) 1996 Auburn University.  All Rights Reserved.
##
## This file is part of Octave. 
##
## Octave is free software; you can redistribute it and/or modify it 
## under the terms of the GNU General Public License as published by the 
## Free Software Foundation; either version 2, or (at your option) any 
## later version. 
## 
## Octave is distributed in the hope that it will be useful, but WITHOUT 
## ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
## FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License 
## for more details.
## 
## You should have received a copy of the GNU General Public License 
## along with Octave; see the file COPYING.  If not, write to the Free 
## Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111 USA. 
 
## function sysp = parallel(Asys,Bsys)
## Forms the parallel connection of two systems.
##
##              ____________________
##              |      ________    |
##     u  ----->|----> | Asys |--->|----> y1
##         |    |      --------    |
##         |    |      ________    |
##         |--->|----> | Bsys |--->|----> y2
##              |      --------    |
##              --------------------
##                   Ksys

function sysp = parallel (Asys, Bsys)

  ## Written by David Clem August 15, 1994
  ## completely rewritten Oct 1996 a s hodel
  ## SYS_INTERNAL accesses members of system structure

  if(nargin != 2)
    usage("sysp = parallel(Asys,Bsys)");
  endif
  if(! is_struct(Asys) )
    error("1st input argument is not a system data structure")
  elseif (! is_struct(Bsys) )
    error("2nd input argument is not a system data structure")
  endif
  [Ann,Anz,mA] = sysdimen(Asys);
  [Bnn,Bnz,mB] = sysdimen(Bsys);
  if(mA != mB)
    error(["Asys has ",num2str(mA)," inputs, Bsys has ",num2str(mB)," inputs"]);
  endif

  ## save signal names
  Ain = sysgetsg(Asys,"in");

  ## change signal names to avoid warning messages from sysgroup
  Asys = syssetsg(Asys,"in",sysdefio(length(Ain),"Ain_u"));
  Bsys = syssetsg(Bsys,"in",sysdefio(length(Ain),"Bin_u"));

  sysp = sysgroup(Asys,Bsys);
  sysD = ss2sys([],[],[],[eye(mA);eye(mA)]);
  
  sysp = sysmult(sysp,sysD);
  sysp = syssetsg(sysp,"in",Ain);
  
endfunction
