/* Installationsskript zur Abkrzungen-Datenbank  */
SIGNAL ON ERROR NAME Fehler

SAY " "

/* REXXUTIL laden */
CALL rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
CALL sysloadfuncs

/* Abfrage, in welchem Pfad wir sind */
CALL SysFileTree 'acronyms.*', datei, 'FO'
IF datei.0 < 3 THEN
DO
   SAY "Anscheinend haben sie das Archiv ACRO*.* noch nicht entpackt."
   SAY "Bitte erledigen Sie dies und beginnen Sie dann nochmal."
   EXIT
END

/* Den Pfad und die Platte extrahieren */
pfad = FILESPEC("path",datei.1)
disk = FILESPEC("drive",datei.1)
path = OVERLAY(pfad,disk,3)

SAY "Installationsscript zur Abkrzungen-Datenbank  (c) 1995 Uwe Schlenther Software"
SAY "==============================================================================="
SAY " "

/* Ansonsten Daten erfragen */
Abfrage:
SAY "In welchem Pfad soll die Abkrzungen-Datenbank installiert werden ?"
SAY "(z.B. C:\ACRONYMS)  "
PARSE PULL pfad
IF pfad = "" THEN pfad="C:\ACRONYMS"
SAY " "
SAY "Die Abkrzungen-Datenbank wird im Pfad " pfad " installiert."
SAY " "
SAY "Geben sie <return> fr weiter ein, <K> fr Korrektur oder <A> fr Abbruch!"
PULL antwort

/* Auswerten */
IF antwort = "A" THEN SIGNAL Abbruch
IF antwort = "K" THEN SIGNAL Abfrage

SAY "Danke...."

weiter:
/* Jetzt ggf. das Verzeichnis erzeugen */
rc = SysMkDir(pfad)

/* und die dort ntigen Dateien hinverschieben */
INTERPRET "'COPY ACRONYMS.EXE 'pfad'\*.*'"
INTERPRET "'COPY ACRONYMS.DB 'pfad'\*.*'"
INTERPRET "'COPY ACRONYMS.INF 'pfad'\*.*'"
INTERPRET "'COPY ACRONYMS.ICO 'pfad'\*.*'"

/* Anlegen des Ordners auf der WPS */
SAY " "
SAY "Soll ein Programmobjekt fr die Abkrzungen-Datenbank erstellt werden?"
SAY "Geben sie <J> oder <N> ein!"
PULL antwort

/* Auswerten */
IF antwort = "N" THEN SIGNAL Ende
SAY " "
SAY "WPS-Objekte werden erzeugt..."

/* Den Ordner anlegen */
klasse='WPFolder'
titel='Abkrzungen-Datenbank'
ort='<WP_DESKTOP>'
param='OBJECTID=<ABK_ORDNER>;'
mode='fail'
rc = SysCreateObject(klasse,titel,ort,param,mode)

/* Das Programmobjekt anlegen */
klasse='WPProgram'
titel='Abkrzungen-Datenbank'
ort='<ABK_ORDNER>'
param='PROGTYPE=PM;EXENAME='pfad'\ACRONYMS.EXE;ICONFILE='pfad'\ACRONYMS.ICO;STARTUPDIR='pfad';'
mode='fail'
rc = SysCreateObject(klasse,titel,ort,param,mode)

/* Das Hilfeobjekt anlegen */
klasse='WPProgram'
titel='Hilfe zur Abkrzungen-Datenbank'
ort='<ABK_ORDNER>'
param='PROGTYPE=PM;NOPRINT=YES;HELPPANEL=4083;EXENAME=VIEW.EXE;NOPRINT=YES;STARTUPDIR='pfad';PARAMETERS='pfad'\ACRONYMS.INF;'
mode='fail'
Location = "<WP_TEMPS>"
Title = "Hilfedatei"
rc = SysCreateObject(klasse,titel,ort,param,mode)

/* Ende-Meldung */
Ende:
SAY "Die Abkrzungen-Datenbank ist jetzt installiert!"
SAY " "
SAY "Bitte beachten Sie, da in dieser Demo-Version lediglich 200 Datenstze"
SAY "enthalten sind. Die Vollversion enthlt den vollstndigen Datenbestand"
SAY "mit ber 12.000 Eintrgen."
EXIT

/* Standard-Fehlerhandler */
Fehler:
SAY "Es ist ein Fehler aufgetreten. Bitte versuchen Sie's nochmal!"
EXIT

/* Abbruch des scripts */
Abbruch:
SAY "Schade, da Sie das Installationsprogramm abgebrochen haben!"
EXIT

