/**************************************************************************
 *                                                                        *
 *              This code is copyright (c) 1994 & 1995                    *
 *                        Athena Design, Inc.                             *
 *        This code is copyright (c) 1996 & 1997 & 1998 & 1999            *
 *                       Sundial Systems Corp.                            *
 *                                                                        *
 *                        ALL RIGHTS RESERVED                             *
 *                                                                        *
 **************************************************************************/


#define INCL_ERRORS
#define INCL_DOS

#include <os2.h>

#ifdef __cplusplus
extern "C"
{
#endif
    /* The Mesa 2 feed table is a list of feeds that consist of:    */
    /*   a) Two strings up to 28 characters in length used as       */
    /*      the identifiers for the feed.  These can be any strings */
    /*      that you choose.                                        */
    /*   b) The current value of the feed. (double precision float) */
    /*   c) Timestamp when the feed was last updated. This is in    */
    /*      universal time. (seconds since 00:00:00 Jan 1, 1970.    */
    /*   d) (Optionally) A history of the last "n" values and       */
    /*      the timestamps for the feed.                            */

    /* If the functions below return strings in the parameters, the */
    /* input strings MUST be at least 29 bytes long.  Otherwise, a  */
    /* a crash may occur.                                           */

    /* returns the version number of the feed table. */
    extern int _System RTFVersion();

    #define CURRENT_FEED_VERSION 2

    /* returns the last time the feed table was updated */
    extern void _System getRTFTableTime(DATETIME *);

    /* sets a value in the feed table */
    extern int _System setRTFValue(char *, char *,double);

    /* deletes a feed from the table.  It also deletes feeds */
    /* from the list of "missing" feeds as well as deletes */
    /* the history for the feed if one is available. */
    extern int _System deleteRTFValue(char *, char *);

    /* gets the current value of a feed */
    extern int _System getRTFValue(char *, char *,double *);

    /* gets the time (seconds since 1/1/1970) when the given */
    /* feed was last posted. */
    extern int _System getRTFTime(char *, char *,unsigned long *);

    /* gets an older value of a feed.  If the given feed is not */
    /* setup to maintain the history or not to the required depth, */
    /* it will automatically set the feed up to do so. */
    extern int _System getOldRTFValue(char *, char *,int ,double *);

    /* gets the time (seconds since 1/1/1970) when the older */
    /* feed was last posted. */
    extern int _System getOldRTFTime(char *, char *,int ,unsigned long *);

    /* Gets the value of a feed a the specified number of seconds in */
    /* the past. */
    extern int _System getRTFValueAtTime(char *, char *, int, double *);

    /* Returns the number of feeds that are either valid or missing */
    extern int _System getNumberOfFeeds();
    extern int _System getNumberOfMissingFeeds();


    /* For speed, Mesa 2 queries all the feeds for a given workbook in one call. */
    /* This avoids cycling the global mutex for each feed. */
    extern int _System getMultiRTFValue(int num, char **s1, char **s2,int *historyLevel,
                                        double *vals, unsigned long *timestamps,
                                        int *status);


    /* If you maintain your own table, you can set all the values at once */
    /* with this call.  Again, this avoids cycling the global mutex for   */
    /* each feed. */
    extern int _System setMultiRTFValue(int num, char **, char **,double *);


    /* Returns the number of old values being maintained for the feed. */
    extern int _System getFeedHistoryLevel(char *, char *);

    /* Sets the number of old values being maintained for the feed. */
    extern int _System setFeedHistoryLevel(char *, char *, int);


    /* Returns 1 if successfull.  The unsigned long will be used to record */
    /* the time (universal) that the feed was first attempted */
    extern int _System getMissingFeed(int num, char *, char *, unsigned long *);

    /* These return the number of feeds actually copied to the array */
    extern int _System getAllMissingFeeds(int max, char **, char **, unsigned long *);

    /* These return the number of feeds actually copied to the array */
    extern int _System getAllFeeds(int max, char **, char **);



    /* Saves the entire feed table to a file which can then be loaded later */
    extern void _System saveFeedTable(char *filename);
    extern void _System loadFeedTable(char *filename);


    /* Purges all feeds that have not been updated since the given time */
    extern void _System purgeOldFeeds(unsigned long tm);
    /* Emptys all values from the feed table */
    extern void _System emptyFeedTable();


    /* Allows atomic access to the feed table.  Each lock MUST have an */
    /* unlock or dead-lock conditions will occur. */
    extern void _System lockFeedTable();
    extern void _System unlockFeedTable();

    /* Registers the REXX feed functions */
    extern void _System loadRexxFeedFuncs();

#ifdef __cplusplus
}
#endif


