/*



        Sample REXX script to request weather data from the National

        Weather Service and place it into Mesa's feed pool.



        Uses WGET available from Hobbes.



        Uses Mesa 2.3's GETMISSINGFEED to automatically add new requests



        Creates feed entries with primary key of "WEATHER"

        Creates secondary keys in the form of "<AIRPORTCODE>/<ATTRIBUTE>"

                Where <AIRPORTCODE> is the three letter code such as LAX

                Where <ATTRIBUTE> is one of the following:

                        WindDirection

                        WindSpeed

                        Temperature

                        DewPoint

                        Humidity

                        BarometricPressure



        For example, to retrieve the LAX temperature:

                FEED("WEATHER","LAX/Temperature")

*/



/* List of airports to request */

AirportList = ""

/* List of airports that were not found at NWS */

BadAirportList = ""



/* Time (minutes) between refreshes */

RefreshMinutes = 15



                   

BaseURL = 'http://weather.noaa.gov/weather/current/'



/* Load the needed functions */

rc = RxFuncAdd("MesaLoadFeedFuncs","mesafeed","MesaLoadFeedFuncs")

call MesaLoadFeedFuncs

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'

call SysLoadFuncs



/* Create the CRLF combo */

CRLF = D2C(13)""D2C(10)





/* Set stop flag to off */

rc = SETFEED("WEATHER","STOP",0)

call GetAirportList



/* the loop */

do forever

        StopFlag = GETFEED("WEATHER","STOP")

        if StopFlag = 1 then do

                exit 0

        end

        if LENGTH(AirportList) > 0 then do

             rc = GetData(AirportList)

        end



        /* sleep, but wakeup every 10 seconds to */

        /* check for new airports */

        do count = 1 to RefreshMinutes*6

             call CheckForNewAirports

             rc = SysSleep(10)

        end /* do */

end





/* Gets the web pages, then calls parsing routine */

GetData: procedure expose BaseURL

        List = ARG(1);

        say 'Getting data for: 'List

        RC = 1

        do Index = 1 to WORDS(List)

                CurrentAirport = WORD(List,Index)

                URL = BaseURL||'K'||CurrentAirport||'.html'

                FileName = 'K'||CurrentAirport||'.html'

                call SysFileDelete FileName

                'wget -nd 'URL

                if RC = 0 then do

                        call ParseFileAndSetFeed FileName

                end

        end

return RC



ParseFileAndSetFeed: procedure

PARSE ARG Filename

do while LINES(FileName) > 0

        Line = LINEIN(FileName)

        select

                when POS('>(K', Line) > 0 then do

                        Airport = SUBSTR(Line, POS('>(K', Line) + 3, 3)

                end

                when POS('Wind', Line) > 0 & Direction = 'DIRECTION' then do

                        Line = ''

                        do while LINES(FileName) > 0 & Line = ''

                                Line = LINEIN(Filename)

                        end

                        if Line <> '' then do

/*from the WSW (250 degrees) at 14 MPH (13 KT) */

                                PARSE VAR Line Rest1' from the 'Direction' ('Degrees' degrees) at 'MPH' MPH'Rest3

                        end

                end

                when POS('Temperature', Line) > 0 & Temp = 'TEMP' then do

                        Line = ''

                        do while LINES(FileName) > 0 & Line = ''

                                Line = LINEIN(FileName)

                        end

                        if Line <> '' then do

                                PARSE VAR Line Rest1'  'Temp' F ('Rest2

                        end

                end

                when POS('Dew Point', Line) > 0 & Dew = 'DEW' then do

                        Line = ''

                        do while LINES(FileName) > 0 & Line = ''

                                Line = LINEIN(FileName)

                        end

                        if Line <> '' then do

                                PARSE VAR Line Rest1'  'Dew' F ('Rest2

                        end

                end

                when POS('Relative Humidity', Line) > 0 & Humidity = 'HUMIDITY' then do

                        Line = ''

                        do while LINES(FileName) > 0 & Line = ''

                                Line = LINEIN(FileName)

                        end

                        if Line <> '' then do

                                PARSE VAR Line Rest1'  'Humidity'%'

                        end

                end

                when POS('Pressure (altimeter)', Line) > 0 & Pressure = 'PRESSURE' then do

                        Line = ''

                        do while LINES(FileName) > 0 & Line = ''

                                Line = LINEIN(FileName)

                        end

                        if Line <> '' then do

                                PARSE VAR Line Rest1'  'Pressure'in. Hg'Rest2

                        end

                end

                otherwise do

                end

        end



end



call LINEOUT FileName



rc = SetFeed("WEATHER",Airport"/WindDirection",Degrees)

rc = SetFeed("WEATHER",Airport"/WindSpeed",MPH)

rc = SetFeed("WEATHER",Airport"/Temperature",Temp)

rc = SetFeed("WEATHER",Airport"/DewPoint",Dew)

rc = SetFeed("WEATHER",Airport"/Humidity",Humidity)

rc = SetFeed("WEATHER",Airport"/BarometricPressure",Pressure)

return 0





CheckForNewAirports:

   MissingFeedCount = GetMissingFeeds("Str1.","Str2.")

   if MissingFeedCount > 0 then do

      do i = 1 to MissingFeedCount

         if Str1.i = "WEATHER" then do

            PARSE VAR Str2.i NewAirport'/'Attribute

            if LENGTH(NewAirport) > 0 then do

               if POS(NewAirport, AirportList) = 0 then do

                  if POS(NewAirport, BadAirportList ) = 0 then do

                     if GetData(NewAirport) = 0 then do

                        say 'Adding 'NewAirport' to AirportList'

                        if LENGTH(AirportList) = 0 then do

                           AirportList = NewAirport

                        end

                        else do

                           AirportList = AirportList||' '||NewAirport

                        end

                     end

                     else do

                        say 'Adding 'NewAirport' to BadAirportList'

                        if LENGTH(BadAirportList) = 0 then do

                           BadAirportList= NewAirport

                        end

                        else do

                           BadAirportList= BadAirportList||' '||NewAirport

                        end

                     end /* do */

                  end

               end

            end

         end

      end

   end

return 0





GetAirportList:

   FeedCount = GetAllFeeds("Str1.","Str2.")

   if FeedCount > 0 then do

      do i = 1 to FeedCount

         if Str1.i = "WEATHER" & Str2.i <> 'STOP' then do

            say Str2.i

            PARSE VAR Str2.i NewAirport'/'Attribute

            if LENGTH(NewAirport) > 0 then do

               if POS(NewAirport, AirportList) = 0 then do

                  if GetData(NewAirport) = 0 then do

                     say 'Adding 'NewAirport' to AirportList'

                     if LENGTH(AirportList) = 0 then do

                        AirportList = NewAirport

                     end

                     else do

                        AirportList = AirportList||' '||NewAirport

                     end

                  end

                  else do

                     say 'Adding 'NewAirport' to BadAirportList'

                     if LENGTH(BadAirportList) = 0 then do

                        BadAirportList= NewAirport

                     end

                     else do

                        BadAirportList= BadAirportList||' '||NewAirport

                     end

                  end

               end

            end

         end

      end

   end

return 0

