/* REXX Script to install Ini2URLs on the desktop */

	call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
	call SysLoadFuncs

	rc = SysSetIcon(DIRECTORY() || "\INI2URLS.CMD", DIRECTORY() || "\Icons\INI2URLS.ICO")
	if SysCreateObject("WPProgram", "Ini2URLs v3.0", "<WP_DESKTOP>", "NOAUTOCLOSE=YES;EXENAME=" || DIRECTORY() || "\INI2URLS.CMD;STARTUPDIR=" || DIRECTORY() ||";", "replace") Then
		Say 'Created the Ini2URLs object on your desktop'
	else do
		Say 'Failed to create the Ini2URLs object on your desktop'
		Exit
	end

	destination = '<WP_DESKTOP>'
	resultline = 'Created the folder My_URLs on the desktop'
	If SysCreateObject("WPFolder", "My_URLs", destination, "CCVIEW=YES;ICONFONT=8.Helv;ALWAYSSORT=YES;DEFAULTSORT=3;DEFAULTVIEW=ICON;ICONVIEW=NONFLOWED,MINI;OBJECTID=<WEBXURLS>;", "fail") Then
	Do
		rc = SysSetObjectData('<WEBXURLS>', 'ICONFILE=' || DIRECTORY() || '\Icons\NETF.ICO;ICONNFILE=1,' || DIRECTORY() || '\Icons\NETFOP.ICO')
		rc = SysSaveObject('<WEBXURLS>', 0)
		Say resultline
	End
	Else
	Do
		Say 'Could not create the My_URLs folder.  Does it still exist?'
		Say 'If this is a REinstallation, try running FIX-FOLD.CMD after deleting'
		Say 'all the folders created by Ini2URLs'
		Say ' '
		Say 'If this still does not work, email jroepcke@compusmart.ab.ca'
		Say 'for free support.'
		Exit
	End
	
