/* REXX Script to convert your Ini2URLs WebExplorer_Url objects *
 * to a WebExplorer Quicklist                                   */

/* Initialization of DLL's.  make sure REXXUTIL.DLL and RCSTOOLS.DLL exist
   on your LIBPATH!!  Note: REXXUTIL.DLL is usually in \OS2\DLL\ */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs
call RxFuncAdd 'RCSLoadFuncs', 'RCSTools', 'RCSLoadFuncs'
call RCSLoadFuncs

found = 'false'
call SysQueryClassList "list."
do i = 1 to list.0
	if left(list.i, 15) = "WebExplorer_Url" Then
	do
		found = 'true'
		Say 'Found the WebExplorer_Url object class in the WPS Object registy'
		Leave
	End
End
if found = 'false' then
Do
	Say 'The WebExplorer_Url object class is not registered with the'
	Say 'Workplace Shell.  This program cannot continue.  You should'
	Say 'reinstall WebExplorer 1.03 or later...'
	Say 'email jroepcke@compusmart.ab.ca for free support.'
	Exit
End

If SysSetObjectData("<WEBXURLS>", "NOTVISIBLE=NO") Then
	Say 'I found your main URLs folder and can continue.'
Else
Do
	Say 'Could not find your URLs folder.  You should run install.cmd.'
	Say 'email jroepcke@compusmart.ab.ca for free support if problems persist.'
	Exit
End

URLFolder.0 = 0
result = SysIni('USER', 'PM_Workplace:Location', 'ALL:', 'Keys')
if result = 'ERROR:' then
do
	SAY 'I wasn''t able to query the contents of the PM_Workplace:Location group in the'
	SAY 'USER INI file.  This means I can''t tell if you have any URL folders other than'
	SAY 'the main URLs folder.  Please e-mail jroepcke@compusmart.ab.ca for free support.'
	Exit
end
Say 'Getting the list of URL Folders...(which are created with `Create URL Folder`)'
do j=1 to Keys.0
	if (left(Keys.j, 6) = '<WEBX_') & (right(Keys.j, 8) = '_FOLDER>') then
	do
		If SysSetObjectData(Keys.j, "NOTVISIBLE=NO") Then
		Do
			i = 1 + URLFolder.0
			URLFolder.i = Keys.j
			URLFolder.0 = i
		End
		Else
		Do
			result = SysIni('USER', 'PM_Workplace:Location', Keys.j, 'DELETE:')
			If result = 0 then
			Do
				Say 'I found an URL folder that didn''t remove itself from the Workplace'
				Say 'Shell properly, so I removed the unnecessary information for you.'
			End
			Else
			Do
				Say 'I found an URL folder that didn''t remove itself from the Workplace'
				Say 'Shell propery when deleted, and I was not able to properly remove'
				Say 'it.  For your information, it''s OBJECTID is ' || Keys.j
			End
		End
	end
end
Say 'I found ' || URLFolder.0 + 1 || ' URL Folders in total'

/* Query the contents of <WEBXURLS> (SysFileTree) */
destination = '<WEBXURLS>'
fldrPath = RCSGetObjectPath(destination)
if fldrPath = 'ERROR:' then
Do
	SAY 'I wasn''t able to get the full pathname of your URLs folder.'
	SAY 'I cannot continue...'
	SAY 'Please e-mail jroepcke@compusmart.ab.ca for free support.'
	Exit
End

rc = SysFileTree(fldrpath || '\*.*', 'fldrCont', 'O', '*--*-')
if rc <> 0 then
do
	SAY 'I wasn''t able to get the contents of your main URLs folder.'
	SAY 'I cannot continue...'
	SAY 'Please e-mail jroepcke@compusmart.ab.ca for free support.'
	Exit
end

fspec = ''
fspec = SysSearchPath('ETC', 'Explore.Ini')
if fspec = '' Then
Do
	SAY 'I cannot find EXPLORE.INI, so I can''t continue.'
	SAY 'It should be in the path pointed to by the ETC environment variable.'
	Exit
End
bakfspec = left(fspec, length(fspec) - 3) || 'BAK'
SAY 'I''m making a backup of your EXPLORE.INI (EXPLORE.BAK)'
'copy ' || fspec || ' ' || bakfspec
if rc = 0 then
	SAY 'Backup Successful...'
Else
	SAY 'Backup could not be completed...'

Title.0 = 0
URL.0 = 0
i = 0
increment = 1
Do k=1 to fldrCont.0  /* check if ea.type = 'WebExplorer_Url' */
	if increment then
		i = i + 1
	else
		increment = 1
	thisFile = fldrCont.k
	if SysGetEA(thisFile, '.type', 'TYPEINFO') <> 0 then
	Do
		SAY 'I wasn''t able to determine the file type of:'
		SAY thisFile
		SAY 'Please e-mail jroepcke@compusmart.ab.ca for free support.'
		Exit
	End
	parse var typeinfo 11 type
	if type <> 'WebExplorer_Url' then
		increment = 0
	else
	Do
		if SysGetEA(thisFile, '.longname', 'LONGNAMEINFO') <> 0 then
		Do
			SAY 'I wasn''t able to determine the .longname of file ' || thisFile
			SAY 'I will use the filename for the title instead.'
			Title.i = FILESPEC('name', thisFile)
		End
		Else
		do
			parse var longnameinfo 5 longname
			Title.i = longname
		end
		Title.i = TRANSLATE(Title.i, ' ', '_')
		Title.i = 'quicklist= ' || Title.i
		rc = stream(thisFile, 'c', 'open read')
		if rc <> 'READY:' then
		do
			Say 'I cannot open ' || thisFile || ' Explore.Ini.  Terminating...'
			Exit
		End
		if stream(thisFile, 's') = 'READY' Then
		do
			URL.i = LINEIN(thisFile)
			Title.0 = Title.0 + 1
			URL.0 = URL.0 + 1
		end
		else
		do
			Say 'I wasn''t able to get the URL for ' || thisFile || '.  I will try to continue.'
			increment = 0
		end
		theresult = stream(thisFile, 'c', 'close')
	End
End			

j = 1
Do j=1 to URLFolder.0 /* iterate over each of the found <WEBX_*_FOLDER> folders */
	if URLFolder.j = '<WEBX_New_URLs_FOLDER>' then
	do
		if j <> URLFolder.0 then
		do
			jj = URLFolder.0
			temp = URLFolder.jj
			URLFolder.jj = URLFolder.j
			URLFolder.j = temp
		end
	end
	if increment then
		i = i + 1
	else
		increment = 1
	thisFolder = URLFolder.j
	/* now RCSGetObjectPath */
	fldrPath = RCSGetObjectPath(thisFolder)
	if fldrPath = 'ERROR:' then
	Do
		SAY 'I wasn''t able to get the full pathname of an URLs folder.'
		SAY 'ObjectID = ' || thisFolder || '.  I cannot continue...'
		SAY 'Please e-mail jroepcke@compusmart.ab.ca for free support.'
		Exit
	End
	/* and get the .longname of the folder */
	/* add to stems */
	if SysGetEA(fldrPath, '.longname', 'LONGNAMEINFO') <> 0 then
	Do
		SAY 'I wasn''t able to determine the .longname of folder'
		SAY fldrPath
		SAY 'I will use the name of the folder for the title instead.'
		Title.i = FILESPEC('name', fldrPath)
	End
	Else
	do
		parse var longnameinfo 5 longname
		Title.i = longname
	end
	Title.i = TRANSLATE(Title.i, ' ', '_')
	Title.i = 'quicklist= ____' || Title.i || '____'
	URL.i = 'http://dummy.ini2urls.' || copies(d2c(97 + (j // 26)), 1 + (j % 27)) /* '.b' .. '.a', '.bb' .. '.aa' */
	Title.0 = Title.0 + 1
	URL.0 = URL.0 + 1
	/* SysFileTree the folderpath */
	rc = SysFileTree(fldrpath || '\*.*', 'fldrCont', 'O', '*--*-')
	if rc <> 0 then
	do
		SAY 'I wasn''t able to get the contents of an URLs folder.'
		SAY 'Path = ' || fldrPath || '.  I cannot continue...'
		SAY 'Please e-mail jroepcke@compusmart.ab.ca for free support.'
		Exit
	end

	/* iterate over each file like above */
	Do k=1 to fldrCont.0  /* check if ea.type = 'WebExplorer_Url' */
		if increment then
			i = i + 1
		else
			increment = 1
		thisFile = fldrCont.k
		if SysGetEA(thisFile, '.type', 'TYPEINFO') <> 0 then
		Do
			SAY 'I wasn''t able to determine the file type of:'
			SAY thisFile
			SAY 'Please e-mail jroepcke@compusmart.ab.ca for free support.'
			Exit
		End
		parse var typeinfo 11 type
		if type <> 'WebExplorer_Url' then
			increment = 0
		else
		Do
			if SysGetEA(thisFile, '.longname', 'LONGNAMEINFO') <> 0 then
			Do
				SAY 'I wasn''t able to determine the .longname of file ' || thisFile
				SAY 'I will use the filename for the title instead.'
				Title.i = FILESPEC('name', thisFile)
			End
			Else
			do
				parse var longnameinfo 5 longname
				Title.i = longname
			end
			Title.i = TRANSLATE(Title.i, ' ', '_')
			Title.i = 'quicklist= ' || Title.i
			rc = stream(thisFile, 'c', 'open read')
			if rc <> 'READY:' then
			do
				Say 'I cannot open ' || thisFile || ' Explore.Ini.  Terminating...'
				Exit
			End
			if stream(thisFile, 's') = 'READY' Then
			Do
				URL.i = LINEIN(thisFile)
				Title.0 = Title.0 + 1
				URL.0 = URL.0 + 1
			end
			else
			do
				Say 'I wasn''t able to get the URL for ' || thisFile || '.  I will try to continue.'
				increment = 0
			end
			theresult = stream(thisFile, 'c', 'close')
		End
	End
End


homedest = destination
fspec = ''
fspec = SysSearchPath('ETC', 'Explore.Ini')
if fspec = '' Then
Do
	SAY 'I cannot find EXPLORE.INI, so I can''t continue.'
	SAY 'It should be in the path pointed to by the ETC environment variable.'
	Exit
End
rc = stream(fspec, 'c', 'open read')
if rc <> 'READY:' then
do
	Say 'But I cannot open Explore.Ini.  Terminating...'
	Exit
End
linenum = 0
explore.0 = 0
i = 0
DO WHILE stream(fspec, 's') = 'READY'
	i = i + 1
	lineread = LINEIN(fspec)
	explore.i = lineread
	explore.0 = explore.0 + 1
end
theresult = stream(fspec, 'c' 'close')
quicklistline = -1
do i=linenum to explore.0
	If STRIP(explore.i, 'T') = '[quicklist]' then
	do
		quicklistline = i
		Leave
	end
end
if quicklistline = -1 then
do
	Say 'I Couldn''t find the [quicklist] section in your current'
	Say 'Explore.Ini.  Terminating...'
	Exit
end
blankline = explore.0
Do i=quicklistline + 1 to explore.0 /* find a blank line */
	If STRIP(explore.i, 'B') = '' then
	do
		blankline = i
		Leave
	end
end
/* Now write out the new EXPLORE.INI */
rc = stream(fspec, 'c', 'open write')
if rc <> 'READY:' then
do
	Say 'I cannot open the EXPLORE.INI file to update it.  Terminating...'
	Exit
End
rc = LINEOUT(fspec,,1) /* sets the filepos to beginning of file */
do i=1 to quicklistline
	rc = LINEOUT(fspec, explore.i)
end
/* write out the quicklist here */
do i=1 to Title.0 /* or URL.0 */
	rc = LINEOUT(fspec, Title.i)
	rc = LINEOUT(fspec, URL.i)
end
if blankline < explore.0 then
do
	do i=blankline to explore.0
		rc = LINEOUT(fspec, explore.i)
	end
end
theresult = stream(fspec, 'c' 'close')
Exit
