<?xml version="1.0"?>

  <!--XSLT 1.0 - http://www.untravelledsphere.com -->
  
  <!-- A GENERIC TRANSFORM TEMPLATE TO EMIT HTML INTO A MULTI-PAGE SITE -->

<xsl:transform xmlns:xlink="http://www.w3c.org/1999/xlink"
               xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
               xmlns:xmlorigin='http://www.xmlorigin.com/xslt'
               extension-element-prefixes="xmlorigin"
               version="1.0">
   

 <xsl:output method="html" omit-xml-declaration="yes"/>


  <xsl:template match="TechNote">
    <xsl:apply-templates select="Section" mode="full">
      <xsl:with-param name="namingPrefix"></xsl:with-param>
      <xsl:with-param name="filePrefix"></xsl:with-param>
      <xsl:with-param name="relativePathPrefix"></xsl:with-param>
      <xsl:with-param name="parentPageName"></xsl:with-param>
    </xsl:apply-templates>
  </xsl:template>

  <xsl:template match="Cover">
  </xsl:template>


<!-- SECTION -->  
  <xsl:template match="Section" mode="full">
    <xsl:param name="namingPrefix"/>
    <xsl:param name="filePrefix"/>
    <xsl:param name="relativePathPrefix"/>
    <xsl:param name="parentPageName" />
    
     
    <xsl:variable name="dirName">
      <xsl:value-of select="$namingPrefix"/><xsl:value-of select="./SectionTitle"/><xsl:text>/</xsl:text>
    </xsl:variable>

    <xsl:variable name='depth'>
       <xsl:value-of select="count(./ancestor::node())" />
    </xsl:variable >
  
    <xsl:variable name='saveFileName'>
      <xsl:if test="position() = 1"><xsl:value-of select="$filePrefix"/>index.html</xsl:if>
      <xsl:if test="position() > 1">
        <xsl:value-of select="concat($filePrefix,'page_',position(),'.html')" />
      </xsl:if>
    </xsl:variable>
    
    <xsl:variable name='fileName'>
      <xsl:if test="position() = 1"><xsl:value-of select="$namingPrefix"/>index.html</xsl:if>
      <xsl:if test="position() > 1">
        <xsl:value-of select="concat($namingPrefix,'page_',position(),'.html')" />
      </xsl:if>
    </xsl:variable>

    <xsl:variable name='prevFileName'> 
      <xsl:if test="position() = 1">
        <xsl:value-of select="concat('page_',last(),'.html')" />
      </xsl:if>
      <xsl:if test="position() = 2">index.html</xsl:if>
      <xsl:if test="position() > 2">
        <xsl:value-of select="concat('page_', position() - 1, '.html')" />
      </xsl:if>
    </xsl:variable>
    
    <xsl:variable name='nextFileName' >
      <xsl:if test="position() = last()">index.html</xsl:if>
      <xsl:if test="position() &lt; last()">
        <xsl:value-of  select="concat('page_', position() + 1, '.html')" />
      </xsl:if>
    </xsl:variable>



    
    <!-- <saxon:output href="{$saveFileName}" > -->
    <xmlorigin:document href="{$saveFileName}" method="html">
    <html>
    <head><title><xsl:value-of select="//Cover/Title" /></title></head>
    <body>
        <center><img src="{$relativePathPrefix}images/PageLogo.jpg"/></center>
    <center>
      <center><font size='7' color='BB2222'><xsl:value-of select="SectionTitle"/></font></center>
    <xsl:if test="last() > 1">
      <a href="{$prevFileName}" ><img border='0' src="{$relativePathPrefix}images/previous.jpg"/></a>
    </xsl:if>
    <xsl:if test='$depth>2'>
      <a href="{concat('../',$parentPageName)}" ><img border='0' src="{$relativePathPrefix}images/parent.jpg"/></a>
    </xsl:if>
    <xsl:if test='$depth=2'>
      <!-- <a href="index.html" ><img border='0' src="{$relativePathPrefix}images/parent.jpg"/></a>  -->
    </xsl:if>
    <xsl:if test="last() > 1">
      <a href="{$nextFileName}" ><img border='0' src="{$relativePathPrefix}images/next.jpg" /></a>
    </xsl:if>
    </center>
    <hr/>

    <xsl:apply-templates select="SectionContent"/>

    <hr/>

    <table border='0'>
    <xsl:apply-templates select="./Section" mode="subsectionLinks">
      <xsl:with-param name="namingPrefix" select="$dirName" />
      <xsl:with-param name="relativePathPrefix" select="$relativePathPrefix" />
    </xsl:apply-templates>
    </table>

    <hr size='3'/>
    <center>
      <small><font color='blue'>This page is maintained by Gregory Bourassa<br/>
        <a href="mailto:Gregory.bourassa@stelco.ca?SUBJECT=SMS_Developers_Page">Gregory.Bourassa@stelco.ca</a>
        <br/>The entire site is generated automatically from a single XML document<br/>
        conforming to the TechNote DTD </font></small> 
    </center>

    </body>
    </html>
    <!-- </saxon:output> -->

    </xmlorigin:document >
    

  <xsl:apply-templates select="./Section" mode="full" >
      <xsl:with-param name="namingPrefix" select="$namingPrefix" />
      <xsl:with-param name="filePrefix" >
        <!-- select="$dirName" /> -->
        <xsl:value-of select="$filePrefix"/><xsl:value-of select="./SectionTitle"/><xsl:text>/</xsl:text>
      </xsl:with-param>
      <xsl:with-param name="relativePathPrefix" select="concat('../',$relativePathPrefix)" />
      <xsl:with-param name="parentPageName" select="$fileName" />
    </xsl:apply-templates >

  </xsl:template>



  <xsl:template match="Section" mode="subsectionLinks">
    <xsl:param name="namingPrefix"/>
    <xsl:param name="filePrefix"/>
    <xsl:param name="relativePathPrefix"/>
    <xsl:param name="parentPageName"/>
    
    <xsl:variable name='fileName'>
      <xsl:if test="position() = 1"><xsl:value-of select="$namingPrefix"/>index.html</xsl:if>
      <xsl:if test="position() > 1">
        <xsl:value-of select="concat($namingPrefix,'page_',position(),'.html')" />
      </xsl:if>
    </xsl:variable>

    <tr>
      <td bgcolor='FFFF99' width='400'>
        <img src='{$relativePathPrefix}images/bulletB.gif' align='center'/>
        <strong><a href="{$fileName}"><xsl:value-of select="./SectionTitle"/></a></strong>
      </td>
      <td bgcolor='DDDDFF'>
        <xsl:value-of select="./SectionContent/Paragraph[1]"/>
      </td>
    </tr>
  </xsl:template>





  <xsl:template match="UseCase">
    <table border="1">
    <tr><td>Use Case Name</td><td colspan="2"><xsl:value-of select="./UseCaseTitle" /></td></tr>
    <tr><td>Requirement</td><td colspan="2"><xsl:value-of select="./UCRequirement" /></td></tr>
    <tr><td>Goal</td><td colspan="2"><xsl:value-of select="./UCGoal" /></td></tr>
    <tr><td>Preconditions</td><td colspan="2"><xsl:apply-templates select="./UCPreconditions" /></td></tr>
    <tr><td>Actors</td><td colspan="2"><xsl:apply-templates select="./UCActors" /></td></tr>
    <tr><td>Description</td><td>Step</td><td>Action</td></tr>
    <xsl:apply-templates select="./UCDescription/Paragraph" />
    <tr><td>Result</td><td colspan="2"><xsl:apply-templates select="./UCResult" /></td></tr>
   </table>    
  </xsl:template>

  
  <xsl:template match="UCDescription/Paragraph">
    <tr><td> </td><td><xsl:number /></td><td><xsl:apply-templates /></td></tr>
  </xsl:template>


  <xsl:template match="ImageLink">
    <br/>
  <center>
    <strong><xsl:value-of select='.' /></strong>
    <br/>
    <img alt='{.}' border='0' src='{@xlink:href}'/>
  </center>
  </xsl:template>

  <xsl:template match="PageLink">
    <a href='{@xlink:href}'><xsl:value-of select='.' /></a>
  </xsl:template>

  <xsl:template match="Paragraph">
    <p><xsl:apply-templates  /></p>
  </xsl:template>

  <xsl:template match="T">
    <xsl:value-of select="." />
   </xsl:template>
 
  <xsl:template match="GlossaryEntry">
    <xsl:value-of select="./FullName"/> (<strong><xsl:value-of select="./Abbreviation"/></strong>) 
  </xsl:template>

  <xsl:template match="List">
    <xsl:if test="@style='ordered'">
    <ol>
    <xsl:apply-templates />
  </ol>
  </xsl:if>
    <xsl:if test="@style!='ordered'">
    <ul>
    <xsl:apply-templates />
  </ul>
  </xsl:if>
  </xsl:template>
  
  <xsl:template match="Member">
    <li><xsl:apply-templates /></li>
  </xsl:template>


  <xsl:template match="Emphasis[@intensity='high']">
    <strong><xsl:value-of select="."/></strong>
  </xsl:template>

  <xsl:template match="Emphasis">
    <i><xsl:value-of select="."/></i>
  </xsl:template>

  <xsl:template match="Table">
    <table border="1">
    <xsl:apply-templates />
  </table>
  </xsl:template>
    
  <xsl:template match="TableRow">
    <tr>
    <xsl:apply-templates />
  </tr>
  </xsl:template>


  <xsl:template match="TableCell">
    <td>
    <xsl:apply-templates />
  </td>
  </xsl:template>

</xsl:transform>

 