/*
  select DISTINCT Vers from Keys where Domain = arg(2) ==> AddStringList -> arg(1)
*/

Obj  = arg(1);
!Dom = arg(2);

KysDBName = "keys.dbf";

if(0) then ret = Rexxbase_OpenDBF("KysDBName");

/* ------						*/
/* STEP-1: Read seq all Vers into Stem			*/
/* ------						*/
Vers.  = "";
Vers.0 = 0;

Filter = "Domain='"!Dom"'";
ret = Rexxbase_FilterDBF("KysDBName",Filter);  Mess = XSay( ret,"Filtering for Versions:"); if Mess <> "" then SIGNAL ErrExit;
ret = Rexxbase_GoToRecord("KysDBName","TOP");  Mess = XSay( ret,"Goto Top:");               if Mess <> "" then SIGNAL ErrExit;
do while ret="" | ret="TOF"
   ret = Rexxbase_ReadDBF("KysDBName");        Mess = XSay( ret,"Reading for Versions:");   if Mess <> "" then SIGNAL ErrExit;

   if(0) then do;say "Nach Readdbf:"ret"...pull:"; pull;end;

   if ret="" then do
      i = Vers.0 +1;
      Vers.i = strip( KysDBName.Vers );
      Vers.0 = i;
   end;
end;
if(0) then ret = Rexxbase_CloseDBF("KysDBName");
else;      ret = Rexxbase_FilterDBF("KysDBName","");

/* ------						*/
/* STEP-2: Sort VersionStem				*/
/* ------						*/
ok  = VRSortStem( "Vers.", "SrtVers." );

/* ------						*/
/* STEP-3: Group all Sorted-Stem-Entries by Vers	*/
/* ------						*/
Vers.  = "";
Vers.0 = 0;
OldVer = "";
do i = 1 to SrtVers.0
   !Vers = SrtVers.i;
   if !Vers <> OldVer then do
      j = Vers.0 +1;
      Vers.j = !Vers;
      Vers.0 = j;
   end;
   OldVer = !Vers;
end;
ok  = VRMethod( Obj, "AddStringList", "Vers." );

return ret;

/* --------------------------------------------		*/
ErrExit:
if(0) then ret = Rexxbase_CloseDBF("KysDBName");
else;      ret = Rexxbase_FilterDBF("KysDBName","");
say "Mess="Mess"!";
return Mess;

/* --------------------------------------------		*/
XSay: Procedure;
What = strip(arg(1));
Text = strip(arg(2));
if What = ""	,
 | What = "TOF"	,
 | What = "BOF" then RETURN "";

say date()"-"substr(time(),1,8)"=>"Text What;
return Text What;
