/*******************************************************************************
    Bitmap handler resources
     Peter Koller 1998, All Rights Reserved
*******************************************************************************/
#ifndef BMPHAND_RESOURCES
#define BMPHAND_RESOURCES
/*******************************************************************************
    pointers
*******************************************************************************/
#define     PROF_STYLESHEET     ",ssh"
#define     PROF_LOADIMG        ",loadstyle"
#define     DEF_STYLESHEET      "*"
#define     EXT_STYLESHEET		".ssh"
#define     EXT_MEGAFILE	    "MBM"

#define		MSKMAPCLASS			"MaulMakeMsk"
#define		CROPMAPCLASS		"MaulCropmap"

/*******************************************************************************
    RCDATA descriptions
*******************************************************************************/
#define IDACC_DEFLTKEYS         40

/*******************************************************************************
    bitmaps
*******************************************************************************/
#define IDBMP_HANDLER       1000
#define IDBMP_COLOFILL      1001
#define IDBMP_ORIENTATION   1002

/*******************************************************************************
    add on menu...
*******************************************************************************/

/*******************************************************************************
    edit menu
*******************************************************************************/
#define HAND_REMOVE         (FIRST_MENU_ID + 1)
#define BMP_CUT             (FIRST_MENU_ID + 2)
#define BMP_COPY            (FIRST_MENU_ID + 3)
#define BMP_PASTE           (FIRST_MENU_ID + 4)
#define BMP_CLEAR           (FIRST_MENU_ID + 5)
#define BMP_LOAD            (FIRST_MENU_ID + 6)
#define BMP_SZLOCK          (FIRST_MENU_ID + 7)
#define BMP_ASPECTLOCK      (FIRST_MENU_ID + 8)
#define BMP_POSLOCK         (FIRST_MENU_ID + 9)
#define BMP_TILEMODE        (FIRST_MENU_ID + 10)
#define BMP_SCALE           (FIRST_MENU_ID + 11)
#define BMP_ROTATE          (FIRST_MENU_ID + 12)
#define BMP_FRAMECROP       (FIRST_MENU_ID + 13)
#define BMP_FRAMESTYLESAVE	(FIRST_MENU_ID + 14)
#define BMP_REDPI           (FIRST_MENU_ID + 15)
#define BMP_DPIRESET        (FIRST_MENU_ID + 16)
#define BMP_CROP            (FIRST_MENU_ID + 17)

#define SCND_MENU_ID        (FIRST_MENU_ID + 20)
#define BMP_INFO            SCND_MENU_ID
#define BMP_OFFLINING		(SCND_MENU_ID + 1)
#define BMP_RESAMPLE		(SCND_MENU_ID + 2)
//
#define BMP_ROTLEFT			(SCND_MENU_ID + 4)
#define BMP_ROTRIGHT		(SCND_MENU_ID + 5)
#define BMP_VERTMIRROR		(SCND_MENU_ID + 6)
#define BMP_HORZMIRROR		(SCND_MENU_ID + 7)
#define BMP_SCALEBITS		(SCND_MENU_ID + 8)
#define BMP_COLOR           (SCND_MENU_ID + 9)
#define BMP_ADDMASKMP       (SCND_MENU_ID + 10)
#define BMP_DELMASKMP		(SCND_MENU_ID + 11)
#define BMP_CUTMASKMP       (SCND_MENU_ID + 12)
#define BMP_CPYMASKMP		(SCND_MENU_ID + 13)
#define BMP_FRAMESTYLESEL   (SCND_MENU_ID + 20)	/* must be last */
#define BMP_EXTEDITSEL   	(BMP_FRAMESTYLESEL + MENU_FILELIST_LIM)

/*******************************************************************************
    button bar
*******************************************************************************/
#define     IDB_COLORFILL       FIRST_BBAR_ID
#define     IDB_ORIENTATE       (FIRST_BBAR_ID + 1)

/*******************************************************************************
    status bar
*******************************************************************************/
#define     IDS_HANDIDENT   FIRST_STAT_ID
#define     IDS_BMPSTATUS   (FIRST_STAT_ID + 1)

/*******************************************************************************
    help table
*******************************************************************************/

/*******************************************************************************
    string defs
*******************************************************************************/
#define IDS_HELPWINTITLE    16  //"Maul bitmap handler help"
#define IDS_HELPLIBRARY     17  //"bmphand.hlp"
#define IDS_NEWBITMAP       18  //"load new bitmap"
#define IDS_LOCKSIZE        19  //"change bitmap resize lock"
#define IDS_LOCKASPECT      20  //"change bitmap aspect lock"
#define IDS_CHANGEROTN      21  //"change bitmap rotation"
#define IDS_CHANGESCALE     22  //"change bitmap scale"
#define IDS_CHANGECOLS      23  //"change bitmap colours"
#define IDS_DELETEHAND      24  //"remove bitmap handler"
#define IDS_BMPCUT          25  //"cut bitmap"
#define IDS_BMPPASTE        26  //"paste bitmap"
#define IDS_BMPCLEAR        27  //"clear bitmap"
#define IDS_TILEMAP         28  //"change bitmap tile mode"
#define IDS_POSLOCK         29  //"change bitmap position lock"
#define IDS_CLIPBD_ERR      30  //"Error - failed to save clipboard data"
#define IDS_CLIPBD_HANDLE   31  //"Error - failed to save bitmap handle"
#define IDS_FILE_EXISTS     32  //"Warning - File Exists, save anyway ?"
#define IDS_IMPORTTITLE     33  //"Import Pictures"
#define IDS_IMPORTBUTTON    34  //"~Import"
#define IDS_EXPORTTITLE     35  //"Export Pictures"
#define IDS_EXPORTBUTTON    36  //"~Export"
#define IDS_LOADPICTURE     37  //"Load Picture"
#define IDS_IMGFORMERR      38  //"Unknown image format"
#define IDS_HANDMENU        39  //"~Bitmap"
#define UNDO_ROTATE         40  //"rotate image"
#define UNDO_MIRROR         41  //"mirror image"
#define IDS_NOSTYLESHEET    42  //"No stylesheet is selected"
#define IDS_BMPDATASCALE    43  //"change bitmap size"

#define IDS_SETSTYLE		45  //"add bitmap handler style data"
#define IDS_STYLE_DELETE	46  //"Delete this style sheet"
#define IDS_STYLE_EXISTS	47  //"Style sheet exists, overwrite"
#define UNDO_REFORMAT_ID    50  //"update header version"
#define UNDO_RESAMPLE		51  //"change size and colour depth"
#define UNDO_TUNEIMG		52  //"change image tuning"
#define UNDO_OFFLINE		53  //"move image offline"
#define UNDO_ONLINE			54  //"move image online"
#define BMPINFO_MSG			55  //"%d x %d, %d bits per pel\n%s\nImage is %sline"
#define BMPINFO_OFF			56  //"off"
#define BMPINFO_ON			57  //"on"
#define BMPINFO_MASK		58  //"\nIncludes maskmap"
#define BMPINFO_TITLE		59  //"Image information"
#define OPTMENU_REFRESH		60  //"Refresh offlined bitmaps"
#define OPTMENU_MESSAGE		61  //"Recreate all placeholder bitmaps from their offlined versions"
#define OFFLINE_ERROR1		62  //"Offline image - images don't match"
#define OFFLINE_ERROR2		63  //"Offline image - missing or bad mask map"
#define OFFLINE_ERROR3		64  //"Offline image file is missing"
#define UNDO_MAKEMSK		65  //"make mask map"
#define UNDO_DELETEMSK		66  //"remove mask map"
#define IDS_BMPCROP			67  //"crop bitmap"
#define IDS_HANDLERTYPE     68  //"Bitmaps"
#define IDS_HANDLERNAME     69  //"Bitmap handler"
#define IDS_IMPORTNTYPE     70  //"Bitmaps (*.bmp)"
#define IDS_IMPORTNNAME     71  //"Import bitmaps, also from clipboard"
#define IDS_EXPORTNTYPE     72  //"Native multimap (*.mbm)"
#define IDS_EXPORTNNAME     73  //"Export native multi bitmaps"
#define	IDS_IOFILTCOMPAT	74	//"bitmap handler compatible"
#define	IDS_IOFILTICONS		75	//"native or bitmaps with mask maps"
#define	IDS_IOFILTMSKBMP	76	//"maul native maskable bitmaps"
#define	IDS_SCALEBMPINFO1	77	//"size %s x %s (%d x %d)"
#define	IDS_SCALEBMPINFO2	78	//"scaled %d%% x %d%%"
#define	IDS_SCALEBMPINFO3	79	//"24 bits per pel, %sMb"
#define IDS_GENERALERROR	80  //"Error - Function failed"
#define BMPSTATS_MSG		81  //"%d x %d, %dbpp"

#define IDFH_EDITTASK       140 //"Select bitmap editing tasks"
#define IDFH_BMPPARMS       141 //"Select bitmap parameters"
#define IDFH_HANDIDENT      142 //"Bitmap handler is active"
#define IDFH_COLOR          143 //"Edit colour table"
#define IDFH_ORIENT         144 //"Rotate bitmap"
#define IDFH_BMPSTATUS      145 //"Bitmap information"

/*******************************************************************************
    Dialogs
*******************************************************************************/
#define IDD_HELPBUTTON          100
#define IDD_RESETBUTTON         101
#define IDD_REFRESHBUTTON       102
#define IDD_SAVEBUTTON       	103

#define IDD_ROTATEDLG           110
#define IDD_ROTATEACTUAL        111
#define IDD_ROTATEOBJECT        112
#define IDD_ROTATEENTRY         113
#define IDD_ROTATECONTROL       114

#define IDD_SCALEDLG            120
#define IDD_SCALEXENTRY         121
#define IDD_SCALEXUP            122
#define IDD_SCALEXDOWN          123
#define IDD_SCALEXSLIDER        124
#define IDD_SCALEYENTRY         125
#define IDD_SCALEYUP            126
#define IDD_SCALEYDOWN          127
#define IDD_SCALEYSLIDER        128
#define IDD_SCALESAMPLE         129
#define IDD_SCALELOCK           130
#define IDD_SCALEBIGX           131
#define IDD_SCALEBIGY           132

#define IDD_SCALEBMPDDLG        140
#define IDD_SCALEBMPDHARSH      141
#define IDD_SCALEBMPDCRISP      142
#define IDD_SCALEBMPDSMOTH      143
#define IDD_SCALEBMPDDPI        144
#define IDD_SCALEBMPDINF1		145
#define IDD_SCALEBMPDINF2		146
#define IDD_SCALEBMPDINF3		147

#define DID_PRIORIMG_PB         270
#define DID_NEXTIMG_PB          271
#define DID_TILESCALE           272

#define IDD_OFFLINEDLG			300

#define IDD_STYLE_DLG			310
#define IDD_STYLE_ENTRY			311
#define IDD_STYLE_DELETE		312
#define IDD_STYLE_GROUPBOX		313

#define IDD_MASKMAKEDLG			320
#define IDD_MASKMAKESHWMSK		321
#define IDD_MASKMAKECOORD		322
#define IDD_MASKMAKECURC		323
#define IDD_MASKMAKESELC		324
#define IDD_MASKMAKECOPY		325
#define IDD_MASKMAKETOLE		326

#define IDD_SAMPLEDLG			380
#define IDD_BMPPCBAR			381
#define IDD_SAMPLEGRPBOX		382

#define IDD_EDCOLDLG			390
#define IDD_EDCOLFIELD			391
#define IDD_EDCOLPRIOR			392
#define IDD_EDCOLNEXT			393

#define IDD_CREATEMSKDLG		400
#define IDD_CREATEMSKINV		401
#define IDD_CREATEMSKCOL		402
#define IDD_CREATEMSKLOAD		403
#define IDD_CREATEMSKPASTE		404
#define IDD_CREATEMSKMAKE		405
#define IDD_CREATEMSKFETCH		406

#define	IDD_CROPDLG				420
#define	IDD_CROPTOP				421
#define	IDD_CROPLEFT			423
#define	IDD_CROPRIGHT			425
#define	IDD_CROPBOTTOM			427
#define	IDD_CROPOLDSIZE			429
#define	IDD_CROPNEWSIZE			430

#endif
