/* NDRLANDS.CMD : Installeer de Nederlandse versie van Pluma. */

'@echo off'

/* Zet de titel van het programma */

Title = 'Pluma 1.10'

/* Laad REXXUTIL */

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs

/* Initialiseer */

Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX

Call SysCls
Say 'Installatie van Pluma nu bezig...'
Say ''

/* Controlleer of de verschillende bestanden beschikbaar zijn. */

Language = 'NDRLANDS'

Result = SysFileTree( 'PLUMA.EXE', 'Files', 'F')
If Files.0 = 0 Then
   Do
   Say 'FOUT: PLUMA.EXE niet gevonden!'
   Signal DONE
   End

Result = SysFileTree( Language".DLL", 'Files', 'F')
If Files.0 = 0 Then
   Do
   Say 'FOUT: 'Language'.DLL niet gevonden!'
   Signal DONE
   End

Result = SysFileTree( Language".HLP", 'Files', 'F')
If Files.0 = 0 Then
   Do
   Say 'FOUT: 'Language'.HLP niet gevonden!'
   Signal DONE
   End

/* Vraag naar de directory waarin het programma moet geplaatst worden */

Say 'Geef a.u.b. de volledige naam van de directory waarin'
Say ' PLUMA moet geplaatst worden (standaard C:\OS2\APPS): '
Pull Directory
If Directory = "" Then Directory = 'C:\OS2\APPS'

/* Maak de aangegeven directory indien nodig */

Result = SysFileTree( Directory, 'Dirs', 'D')
If Dirs.0 = 0 Then
   Do
   Result - SysMkDir( Directory )
   If Result == 0 Then
      Do
      End
   Else
      Do
      Say 'FOUT: Onmogelijk om de aangegeven directory te maken.'
      Signal DONE
      End
   End
Say ''

/* Voer de installatie uit */

Say 'PLUMA wordt op' Directory 'gecopieerd...'
Copy PLUMA.EXE Directory                   '1>NUL'
Copy Language".DLL" Directory"\PLUMA.DLL"  '1>NUL'
Copy Language".HLP" Directory"\PLUMA.HLP"  '1>NUL'

Say 'Het programma-object wordt gemaakt...'
Type = 'WPProgram'
Folder = '<WP_DESKTOP>'
Parms = "MINWIN=DESKTOP;PROGTYPE=PM;EXENAME="Directory"\PLUMA.EXE;STARTUPDIR="Directory";OBJECTID=<PLUMA>;NOPRINT=YES;ASSOCTYPE=Pluma;"
Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )

If Result = 1 Then
   Say 'Object gemaakt! Klaar.'
Else
   Say 'FOUT: Object niet gemaakt.'

Signal DONE

FAILURE:
Say 'REXX fout.'
Signal DONE

HALT:
Say 'REXX halt.'
Signal DONE

SYNTAX:
Say 'REXX taalfout.'
Signal DONE

DONE:
Exit
