/****
 INSTALL.CMD for XYOS2SHL.ZIP  1/23/97  R.J.Holmgren
 Locate in the directory that contains all unzipped XYOS2SHL files,
 then command "INSTALL"
****/

'@echo off'
'cls'
quot=""""
last=''
exclude='#'

if RxFuncQuery("SysLoadFuncs") then do
  call RxFuncAdd "SysLoadFuncs","RexxUtil","SysLoadFuncs"
  call SysLoadfuncs
  end

Shell=translate(value('COMSPEC',,'OS2ENVIRONMENT'))
if pos(':',Shell)\=2 then call BadShell
Verify=stream(Shell,'C','query exists')
if Verify='' then call BadShell
call SysIni "BOTH","FolderWorkareaRunningObjects","ALL:","Objects"
BootDrive=translate(left(Objects.1,1))
currdir=directory()
if right(currdir,1)='\' then currdir=left(currdir,length(currdir)-1)
changedir=currdir
mdosdir=BootDrive||":\OS2\MDOS"
newdir=directory(mdosdir)
if newdir=mdosdir then call directory currdir
else do
  say
  say
  say mdosdir" not found!"
  say "XYOS2SHL.ZIP cannot be installed."
  say
  say BootDrive": should be the drive where OS/2 is installed;"
  say "  directory \OS2\MDOS should provide DOS support."
  call beep 1000,200
  exit
  end

say
say
say "		Xy-OS/2 Shell (XYOS2SHL.ZIP)"
say "		~~~~~~~ ~~~~~  ~~~~~~~~~~~~"
say "		 INSTALL.CMD v1.0e  1/23/97"
say
say "INSTALL needs to know the *fully-qualified* ""d:\dir"" of your XyWrite"
say "U2 file, or, if no U2 file exists, of your XyDOS (v4.011+) or XyWin"
say "editor (filenames EDITOR.EXE or XW.EXE), e.g.:"
say
say "	C:\XY4 or F:\XW"
say
say "INSTALL.CMD will place XYOS2SHL's XyWrite files (O2.PM, SW.PM,"
say "RUNCMD.PM, LISTOBJS.CMD, XYOS2SHL.U2, and XYOS2SHL.DOC) in the"
say "directory that you specify now.  All OS/2 files in this XYOS2SHL"
say "package (O2.CMD, O2-ALIAS.DAT, O2.ICO, O2.BAT, SW.CMD, SW.BAT,"
say "STARTOS2.EXE, PMSW.EXE, and TL.EXE) will be installed in the"
say BootDrive||":\OS2\MDOS directory."
say
call charout ,"Hit ""Y"" to continue, or Escape to abort now?  (Y|n|esc) "
dummy=''
dummy=SysGetKey('noecho')
parse upper var dummy dummy
if dummy='1b'x then dummy='N'
say
if dummy='N' then do
  say
  say "Aborting"
  exit
  end
do until length(xydir)>0
  say
  call charout ,"Enter name of XyWrite install Drive:\DIRectory: "
  pull xydir
  xydir=strip(xydir)
  end
say
if right(xydir,1)='\' then xydir=left(xydir,length(xydir)-1)
newdir=directory(xydir)
if newdir\=xydir then do
  say "Drive:\DIRectory "quot||xydir||quot" doesn't exist!"
  say "XYOS2SHL.ZIP cannot be installed."
  say "Start over and try again.  Aborting . . . "
  say
  call beep 1000,200
  exit
  end
else call directory currdir
say "Install XyWrite files to directory "||xydir
say

arg.1="XYOS2SHL.DOC"
arg.2="LISTOBJS.CMD"
arg.3="O2-ALIAS.DAT"
arg.4="O2.CMD"
arg.5="SW.CMD"
arg.6="O2.ICO"
arg.7="PMSW.EXE"
arg.8="TL.EXE"
arg.9="STARTOS2.EXE"
arg.10="O2.BAT"
arg.11="SW.BAT"
arg.12="O2.PM"
arg.13="RUNCMD.PM"
arg.14="SW.PM"
arg.15="XYOS2SHL.DOC"
arg.16="XYOS2SHL.U2"
arg.17="LISTOBJS.CMD"

b="Testing   "
initchk=0
do c=1 to 14
  call CheckIt
  end

if pos('#1#',exclude)>0 then exclude=exclude||'15#'

copies=0
b="Modifying "
initchk=1
text="LBA"
x="LBASV01,"||BootDrive||";*;"
do c=13 to 14
  if pos('#'||c||'#',exclude)=0 then call ChangeIt
  end

text="BootDrive="
x="BootDrive="||quot||BootDrive||quot
do c=4 to 5
  if pos('#'||c||'#',exclude)=0 then call ChangeIt
  end

if pos('#3#',exclude)=0 then do
  c=3
  text="FullScreen"
  x="="||quot||"FullScreen OS/2 Command Session"||quot||" /C /FS /P:XyWr /R call directory "||quot||BootDrive||":\"||quot||"; "||quot||Shell||quot
  call ChangeIt
  text="GoDir"
  x="\="||quot||"GoDir"||quot||" /C /FS /R call directory "||quot||"%1"||quot||";"||quot||Shell||quot
  call ChangeIt
  text="Full_Screen"
  x="="||quot||"Full_Screen OS/2 Command Session"||quot||" /C /FS /P:XyWr "||Shell
  call ChangeIt
  text="OS/2_Window"
  x="w="||quot||"OS/2_Window"||quot||" /C /WIN /P:XyWr "||Shell
  call ChangeIt
  text="Global Explorer"
  x="e="||quot||"Global Explorer"||quot||" /C /M:"||BootDrive||":\TCPIP\BIN\TELNET.ICO "||BootDrive||":\TCPIP\BIN\EXPLORE.EXE -q -t 8"
  call ChangeIt
  text="time="
  x="time=/b /c /M:"||BootDrive||":\OS2\MDOS\O2.ICO NISTIME.EXE -s1"
  call ChangeIt
  end

if pos('#10#',exclude)=0 then do
  c=10
  text="p:Xy"
  x="echo /e /h /p:Xy > "||BootDrive||":\os2\mdos\o2.ini"
  call ChangeIt
  text="%9"
  x="echo %1 %2 %3 %4 %5 %6 %7 %8 %9 >> "||BootDrive||":\os2\mdos\o2.ini"
  call ChangeIt
  text="startos2"
  x=BootDrive||":\os2\mdos\startos2.exe "||quot||"OS2 from DOS"||quot||" /c /fs "||BootDrive||":\os2\mdos\o2.cmd > "||"NUL"
  call ChangeIt
  end

if pos('#11#',exclude)=0 then do
  c=11
  text="startos2"
  x=BootDrive||":\os2\mdos\startos2.exe /c /b /fs "||BootDrive||":\os2\mdos\sw.cmd %1 %2 > "||"NUL"
  call ChangeIt
  end

if pos('#12#',exclude)=0 then do
  c=12
  text="LBA"
  x="LBASV661,"||BootDrive||";*;"
  call ChangeIt
  text="ICO file"
  x="SV667,/M:"||BootDrive||":\os2\mdos\o2.ico;*; ICO file"
  call ChangeIt
  text="Get COMSPEC"
  x="IFVA|678<1SV678,"||Shell||"EI;*; Get COMSPEC"
  call ChangeIt
  end

if pos('#13#',exclude)=0 then do
  c=13
  text="CMD Big Screen"
  x="SV02,""CMD Big Screen""SX50,IS02+"" /C /FS /I /R call directory '""+VA@01+""'; '"||Shell||"'""2.o2"
  call ChangeIt
  end

b="Creating  "
if pos('#12#',exclude)=0&pos('#13#',exclude)=0&pos('#14#',exclude)=0 then do
  c=16
  x='echo ;U2;> '||currdir||'\XYOS2SHL.U2'
  x
  x='echo SS0,SZ=12PT,UF=STANDARD,LM=0,RM=0,PW=85DI,OF=0,4DI,IP=0,0,0,NJ,HY=0,PL=273LI,273LI,273LI,FD=273LI,TP=0,BT=0,RT=0,TS=16DI,24DI,32DIUS0>> '||currdir||'\XYOS2SHL.U2'
  x
  x='echo XYOS2SHL.U2 [XYOS2SHL.ZIP] by R.J.Holmgren  1/23/97>> '||currdir||'\XYOS2SHL.U2'
  x
  x='copy '||currdir||'\XYOS2SHL.U2+'||currdir||'\'||arg.12||'+'||currdir||'\'||arg.14||'+'||currdir||'\'||arg.13||'> '||'NUL'
  x
  call CheckIt
  end
else exclude=exclude||'16#'

newdir=mdosdir
do c=3 to 11
  if pos('#'||c||'#',exclude)=0 then call copy
  end

newdir=xydir
do c=12 to 17
  if pos('#'||c||'#',exclude)=0 then call copy
  end

say
b="Proving   "
initchk=0
changedir=mdosdir
do c=3 to 11
  call CheckIt
  end

changedir=xydir
do c=12 to 17
  call CheckIt
  end
say

lister=xydir||'\LISTOBJS.CMD'
rc=stream(lister,'C','query exists')
if rc\=''&pos('#17#',exclude)=0 then do
  rc=SysCreateObject('WPFolder',,
  'Xy-OS/2 Shell',,
  '<WP_DESKTOP>',,
  'OBJECTID=<XYOS2SHL>;OPEN=ICON;ICONFILE='||mdosdir||'\O2.ICO',,
  'ReplaceIfExists')
  if rc=0 then say 'Failed to Create Xy-OS/2 Shell Folder'
  else do
    say 'Folder '||quot||'Xy-OS/2 Shell'||quot||' Created'
    rc=SysCreateObject('WPProgram',,
    'List WPS Titles^and ObjectIDs',,
    '<XYOS2SHL>',,
    'OBJECTID=<LISTOBJS>;EXENAME='||lister||';PROGTYPE=WINDOWABLEVIO;ICONFILE='||mdosdir||'\O2.ICO',,
    'ReplaceIfExists')
    if rc=0 then say 'Failed to Create LISTOBJS.CMD Object'
    else say quot||'LISTOBJS.CMD'||quot||' Object Created'
    rc=SysCreateObject('WPShadow',,
    'Xy-OS/2 Shell.Doc',,
    '<XYOS2SHL>',,
    'SHADOWID='||xydir||'\XYOS2SHL.DOC',,
    'ReplaceIfExists')
    if rc=0 then say 'Failed to Create XYOS2SHL.DOC Object'
    else say quot||'XYOS2SHL.DOC'||quot||' Object Created'
    end
  end

Path=translate(value('PATH',,'OS2ENVIRONMENT'))
Path=Path||';'
if pos(mdosdir,Path)=0 then do
  call beep 1000,200
  say '				IMPORTANT NOTE:'
  say '				~~~~~~~~~ ~~~~'
  say 'The location of important Xy-OS/2 Shell files, e.g. O2.CMD,'
  say 'is not in the current PATH.  Modify CONFIG.SYS to include'
  say mdosdir||';'
  say 'in the PATH statement, then Shutdown and reboot OS/2.'
  end

say
'pause'

'cls'
say
say
say "XYOS2SHL INSTALL executed without error"
say 'Number of files installed: '||copies||' (of 15)'
say
if pos('#16#',exclude)=0 then do
  say "File XYOS2SHL.U2 has been *newly created* and now exists in"
  say "your "||xydir||" directory.  Insert XYOS2SHL.U2 within your U2 file"
  say "(if U2 exists), or else edit your STARTUP.INT|XWSTART.INT"
  say "file to issue command ""LOAD "||xydir||"\XYOS2SHL.U2""."
  say
  say "Put the following command on an empty key in your keyboard file,"
  say "to shell with a single keystroke to full-screen OS/2 in the"
  say "current directory:"
  say
  say "	nn=NOJM,2,.,g,o,2,Q2"
  say
  say "Read XYOS2SHL.DOC  there is lots of power under the hood."
  say
  call charout ,"Reload XyWrite, and "
  end
say "Enjoy."
say
say "Done"

exit

----------------------

CHECKIT:
arg1.c = changedir||'\'||arg.c
if last\=b||arg1.c then say b||arg1.c
last=b||arg1.c
a=stream(arg1.c,'C','query exists')
if a='' then do
  say
  say arg1.c||" not found!"
  if initchk=0 then do
    call charout ,"Continue Install without "||arg1.c||"?  (y|N) "
    x=SysGetKey('noecho')
    if pos(x,'Yy')=0 then do
      say
      say 'Aborting'
      exit
      end
    exclude=exclude||c||'#'
    end
  else do
    say "  UnZip XYOS2SHL.ZIP again,"
    say "  and make sure that" arg1.c "exists!  Aborting..."
    exit
    end
  say
  end
RETURN

CHANGEIT:
call SysFileSearch text, arg1.c, "found.", "N"
do i=1 to found.0
  parse var found.i linum line
  end
call linein arg1.c,1,0             /* (Re)Set Read/Write Position */
totlines=0
do while lines(arg1.c)
  totlines=totlines+1
  driveline.totlines=linein(arg1.c)
  end
driveline.linum=x
call linein arg1.c,1,0             /* (Re)Set Read/Write Position */
do a=1 to totlines
  rc=0
  call lineout arg1.c,driveline.a
  if rc>0 then call ProcError
  end
call stream arg1.c,'C','close'
call CheckIt
RETURN

COPY:
say
arg1.c = newdir||'\'||arg.c
b=1
a=stream(arg1.c,'C','query exists')
if a\='' then do
  call charout ,"File "||arg1.c||" exists - overwrite it?  y|N "
  x=SysGetKey('echo')
  b=pos(x,'Yy')
  say
  end
if b>0 then do
  rc=0
  'copy '||arg.c||' '||newdir' > '||'NUL'
  if rc>0 then call ProcError
  say 'Copying 'currdir||'\'||arg.c||' to '||newdir||' . . . '
  copies=copies+1
  end
else do
  say "   "||arg.c||" *not* copied"
  if c=16 then exclude=exclude||'16#'
  end
RETURN

BADSHELL:
do
  say
  say "The current environment variable COMSPEC is:"
  say "	"||Shell
  say "It does not specify the Drive: of your command processor,"
  say "or the indicated COMSPEC doesn't exist!"
  say "Edit CONFIG.SYS to reflect the drive:\path\filename.ext of the command"
  say "processor, e.g. "||quot||"SET COMSPEC=C:\OS2\CMD.EXE"||quot
  say "                             ^^^^^^^"
  say "Then reboot and try again."
  say
  say "Aborting."
  exit
  end
RETURN

PROCERROR:
do
  say "  Error #"||rc||" processing "||arg.c||" - Aborting"
  call beep 1000,200
  exit
  end
RETURN
