/* Sample to show basic UI component interaction */

import java.applet.*;
import java.awt.*;

public class Panel1 extends Applet {

// Define objects, data used within the applet

  String pFirst, pFont;

  Button bText = new Button("Change text");
  Button bFont = new Button("Change font");

  TextField tfText = new TextField("", 16);
  TextField tfFont = new TextField("", 16);

  Checkbox cbPlain = new Checkbox("Plain");
  Checkbox cbBold = new Checkbox("Bold");
  Checkbox cbItalic= new Checkbox("Italicized");
  CheckboxGroup cbgStyle = new CheckboxGroup();

  Choice cSize = new Choice();

  int iFontsize = 16;

  int iSizes[] = {8, 10, 12, 14, 16, 18, 20, 22, 24};

/*--------------------------------------------------------*/
/* init method -                                          */
/*  this method performs layout and initialization of     */
/*  objects for the class.                                */
/*--------------------------------------------------------*/

  public void init() {

// Get the two parameters from HTML and set the text field
// to the value of the parameter First

    pFirst = getParameter("First");
    pFont = getParameter("Font");
    tfText.setText(pFirst);

// Add buttons and textfields to the panel

    add(bText);
    add(tfText);
    add(bFont);
    add(tfFont);

// Add the fontsize choicelist and its label to the panel
// Add the fontsizes from the static array to the choice and
//  set the default size to the fourth entry

    add(new Label("Font Size"));
    add(cSize);

    for (int i=0;i<iSizes.length ;i++ ) {
       cSize.addItem( (new Integer(iSizes[i])).toString() );
    }

    cSize.select(3);


// Add the fontstyle buttons to the panel and then define them
//  as a group.  Set the initial style to BOLD

    add(cbPlain);
    add(cbBold);
    add(cbItalic);
    cbPlain.setCheckboxGroup(cbgStyle);
    cbBold.setCheckboxGroup(cbgStyle);
    cbItalic.setCheckboxGroup(cbgStyle);
    cbgStyle.setCurrent(cbBold);

// Initialize fontname from Font parameter

    tfFont.setText(pFont);

// Now show the panel (this is required)

    show();

  }

/*--------------------------------------------------------*/
/* paint method -                                         */
/*  this method performs repaint of the text using the    */
/*  specified font parameters.  The font style is         */
/*  determined from the checkbox group.  The font size is */
/*  determined from the size choice list.                 */
/*--------------------------------------------------------*/

  public void paint(Graphics g) {
    int iStyle;

    Checkbox cbTemp = cbgStyle.getCurrent();

    if (cbTemp == cbBold) {
       iStyle = Font.BOLD;
    } else {
       if (cbTemp == cbItalic) {
          iStyle = Font.ITALIC;
       } else {
          iStyle = Font.PLAIN;
       } 
    } 

    g.setFont(new Font(pFont, iStyle, iSizes[cSize.getSelectedIndex()]) );
    g.drawString(pFirst, 10, 100);

  }

/*--------------------------------------------------------*/
/* action method -                                        */
/*  invoked when an event action occurs. It processes     */
/*  the button click events.                              */
/*--------------------------------------------------------*/

  public boolean action(Event e, Object o) {

    if (e.target == bText) {
       pFirst = tfText.getText();
       repaint();
       return true;
    }

    if (e.target == bFont) {
       pFont = tfFont.getText();
       repaint();
       return true;
    } 
    
    return false;
  }
}
