/********************************************************************/
/*                                                                  */
/* (C) Copyright IBM UK Ltd. 1996                                   */
/*                                                                  */
/* QMODCS  - Example of DosQueryModFromCS usage.                    */
/*                                                                  */
/* Query the name, segment and handle that corresponds to a 16-bit  */
/* selector.
/* Note: does not have to be a code selector.                       */
/*                                                                  */
/* Richard Moore 16th November 98                                   */
/* Version 1.0                                                      */
/*                                                                  */
/* Syntax QMODCS sel                                                */
/*                                                                  */
/*                                                                  */
/********************************************************************/


#define INCL_DOSMODULEMGR

#include <os2.h>
#include <conio.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "apis.h"          /* include this if not using the toolkit for Warp E-Server */

/*************************************************************************************/
/*                                                                                   */
/* Purpose:                                                                          */
/*                                                                                   */
/* DosQueryModFromCS takes a selector as a parameter and returns                     */
/* information about the module owning that selector (module refers to               */
/* a protect mode application currently executing).                                  */
/*                                                                                   */
/*************************************************************************************/


/*************************************************************************************/
/*                                                                                   */
/*                       Prototype definition for DosQueryModFromCS                  */
/*                                                                                   */
/*************************************************************************************/
/*                                                                                   */
/* APIRET16 APIENTRY16 DosQueryModFromCS(SEL, PQMRESULT);                            */
/*                                                                                   */
/*************************************************************************************/
/* This API is not defined in older versins of OS2386.LIB. For older versions        */
/* explicitely import the API using the following ordinal definiton from the .DEF    */
/* file.                                                                             */
/*   IMPORTS                                                                         */
/*   Dos16QueryModFromCS = DOSCALLS.359                                              */
/*                                                                                   */
/*************************************************************************************/

/*************************************************************************************/
/*                                                                                   */
/*                       Parameters to DosQueryModFromCS                             */
/*                                                                                   */
/*************************************************************************************/
/*                                                                                   */
/*                                                                                   */
/* SEL is the selctor to be queried.                                                 */
/* QMRESULT is the structure containind the queried information.                     */
/*                                                                                   */
/*   typedef struct _QMRESULT {                                                      */
/*      USHORT seg;                                                                  */
/*      USHORT hmte;                                                                 */
/*      char name[256];                                                              */
/*   } QMRESULT;                                                                     */
/*  typedef QMRESULT * PQMRESULT;                                                    */
/*                                                                                   */
/*************************************************************************************/

/*************************************************************************************/
/*                                                                                   */
/*                       Returns the following return codes:                         */
/*                                                                                   */
/*************************************************************************************/
/*                                                                                   */
/* NO_ERROR                0                                                         */
/* ERROR_INVALID_PARAMETER 87                                                        */
/*                                                                                   */
/*************************************************************************************/

int main(int argc, char *argv[], char *envp[])
{
   SEL sel=0;
   QMRESULT qmresult;
   APIRET16 rc;

   if (argc!=2) {
      printf("QMODCS sel\n");
      return;
   } /* endif */

   sel=(SEL)strtoul(argv[1],NULL,16);

   rc=Dos16QueryModFromCS(sel, &qmresult);

   if (rc != 0) {
      printf("DosQueryModFromCS returned rc=%u\n",rc);
      return rc;
   } /* endif */

   printf("Sel=0x%04x Handle=0x%04x Segment=0x%04x %s\n",sel,qmresult.hmte,qmresult.seg,qmresult.name);

   return 0;
}

