/********************************************************************/
/*                                                                  */
/* (C) Copyright IBM UK Ltd. 1996                                   */
/*                                                                  */
/* QSWLIST - Example of WinHAPPfromPID and WinHSWITCHfromHAPP       */
/*                                                                  */
/* Query an application switch list entry from its PID.             */
/* Richard Moore 1st March                                          */
/* Version 1.0                                                      */
/*                                                                  */
/* Syntax QSWLIST                                                   */
/*                                                                  */
/*                                                                  */
/********************************************************************/

#define INCL_PMAPI
#include <os2.h>
#include <conio.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "apis.h"          /* include this if not using the toolkit for Warp E-Server */

/*************************************************************************************/
/*                                                                                   */
/* Purpose:                                                                          */
/*                                                                                   */
/* WinHAPPfromPID returns the PM Application Handle (HAPP) from the process Id.      */
/* If the process Id is not a valid PM application then 0 is returned.               */
/*                                                                                   */
/* WinHSWITCHfromHAPP returns the handle of the switch list entry from the           */
/* application handle. If the application handle is invalid or no switch list        */
/* entrt exists then 0 is returned.                                                  */
/*                                                                                   */
/*************************************************************************************/

/*************************************************************************************/
/*                                                                                   */
/*        Prototype definitions for WinHAPPfromPID and WinHSWITCHfromHAPP            */
/*                                                                                   */
/*************************************************************************************/
/*                                                                                   */
/*         HAPP     APIENTRY  WinHAPPfromPID(PID pid);                               */
/*                                                                                   */
/*         HSWITCH  APIENTRY  WinHSWITCHfromHAPP(HAPP happ);                         */
/*                                                                                   */
/*************************************************************************************/

/*************************************************************************************/
/*                                                                                   */
/*                       Parameters to WinHAPPfromPID                                */
/*                                                                                   */
/*************************************************************************************/
/*                                                                                   */
/* pid: Process Id.                                                                  */
/*                                                                                   */
/*************************************************************************************/

/*************************************************************************************/
/*                                                                                   */
/*                       Parameters to WinHSWITCHfromHAPP                            */
/*                                                                                   */
/*************************************************************************************/
/*                                                                                   */
/* happ: Application Handle.                                                         */
/*                                                                                   */
/*************************************************************************************/

/*************************************************************************************/
/*                                                                                   */
/* WinHAPPfromPID returns a HAPP or zero.                                            */
/*                                                                                   */
/*************************************************************************************/
/*                                                                                   */
/* WinHSWITCHfromHAPP returns a HSWITCH or zero.                                     */
/*                                                                                   */
/*************************************************************************************/

/*************************************************************************************/
/*                                                                                   */
/* Remarks.                                                                          */
/*                                                                                   */
/*************************************************************************************/
/*                                                                                   */
/* WinHAPPfromHSWITCH and WinHSWITCHfromHAPP may be called from non-PM programs.     */
/*                                                                                   */
/* For some versions of OS/2 it may be necessary to import explicitly these APIs     */
/* using the following ordinals:                                                     */
/*                                                                                   */
/* WinHAPPfromPID        = PMMERGE.5198                                              */
/* WinHSWITCHfromHAPP    = PMMERGE.5199                                              */
/*                                                                                   */
/*************************************************************************************/

int main (int argc, char *argv[], char *envp[])
{

   APIRET rc;
   HAPP happ;
   HSWITCH hswitch;
   SWCNTRL swcntrl;
   PID pid;

   if (argc==1) {
      printf("QSWLIST pid\n");
      return 0;
   } /* endif */

   pid=strtoul(argv[1],NULL,0);

   happ=WinHAPPfromPID(pid);          /* get HAPP from PID */

   hswitch=WinHSWITCHfromHAPP(happ);  /* get HSWITCH from HAPP */

   rc=WinQuerySwitchEntry(hswitch,&swcntrl); /* interpret HSWITCH */
   if (rc) {
      printf("WinQuerySwitchEntry returned %u\n",rc);
      return rc;
   } /* endif */

   printf("Pid: %04x, Happ: %08x, Hswitch: %08x\n", pid, happ, hswitch);
   printf("swcntrl.hwnd:     \t%08x,   swcntrl.hwndIcon:    \t%08x\n",swcntrl.hwnd, swcntrl.hwndIcon);
   printf("swcntrl.hprog:    \t%08x,   swcntrl.idProcess:   \t%08x\n",swcntrl.hprog, swcntrl.idProcess);
   printf("swcntrl.idSession:\t%08x,   swcntrl.uchVisbility:\t%08x\n",swcntrl.idSession, swcntrl.uchVisibility);
   printf("swcntrl.fbJump:   \t%08x,   swcntrl.bProgType:   \t%08x\n",swcntrl.fbJump, swcntrl.bProgType);
   printf("swcntrl.szSwtitle %s\n",&swcntrl.szSwtitle);
   

   return 0;

}

