/********************************************************************/

/*                                                                  */

/* (C) Copyright IBM UK Ltd. 1996                                   */

/*                                                                  */

/* SYSSTATE - Example of DosQuerySysState usage.                    */

/*                                                                  */

/* Get status of open files.                                        */

/*                                                                  */

/* Richard Moore 9th February 99                                    */

/* Version 1.0                                                      */

/*                                                                  */

/* Syntax SYSSTATE                                                  */

/*                                                                  */

/*                                                                  */

/********************************************************************/





#define INCL_DOSPROFILE

#define INCL_DOSERRORS



#include <os2.h>

#include <conio.h>

#include <stdio.h>

#include <string.h>

#include <stdlib.h>

#include "apis.h"          /* include this if not using the toolkit for Warp E-Server */



/*************************************************************************************/

/*                                                                                   */

/* Purpose:                                                                          */

/*                                                                                   */

/* DosQuerySysState returns information about various resources in use by the system.*/

/* The EntityList paramter detrmines which information is returned according to the  */

/* bits sets in this parameter.                                                      */

/*                                                                                   */

/* The information returned begins with a pointer to the global record structure,    */

/* qsGrec_s. Following this will be a series of other records which depend on which  */

/* information was requested. Some of these subsequent record structures contain     */

/* an identifier as its first member, which enables the returned information to be   */

/* interpreted without any order being imposed. Entities that may be requested are:  */

/*                                                                                   */

/*   Process information (QS_PROCESS)                                                */

/*   Semaphore informaion (QS_SEMAPHORE)                                             */

/*   Module information (QS_MTE)                                                     */

/*   File system information (QS_FILESYS)                                            */

/*   Shared memory information (QS_SHMEMORY)                                         */

/*   Module Version information (QS_MODVER)                                          */

/*   Not all entities have beed supported on earlier versions of OS2.                */

/*                                                                                   */

/* The structures returned will be a combination of the following:                   */

/*                                                                                   */

/*  qsGrec_t Global Record structure                                                 */

/*                                                                                   */

/*  qsTrec_t Thread Record structure                                                 */

/*                                                                                   */

/*  qsPrec_t Process Record structure                                                */

/*                                                                                   */

/*  qsS16rec_t  16-bit system semaphore structure                                    */

/*  qsS16Headrec_t 16-bit system semaphore structure                                 */

/*                                                                                   */

/*  qsMrec_t Shared Memory Record structure                                          */

/*                                                                                   */

/*  QSOPENQ     32-bit Open Semaphore structure                                      */

/*  QSEVENT     32-bit Event Semaphore structure                                     */

/*  QSMUTEX     32-bit Event Mutex semaphore structure                               */

/*  QSMUX       32-bit Event Mux semaphore structure                                 */

/*  QSHUN       32-bit semaphore header structure                                    */

/*  qsS32rec_t  32-bit semaphore header structure                                    */

/*                                                                                   */

/*  qsLObjrec_t Object level MTE information                                         */

/*  qsLrec_t    System wide MTE information                                          */

/*                                                                                   */

/*  qsExLrec_t  Module version information                                           */

/*                                                                                   */

/*  qsSft_t    System wide FILE information - one per open instance                  */

/*  qsFrec_t   System wide FILE information - one per file name                      */

/*  qsPtrRec_t System wide FILE information                                          */

/*                                                                                   */

/*                                                                                   */

/*************************************************************************************/





/*************************************************************************************/

/*                                                                                   */

/*                      Prototype definition for DosQuerySysState                    */

/*                                                                                   */

/*************************************************************************************/

/*                                                                                   */

/* APIRET  APIENTRY DosQuerySysState(ULONG EntityList,                               */

/*                                   ULONG EntityLevel,                              */

/*                                   PID pid,                                        */

/*                                   TID tid,                                        */

/*                                   PVOID pDataBuf,                                 */

/*                                   ULONG cbBuf);                                   */

/*                                                                                   */

/*************************************************************************************/





/*************************************************************************************/

/*                                                                                   */

/* Parameters to DosQuerySysState                                                    */

/*                                                                                   */

/*************************************************************************************/

/*                                                                                   */

/* EntityList: Determines what informaiton is returned. May be a combination of the  */

/*             following:                                                            */

/*                                                                                   */

/*             QS_PROCESS      0x0001  Requests process information                  */

/*             QS_SEMAPHORE    0x0002  Requests semaphore information                */

/*             QS_MTE          0x0004  Requests module information                   */

/*             QS_FILESYS      0x0008  Requests file system information              */

/*             QS_SHMEMORY     0x0010  Requests shared memory information            */

/*             QS_MODVER       0x0200  Requests module version information           */

/*                                                                                   */

/*                                                                                   */

/* EntityLevel: Determines the extent on information returned for a given entity.    */

/*              Currently this only applies to QS_MTE entities. If EntityLevel is    */

/*              also set to QS_MTE then module object information is returned.       */

/*                                                                                   */

/* pid:         Restricts information to a particular process id. If 0 is specified  */

/*              then entities for all processes are returned.                        */

/*                                                                                   */

/* tid:         Restricts information to a particular thread id. Currently a value   */

/*              of zero only is supported, requesting all threads of a process.      */

/*                                                                                   */

/* pDataBuf:    Pointer to the buffer allocated by the user into which entity        */

/*              structures are returned.                                             */

/*              If the buffer is of insufficient size then a ERROR_BUFFER_OVERFLOW   */

/*              is returned.                                                         */

/*                                                                                   */

/* cbBuf:       Size of the buffer pointed to by pDataBuf, in bytes.                 */

/*                                                                                   */

/*************************************************************************************/





/*************************************************************************************/

/*                                                                                   */

/* Use the following ordinal to import DosQuerySysState.                             */

/*                                                                                   */

/*************************************************************************************/

/*                                                                                   */

/* #define ORD_DOS32QUERYSYSSTATE          368                                       */

/*                                                                                   */

/*************************************************************************************/



/*************************************************************************************/

/*                                                                                   */

/* DosQueryMemState returns the following:                                           */

/*                                                                                   */

/*************************************************************************************/

/*                                                                                   */

/*  0      NO_ERROR                                                                  */

/*  87     ERROR_INVALID_PARAMETER                                                   */

/*  111    ERROR_BUFFER_OVERFLOW                                                     */

/*  115    ERROR_PROTECTION_VIOLATION                                                */

/*  124    ERROR_INVALID_LEVEL                                                       */

/*                                                                                   */

/*************************************************************************************/





#define BUFSIZE 64*1024

int main(int argc, char *argv[], char *envp[])

{

   APIRET rc;  

   qsGrec_t ** pBuf;       

   qsGrec_t * pGrec;

   qsLrec_t * pLrec;



 

   pBuf=malloc(BUFSIZE); /* allocate a 64K buffer */

   if (pBuf == NULL) {

      printf("Not enough memoryan");

      return ERROR_NOT_ENOUGH_MEMORY;

   } /* endif */



   /* query module information */

   

   rc=DosQuerySysState(QS_MTE, 0L, 0L, 0L, pBuf, BUFSIZE);

   if (rc!=0) {

      printf("DosQuerySysState returned rc=%u\n",rc);

      return rc;

   } /* endif */



   pGrec = *  pBuf;  



   printf("Threads=%u 32-bit Sems=%u File Names=%u\n\n", 

                pGrec->cThrds, 

                pGrec->c32SSem,

                pGrec->cMFTNodes);



   pLrec = (ULONG)pGrec + sizeof(qsGrec_t);   



   while (pLrec) {

      if (pLrec->pName) printf("hmte=%04x %s\n", pLrec->hmte, pLrec->pName);

      pLrec = pLrec->pNextRec;

   } /* endwhile */



   return rc;

   

}



