;  movebyte.asm  OS/2 Version 2.0
;
;  this routine transfers bytes data to and from the device driver
;
;  C Calling Sequence:
;  if (MoveBytes(&From,&To,USHORT Lenth))  err
;
        .386
        include	drvlib.inc

	public	MOVEBYTES
	extrn	_DevHlp:dword
	assume  CS: _TEXT
_TEXT	segment word public use16 'CODE'
MOVEBYTES proc near

	push	bp
	mov	bp,sp
	push    es
	push	ds
	push    si
	push    di
	push    cx
	pushf			; save everything
	mov	cx,[bp+4]	; length
        xor     ax,ax
	or	cx,cx		; exit if zero
        jz      error           ; bail out
	lds	si,[bp+10]	; from
	les	di,[bp+6]	; to
        cld
	test    cx,3            ; optimize if possible
	jz      double_move     ; for large moves
        test    cx,1            ; if even number of bytes, save a
        jz      wordmove        ; little time by doing a word move
	rep     movsb
        jmp     short finish    ; done

double_move:
	shr	cx,1
	shr	cx,1
	rep	movsd
	jmp	short finish	;done
error:  mov     ax,1
        jmp     short get_out   ; bail

wordmove:
        shr     cx,1            ; half the number of bytes
        rep     movsw
finish:
        sub     ah,ah
get_out:
	popf			; restore flags
	pop	cx
	pop	di
	pop	si
	pop	ds
	pop     es
	pop	bp
	ret	10              ; fix up stack

MOVEBYTES endp
_TEXT	ends
	end
