#include <stdio.h>
#include <unidef.h>

#define BYTE1FROMUNICHAR( unic ) ( unic >> 8 )
#define BYTE2FROMUNICHAR( unic ) ( unic & 0x00FF )

int main( void )
{
    int     length, bytes, i;
    UniChar *psuString = (UniChar *) L"Hello, Warpstock!";

    length = UniStrlen( psuString );
    bytes  = (length + 1) * sizeof(UniChar);
    printf("Unicode string: \"%ls\"\n", psuString );
    printf("Characters:     %d (plus terminating null)\n", length );
    printf("Total size:     %d bytes\n", bytes );
    printf("\nRaw byte values:\n|");
    for ( i = 0; i <= length; i++ ) {
        printf(" %02X %02X |",
               BYTE1FROMUNICHAR( psuString[i] ),
               BYTE2FROMUNICHAR( psuString[i] ) );
    }
    printf("\n");

    return 0;
}
