/* An example of device input (ie, using FILEREXX.DLL too) */

/* The FileLoadFuncs loads all the rest of the REXX functions in the FILEREXX DLL.
 So, we don't have to make calls to RxFuncAdd to add each one of those functions. Of
 course, in order to call FileLoadFuncs, we have to add that one */
CALL RxFuncAdd 'FileLoadFuncs', 'FILEREXX', 'FileLoadFuncs'
CALL FileLoadFuncs

/* Change this to whatever COM port your modem is attached to */
port = 'COM2'

/* Open the COM device driver for reading/writing. Let it be shared with other programs */
RXHANDLE = FileOpen(port, 'rws')
IF RXHANDLE = 0 THEN DO
    RXSAY "Error opening" port "device!"
    EXIT
END

/* Trap ERROR and FAILURE */
SIGNAL ON ERROR
SIGNAL ON FAILURE




/* ====================== 'Main Window' ======================= */
/* First Group is TEXT */
RXTYPE.1 = 'TEXT'

/* Default */
RXFLAGS.1 = ' '

/* Text lines */
RXLABEL.1 = "COM device input. Here's the received line:"

/* TotalPhrases, PhrasesPerLine, WidthOfPhrase, BetweenPhrases */
RXINFO.1 = '1 1 0 0'

/* Position */
RXX.1 = 10
RXY.1 = 30

/* Use another TEXT Group to display the device input byte */
RXTYPE.2 = 'TEXT'

/* Default */
RXFLAGS.2 = ' '

/* Text lines */
RXLABEL.2 = ' '

/* TotalPhrases, PhrasesPerLine, WidthOfPhrase, BetweenPhrases. Note that
 we deliberately set WidthOfPhrase non-0 to allow enough width to accomodate
 a range of text */
RXINFO.2 = '1 1 255 0'

/* Position */
RXX.2 = 10
RXY.2 = 10

/* Default size and position (also gives us sizing and max button) */
RXWINMAIN = ' '
RXDLG 2 '"Main Window"' 'RXWINMAIN' 'NOCLOSE|RESULT'




/* ============= Open device for input ================ */
/* Trim off the start or end patterns */
RXFLAGS = 'TRIM'

/* Default input buffer size and count limit */
RXCOUNT = ' '

/* File handle */
RXINFO = RXHANDLE

/* No Start string to match (ie, null string). End string contains 1 pattern;
    a Line Feed and Carriage Return. We set the TRIM flag, so this is
    removed from the returned input */
RXSTARTPAT = ' '
RXENDPAT = 'D 13 10'

/* The input is returned to me in this variable */
RXLABEL = 'MYINPUT'

RXDEV 'COM INIT'



more:
   /* Do user interaction (and also device input). We go to sleep while user
      manipulates the window, until such time as the user presses ESC or
      ENTER if the window's RESULT Flag is set, or tries to close a dialog
      using its CLOSE ICON, or uses a RESULT Group, or uses some Group with
      its END Flag set, or presses a key if the window's KEYS Flag is set, or
      the timer times out, or device input is received */
   RXDLG  /* NOTE: No window title means "use Main Window". No operation
		   specified means an operation of 0 (ie, PROCESS) */

   /* RXWIND now specifies which window or device woke us up */

   /* Did user press ESC or click on the CLOSE ICON? Note that we haven't set
      the KEYS flag of any window, so we don't need to check for particular
      negative values of RXID because the only 2 we ever receive here are
      for the ESC key and CLOSE ICON */
   IF RXID < 0 THEN DO
      /* Done */
      EXIT
   END

   /* If user didn't abort, then check if this is device input */
   IF RXID >= 1000 THEN DO
       /* RXSUBID is the number of bytes returned. RXSTARTPAT and
	   RXENDPAT are the number of the matching start and end
	   patterns, or 0 if none. RXWIND is the device name */

       /* Print the received input (ie, may be the modem echoing back the
	   ATZ, or the OK from the ATZ command, or some line that it
	   received from some other host */
       RXSET '"Main Window"' 2 1 'VAL' MYINPUT.0
   END

   /* NOTE: We have no RESULT Group nor any Groups with the END Flag set,
      so there's no need to further check for RXID being anything but -1 or 0,
      and therefore what we must have here is the ENTER key (ie, RXID=0,
      RXSUBID=10). Ignore it */
   ELSE DO
       /* ====== Clear out driver's input queue ===== */
       /* Clear out any queued input waiting to be read before we do the
	  write and operation below. We don't want RXDLG to have to wade
	  through anything except what the modem sends AFTER we do the
	  FilePuts */
       REQ.0 = 1
       REQ.1 = '1.1.0'   /* Command. Must be 0 */
       DATA.0 = 1
       DATA.1 = '1.1.0'  /* Reserved */
       err = FileDevIOCtl(RXHANDLE, 11, 1, 'REQ', 'DATA')
       IF err <> 0 THEN RXSAY "ERROR flushing input queue:" err

       /* ====== Send the modem reset string ===== */
       /* Send the Hayes command string 'ATZ' (followed by a line feed, so
	   we use FilePuts to automatically send that terminating line feed)
	   to the modem */
       err = FilePuts(RXHANDLE, 'ATZ')
       IF err <> 5 THEN RXSAY 'Error sending ATZ'
   END


/* Do another message loop */
SIGNAL more

/* ========================== Done ========================== */

FAILURE:
    /* NOTE: the variable RC contains the returned error message (not a number,
	unless we use RXERR to set up Rexx Dialog to return error numbers instead).
	Because we used the default severity level, Rexx Dialog has already displayed
	this error message to the enduser */
ERROR:
    /* NOTE: the variable RC contains the returned error message (not a number,
	unless we use RXERR to set up Rexx Dialog to return error numbers instead).
	Because we used the default severity level, Rexx Dialog has already displayed
	this error message to the enduser */

    EXIT
