/* RX2.C (RX2.EXE)
 *
 * This is a Presentation Manager program that launches a REXX script and allows it to open and use a PM window
 * with PM controls in order to obtain user input (as opposed to "pull"ing from a command line prompt). It takes 1 arg
 * from OS/2; the name of the REXX script to launch. It uses Rexx Dialog to implement the REXX/PM interface.
 */

#define INCL_WININPUT
#define INCL_WINSWITCHLIST
#define INCL_WINSYS
#define INCL_WINFRAMEMGR
#define INCL_WINWINDOWMGR

#include <os2.h>
#include "rx.h"


/* Global vars */
HMQ	   hmq;
HWND	 hwndFrame;
UCHAR * ScriptName;
UCHAR	 myClassName[] = "My class";



/***************************** myClientWndProc() ****************************
 * Window procedure for my client window
 *************************************************************************/
MRESULT EXPENTRY myClientWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    RECTL  rcl;
    HPS      hps;

    switch (msg)
    {
	case WM_PAINT:
	    /* Fill update region with background color. There is nothing but perhaps child controls
		in the window, and they will receive their own WM_PAINT subsequently */
	    hps = WinBeginPaint(hwnd, 0, &rcl);
	    WinFillRect(hps, &rcl, 15);
	    WinEndPaint(hps);
	    return(0);

	/* The following WM_HITTEST case is to support disabling the Client and
	    its children when the REXX script opens a MODAL window */
	case WM_HITTEST:
	    /* Check for MODAL window handling */
	    return(DlgCheckModal(hwnd, mp1));

	case WM_BUTTON1DBLCLK:
	    /* Execute REXX script unless there is currently a script already being executed */
	    if (!(RexxSpec.Flags & EXECUTING)) RexxRunScript(ScriptName);
	    break;

	case WM_CLOSE:
	    /* If a REXX script is currently being executed, don't allow the app to be closed down.
		Alternately, if we really wanted to close everything down, then we could just
		comment out this WM_CLOSE case, and it will cause the script to
		receive an RXDLG return of -99 (ie, ABORT) when it does an operation with
		user interaction */
	    if (RexxSpec.Flags & EXECUTING) return(0);

	    /* Otherwise, fall through to do the default procedure and allow close down */
    }
    return(WinDefWindowProc(hwnd, msg, mp1, mp2));
}



/********************************** main() ********************************
 * 1. Initializes PM environment: obtains anchor block handle and creates msg queue
 *    that all of the Rexx Dialog windows use.
 * 2. Opens a Main Window on behalf of the REXX script.
 * 3. Calls RexxSet() routine (init RXDLG.DLL stuff)
 * 4. Executes REXX script
 * 5. Frees resources
 * 6. Ends program
 *
 * Return: 0 if successful execution, non-zero if error
 *************************************************************************/
int main(int argc, char *argv[], char *envp[])
{
    QMSG   qmsg;

    /* Obtain a PM anchor block. Store it in REXXSPEC */
    if(!(RexxSpec.Hab = WinInitialize(0)))
    {
badinit:
	DosBeep(60, 120);
	return(ERRAPP);
    }

    /* Obtain a PM Message Queue */
    if(!(hmq = WinCreateMsgQueue(RexxSpec.Hab, 0)))
    {
	WinTerminate(RexxSpec.Hab);
	goto badinit;
    }

    /* Register my window class */
    WinRegisterClass(RexxSpec.Hab, &myClassName[0], myClientWndProc, CS_HITTEST, 0);

    /* Create a standard PM Window and store client window handle in REXXSPEC Hwnd */
    qmsg.reserved = FCF_TITLEBAR|FCF_SIZEBORDER|FCF_SYSMENU|FCF_MINMAX|FCF_SHELLPOSITION|FCF_TASKLIST;
    if(!(hwndFrame = WinCreateStdWindow(HWND_DESKTOP, WS_VISIBLE, &qmsg.reserved, &myClassName[0],
	     "My C App Window", 0, 0, 0, &RexxSpec.Hwnd))) goto badinit2;

    /* Is there a REXX script name specified? */
    if (argc>1)
    {
	/* Install REXX support */
	if((qmsg.reserved = RexxSet()))
	{
	    DlgErrMsg(qmsg.reserved, qmsg.reserved+ERRINIT);
	}
	else
	{
	    /* Store the REXX script name */
	    ScriptName = argv[1];

	    /* Do a PM message loop until our app window is closed */
	    while (WinGetMsg(RexxSpec.Hab, &qmsg, 0, 0, 0))
		WinDispatchMsg(RexxSpec.Hab, &qmsg);

	    /* Uninstall REXX support */
	    RexxFree();
	}
    }
    /* Print usage */
    else
    {
	DlgMsgStr("Usage: RX2 [Rexx script filename]", 0, 0);
    }

    /* Destroy the window */
    WinDestroyWindow(hwndFrame);

    /* Free resources */
    WinDestroyMsgQueue(hmq);
    WinTerminate(RexxSpec.Hab);

    /* Return error code */
    return(RexxSpec.ErrNum);
}
