/* This creates a Main Window, with 1 PUSH Group with 1 button labeled
    "Time-out". When the user presses that button, we create a Child Dialog
    just for the purpose of counting down a time-out. The Child contains a
   TEXT Group with 1 blank line of text, is MODAL, and is hidden. The point of
   this is so that we can do a timeout without the user being able to interact
   during that timeout, as well as not seeing the time-out window. We start up
   the time-out in the hidden window, and pass that window to RXDLG, doing an
   Operation of 0. So, when RXDLG returns, the window has timed out.
*/

/* Trap ERROR and FAILURE */
SIGNAL ON ERROR
SIGNAL ON FAILURE

/* =============== Create "Main Window" ================= */
/* First Group is PUSH */
RXTYPE.1 = 'PUSH'

/* Use of a control in this group causes RXDLG to return. Also let RXDLG
    label the controls with numbers */
RXFLAGS.1 = 'END'

/* Label, no groupbox */
RXLABEL.1 = 'Time-Out'

/* TotalControls, ControlsPerLine, WidthOfControls */
RXINFO.1 = '1 1 0'

/* */
RXVAL.1 = ''

/* Position */
RXX.1 = 7
RXY.1 = 6

/* Use another TEXT Group to display the elapsed timeout */
RXTYPE.2 = 'TEXT'

/* Default */
RXFLAGS.2 = ' '

/* Text lines */
RXLABEL.2 = ' '

/* TotalPhrases, PhrasesPerLine, WidthOfPhrase, BetweenPhrases. Note that
 we deliberately set WidthOfPhrase non-0 to allow enough width to accomodate
 a variety of phrases */
RXINFO.2 = '1 1 90 0'

/* Position */
RXX.2 = 10
RXY.2 = 40

/* Default size and position (also gives us sizing and max button) */
RXWIN1 = ''
RXDLG 2 '"Main Window"' 'RXWIN1' 'NOCLOSE'

more:
/* Do user interaction */
RXDLG

/* We only have 1 window (without KEYS or RESULT flag), with one pushbutton,
    so it's either the CLOSE ICON or that button that caused RXDLG to return */

/* Did user click on the CLOSE ICON? */
IF RXID < 0 THEN EXIT

/* ================== Create "Child 1" dialog ================== */
/* First Group is TEXT */
RXTYPE.1 = 'TEXT'

/* Default */
RXFLAGS.1 = ' '

/* Empty Label, no Groupbox */
RXLABEL.1 = '|'

/* TotalControls, ControlsPerLine, WidthOfControls */
RXINFO.1 = '1 1 0'

/* Default choice for PushButton is nothing */
RXVAL.1 = ''

/* Position */
RXX.1 = 1
RXY.1 = 1

RXWIN2 = '1 1 0 0'

/* Set MODAL */
RXDLG 1 '"Child 1"' 'RXWIN2' 'MODAL'
/* ========================================================= */

/* Hide the child window. The window is only 1 by 1 pixel, so it's pretty hard
 to see down there in lower left corner of Main, but... */
RXSET '"Child 1"' 'HIDE'

/* Setup a timeout (in Child 1) for 5000 milliseconds (ie, 5 seconds) */
RXSET '"Child 1"' 'TIME' 5000

/* Print "Timing Out..." in the main window */
RXSET '""' 2 1 'VAL' 'Timing Out...'

/* Do the timeout. Specify "Child 1" and because it's hidden and MODAL,
   user can't interact with any windows. Because we didn't specify
   NOCLOSE, this window is closed at the end of the time-out */
RXDLG '"Child 1"'

/* Print "All Done!" in the main window */
RXSET '""' 2 1 'VAL' 'All Done!'

SIGNAL more

/* ========================== Done ========================== */

FAILURE:
    /* NOTE: the variable RC contains the returned error message (not a number,
	unless we use RXERR to set up Rexx Dialog to return error numbers instead).
	Because we used the default severity level, Rexx Dialog has already displayed
	this error message to the enduser */
    EXIT
ERROR:
    /* NOTE: the variable RC contains the returned error message (not a number,
	unless we use RXERR to set up Rexx Dialog to return error numbers instead).
	Because we used the default severity level, Rexx Dialog has already displayed
	this error message to the enduser */
    EXIT
