//
//                     TxWin, Textmode Windowing Library
//
//   Original code Copyright (c) 1995-2021 Fsys Software and Jan van Wijk
//
// ==========================================================================
//
//   TxLib, released under MIT License
//
//   Copyright (c) 1995-2021  Fsys Software and Jan Van Wijk
//
//   Permission is hereby granted, free of charge, to any person obtaining a copy
//   of this software and associated documentation files (the "Software"), to deal
//   in the Software without restriction, including without limitation the rights
//   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//   copies of the Software, and to permit persons to whom the Software is
//   furnished to do so, subject to the following conditions:
//
//   The above copyright notice and this permission notice shall be included in all
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//   SOFTWARE.
//
//
//   Questions on TxWin licensing can be directed to: info@dfsee.com
//
// ==========================================================================
//
// TX string number handling functions
//
// Author: J. van Wijk
//
// JvW  28-02-2021 LICENSING: Changed from LGPL to the more liberal MIT license
// JvW  24-07-2005 Initial version, split off from TXUTIL

#include <txlib.h>


/*****************************************************************************/
// Test if string represents a valid hex number, allow 0x prefix and ,unit
/*****************************************************************************/
BOOL txIsValidHex                               // RET   string is valid hex
(
   char               *num                      // IN    candidate string
)
{
   BOOL                rc = TRUE;               // function return
   char               *s  = num;

   if (strncasecmp( s, "0x", 2) == 0)
   {
      s += 2;
   }
   while ((*s) && (*s != ','))                  // until end or unit separator
   {
      if (isxdigit(*s))
      {
         s++;
      }
      else
      {
         rc = FALSE;
         break;
      }
   }
   return (rc);
}                                               // end 'txIsValidHex'
/*---------------------------------------------------------------------------*/


/*****************************************************************************/
// Test if string represents a valid decimal nr, allow 0t/0n prefix and ,unit
/*****************************************************************************/
BOOL txIsValidDec                               // RET   string is not decimal
(
   char               *num                      // IN    candidate string
)
{
   BOOL                rc = TRUE;               // function return
   char               *s  = num;

   if ((strncasecmp( s, "0t", 2) == 0) ||
       (strncasecmp( s, "0n", 2) == 0)  )
   {
      s += 2;
   }
   while ((*s) && (*s != ','))                  // until end or unit separator
   {
      if (isdigit(*s))
      {
         s++;
      }
      else
      {
         rc = FALSE;
         break;
      }
   }
   return (rc);
}                                               // end 'txIsValidDec'
/*---------------------------------------------------------------------------*/


/*****************************************************************************/
// Test if string starts with a valid MCS prefix 0x 0n 0t 0x (case insensitive)
/*****************************************************************************/
BOOL txHasMcsPrefix                             // RET   string has MCS prefix
(
   char               *num                      // IN    candidate string
)
{
   BOOL                rc = FALSE;              // function return

   ENTER();
   TRACES(("num string: '%s'\n", num));

   if (num[0] == '0')
   {
      if (strchr("NnOoTtXx", num[1]) != NULL)
      {
         rc = TRUE;
      }
   }
   BRETURN (rc);
}                                               // end 'txHasMcsPrefix'
/*---------------------------------------------------------------------------*/

