//
//                     TxWin, Textmode Windowing Library
//
//   Original code Copyright (c) 1995-2021 Fsys Software and Jan van Wijk
//
// ==========================================================================
//
//   TxLib, released under MIT License
//
//   Copyright (c) 1995-2021  Fsys Software and Jan Van Wijk
//
//   Permission is hereby granted, free of charge, to any person obtaining a copy
//   of this software and associated documentation files (the "Software"), to deal
//   in the Software without restriction, including without limitation the rights
//   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//   copies of the Software, and to permit persons to whom the Software is
//   furnished to do so, subject to the following conditions:
//
//   The above copyright notice and this permission notice shall be included in all
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//   SOFTWARE.
//
//
//   Questions on TxWin licensing can be directed to: info@dfsee.com
//
// ==========================================================================
//
// Trace functions for module entry/exit, section-2
//
// Author: J. van Wijk
//
// JvW  28-02-2021 LICENSING: Changed from LGPL to the more liberal MIT license
// JvW  20-08-2005   Split-off from txtrace

#define DUMP 1                                  // tracecode always available

#include <txlib.h>
#include <txtpriv.h>


/*****************************************************************************/
// Set timestamping on tracelines on or off
/*****************************************************************************/
void TxTraceSetStamp
(
   BOOL                stamp                    // IN    timestampming on
)
{
   TxTrTstamp = stamp;
}                                               // end 'TxTraceSetStamp'
/*---------------------------------------------------------------------------*/


/*****************************************************************************/
// Handle double floating-point return of a routine
/*****************************************************************************/
void TxTraceRetDouble
(
   char              *mod,                      // IN    module/function name
   double             rc                        // IN    return value
)
{
   if (TxTrIndent[TXTHREADID])
   {
      TxTrIndent[TXTHREADID]--;
   }
   TxTraceLeader();
   TxPrint( "%sRet%s:%s%8.2lf %s%s%s\n", CNM, CNN, CBG, rc,
                                         CNC, mod, CNN);
}                                               // end 'TxTraceRetDouble'
/*---------------------------------------------------------------------------*/

