#ifndef TXWDRAW_H
#define TXWDRAW_H
//
//                     TxWin, Textmode Windowing Library
//
//   Original code Copyright (c) 1995-2021 Fsys Software and Jan van Wijk
//
// ==========================================================================
//
//   TxLib, released under MIT License
//
//   Copyright (c) 1995-2021  Fsys Software and Jan Van Wijk
//
//   Permission is hereby granted, free of charge, to any person obtaining a copy
//   of this software and associated documentation files (the "Software"), to deal
//   in the Software without restriction, including without limitation the rights
//   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//   copies of the Software, and to permit persons to whom the Software is
//   furnished to do so, subject to the following conditions:
//
//   The above copyright notice and this permission notice shall be included in all
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//   SOFTWARE.
//
//
//   Questions on TxWin licensing can be directed to: info@dfsee.com
//
// ==========================================================================
//
//
// TX Windowed text, drawing, color-scheme definitions
//
// Author: J. van Wijk
//
// JvW  28-02-2021 LICENSING: Changed from LGPL to the more liberal MIT license
// JvW  16-04-2004 Implement color scheme data structures

//- define the actual color-mappings, to be used in the colorschemes below



//- New default scheme, a 3D-look with Grey menus, Cyan borders and White Windows
static TXW_COLORMAP    txwcm_3g =
{
   0,                                           // cSchemeColor
   TX_Black_on_White,                           // cWinClientClr
   TX_Red_on_White,                             // cWinClientErr
   TX_Lwhite_on_White,                          // cWinBorder_top
   TX_Lwhite_on_White,                          // cWinBorder_trc
   TX_Black_on_White,                           // cWinBorder_rgt
   TX_Black_on_White,                           // cWinBorder_brc
   TX_Black_on_White,                           // cWinBorder_bot
   TX_Lwhite_on_White,                          // cWinBorder_blc
   TX_Lwhite_on_White,                          // cWinBorder_lft
   TX_Lwhite_on_White,                          // cWinBorder_tlc
   TX_Lwhite_on_White,                          // cWinTitleStand
   TX_Lwhite_on_Grey,                           // cWinTitleFocus
   TX_Black_on_White,                           // cWinFooterStand
   TX_Lwhite_on_Grey,                           // cWinFooterFocus
   TX_Lwhite_on_White,                          // cDlgBorder_top
   TX_Black_on_White,                           // cDlgBorder_trc
   TX_Black_on_White,                           // cDlgBorder_rgt
   TX_Black_on_White,                           // cDlgBorder_brc
   TX_Black_on_White,                           // cDlgBorder_bot
   TX_Lwhite_on_White,                          // cDlgBorder_blc
   TX_Lwhite_on_White,                          // cDlgBorder_lft
   TX_Lwhite_on_White,                          // cDlgBorder_tlc
   TX_Black_on_White,                           // cDlgTitleStand
   TX_Black_on_White,                           // cDlgTitleFocus
   TX_Black_on_White,                           // cDlgFooterStand
   TX_Black_on_White,                           // cDlgFooterFocus
   TX_White_on_Grey,                            // cPushBorder_top
   TX_White_on_Grey,                            // cPushBorder_trc
   TX_Black_on_Grey,                            // cPushBorder_rgt
   TX_Black_on_Grey,                            // cPushBorder_brc
   TX_Black_on_Grey,                            // cPushBorder_bot
   TX_White_on_Grey,                            // cPushBorder_blc
   TX_White_on_Grey,                            // cPushBorder_lft
   TX_White_on_Grey,                            // cPushBorder_tlc
   TX_Yellow_on_Cyan,                           // cPushTitleStand
   TX_Lwhite_on_Magenta,                        // cPushTitleFocus
   TX_Cyan_on_Cyan,                             // cPushFooterStand
   TX_Yellow_on_Blue,                           // cPushFooterFocus
   TX_Lwhite_on_White,                          // cViewBorder_top
   TX_Lwhite_on_White,                          // cViewBorder_trc
   TX_Black_on_White,                           // cViewBorder_rgt
   TX_Black_on_White,                           // cViewBorder_brc
   TX_Black_on_White,                           // cViewBorder_bot
   TX_Lwhite_on_White,                          // cViewBorder_blc
   TX_Lwhite_on_White,                          // cViewBorder_lft
   TX_Lwhite_on_White,                          // cViewBorder_tlc
   TX_Lwhite_on_White,                          // cViewTitleStand
   TX_Lwhite_on_Grey,                           // cViewTitleFocus
   TX_Black_on_White,                           // cViewFooterStand
   TX_White_on_Grey,                            // cViewFooterFocus
   TX_Black_on_Cyan,                            // cSbvBorder_top
   TX_Lcyan_on_Cyan,                            // cSbvBorder_trc (or blank)
   TX_Lcyan_on_Cyan,                            // cSbvBorder_rgt
   TX_Lcyan_on_Cyan,                            // cSbvBorder_brc
   TX_Lcyan_on_Cyan,                            // cSbvBorder_bot
   TX_Black_on_Cyan,                            // cSbvBorder_blc (or blank)
   TX_Black_on_Cyan,                            // cSbvBorder_lft
   TX_Black_on_Cyan,                            // cSbvBorder_tlc
   TX_Yellow_on_Cyan,                           // cSbvTitleStand
   TX_Lwhite_on_Magenta,                        // cSbvTitleFocus
   TX_Lcyan_on_Cyan,                            // cSbvFooterStand
   TX_Lcyan_on_Cyan,                            // cSbvFooterFocus
   TX_Yellow_on_Cyan,                           // cSbvStatusStand
   TX_Yellow_on_Cyan,                           // cSbvStatusFocus
   TX_Lwhite_on_Cyan,                           // cSbvProgreStand
   TX_Lgreen_on_Cyan,                           // cSbvTraceStand
   TX_White_on_Magenta,                         // cSbvMarkedArea
   TX_Lgreen_on_Cyan,                           // cDskTraceStand
   TX_Lcyan_on_Cyan,                            // cDskBorder_top
   TX_Lcyan_on_Cyan,                            // cDskBorder_trc (or blank)
   TX_Black_on_Cyan,                            // cDskBorder_rgt
   TX_Black_on_Cyan,                            // cDskBorder_brc
   TX_Black_on_Cyan,                            // cDskBorder_bot
   TX_Lcyan_on_Cyan,                            // cDskBorder_blc (or blank)
   TX_Lcyan_on_Cyan,                            // cDskBorder_lft
   TX_Lcyan_on_Cyan,                            // cDskBorder_tlc
   TX_Lwhite_on_Cyan,                           // cDskTitleStand
   TX_Lwhite_on_Cyan,                           // cDskTitleFocus
   TX_White_on_Blue,                            // cDskFooterStand
   TX_White_on_Blue,                            // cDskFooterFocus
   TX_Black_on_White,                           // cLineTextStand
   TX_Black_on_White,                           // cLineTextNr0
   TX_Blue_on_White,                            // cLineTextNr1
   TX_Green_on_White,                           // cLineTextNr2
   TX_Cyan_on_White,                            // cLineTextNr3
   TX_Black_on_White,                           // cHelpTextStand
   TX_Black_on_White,                           // cHelpTextHelp
   TX_Black_on_White,                           // cViewTextStand
   TX_White_on_Magenta,                         // cViewTextMark
   TX_Blue_on_White,                            // cViewTextNr1
   TX_Green_on_White,                           // cViewTextNr2
   TX_Cyan_on_White,                            // cViewTextNr3
   TX_Black_on_White,                           // cListTextStand
   TX_Lgreen_on_Black,                          // cListTextFocus
   TX_Blue_on_White,                            // cListTxt1Stand
   TX_Lgreen_on_Black,                          // cListTxt1Focus
   TX_Green_on_White,                           // cListTxt2Stand
   TX_Lgreen_on_Black,                          // cListTxt2Focus
   TX_Grey_on_White,                            // cListTxt3Stand
   TX_Lgreen_on_Black,                          // cListTxt3Focus
   TX_Green_on_White,                           // cListSelectStand
   TX_Lgreen_on_Black,                          // cListSelectFocus
   TX_Magenta_on_White,                         // cListMarkStand
   TX_Lmagenta_on_Black,                        // cListMarkFocus
   TX_Lwhite_on_White,                          // cListDisableStand
   TX_White_on_Blue,                            // cListDisableFocus
   TX_Black_on_White,                           // cListSeparatStand
   TX_Green_on_Black,                           // cListSeparatFocus
   TX_White_on_Cyan,                            // cListCountStand
   TX_Yellow_on_Cyan,                           // cListCountFocus
   TX_Black_on_White,                           // cFileTextStand
   TX_Yellow_on_Black,                          // cFileTextFocus
   TX_Blue_on_White,                            // cFileTxt1Stand
   TX_Yellow_on_Black,                          // cFileTxt1Focus
   TX_Green_on_White,                           // cFileTxt2Stand
   TX_Yellow_on_Black,                          // cFileTxt2Focus
   TX_Grey_on_White,                            // cFileTxt3Stand
   TX_Yellow_on_Black,                          // cFileTxt3Focus
   TX_Black_on_White,                           // cFileSelectStand
   TX_Yellow_on_Black,                          // cFileSelectFocus
   TX_Magenta_on_Grey,                          // cFileMarkStand     (DIR/Browser mark line/area)
   TX_Lmagenta_on_Black,                        // cFileMarkFocus     (DIR/Browser cursor line)
   TX_Lwhite_on_White,                          // cFileDisableStand
   TX_White_on_Blue,                            // cFileDisableFocus
   TX_Black_on_White,                           // cFileSeparatStand
   TX_Yellow_on_Black,                          // cFileSeparatFocus
   TX_Black_on_White,                           // cFileCountStand
   TX_Blue_on_White,                            // cFileCountFocus
   TX_Black_on_White,                           // cFileBorder_top
   TX_Lwhite_on_White,                          // cFileBorder_trc (or blank)
   TX_Lwhite_on_White,                          // cFileBorder_rgt
   TX_Lwhite_on_White,                          // cFileBorder_brc
   TX_Lwhite_on_White,                          // cFileBorder_bot
   TX_Lwhite_on_White,                          // cFileBorder_blc (or blank)
   TX_Black_on_White,                           // cFileBorder_lft
   TX_Black_on_White,                           // cFileBorder_tlc
   TX_Black_on_White,                           // cFileTitleStand
   TX_Lwhite_on_Grey,                           // cFileTitleFocus
   TX_Lwhite_on_White,                          // cFileFooterStand
   TX_White_on_Grey,                            // cFileFooterFocus
   TX_White_on_Grey,                            // cMenuTextStand
   TX_White_on_Blue,                            // cMenuTextFocus
   TX_Blue_on_Grey,                             // cMenuTxt1Stand
   TX_Lgreen_on_Blue,                           // cMenuTxt1Focus
   TX_Green_on_Grey,                            // cMenuTxt2Stand
   TX_Lgreen_on_Blue,                           // cMenuTxt2Focus
   TX_Cyan_on_Grey,                             // cMenuTxt3Stand
   TX_Lgreen_on_Blue,                           // cMenuTxt3Focus
   TX_Yellow_on_Grey,                           // cMenuSelectStand
   TX_Yellow_on_Blue,                           // cMenuSelectFocus
   TX_Black_on_Grey,                            // cMenuMarkStand
   TX_Cyan_on_Blue,                             // cMenuMarkFocus            (mbar)
   TX_Black_on_Grey,                            // cMenuDisableStand
   TX_Cyan_on_Blue,                             // cMenuDisableFocus         (mbar)
   TX_White_on_Grey,                            // cMenuSeparatStand
   TX_White_on_Blue,                            // cMenuSeparatFocus
   TX_White_on_Grey,                            // cMenuBorder_top
   TX_White_on_Grey,                            // cMenuBorder_trc
   TX_Black_on_Grey,                            // cMenuBorder_rgt
   TX_Black_on_Grey,                            // cMenuBorder_brc
   TX_Black_on_Grey,                            // cMenuBorder_bot
   TX_White_on_Grey,                            // cMenuBorder_blc
   TX_White_on_Grey,                            // cMenuBorder_lft
   TX_White_on_Grey,                            // cMenuBorder_tlc
   TX_White_on_Grey,                            // cMbarBorder_top
   TX_White_on_Grey,                            // cMbarBorder_trc
   TX_White_on_Grey,                            // cMbarBorder_rgt
   TX_White_on_Grey,                            // cMbarBorder_brc
   TX_White_on_Grey,                            // cMbarBorder_bot
   TX_White_on_Grey,                            // cMbarBorder_blc
   TX_White_on_Grey,                            // cMbarBorder_lft
   TX_White_on_Grey,                            // cMbarBorder_tlc
   TX_White_on_Grey,                            // cMbarTextStand
   TX_White_on_Grey,                            // cMbarTextFocus
   TX_Yellow_on_Grey,                           // cMbarHeadStand
   TX_Lwhite_on_Magenta,                        // cMbarHeadFocus
   TX_White_on_Grey,                            // cSpinTextStand
   TX_Lwhite_on_Grey,                           // cSpinTextFocus
   TX_Yellow_on_Grey,                           // cSpinSelectStand
   TX_Yellow_on_Grey,                           // cSpinSelectFocus
   TX_Black_on_Grey,                            // cSpinMarkStand
   TX_Black_on_Grey,                            // cSpinMarkFocus
   TX_Black_on_Grey,                            // cSpinDisableStand
   TX_Black_on_Grey,                            // cSpinDisableFocus
   TX_White_on_Grey,                            // cSpinSeparatStand
   TX_White_on_Grey,                            // cSpinSeparatFocus
   TX_Lwhite_on_Grey,                           // cSpinIndcStand
   TX_White_on_Blue,                            // cSpinIndcFocus
   TX_Lwhite_on_Grey,                           // cPushTextStand
   TX_Yellow_on_Grey,                           // cPushTextFocus
   TX_Black_on_White,                           // cRadioValueStand
   TX_Lwhite_on_Green,                          // cRadioValueFocus
   TX_Black_on_White,                           // cRadioTextStand
   TX_Black_on_White,                           // cRadioTextFocus
   TX_Black_on_White,                           // cCheckValueStand
   TX_Lwhite_on_Green,                          // cCheckValueFocus
   TX_Black_on_White,                           // cCheckTextStand
   TX_Black_on_White,                           // cCheckTextFocus
   TX_Yellow_on_Green,                          // cDlgEfTextStand
   TX_Lwhite_on_Green,                          // cDlgEfTextFocus
   TX_Yellow_on_Green,                          // cEntryTextStand
   TX_Yellow_on_Green,                          // cEntryTextFocus
   TX_Green_on_Green,                           // cEntryHistStand
   TX_White_on_Green,                           // cEntryHistFocus
   TX_White_on_Green,                           // cEntrBorder_top
   TX_White_on_Green,                           // cEntrBorder_trc
   TX_White_on_Green,                           // cEntrBorder_rgt
   TX_White_on_Green,                           // cEntrBorder_brc
   TX_White_on_Green,                           // cEntrBorder_bot
   TX_White_on_Green,                           // cEntrBorder_blc
   TX_White_on_Green,                           // cEntrBorder_lft
   TX_White_on_Green,                           // cEntrBorder_tlc
   TX_White_on_Green,                           // cEntrTitleStand
   TX_Lwhite_on_Grey,                           // cEntrTitleFocus
   TX_Black_on_White,                           // cEntrFooterStand
   TX_White_on_Grey,                            // cEntrFooterFocus
   TX_Lcyan_on_Blue,                            // cHexEdAscBracket
   TX_Grey_on_White,                            // cHexEdRelPosPrev
   TX_Black_on_White,                           // cHexEdRelPosCurr
   TX_Grey_on_White,                            // cHexEdRelPosNext
   TX_Cyan_on_White,                            // cHexEdAbsBytePos
   TX_Cyan_on_White,                            // cHexEdAbsByteCur
   TX_Black_on_White,                           // cHexEdRelCursorP
   TX_Yellow_on_Grey,                           // cHexEdButtonText
   TX_White_on_Grey,                            // cHexEdButBracket
   TX_Grey_on_White,                            // cHexEdByteNumber
   TX_White_on_Cyan,                            // cHexEdItemSnText
   TX_Yellow_on_Cyan,                           // cHexEdItemHlight
   TX_Red_on_White,                             // cHexEdModifyText
   TX_White_on_Blue,                            // c1NomarkActiveOrgStd
   TX_Lwhite_on_Green,                          // c1NomarkActiveOrgCur
   TX_Yellow_on_Blue,                           // c1NomarkActiveModStd
   TX_Yellow_on_Green,                          // c1NomarkActiveModCur
   TX_Grey_on_Blue,                             // c1NomarkDimmedOrgStd
   TX_White_on_Green,                           // c1NomarkDimmedOrgCur
   TX_Brown_on_Blue,                            // c1NomarkDimmedModStd
   TX_Brown_on_Green,                           // c1NomarkDimmedModCur
   TX_White_on_Magenta,                         // c1MarkedActiveOrgStd
   TX_Lwhite_on_Green,                          // c1MarkedActiveOrgCur
   TX_Yellow_on_Magenta,                        // c1MarkedActiveModStd
   TX_Yellow_on_Green,                          // c1MarkedActiveModCur
   TX_Grey_on_Magenta,                          // c1MarkedDimmedOrgStd
   TX_White_on_Green,                           // c1MarkedDimmedOrgCur
   TX_Brown_on_Magenta,                         // c1MarkedDimmedModStd
   TX_Yellow_on_Green,                          // c1MarkedDimmedModCur
   TX_Lwhite_on_Blue,                           // c2NomarkActiveOrgStd
   TX_Lwhite_on_Green,                          // c2NomarkActiveOrgCur
   TX_Yellow_on_Blue,                           // c2NomarkActiveModStd
   TX_Yellow_on_Green,                          // c2NomarkActiveModCur
   TX_White_on_Blue,                            // c2NomarkDimmedOrgStd
   TX_White_on_Green,                           // c2NomarkDimmedOrgCur
   TX_Brown_on_Blue,                            // c2NomarkDimmedModStd
   TX_Brown_on_Green,                           // c2NomarkDimmedModCur
};

//- Color scheme that avoids the 'bright backgrounds' that may cause blinking
static TXW_COLORMAP    txwcm_nb =
{
   0,                                           // cSchemeColor
   TX_Black_on_White,                           // cWinClientClr
   TX_Red_on_White,                             // cWinClientErr
   TX_White_on_Cyan,                            // cWinBorder_top
   TX_White_on_Cyan,                            // cWinBorder_trc
   TX_White_on_Cyan,                            // cWinBorder_rgt
   TX_White_on_Cyan,                            // cWinBorder_brc
   TX_White_on_Cyan,                            // cWinBorder_bot
   TX_White_on_Cyan,                            // cWinBorder_blc
   TX_White_on_Cyan,                            // cWinBorder_lft
   TX_White_on_Cyan,                            // cWinBorder_tlc
   TX_Yellow_on_Cyan,                           // cWinTitleStand
   TX_Lwhite_on_Magenta,                        // cWinTitleFocus
   TX_Cyan_on_Cyan,                             // cWinFooterStand
   TX_Yellow_on_Blue,                           // cWinFooterFocus
   TX_Black_on_White,                           // cDlgBorder_top
   TX_Black_on_White,                           // cDlgBorder_trc
   TX_Black_on_White,                           // cDlgBorder_rgt
   TX_Black_on_White,                           // cDlgBorder_brc
   TX_Black_on_White,                           // cDlgBorder_bot
   TX_Black_on_White,                           // cDlgBorder_blc
   TX_Black_on_White,                           // cDlgBorder_lft
   TX_Black_on_White,                           // cDlgBorder_tlc
   TX_Black_on_White,                           // cDlgTitleStand
   TX_Black_on_White,                           // cDlgTitleFocus
   TX_Black_on_White,                           // cDlgFooterStand
   TX_Black_on_White,                           // cDlgFooterFocus
   TX_Lwhite_on_Cyan,                           // cPushBorder_top
   TX_Lwhite_on_Cyan,                           // cPushBorder_trc
   TX_Lwhite_on_Cyan,                           // cPushBorder_rgt
   TX_Lwhite_on_Cyan,                           // cPushBorder_brc
   TX_Lwhite_on_Cyan,                           // cPushBorder_bot
   TX_Lwhite_on_Cyan,                           // cPushBorder_blc
   TX_Lwhite_on_Cyan,                           // cPushBorder_lft
   TX_Lwhite_on_Cyan,                           // cPushBorder_tlc
   TX_Yellow_on_Cyan,                           // cPushTitleStand
   TX_Lwhite_on_Magenta,                        // cPushTitleFocus
   TX_Cyan_on_Cyan,                             // cPushFooterStand
   TX_Yellow_on_Blue,                           // cPushFooterFocus
   TX_White_on_Cyan,                            // cViewBorder_top
   TX_White_on_Cyan,                            // cViewBorder_trc
   TX_White_on_Cyan,                            // cViewBorder_rgt
   TX_White_on_Cyan,                            // cViewBorder_brc
   TX_White_on_Cyan,                            // cViewBorder_bot
   TX_White_on_Cyan,                            // cViewBorder_blc
   TX_White_on_Cyan,                            // cViewBorder_lft
   TX_White_on_Cyan,                            // cViewBorder_tlc
   TX_Yellow_on_Cyan,                           // cViewTitleStand
   TX_Lwhite_on_Magenta,                        // cViewTitleFocus
   TX_Cyan_on_Cyan,                             // cViewFooterStand
   TX_Yellow_on_Blue,                           // cViewFooterFocus
   TX_White_on_Cyan,                            // cSbvBorder_top
   TX_White_on_Cyan,                            // cSbvBorder_trc
   TX_White_on_Cyan,                            // cSbvBorder_rgt
   TX_White_on_Cyan,                            // cSbvBorder_brc
   TX_White_on_Cyan,                            // cSbvBorder_bot
   TX_White_on_Cyan,                            // cSbvBorder_blc
   TX_White_on_Cyan,                            // cSbvBorder_lft
   TX_White_on_Cyan,                            // cSbvBorder_tlc
   TX_Yellow_on_Cyan,                           // cSbvTitleStand
   TX_Lwhite_on_Magenta,                        // cSbvTitleFocus
   TX_White_on_Cyan,                            // cSbvFooterStand
   TX_White_on_Cyan,                            // cSbvFooterFocus
   TX_Yellow_on_Cyan,                           // cSbvStatusStand
   TX_Yellow_on_Cyan,                           // cSbvStatusFocus
   TX_Lwhite_on_Cyan,                           // cSbvProgreStand
   TX_Lgreen_on_Cyan,                           // cSbvTraceStand
   TX_White_on_Magenta,                         // cSbvMarkedArea
   TX_Lgreen_on_Cyan,                           // cDskTraceStand
   TX_White_on_Cyan,                            // cDskBorder_top
   TX_White_on_Cyan,                            // cDskBorder_trc
   TX_White_on_Cyan,                            // cDskBorder_rgt
   TX_White_on_Cyan,                            // cDskBorder_brc
   TX_White_on_Cyan,                            // cDskBorder_bot
   TX_White_on_Cyan,                            // cDskBorder_blc
   TX_White_on_Cyan,                            // cDskBorder_lft
   TX_White_on_Cyan,                            // cDskBorder_tlc
   TX_Lwhite_on_Cyan,                           // cDskTitleStand
   TX_Lwhite_on_Cyan,                           // cDskTitleFocus
   TX_White_on_Blue,                            // cDskFooterStand
   TX_White_on_Blue,                            // cDskFooterFocus
   TX_Black_on_White,                           // cLineTextStand
   TX_Black_on_White,                           // cLineTextNr0
   TX_Blue_on_White,                            // cLineTextNr1
   TX_Green_on_White,                           // cLineTextNr2
   TX_Cyan_on_White,                            // cLineTextNr3
   TX_Black_on_White,                           // cHelpTextStand
   TX_Black_on_White,                           // cHelpTextHelp
   TX_Black_on_White,                           // cViewTextStand
   TX_White_on_Magenta,                         // cViewTextMark
   TX_Blue_on_White,                            // cViewTextNr1
   TX_Green_on_White,                           // cViewTextNr2
   TX_Cyan_on_White,                            // cViewTextNr3
   TX_White_on_Brown,                           // cListTextStand
   TX_White_on_Blue,                            // cListTextFocus
   TX_Blue_on_Brown,                            // cListTxt1Stand
   TX_White_on_Blue,                            // cListTxt1Focus
   TX_Green_on_Brown,                           // cListTxt2Stand
   TX_White_on_Blue,                            // cListTxt2Focus
   TX_Lcyan_on_Brown,                           // cListTxt3Stand
   TX_White_on_Blue,                            // cListTxt3Focus
   TX_Yellow_on_Brown,                          // cListSelectStand
   TX_Yellow_on_Blue,                           // cListSelectFocus
   TX_Black_on_Brown,                           // cListMarkStand
   TX_Cyan_on_Blue,                             // cListMarkFocus            (mbar)
   TX_Black_on_Brown,                           // cListDisableStand
   TX_Cyan_on_Blue,                             // cListDisableFocus         (mbar)
   TX_White_on_Brown,                           // cListSeparatStand
   TX_White_on_Blue,                            // cListSeparatFocus
   TX_White_on_Cyan,                            // cListCountStand
   TX_Yellow_on_Cyan,                           // cListCountFocus
   TX_Black_on_White,                           // cFileTextStand
   TX_Green_on_Black,                           // cFileTextFocus
   TX_Blue_on_White,                            // cFileTxt1Stand
   TX_Green_on_Black,                           // cFileTxt1Focus
   TX_Green_on_White,                           // cFileTxt2Stand
   TX_Green_on_Black,                           // cFileTxt2Focus
   TX_Lcyan_on_White,                           // cFileTxt3Stand
   TX_Green_on_Black,                           // cFileTxt3Focus
   TX_Black_on_White,                           // cFileSelectStand
   TX_Green_on_Black,                           // cFileSelectFocus
   TX_Magenta_on_White,                         // cFileMarkStand     (DIR/Browser mark line/area)
   TX_Lmagenta_on_Black,                        // cFileMarkFocus     (DIR/Browser cursor line)
   TX_Grey_on_Black,                            // cFileDisableStand
   TX_Cyan_on_Blue,                             // cFileDisableFocus         (mbar)
   TX_Black_on_White,                           // cFileSeparatStand
   TX_Green_on_Black,                           // cFileSeparatFocus
   TX_White_on_Cyan,                            // cFileCountStand
   TX_Yellow_on_Cyan,                           // cFileCountFocus
   TX_White_on_Cyan,                            // cFileBorder_top
   TX_White_on_Cyan,                            // cFileBorder_trc
   TX_White_on_Cyan,                            // cFileBorder_rgt
   TX_White_on_Cyan,                            // cFileBorder_brc
   TX_White_on_Cyan,                            // cFileBorder_bot
   TX_White_on_Cyan,                            // cFileBorder_blc
   TX_White_on_Cyan,                            // cFileBorder_lft
   TX_White_on_Cyan,                            // cFileBorder_tlc
   TX_Yellow_on_Cyan,                           // cFileTitleStand
   TX_Lwhite_on_Magenta,                        // cFileTitleFocus
   TX_Cyan_on_Cyan,                             // cFileFooterStand
   TX_Yellow_on_Blue,                           // cFileFooterFocus
   TX_White_on_Brown,                           // cMenuTextStand
   TX_White_on_Blue,                            // cMenuTextFocus
   TX_Blue_on_Brown,                            // cMenuTxt1Stand
   TX_White_on_Blue,                            // cMenuTxt1Focus
   TX_Green_on_Brown,                           // cMenuTxt2Stand
   TX_White_on_Blue,                            // cMenuTxt2Focus
   TX_Cyan_on_Brown,                            // cMenuTxt3Stand
   TX_White_on_Blue,                            // cMenuTxt3Focus
   TX_Yellow_on_Brown,                          // cMenuSelectStand
   TX_Yellow_on_Blue,                           // cMenuSelectFocus
   TX_Black_on_Brown,                           // cMenuMarkStand
   TX_Cyan_on_Blue,                             // cMenuMarkFocus            (mbar)
   TX_Black_on_Brown,                           // cMenuDisableStand
   TX_Cyan_on_Blue,                             // cMenuDisableFocus         (mbar)
   TX_White_on_Brown,                           // cMenuSeparatStand
   TX_White_on_Blue,                            // cMenuSeparatFocus
   TX_White_on_Cyan,                            // cMenuBorder_top
   TX_White_on_Cyan,                            // cMenuBorder_trc
   TX_White_on_Cyan,                            // cMenuBorder_rgt
   TX_White_on_Cyan,                            // cMenuBorder_brc
   TX_White_on_Cyan,                            // cMenuBorder_bot
   TX_White_on_Cyan,                            // cMenuBorder_blc
   TX_White_on_Cyan,                            // cMenuBorder_lft
   TX_White_on_Cyan,                            // cMenuBorder_tlc
   TX_White_on_Brown,                           // cMbarBorder_top
   TX_White_on_Brown,                           // cMbarBorder_trc
   TX_White_on_Brown,                           // cMbarBorder_rgt
   TX_White_on_Brown,                           // cMbarBorder_brc
   TX_White_on_Brown,                           // cMbarBorder_bot
   TX_White_on_Brown,                           // cMbarBorder_blc
   TX_White_on_Brown,                           // cMbarBorder_lft
   TX_White_on_Brown,                           // cMbarBorder_tlc
   TX_White_on_Brown,                           // cMbarTextStand
   TX_White_on_Brown,                           // cMbarTextFocus
   TX_Yellow_on_Brown,                          // cMbarHeadStand
   TX_Lwhite_on_Magenta,                        // cMbarHeadFocus
   TX_White_on_Brown,                           // cSpinTextStand
   TX_Lwhite_on_Brown,                          // cSpinTextFocus
   TX_Yellow_on_Brown,                          // cSpinSelectStand
   TX_Yellow_on_Brown,                          // cSpinSelectFocus
   TX_Black_on_Brown,                           // cSpinMarkStand
   TX_Black_on_Brown,                           // cSpinMarkFocus
   TX_Black_on_Brown,                           // cSpinDisableStand
   TX_Black_on_Brown,                           // cSpinDisableFocus
   TX_White_on_Brown,                           // cSpinSeparatStand
   TX_White_on_Brown,                           // cSpinSeparatFocus
   TX_Black_on_Brown,                           // cSpinIndcStand
   TX_White_on_Blue,                            // cSpinIndcFocus
   TX_Lwhite_on_Cyan,                           // cPushTextStand
   TX_Yellow_on_Cyan,                           // cPushTextFocus
   TX_Black_on_White,                           // cRadioValueStand
   TX_Lwhite_on_Green,                          // cRadioValueFocus
   TX_Black_on_White,                           // cRadioTextStand
   TX_Black_on_White,                           // cRadioTextFocus
   TX_Black_on_White,                           // cCheckValueStand
   TX_Lwhite_on_Green,                          // cCheckValueFocus
   TX_Black_on_White,                           // cCheckTextStand
   TX_Black_on_White,                           // cCheckTextFocus
   TX_Yellow_on_Green,                          // cDlgEfTextStand
   TX_Lwhite_on_Green,                          // cDlgEfTextFocus
   TX_Yellow_on_Green,                          // cEntryTextStand
   TX_Yellow_on_Green,                          // cEntryTextFocus
   TX_Green_on_Green,                           // cEntryHistStand
   TX_White_on_Green,                           // cEntryHistFocus
   TX_White_on_Green,                           // cEntrBorder_top
   TX_White_on_Green,                           // cEntrBorder_trc
   TX_White_on_Green,                           // cEntrBorder_rgt
   TX_White_on_Green,                           // cEntrBorder_brc
   TX_White_on_Green,                           // cEntrBorder_bot
   TX_White_on_Green,                           // cEntrBorder_blc
   TX_White_on_Green,                           // cEntrBorder_lft
   TX_White_on_Green,                           // cEntrBorder_tlc
   TX_White_on_Green,                           // cEntrTitleStand
   TX_Lwhite_on_Magenta,                        // cEntrTitleFocus
   TX_White_on_Green,                           // cEntrFooterStand
   TX_White_on_Blue,                            // cEntrFooterFocus
   TX_Lcyan_on_Blue,                            // cHexEdAscBracket
   TX_Grey_on_White,                            // cHexEdRelPosPrev
   TX_Black_on_White,                           // cHexEdRelPosCurr
   TX_Grey_on_White,                            // cHexEdRelPosNext
   TX_Cyan_on_White,                            // cHexEdAbsBytePos
   TX_Cyan_on_White,                            // cHexEdAbsByteCur
   TX_Black_on_White,                           // cHexEdRelCursorP
   TX_Yellow_on_Cyan,                           // cHexEdButtonText
   TX_White_on_Cyan,                            // cHexEdButBracket
   TX_Grey_on_White,                            // cHexEdByteNumber
   TX_White_on_Magenta,                         // cHexEdItemSnText
   TX_Yellow_on_Magenta,                        // cHexEdItemHlight
   TX_Red_on_White,                             // cHexEdModifyText
   TX_White_on_Blue,                            // c1NomarkActiveOrgStd
   TX_Lwhite_on_Green,                          // c1NomarkActiveOrgCur
   TX_Yellow_on_Blue,                           // c1NomarkActiveModStd
   TX_Yellow_on_Green,                          // c1NomarkActiveModCur
   TX_Grey_on_Blue,                             // c1NomarkDimmedOrgStd
   TX_White_on_Green,                           // c1NomarkDimmedOrgCur
   TX_Brown_on_Blue,                            // c1NomarkDimmedModStd
   TX_Brown_on_Green,                           // c1NomarkDimmedModCur
   TX_White_on_Magenta,                         // c1MarkedActiveOrgStd
   TX_Lwhite_on_Green,                          // c1MarkedActiveOrgCur
   TX_Yellow_on_Magenta,                        // c1MarkedActiveModStd
   TX_Yellow_on_Green,                          // c1MarkedActiveModCur
   TX_Grey_on_Magenta,                          // c1MarkedDimmedOrgStd
   TX_White_on_Green,                           // c1MarkedDimmedOrgCur
   TX_Brown_on_Magenta,                         // c1MarkedDimmedModStd
   TX_Yellow_on_Green,                          // c1MarkedDimmedModCur
   TX_Lwhite_on_Blue,                           // c2NomarkActiveOrgStd
   TX_Lwhite_on_Green,                          // c2NomarkActiveOrgCur
   TX_Yellow_on_Blue,                           // c2NomarkActiveModStd
   TX_Yellow_on_Green,                          // c2NomarkActiveModCur
   TX_White_on_Blue,                            // c2NomarkDimmedOrgStd
   TX_White_on_Green,                           // c2NomarkDimmedOrgCur
   TX_Brown_on_Blue,                            // c2NomarkDimmedModStd
   TX_Brown_on_Green,                           // c2NomarkDimmedModCur
};

//- Color scheme inspired by the Norton Commander and clones, very Cyan/Blue
static TXW_COLORMAP    txwcm_cm =
{
   0,                                           // cSchemeColor
   TX_Black_on_White,                           // cWinClientClr
   TX_Red_on_White,                             // cWinClientErr
   TX_Black_on_White,                           // cWinBorder_top
   TX_Black_on_White,                           // cWinBorder_trc
   TX_Black_on_White,                           // cWinBorder_rgt
   TX_Black_on_White,                           // cWinBorder_brc
   TX_Black_on_White,                           // cWinBorder_bot
   TX_Black_on_White,                           // cWinBorder_blc
   TX_Black_on_White,                           // cWinBorder_lft
   TX_Black_on_White,                           // cWinBorder_tlc
   TX_Black_on_White,                           // cWinTitleStand
   TX_Blue_on_White,                            // cWinTitleFocus
   TX_Black_on_White,                           // cWinFooterStand
   TX_Magenta_on_White,                         // cWinFooterFocus
   TX_Black_on_White,                           // cDlgBorder_top
   TX_Black_on_White,                           // cDlgBorder_trc
   TX_Black_on_White,                           // cDlgBorder_rgt
   TX_Black_on_White,                           // cDlgBorder_brc
   TX_Black_on_White,                           // cDlgBorder_bot
   TX_Black_on_White,                           // cDlgBorder_blc
   TX_Black_on_White,                           // cDlgBorder_lft
   TX_Black_on_White,                           // cDlgBorder_tlc
   TX_Black_on_White,                           // cDlgTitleStand
   TX_Black_on_White,                           // cDlgTitleFocus
   TX_Black_on_White,                           // cDlgFooterStand
   TX_Black_on_White,                           // cDlgFooterFocus
   TX_Black_on_White,                           // cPushBorder_top
   TX_Black_on_White,                           // cPushBorder_trc
   TX_Black_on_White,                           // cPushBorder_rgt
   TX_Black_on_White,                           // cPushBorder_brc
   TX_Black_on_White,                           // cPushBorder_bot
   TX_Black_on_White,                           // cPushBorder_blc
   TX_Black_on_White,                           // cPushBorder_lft
   TX_Black_on_White,                           // cPushBorder_tlc
   TX_Black_on_White,                           // cPushTitleStand
   TX_Black_on_Cyan,                            // cPushTitleFocus
   TX_Black_on_White,                           // cPushFooterStand
   TX_Black_on_Cyan,                            // cPushFooterFocus
   TX_Black_on_White,                           // cViewBorder_top
   TX_Black_on_White,                           // cViewBorder_trc
   TX_Black_on_White,                           // cViewBorder_rgt
   TX_Black_on_White,                           // cViewBorder_brc
   TX_Black_on_White,                           // cViewBorder_bot
   TX_Black_on_White,                           // cViewBorder_blc
   TX_Black_on_White,                           // cViewBorder_lft
   TX_Black_on_White,                           // cViewBorder_tlc
   TX_Black_on_White,                           // cViewTitleStand
   TX_Blue_on_White,                            // cViewTitleFocus
   TX_Black_on_White,                           // cViewFooterStand
   TX_Magenta_on_White,                         // cViewFooterFocus
   TX_Lcyan_on_Blue,                            // cSbvBorder_top
   TX_Lcyan_on_Blue,                            // cSbvBorder_trc
   TX_Lcyan_on_Blue,                            // cSbvBorder_rgt
   TX_Lcyan_on_Blue,                            // cSbvBorder_brc
   TX_Lcyan_on_Blue,                            // cSbvBorder_bot
   TX_Lcyan_on_Blue,                            // cSbvBorder_blc
   TX_Lcyan_on_Blue,                            // cSbvBorder_lft
   TX_Lcyan_on_Blue,                            // cSbvBorder_tlc
   TX_Lcyan_on_Blue,                            // cSbvTitleStand
   TX_Black_on_Cyan,                            // cSbvTitleFocus
   TX_Lcyan_on_Blue,                            // cSbvFooterStand
   TX_Lcyan_on_Blue,                            // cSbvFooterFocus
   TX_Yellow_on_Blue,                           // cSbvStatusStand
   TX_Yellow_on_Blue,                           // cSbvStatusFocus
   TX_Lgreen_on_Blue,                           // cSbvProgreStand
   TX_Lgreen_on_Blue,                           // cSbvTraceStand
   TX_White_on_Magenta,                         // cSbvMarkedArea
   TX_Lgreen_on_Black,                          // cDskTraceStand
   TX_White_on_Black,                           // cDskBorder_top
   TX_White_on_Black,                           // cDskBorder_trc
   TX_White_on_Black,                           // cDskBorder_rgt
   TX_White_on_Black,                           // cDskBorder_brc
   TX_White_on_Black,                           // cDskBorder_bot
   TX_White_on_Black,                           // cDskBorder_blc
   TX_White_on_Black,                           // cDskBorder_lft
   TX_White_on_Black,                           // cDskBorder_tlc
   TX_Lwhite_on_Black,                          // cDskTitleStand
   TX_Lwhite_on_Black,                          // cDskTitleFocus
   TX_Lgreen_on_Black,                          // cDskFooterStand
   TX_Lgreen_on_Black,                          // cDskFooterFocus
   TX_Black_on_White,                           // cLineTextStand
   TX_Black_on_White,                           // cLineTextNr0
   TX_Blue_on_White,                            // cLineTextNr1
   TX_Green_on_White,                           // cLineTextNr2
   TX_Cyan_on_White,                            // cLineTextNr3
   TX_Black_on_White,                           // cHelpTextStand
   TX_Black_on_White,                           // cHelpTextHelp
   TX_Black_on_White,                           // cViewTextStand
   TX_White_on_Magenta,                         // cViewTextMark
   TX_Blue_on_White,                            // cViewTextNr1
   TX_Green_on_White,                           // cViewTextNr2
   TX_Cyan_on_White,                            // cViewTextNr3
   TX_Lwhite_on_Cyan,                           // cListTextStand
   TX_Lwhite_on_Black,                          // cListTextFocus
   TX_Blue_on_Cyan,                             // cListTxt1Stand
   TX_Lwhite_on_Black,                          // cListTxt1Focus
   TX_Green_on_Cyan,                            // cListTxt2Stand
   TX_Lwhite_on_Black,                          // cListTxt2Focus
   TX_Lcyan_on_Cyan,                            // cListTxt3Stand
   TX_Lwhite_on_Black,                          // cListTxt3Focus
   TX_Yellow_on_Cyan,                           // cListSelectStand
   TX_Yellow_on_Black,                          // cListSelectFocus
   TX_Lwhite_on_Cyan,                           // cListMarkStand
   TX_Lwhite_on_Black,                          // cListMarkFocus
   TX_White_on_Cyan,                            // cListDisableStand
   TX_White_on_Black,                           // cListDisableFocus
   TX_Black_on_Cyan,                            // cListSeparatStand
   TX_White_on_Black,                           // cListSeparatFocus
   TX_White_on_Cyan,                            // cListCountStand
   TX_Yellow_on_Cyan,                           // cListCountFocus
   TX_Lcyan_on_Blue,                            // cFileTextStand
   TX_Black_on_Green,                           // cFileTextFocus
   TX_Lgreen_on_Blue,                           // cFileTxt1Stand
   TX_Black_on_Green,                           // cFileTxt1Focus
   TX_Grey_on_Blue,                             // cFileTxt2Stand
   TX_Black_on_Green,                           // cFileTxt2Focus
   TX_Lcyan_on_Blue,                            // cFileTxt3Stand
   TX_Black_on_Green,                           // cFileTxt3Focus
   TX_Lgreen_on_Blue,                           // cFileSelectStand
   TX_Black_on_Green,                           // cFileSelectFocus
   TX_Yellow_on_Blue,                           // cFileMarkStand     (DIR/Browser mark line/area)
   TX_Yellow_on_Green,                          // cFileMarkFocus     (DIR/Browser cursor line)
   TX_Grey_on_Black,                            // cFileDisableStand
   TX_Cyan_on_Blue,                             // cFileDisableFocus         (mbar)
   TX_Lgreen_on_Blue,                           // cFileSeparatStand
   TX_Black_on_Green,                           // cFileSeparatFocus
   TX_Lcyan_on_Blue,                            // cFileCountStand
   TX_Yellow_on_Blue,                           // cFileCountFocus
   TX_Lcyan_on_Blue,                            // cFileBorder_top
   TX_Lcyan_on_Blue,                            // cFileBorder_trc
   TX_Lcyan_on_Blue,                            // cFileBorder_rgt
   TX_Lcyan_on_Blue,                            // cFileBorder_brc
   TX_Lcyan_on_Blue,                            // cFileBorder_bot
   TX_Lcyan_on_Blue,                            // cFileBorder_blc
   TX_Lcyan_on_Blue,                            // cFileBorder_lft
   TX_Lcyan_on_Blue,                            // cFileBorder_tlc
   TX_Lcyan_on_Blue,                            // cFileTitleStand
   TX_Black_on_Cyan,                            // cFileTitleFocus
   TX_Lcyan_on_Blue,                            // cFileFooterStand
   TX_Black_on_Cyan,                            // cFileFooterFocus
   TX_Lwhite_on_Cyan,                           // cMenuTextStand
   TX_Lwhite_on_Black,                          // cMenuTextFocus
   TX_Blue_on_Cyan,                             // cMenuTxt1Stand
   TX_Lwhite_on_Black,                          // cMenuTxt1Focus
   TX_Green_on_Cyan,                            // cMenuTxt2Stand
   TX_Lwhite_on_Black,                          // cMenuTxt2Focus
   TX_White_on_Cyan,                            // cMenuTxt3Stand
   TX_Lwhite_on_Black,                          // cMenuTxt3Focus
   TX_Yellow_on_Cyan,                           // cMenuSelectStand
   TX_Yellow_on_Black,                          // cMenuSelectFocus
   TX_Lwhite_on_Cyan,                           // cMenuMarkStand
   TX_Lwhite_on_Black,                          // cMenuMarkFocus
   TX_White_on_Cyan,                            // cMenuDisableStand
   TX_White_on_Black,                           // cMenuDisableFocus
   TX_Black_on_Cyan,                            // cMenuSeparatStand
   TX_White_on_Black,                           // cMenuSeparatFocus
   TX_Black_on_Cyan,                            // cMenuBorder_top
   TX_Black_on_Cyan,                            // cMenuBorder_trc
   TX_Black_on_Cyan,                            // cMenuBorder_rgt
   TX_Black_on_Cyan,                            // cMenuBorder_brc
   TX_Black_on_Cyan,                            // cMenuBorder_bot
   TX_Black_on_Cyan,                            // cMenuBorder_blc
   TX_Black_on_Cyan,                            // cMenuBorder_lft
   TX_Black_on_Cyan,                            // cMenuBorder_tlc
   TX_Black_on_Cyan,                            // cMbarBorder_top
   TX_Black_on_Cyan,                            // cMbarBorder_trc
   TX_Black_on_Cyan,                            // cMbarBorder_rgt
   TX_Black_on_Cyan,                            // cMbarBorder_brc
   TX_Black_on_Cyan,                            // cMbarBorder_bot
   TX_Black_on_Cyan,                            // cMbarBorder_blc
   TX_Black_on_Cyan,                            // cMbarBorder_lft
   TX_Black_on_Cyan,                            // cMbarBorder_tlc
   TX_Black_on_Cyan,                            // cMbarTextStand
   TX_Black_on_Cyan,                            // cMbarTextFocus
   TX_Black_on_Cyan,                            // cMbarHeadStand
   TX_Lwhite_on_Black,                          // cMbarHeadFocus
   TX_Black_on_Cyan,                            // cSpinTextStand
   TX_Lwhite_on_Cyan,                           // cSpinTextFocus
   TX_Black_on_Cyan,                            // cSpinSelectStand
   TX_Yellow_on_Cyan,                           // cSpinSelectFocus
   TX_Black_on_Cyan,                            // cSpinMarkStand
   TX_Black_on_Cyan,                            // cSpinMarkFocus
   TX_Black_on_Cyan,                            // cSpinDisableStand
   TX_Black_on_Cyan,                            // cSpinDisableFocus
   TX_Black_on_Cyan,                            // cSpinSeparatStand
   TX_Black_on_Cyan,                            // cSpinSeparatFocus
   TX_Black_on_Cyan,                            // cSpinIndcStand
   TX_White_on_Blue,                            // cSpinIndcFocus
   TX_Black_on_White,                           // cPushTextStand
   TX_Black_on_Cyan,                            // cPushTextFocus
   TX_Black_on_White,                           // cRadioValueStand
   TX_Lwhite_on_Cyan,                           // cRadioValueFocus
   TX_Black_on_White,                           // cRadioTextStand
   TX_Black_on_White,                           // cRadioTextFocus
   TX_Black_on_White,                           // cCheckValueStand
   TX_Lwhite_on_Cyan,                           // cCheckValueFocus
   TX_Black_on_White,                           // cCheckTextStand
   TX_Black_on_White,                           // cCheckTextFocus
   TX_Black_on_Cyan,                            // cDlgEfTextStand
   TX_Lwhite_on_Cyan,                           // cDlgEfTextFocus
   TX_White_on_Black,                           // cEntryTextStand
   TX_White_on_Black,                           // cEntryTextFocus
   TX_Black_on_Black,                           // cEntryHistStand
   TX_White_on_Black,                           // cEntryHistFocus
   TX_White_on_Black,                           // cEntrBorder_top
   TX_White_on_Black,                           // cEntrBorder_trc
   TX_White_on_Black,                           // cEntrBorder_rgt
   TX_White_on_Black,                           // cEntrBorder_brc
   TX_White_on_Black,                           // cEntrBorder_bot
   TX_White_on_Black,                           // cEntrBorder_blc
   TX_White_on_Black,                           // cEntrBorder_lft
   TX_White_on_Black,                           // cEntrBorder_tlc
   TX_Lcyan_on_Blue,                            // cEntrTitleStand
   TX_Black_on_Cyan,                            // cEntrTitleFocus
   TX_Lcyan_on_Blue,                            // cEntrFooterStand
   TX_Black_on_Cyan,                            // cEntrFooterFocus
   TX_Lcyan_on_Blue,                            // cHexEdAscBracket
   TX_Cyan_on_Blue,                             // cHexEdRelPosPrev
   TX_Lcyan_on_Blue,                            // cHexEdRelPosCurr
   TX_Cyan_on_Blue,                             // cHexEdRelPosNext
   TX_Green_on_Blue,                            // cHexEdAbsBytePos
   TX_Green_on_White,                           // cHexEdAbsByteCur
   TX_Cyan_on_White,                            // cHexEdRelCursorP
   TX_Black_on_Cyan,                            // cHexEdButtonText
   TX_White_on_Cyan,                            // cHexEdButBracket
   TX_Black_on_White,                           // cHexEdByteNumber
   TX_White_on_Magenta,                         // cHexEdItemSnText
   TX_Yellow_on_Magenta,                        // cHexEdItemHlight
   TX_Red_on_White,                             // cHexEdModifyText
   TX_Lcyan_on_Blue,                            // c1NomarkActiveOrgStd
   TX_Lcyan_on_Green,                           // c1NomarkActiveOrgCur
   TX_Yellow_on_Blue,                           // c1NomarkActiveModStd
   TX_Yellow_on_Green,                          // c1NomarkActiveModCur
   TX_Cyan_on_Blue,                             // c1NomarkDimmedOrgStd
   TX_White_on_Green,                           // c1NomarkDimmedOrgCur
   TX_White_on_Blue,                            // c1NomarkDimmedModStd
   TX_Yellow_on_Green,                          // c1NomarkDimmedModCur
   TX_Lcyan_on_Magenta,                         // c1MarkedActiveOrgStd
   TX_White_on_Green,                           // c1MarkedActiveOrgCur
   TX_Yellow_on_Magenta,                        // c1MarkedActiveModStd
   TX_Yellow_on_Green,                          // c1MarkedActiveModCur
   TX_Cyan_on_Magenta,                          // c1MarkedDimmedOrgStd
   TX_Lcyan_on_Green,                           // c1MarkedDimmedOrgCur
   TX_White_on_Blue,                            // c1MarkedDimmedModStd
   TX_Yellow_on_Green,                          // c1MarkedDimmedModCur
   TX_Lgreen_on_Blue,                           // c2NomarkActiveOrgStd
   TX_Lwhite_on_Green,                          // c2NomarkActiveOrgCur
   TX_Yellow_on_Blue,                           // c2NomarkActiveModStd
   TX_Yellow_on_Green,                          // c2NomarkActiveModCur
   TX_Green_on_Blue,                            // c2NomarkDimmedOrgStd
   TX_White_on_Green,                           // c2NomarkDimmedOrgCur
   TX_White_on_Blue,                            // c2NomarkDimmedModStd
   TX_Yellow_on_Green,                          // c2NomarkDimmedModCur
};

//- Commander scheme with a 3D-look in Cyan/Black menus and Blue/White Windows
static TXW_COLORMAP    txwcm_3c =
{
   0,                                           // cSchemeColor
   TX_Black_on_White,                           // cWinClientClr
   TX_Red_on_White,                             // cWinClientErr
   TX_Cyan_on_White,                            // cWinBorder_top
   TX_Cyan_on_White,                            // cWinBorder_trc
   TX_Black_on_White,                           // cWinBorder_rgt
   TX_Black_on_White,                           // cWinBorder_brc
   TX_Black_on_White,                           // cWinBorder_bot
   TX_Cyan_on_White,                            // cWinBorder_blc
   TX_Cyan_on_White,                            // cWinBorder_lft
   TX_Cyan_on_White,                            // cWinBorder_tlc
   TX_Black_on_White,                           // cWinTitleStand
   TX_Blue_on_White,                            // cWinTitleFocus
   TX_Black_on_White,                           // cWinFooterStand
   TX_Magenta_on_White,                         // cWinFooterFocus
   TX_Cyan_on_White,                            // cDlgBorder_top
   TX_Cyan_on_White,                            // cDlgBorder_trc
   TX_Black_on_White,                           // cDlgBorder_rgt
   TX_Black_on_White,                           // cDlgBorder_brc
   TX_Black_on_White,                           // cDlgBorder_bot
   TX_Cyan_on_White,                            // cDlgBorder_blc
   TX_Cyan_on_White,                            // cDlgBorder_lft
   TX_Cyan_on_White,                            // cDlgBorder_tlc
   TX_Black_on_White,                           // cDlgTitleStand
   TX_Black_on_White,                           // cDlgTitleFocus
   TX_Black_on_White,                           // cDlgFooterStand
   TX_Black_on_White,                           // cDlgFooterFocus
   TX_White_on_Cyan,                            // cPushBorder_top
   TX_White_on_Cyan,                            // cPushBorder_trc
   TX_Black_on_Cyan,                            // cPushBorder_rgt
   TX_Black_on_Cyan,                            // cPushBorder_brc
   TX_Black_on_Cyan,                            // cPushBorder_bot
   TX_White_on_Cyan,                            // cPushBorder_blc
   TX_White_on_Cyan,                            // cPushBorder_lft
   TX_White_on_Cyan,                            // cPushBorder_tlc
   TX_Black_on_Cyan,                            // cPushTitleStand
   TX_White_on_Cyan,                            // cPushTitleFocus
   TX_Black_on_White,                           // cPushFooterStand
   TX_Black_on_Cyan,                            // cPushFooterFocus
   TX_Cyan_on_White,                            // cViewBorder_top
   TX_Cyan_on_White,                            // cViewBorder_trc
   TX_Black_on_White,                           // cViewBorder_rgt
   TX_Black_on_White,                           // cViewBorder_brc
   TX_Black_on_White,                           // cViewBorder_bot
   TX_Cyan_on_White,                            // cViewBorder_blc
   TX_Cyan_on_White,                            // cViewBorder_lft
   TX_Cyan_on_White,                            // cViewBorder_tlc
   TX_Black_on_White,                           // cViewTitleStand
   TX_Blue_on_White,                            // cViewTitleFocus
   TX_Black_on_White,                           // cViewFooterStand
   TX_Magenta_on_White,                         // cViewFooterFocus
   TX_Cyan_on_Blue,                             // cSbvBorder_top
   TX_Cyan_on_Blue,                             // cSbvBorder_trc (or blank)
   TX_Lcyan_on_Blue,                            // cSbvBorder_rgt
   TX_Lcyan_on_Blue,                            // cSbvBorder_brc
   TX_Lcyan_on_Blue,                            // cSbvBorder_bot
   TX_Cyan_on_Blue,                             // cSbvBorder_blc (or blank)
   TX_Cyan_on_Blue,                             // cSbvBorder_lft
   TX_Cyan_on_Blue,                             // cSbvBorder_tlc
   TX_Lcyan_on_Blue,                            // cSbvTitleStand
   TX_Black_on_Cyan,                            // cSbvTitleFocus
   TX_Lcyan_on_Blue,                            // cSbvFooterStand
   TX_Lcyan_on_Blue,                            // cSbvFooterFocus
   TX_Yellow_on_Blue,                           // cSbvStatusStand
   TX_Yellow_on_Blue,                           // cSbvStatusFocus
   TX_Lgreen_on_Blue,                           // cSbvProgreStand
   TX_Lgreen_on_Blue,                           // cSbvTraceStand
   TX_White_on_Magenta,                         // cSbvMarkedArea
   TX_Lgreen_on_Black,                          // cDskTraceStand
   TX_Lcyan_on_Blue,                            // cDskBorder_top
   TX_Lcyan_on_Blue,                            // cDskBorder_trc (or blank)
   TX_Cyan_on_Blue,                             // cDskBorder_rgt
   TX_Cyan_on_Blue,                             // cDskBorder_brc
   TX_Cyan_on_Blue,                             // cDskBorder_bot
   TX_Lcyan_on_Blue,                            // cDskBorder_blc (or blank)
   TX_Lcyan_on_Blue,                            // cDskBorder_lft
   TX_Lcyan_on_Blue,                            // cDskBorder_tlc
   TX_Lwhite_on_Blue,                           // cDskTitleStand
   TX_Lwhite_on_Blue,                           // cDskTitleFocus
   TX_Black_on_Cyan,                            // cDskFooterStand
   TX_Black_on_Cyan,                            // cDskFooterFocus
   TX_Black_on_White,                           // cLineTextStand
   TX_Black_on_White,                           // cLineTextNr0
   TX_Blue_on_White,                            // cLineTextNr1
   TX_Green_on_White,                           // cLineTextNr2
   TX_Cyan_on_White,                            // cLineTextNr3
   TX_Black_on_White,                           // cHelpTextStand
   TX_Black_on_White,                           // cHelpTextHelp
   TX_Black_on_White,                           // cViewTextStand
   TX_White_on_Magenta,                         // cViewTextMark
   TX_Blue_on_White,                            // cViewTextNr1
   TX_Green_on_White,                           // cViewTextNr2
   TX_Cyan_on_White,                            // cViewTextNr3
   TX_Lwhite_on_Cyan,                           // cListTextStand
   TX_Lwhite_on_Black,                          // cListTextFocus
   TX_Blue_on_Cyan,                             // cListTxt1Stand
   TX_Lwhite_on_Black,                          // cListTxt1Focus
   TX_Green_on_Cyan,                            // cListTxt2Stand
   TX_Lwhite_on_Black,                          // cListTxt2Focus
   TX_Lcyan_on_Cyan,                            // cListTxt3Stand
   TX_Lwhite_on_Black,                          // cListTxt3Focus
   TX_Red_on_Cyan,                              // cListSelectStand
   TX_White_on_Black,                           // cListSelectFocus
   TX_Lwhite_on_Cyan,                           // cListMarkStand
   TX_Lwhite_on_Black,                          // cListMarkFocus
   TX_White_on_Cyan,                            // cListDisableStand
   TX_White_on_Black,                           // cListDisableFocus
   TX_Black_on_Cyan,                            // cListSeparatStand
   TX_White_on_Black,                           // cListSeparatFocus
   TX_White_on_Cyan,                            // cListCountStand
   TX_Magenta_on_Cyan,                          // cListCountFocus
   TX_Lcyan_on_Blue,                            // cFileTextStand
   TX_Black_on_Green,                           // cFileTextFocus
   TX_Lgreen_on_Blue,                           // cFileTxt1Stand
   TX_Black_on_Green,                           // cFileTxt1Focus
   TX_Grey_on_Blue,                             // cFileTxt2Stand
   TX_Black_on_Green,                           // cFileTxt2Focus
   TX_Lcyan_on_Blue,                            // cFileTxt3Stand
   TX_Black_on_Green,                           // cFileTxt3Focus
   TX_Lgreen_on_Blue,                           // cFileSelectStand
   TX_Black_on_Green,                           // cFileSelectFocus
   TX_Yellow_on_Blue,                           // cFileMarkStand     (DIR/Browser mark line/area)
   TX_Yellow_on_Green,                          // cFileMarkFocus     (DIR/Browser cursor line)
   TX_Grey_on_Black,                            // cFileDisableStand
   TX_Cyan_on_Blue,                             // cFileDisableFocus         (mbar)
   TX_Lgreen_on_Blue,                           // cFileSeparatStand
   TX_Black_on_Green,                           // cFileSeparatFocus
   TX_Lcyan_on_Blue,                            // cFileCountStand
   TX_Yellow_on_Blue,                           // cFileCountFocus
   TX_Lcyan_on_Blue,                            // cFileBorder_top
   TX_Blue_on_Blue,                             // cFileBorder_trc
   TX_Cyan_on_Blue,                             // cFileBorder_rgt
   TX_Cyan_on_Blue,                             // cFileBorder_brc
   TX_Cyan_on_Blue,                             // cFileBorder_bot
   TX_Blue_on_Blue,                             // cFileBorder_blc
   TX_Lcyan_on_Blue,                            // cFileBorder_lft
   TX_Lcyan_on_Blue,                            // cFileBorder_tlc
   TX_Black_on_Cyan,                            // cFileTitleStand
   TX_Lwhite_on_Cyan,                           // cFileTitleFocus
   TX_Black_on_Cyan,                            // cFileFooterStand
   TX_White_on_Cyan,                            // cFileFooterFocus
   TX_Lwhite_on_Cyan,                           // cMenuTextStand
   TX_Lwhite_on_Black,                          // cMenuTextFocus
   TX_Blue_on_Cyan,                             // cMenuTxt1Stand
   TX_Lwhite_on_Black,                          // cMenuTxt1Focus
   TX_Green_on_Cyan,                            // cMenuTxt2Stand
   TX_Lwhite_on_Black,                          // cMenuTxt2Focus
   TX_White_on_Cyan,                            // cMenuTxt3Stand
   TX_Lwhite_on_Black,                          // cMenuTxt3Focus
   TX_Red_on_Cyan,                              // cMenuSelectStand
   TX_White_on_Black,                           // cMenuSelectFocus
   TX_Lwhite_on_Cyan,                           // cMenuMarkStand
   TX_Lwhite_on_Black,                          // cMenuMarkFocus
   TX_White_on_Cyan,                            // cMenuDisableStand
   TX_White_on_Black,                           // cMenuDisableFocus
   TX_Black_on_Cyan,                            // cMenuSeparatStand
   TX_White_on_Black,                           // cMenuSeparatFocus
   TX_White_on_Cyan,                            // cMenuBorder_top
   TX_White_on_Cyan,                            // cMenuBorder_trc
   TX_Black_on_Cyan,                            // cMenuBorder_rgt
   TX_Black_on_Cyan,                            // cMenuBorder_brc
   TX_Black_on_Cyan,                            // cMenuBorder_bot
   TX_White_on_Cyan,                            // cMenuBorder_blc
   TX_White_on_Cyan,                            // cMenuBorder_lft
   TX_White_on_Cyan,                            // cMenuBorder_tlc
   TX_Black_on_Cyan,                            // cMbarBorder_top
   TX_Black_on_Cyan,                            // cMbarBorder_trc
   TX_Black_on_Cyan,                            // cMbarBorder_rgt
   TX_Black_on_Cyan,                            // cMbarBorder_brc
   TX_Black_on_Cyan,                            // cMbarBorder_bot
   TX_Black_on_Cyan,                            // cMbarBorder_blc
   TX_Black_on_Cyan,                            // cMbarBorder_lft
   TX_Black_on_Cyan,                            // cMbarBorder_tlc
   TX_Black_on_Cyan,                            // cMbarTextStand
   TX_Black_on_Cyan,                            // cMbarTextFocus
   TX_Black_on_Cyan,                            // cMbarHeadStand
   TX_Lwhite_on_Black,                          // cMbarHeadFocus
   TX_Black_on_Cyan,                            // cSpinTextStand
   TX_Lwhite_on_Cyan,                           // cSpinTextFocus
   TX_Red_on_Cyan,                              // cSpinSelectStand
   TX_White_on_Black,                           // cSpinSelectFocus
   TX_Black_on_Cyan,                            // cSpinMarkStand
   TX_Black_on_Cyan,                            // cSpinMarkFocus
   TX_Black_on_Cyan,                            // cSpinDisableStand
   TX_Black_on_Cyan,                            // cSpinDisableFocus
   TX_Black_on_Cyan,                            // cSpinSeparatStand
   TX_Black_on_Cyan,                            // cSpinSeparatFocus
   TX_Black_on_Cyan,                            // cSpinIndcStand
   TX_White_on_Blue,                            // cSpinIndcFocus
   TX_Black_on_Cyan,                            // cPushTextStand
   TX_White_on_Cyan,                            // cPushTextFocus
   TX_Black_on_White,                           // cRadioValueStand
   TX_Lwhite_on_Cyan,                           // cRadioValueFocus
   TX_Black_on_White,                           // cRadioTextStand
   TX_Black_on_White,                           // cRadioTextFocus
   TX_Black_on_White,                           // cCheckValueStand
   TX_Lwhite_on_Cyan,                           // cCheckValueFocus
   TX_Black_on_White,                           // cCheckTextStand
   TX_Black_on_White,                           // cCheckTextFocus
   TX_Black_on_Cyan,                            // cDlgEfTextStand
   TX_Lwhite_on_Cyan,                           // cDlgEfTextFocus
   TX_White_on_Black,                           // cEntryTextStand
   TX_White_on_Black,                           // cEntryTextFocus
   TX_Black_on_Black,                           // cEntryHistStand
   TX_White_on_Black,                           // cEntryHistFocus
   TX_White_on_Black,                           // cEntrBorder_top
   TX_White_on_Black,                           // cEntrBorder_trc
   TX_White_on_Black,                           // cEntrBorder_rgt
   TX_White_on_Black,                           // cEntrBorder_brc
   TX_White_on_Black,                           // cEntrBorder_bot
   TX_White_on_Black,                           // cEntrBorder_blc
   TX_White_on_Black,                           // cEntrBorder_lft
   TX_White_on_Black,                           // cEntrBorder_tlc
   TX_Lcyan_on_Blue,                            // cEntrTitleStand
   TX_Black_on_Cyan,                            // cEntrTitleFocus
   TX_Lcyan_on_Blue,                            // cEntrFooterStand
   TX_Black_on_Cyan,                            // cEntrFooterFocus
   TX_Lcyan_on_Blue,                            // cHexEdAscBracket
   TX_Brown_on_Blue,                            // cHexEdRelPosPrev
   TX_Lgreen_on_Blue,                           // cHexEdRelPosCurr
   TX_Cyan_on_Blue,                             // cHexEdRelPosNext
   TX_Green_on_Blue,                            // cHexEdAbsBytePos
   TX_Green_on_White,                           // cHexEdAbsByteCur
   TX_Green_on_White,                           // cHexEdRelCursorP
   TX_Black_on_Cyan,                            // cHexEdButtonText
   TX_White_on_Cyan,                            // cHexEdButBracket
   TX_Black_on_White,                           // cHexEdByteNumber
   TX_White_on_Magenta,                         // cHexEdItemSnText
   TX_Lwhite_on_Magenta,                        // cHexEdItemHlight
   TX_Red_on_White,                             // cHexEdModifyText
   TX_Lcyan_on_Blue,                            // c1NomarkActiveOrgStd
   TX_Lcyan_on_Green,                           // c1NomarkActiveOrgCur
   TX_Yellow_on_Blue,                           // c1NomarkActiveModStd
   TX_Yellow_on_Green,                          // c1NomarkActiveModCur
   TX_Cyan_on_Blue,                             // c1NomarkDimmedOrgStd
   TX_White_on_Green,                           // c1NomarkDimmedOrgCur
   TX_White_on_Blue,                            // c1NomarkDimmedModStd
   TX_Yellow_on_Green,                          // c1NomarkDimmedModCur
   TX_Lcyan_on_Magenta,                         // c1MarkedActiveOrgStd
   TX_White_on_Green,                           // c1MarkedActiveOrgCur
   TX_Yellow_on_Magenta,                        // c1MarkedActiveModStd
   TX_Yellow_on_Green,                          // c1MarkedActiveModCur
   TX_Cyan_on_Magenta,                          // c1MarkedDimmedOrgStd
   TX_Lcyan_on_Green,                           // c1MarkedDimmedOrgCur
   TX_White_on_Blue,                            // c1MarkedDimmedModStd
   TX_Yellow_on_Green,                          // c1MarkedDimmedModCur
   TX_Lgreen_on_Blue,                           // c2NomarkActiveOrgStd
   TX_Lwhite_on_Green,                          // c2NomarkActiveOrgCur
   TX_Yellow_on_Blue,                           // c2NomarkActiveModStd
   TX_Yellow_on_Green,                          // c2NomarkActiveModCur
   TX_Green_on_Blue,                            // c2NomarkDimmedOrgStd
   TX_White_on_Green,                           // c2NomarkDimmedOrgCur
   TX_White_on_Blue,                            // c2NomarkDimmedModStd
   TX_Yellow_on_Green,                          // c2NomarkDimmedModCur
};

//- Classic color scheme, very close to the original fixed scheme used by DFSee
static TXW_COLORMAP    txwcm_st =
{
   0,                                           // cSchemeColor
   TX_Black_on_White,                           // cWinClientClr
   TX_Red_on_White,                             // cWinClientErr
   TX_White_on_Cyan,                            // cWinBorder_top
   TX_White_on_Cyan,                            // cWinBorder_trc
   TX_White_on_Cyan,                            // cWinBorder_rgt
   TX_White_on_Cyan,                            // cWinBorder_brc
   TX_White_on_Cyan,                            // cWinBorder_bot
   TX_White_on_Cyan,                            // cWinBorder_blc
   TX_White_on_Cyan,                            // cWinBorder_lft
   TX_White_on_Cyan,                            // cWinBorder_tlc
   TX_Yellow_on_Cyan,                           // cWinTitleStand
   TX_Lwhite_on_Magenta,                        // cWinTitleFocus
   TX_Cyan_on_Cyan,                             // cWinFooterStand
   TX_Yellow_on_Blue,                           // cWinFooterFocus
   TX_Black_on_White,                           // cDlgBorder_top
   TX_Black_on_White,                           // cDlgBorder_trc
   TX_Black_on_White,                           // cDlgBorder_rgt
   TX_Black_on_White,                           // cDlgBorder_brc
   TX_Black_on_White,                           // cDlgBorder_bot
   TX_Black_on_White,                           // cDlgBorder_blc
   TX_Black_on_White,                           // cDlgBorder_lft
   TX_Black_on_White,                           // cDlgBorder_tlc
   TX_Black_on_White,                           // cDlgTitleStand
   TX_Black_on_White,                           // cDlgTitleFocus
   TX_Black_on_White,                           // cDlgFooterStand
   TX_Black_on_White,                           // cDlgFooterFocus
   TX_Yellow_on_Grey,                           // cPushBorder_top
   TX_Yellow_on_Grey,                           // cPushBorder_trc
   TX_Yellow_on_Grey,                           // cPushBorder_rgt
   TX_Yellow_on_Grey,                           // cPushBorder_brc
   TX_Yellow_on_Grey,                           // cPushBorder_bot
   TX_Yellow_on_Grey,                           // cPushBorder_blc
   TX_Yellow_on_Grey,                           // cPushBorder_lft
   TX_Yellow_on_Grey,                           // cPushBorder_tlc
   TX_Yellow_on_Cyan,                           // cPushTitleStand
   TX_Lwhite_on_Magenta,                        // cPushTitleFocus
   TX_Cyan_on_Cyan,                             // cPushFooterStand
   TX_Yellow_on_Blue,                           // cPushFooterFocus
   TX_White_on_Cyan,                            // cViewBorder_top
   TX_White_on_Cyan,                            // cViewBorder_trc
   TX_White_on_Cyan,                            // cViewBorder_rgt
   TX_White_on_Cyan,                            // cViewBorder_brc
   TX_White_on_Cyan,                            // cViewBorder_bot
   TX_White_on_Cyan,                            // cViewBorder_blc
   TX_White_on_Cyan,                            // cViewBorder_lft
   TX_White_on_Cyan,                            // cViewBorder_tlc
   TX_Yellow_on_Cyan,                           // cViewTitleStand
   TX_Lwhite_on_Magenta,                        // cViewTitleFocus
   TX_Cyan_on_Cyan,                             // cViewFooterStand
   TX_Yellow_on_Blue,                           // cViewFooterFocus
   TX_White_on_Cyan,                            // cSbvBorder_top
   TX_White_on_Cyan,                            // cSbvBorder_trc
   TX_White_on_Cyan,                            // cSbvBorder_rgt
   TX_White_on_Cyan,                            // cSbvBorder_brc
   TX_White_on_Cyan,                            // cSbvBorder_bot
   TX_White_on_Cyan,                            // cSbvBorder_blc
   TX_White_on_Cyan,                            // cSbvBorder_lft
   TX_White_on_Cyan,                            // cSbvBorder_tlc
   TX_Yellow_on_Cyan,                           // cSbvTitleStand
   TX_Lwhite_on_Magenta,                        // cSbvTitleFocus
   TX_White_on_Cyan,                            // cSbvFooterStand
   TX_White_on_Cyan,                            // cSbvFooterFocus
   TX_Yellow_on_Cyan,                           // cSbvStatusStand
   TX_Yellow_on_Cyan,                           // cSbvStatusFocus
   TX_Lwhite_on_Cyan,                           // cSbvProgreStand
   TX_Lgreen_on_Cyan,                           // cSbvTraceStand
   TX_White_on_Magenta,                         // cSbvMarkedArea
   TX_Lgreen_on_Cyan,                           // cDskTraceStand
   TX_White_on_Cyan,                            // cDskBorder_top
   TX_White_on_Cyan,                            // cDskBorder_trc
   TX_White_on_Cyan,                            // cDskBorder_rgt
   TX_White_on_Cyan,                            // cDskBorder_brc
   TX_White_on_Cyan,                            // cDskBorder_bot
   TX_White_on_Cyan,                            // cDskBorder_blc
   TX_White_on_Cyan,                            // cDskBorder_lft
   TX_White_on_Cyan,                            // cDskBorder_tlc
   TX_Lwhite_on_Cyan,                           // cDskTitleStand
   TX_Lwhite_on_Cyan,                           // cDskTitleFocus
   TX_White_on_Blue,                            // cDskFooterStand
   TX_White_on_Blue,                            // cDskFooterFocus
   TX_Black_on_White,                           // cLineTextStand
   TX_Black_on_White,                           // cLineTextNr0
   TX_Blue_on_White,                            // cLineTextNr1
   TX_Green_on_White,                           // cLineTextNr2
   TX_Cyan_on_White,                            // cLineTextNr3
   TX_Black_on_White,                           // cHelpTextStand
   TX_Black_on_White,                           // cHelpTextHelp
   TX_Black_on_White,                           // cViewTextStand
   TX_White_on_Magenta,                         // cViewTextMark
   TX_Blue_on_White,                            // cViewTextNr1
   TX_Green_on_White,                           // cViewTextNr2
   TX_Cyan_on_White,                            // cViewTextNr3
   TX_Black_on_White,                           // cListTextStand
   TX_Green_on_Black,                           // cListTextFocus
   TX_Blue_on_White,                            // cListTxt1Stand
   TX_Lgreen_on_Black,                          // cListTxt1Focus
   TX_Green_on_White,                           // cListTxt2Stand
   TX_Lgreen_on_Black,                          // cListTxt2Focus
   TX_Grey_on_White,                            // cListTxt3Stand
   TX_Lgreen_on_Black,                          // cListTxt3Focus
   TX_Green_on_White,                           // cListSelectStand
   TX_Lgreen_on_Black,                          // cListSelectFocus
   TX_Magenta_on_White,                         // cListMarkStand
   TX_Lmagenta_on_Black,                        // cListMarkFocus
   TX_Lwhite_on_White,                          // cListDisableStand
   TX_White_on_Blue,                            // cListDisableFocus
   TX_Black_on_White,                           // cListSeparatStand
   TX_Green_on_Black,                           // cListSeparatFocus
   TX_White_on_Cyan,                            // cListCountStand
   TX_Yellow_on_Cyan,                           // cListCountFocus
   TX_Black_on_White,                           // cFileTextStand
   TX_Green_on_Black,                           // cFileTextFocus
   TX_Blue_on_White,                            // cFileTxt1Stand
   TX_Yellow_on_Black,                          // cFileTxt1Focus
   TX_Green_on_White,                           // cFileTxt2Stand
   TX_Yellow_on_Black,                          // cFileTxt2Focus
   TX_Grey_on_White,                            // cFileTxt3Stand
   TX_Yellow_on_Black,                          // cFileTxt3Focus
   TX_Black_on_White,                           // cFileSelectStand
   TX_Green_on_Black,                           // cFileSelectFocus
   TX_Magenta_on_White,                         // cFileMarkStand     (DIR/Browser mark line/area)
   TX_Lmagenta_on_Black,                        // cFileMarkFocus     (DIR/Browser cursor line)
   TX_Lwhite_on_White,                          // cFileDisableStand
   TX_White_on_Blue,                            // cFileDisableFocus
   TX_Black_on_White,                           // cFileSeparatStand
   TX_Green_on_Black,                           // cFileSeparatFocus
   TX_White_on_Cyan,                            // cFileCountStand
   TX_Yellow_on_Cyan,                           // cFileCountFocus
   TX_White_on_Cyan,                            // cFileBorder_top
   TX_White_on_Cyan,                            // cFileBorder_trc
   TX_White_on_Cyan,                            // cFileBorder_rgt
   TX_White_on_Cyan,                            // cFileBorder_brc
   TX_White_on_Cyan,                            // cFileBorder_bot
   TX_White_on_Cyan,                            // cFileBorder_blc
   TX_White_on_Cyan,                            // cFileBorder_lft
   TX_White_on_Cyan,                            // cFileBorder_tlc
   TX_Yellow_on_Cyan,                           // cFileTitleStand
   TX_Lwhite_on_Magenta,                        // cFileTitleFocus
   TX_Cyan_on_Cyan,                             // cFileFooterStand
   TX_Yellow_on_Blue,                           // cFileFooterFocus
   TX_White_on_Grey,                            // cMenuTextStand
   TX_White_on_Blue,                            // cMenuTextFocus
   TX_Blue_on_Grey,                             // cMenuTxt1Stand
   TX_White_on_Blue,                            // cMenuTxt1Focus
   TX_Green_on_Grey,                            // cMenuTxt2Stand
   TX_White_on_Blue,                            // cMenuTxt2Focus
   TX_Cyan_on_Grey,                             // cMenuTxt3Stand
   TX_White_on_Blue,                            // cMenuTxt3Focus
   TX_Yellow_on_Grey,                           // cMenuSelectStand
   TX_Yellow_on_Blue,                           // cMenuSelectFocus
   TX_Black_on_Grey,                            // cMenuMarkStand
   TX_Cyan_on_Blue,                             // cMenuMarkFocus            (mbar)
   TX_Black_on_Grey,                            // cMenuDisableStand
   TX_Cyan_on_Blue,                             // cMenuDisableFocus         (mbar)
   TX_White_on_Grey,                            // cMenuSeparatStand
   TX_White_on_Blue,                            // cMenuSeparatFocus
   TX_White_on_Cyan,                            // cMenuBorder_top
   TX_White_on_Cyan,                            // cMenuBorder_trc
   TX_White_on_Cyan,                            // cMenuBorder_rgt
   TX_White_on_Cyan,                            // cMenuBorder_brc
   TX_White_on_Cyan,                            // cMenuBorder_bot
   TX_White_on_Cyan,                            // cMenuBorder_blc
   TX_White_on_Cyan,                            // cMenuBorder_lft
   TX_White_on_Cyan,                            // cMenuBorder_tlc
   TX_White_on_Grey,                            // cMbarBorder_top
   TX_White_on_Grey,                            // cMbarBorder_trc
   TX_White_on_Grey,                            // cMbarBorder_rgt
   TX_White_on_Grey,                            // cMbarBorder_brc
   TX_White_on_Grey,                            // cMbarBorder_bot
   TX_White_on_Grey,                            // cMbarBorder_blc
   TX_White_on_Grey,                            // cMbarBorder_lft
   TX_White_on_Grey,                            // cMbarBorder_tlc
   TX_White_on_Grey,                            // cMbarTextStand
   TX_White_on_Grey,                            // cMbarTextFocus
   TX_Yellow_on_Grey,                           // cMbarHeadStand
   TX_Lwhite_on_Magenta,                        // cMbarHeadFocus
   TX_White_on_Grey,                            // cSpinTextStand
   TX_Lwhite_on_Grey,                           // cSpinTextFocus
   TX_Yellow_on_Grey,                           // cSpinSelectStand
   TX_Yellow_on_Grey,                           // cSpinSelectFocus
   TX_Black_on_Grey,                            // cSpinMarkStand
   TX_Black_on_Grey,                            // cSpinMarkFocus
   TX_Black_on_Grey,                            // cSpinDisableStand
   TX_Black_on_Grey,                            // cSpinDisableFocus
   TX_White_on_Grey,                            // cSpinSeparatStand
   TX_White_on_Grey,                            // cSpinSeparatFocus
   TX_Black_on_Grey,                            // cSpinIndcStand
   TX_White_on_Blue,                            // cSpinIndcFocus
   TX_Lwhite_on_Grey,                           // cPushTextStand
   TX_Yellow_on_Grey,                           // cPushTextFocus
   TX_Black_on_White,                           // cRadioValueStand
   TX_Lwhite_on_Green,                          // cRadioValueFocus
   TX_Black_on_White,                           // cRadioTextStand
   TX_Black_on_White,                           // cRadioTextFocus
   TX_Black_on_White,                           // cCheckValueStand
   TX_Lwhite_on_Green,                          // cCheckValueFocus
   TX_Black_on_White,                           // cCheckTextStand
   TX_Black_on_White,                           // cCheckTextFocus
   TX_Yellow_on_Green,                          // cDlgEfTextStand
   TX_Lwhite_on_Green,                          // cDlgEfTextFocus
   TX_Yellow_on_Green,                          // cEntryTextStand
   TX_Yellow_on_Green,                          // cEntryTextFocus
   TX_Green_on_Green,                           // cEntryHistStand
   TX_White_on_Green,                           // cEntryHistFocus
   TX_White_on_Green,                           // cEntrBorder_top
   TX_White_on_Green,                           // cEntrBorder_trc
   TX_White_on_Green,                           // cEntrBorder_rgt
   TX_White_on_Green,                           // cEntrBorder_brc
   TX_White_on_Green,                           // cEntrBorder_bot
   TX_White_on_Green,                           // cEntrBorder_blc
   TX_White_on_Green,                           // cEntrBorder_lft
   TX_White_on_Green,                           // cEntrBorder_tlc
   TX_White_on_Green,                           // cEntrTitleStand
   TX_Lwhite_on_Magenta,                        // cEntrTitleFocus
   TX_White_on_Green,                           // cEntrFooterStand
   TX_White_on_Blue,                            // cEntrFooterFocus
   TX_Lcyan_on_Blue,                            // cHexEdAscBracket
   TX_Brown_on_Blue,                            // cHexEdRelPosPrev
   TX_Lgreen_on_Blue,                           // cHexEdRelPosCurr
   TX_Cyan_on_Blue,                             // cHexEdRelPosNext
   TX_Green_on_Blue,                            // cHexEdAbsBytePos
   TX_Green_on_White,                           // cHexEdAbsByteCur
   TX_Green_on_White,                           // cHexEdRelCursorP
   TX_Yellow_on_Grey,                           // cHexEdButtonText
   TX_White_on_Grey,                            // cHexEdButBracket
   TX_Grey_on_White,                            // cHexEdByteNumber
   TX_White_on_Magenta,                         // cHexEdItemSnText
   TX_Lwhite_on_Magenta,                        // cHexEdItemHlight
   TX_Red_on_White,                             // cHexEdModifyText
   TX_White_on_Blue,                            // c1NomarkActiveOrgStd
   TX_Lwhite_on_Green,                          // c1NomarkActiveOrgCur
   TX_Yellow_on_Blue,                           // c1NomarkActiveModStd
   TX_Yellow_on_Green,                          // c1NomarkActiveModCur
   TX_Grey_on_Blue,                             // c1NomarkDimmedOrgStd
   TX_White_on_Green,                           // c1NomarkDimmedOrgCur
   TX_Brown_on_Blue,                            // c1NomarkDimmedModStd
   TX_Brown_on_Green,                           // c1NomarkDimmedModCur
   TX_White_on_Magenta,                         // c1MarkedActiveOrgStd
   TX_Lwhite_on_Green,                          // c1MarkedActiveOrgCur
   TX_Yellow_on_Magenta,                        // c1MarkedActiveModStd
   TX_Yellow_on_Green,                          // c1MarkedActiveModCur
   TX_Grey_on_Magenta,                          // c1MarkedDimmedOrgStd
   TX_White_on_Green,                           // c1MarkedDimmedOrgCur
   TX_Brown_on_Magenta,                         // c1MarkedDimmedModStd
   TX_Yellow_on_Green,                          // c1MarkedDimmedModCur
   TX_Lwhite_on_Blue,                           // c2NomarkActiveOrgStd
   TX_Lwhite_on_Green,                          // c2NomarkActiveOrgCur
   TX_Yellow_on_Blue,                           // c2NomarkActiveModStd
   TX_Yellow_on_Green,                          // c2NomarkActiveModCur
   TX_White_on_Blue,                            // c2NomarkDimmedOrgStd
   TX_White_on_Green,                           // c2NomarkDimmedOrgCur
   TX_Brown_on_Blue,                            // c2NomarkDimmedModStd
   TX_Brown_on_Green,                           // c2NomarkDimmedModCur
};

//- A mainly Black & White scheme with a 3D-look using White menus and Windows
static TXW_COLORMAP    txwcm_3w =
{
   0,                                           // cSchemeColor
   TX_Black_on_White,                           // cWinClientClr
   TX_Black_on_White,                           // cWinClientErr
   TX_Lwhite_on_White,                          // cWinBorder_top
   TX_Lwhite_on_White,                          // cWinBorder_trc
   TX_Black_on_White,                           // cWinBorder_rgt
   TX_Black_on_White,                           // cWinBorder_brc
   TX_Black_on_White,                           // cWinBorder_bot
   TX_Lwhite_on_White,                          // cWinBorder_blc
   TX_Lwhite_on_White,                          // cWinBorder_lft
   TX_Lwhite_on_White,                          // cWinBorder_tlc
   TX_Black_on_White,                           // cWinTitleStand
   TX_Lwhite_on_White,                          // cWinTitleFocus
   TX_Black_on_White,                           // cWinFooterStand
   TX_Lwhite_on_White,                          // cWinFooterFocus
   TX_Lwhite_on_White,                          // cDlgBorder_top
   TX_Lwhite_on_White,                          // cDlgBorder_trc
   TX_Black_on_White,                           // cDlgBorder_rgt
   TX_Black_on_White,                           // cDlgBorder_brc
   TX_Black_on_White,                           // cDlgBorder_bot
   TX_Lwhite_on_White,                          // cDlgBorder_blc
   TX_Lwhite_on_White,                          // cDlgBorder_lft
   TX_Lwhite_on_White,                          // cDlgBorder_tlc
   TX_Black_on_White,                           // cDlgTitleStand
   TX_Lwhite_on_White,                          // cDlgTitleFocus
   TX_Black_on_White,                           // cDlgFooterStand
   TX_Lwhite_on_White,                          // cDlgFooterFocus
   TX_Lwhite_on_White,                          // cPushBorder_top
   TX_Lwhite_on_White,                          // cPushBorder_trc
   TX_Black_on_White,                           // cPushBorder_rgt
   TX_Black_on_White,                           // cPushBorder_brc
   TX_Black_on_White,                           // cPushBorder_bot
   TX_Lwhite_on_White,                          // cPushBorder_blc
   TX_Lwhite_on_White,                          // cPushBorder_lft
   TX_Lwhite_on_White,                          // cPushBorder_tlc
   TX_Black_on_White,                           // cPushTitleStand
   TX_Lwhite_on_White,                          // cPushTitleFocus
   TX_Black_on_White,                           // cPushFooterStand
   TX_Lwhite_on_White,                          // cPushFooterFocus
   TX_Lwhite_on_White,                          // cViewBorder_top
   TX_Lwhite_on_White,                          // cViewBorder_trc
   TX_Black_on_White,                           // cViewBorder_rgt
   TX_Black_on_White,                           // cViewBorder_brc
   TX_Black_on_White,                           // cViewBorder_bot
   TX_Lwhite_on_White,                          // cViewBorder_blc
   TX_Lwhite_on_White,                          // cViewBorder_lft
   TX_Lwhite_on_White,                          // cViewBorder_tlc
   TX_Black_on_White,                           // cViewTitleStand
   TX_Lwhite_on_White,                          // cViewTitleFocus
   TX_Black_on_White,                           // cViewFooterStand
   TX_Lwhite_on_White,                          // cViewFooterFocus
   TX_Black_on_White,                           // cSbvBorder_top
   TX_White_on_White,                           // cSbvBorder_trc (or blank)
   TX_Lwhite_on_White,                          // cSbvBorder_rgt
   TX_Lwhite_on_White,                          // cSbvBorder_brc
   TX_Lwhite_on_White,                          // cSbvBorder_bot
   TX_White_on_White,                           // cSbvBorder_blc (or blank)
   TX_Black_on_White,                           // cSbvBorder_lft
   TX_Black_on_White,                           // cSbvBorder_tlc
   TX_Black_on_White,                           // cSbvTitleStand
   TX_Lwhite_on_White,                          // cSbvTitleFocus
   TX_Black_on_White,                           // cSbvFooterStand
   TX_Black_on_White,                           // cSbvFooterFocus
   TX_Black_on_White,                           // cSbvStatusStand
   TX_Black_on_White,                           // cSbvStatusFocus
   TX_Black_on_White,                           // cSbvProgreStand
   TX_Lwhite_on_Black,                          // cSbvTraceStand
   TX_Black_on_White,                           // cSbvMarkedArea
   TX_Lwhite_on_Black,                          // cDskTraceStand
   TX_Lwhite_on_White,                          // cDskBorder_top
   TX_White_on_White,                           // cDskBorder_trc (or blank)
   TX_Black_on_White,                           // cDskBorder_rgt
   TX_Black_on_White,                           // cDskBorder_brc
   TX_Black_on_White,                           // cDskBorder_bot
   TX_White_on_White,                           // cDskBorder_blc (or blank)
   TX_Lwhite_on_White,                          // cDskBorder_lft
   TX_Lwhite_on_White,                          // cDskBorder_tlc
   TX_Black_on_White,                           // cDskTitleStand
   TX_Lwhite_on_White,                          // cDskTitleFocus
   TX_Black_on_White,                           // cDskFooterStand
   TX_Black_on_White,                           // cDskFooterFocus
   TX_Black_on_White,                           // cLineTextStand
   TX_Black_on_White,                           // cLineTextNr0
   TX_Black_on_White,                           // cLineTextNr1
   TX_Black_on_White,                           // cLineTextNr2
   TX_Black_on_White,                           // cLineTextNr3
   TX_Black_on_White,                           // cHelpTextStand
   TX_Black_on_White,                           // cHelpTextHelp
   TX_Black_on_White,                           // cViewTextStand
   TX_Lwhite_on_Black,                          // cViewTextMark
   TX_Black_on_White,                           // cViewTextNr1
   TX_Black_on_White,                           // cViewTextNr2
   TX_Black_on_White,                           // cViewTextNr3
   TX_Black_on_White,                           // cListTextStand
   TX_White_on_Black,                           // cListTextFocus
   TX_Black_on_White,                           // cListTxt1Stand
   TX_White_on_Black,                           // cListTxt1Focus
   TX_Black_on_White,                           // cListTxt2Stand
   TX_White_on_Black,                           // cListTxt2Focus
   TX_Black_on_White,                           // cListTxt3Stand
   TX_White_on_Black,                           // cListTxt3Focus
   TX_Lwhite_on_Black,                          // cListSelectStand
   TX_Lwhite_on_Black,                          // cListSelectFocus
   TX_Black_on_White,                           // cListMarkStand
   TX_White_on_Black,                           // cListMarkFocus
   TX_Black_on_White,                           // cListDisableStand
   TX_White_on_Black,                           // cListDisableFocus
   TX_Lwhite_on_White,                          // cListSeparatStand
   TX_Lwhite_on_White,                          // cListSeparatFocus
   TX_Lwhite_on_Black,                          // cListCountStand
   TX_Lwhite_on_Black,                          // cListCountFocus
   TX_Black_on_White,                           // cFileTextStand
   TX_White_on_Black,                           // cFileTextFocus
   TX_Black_on_White,                           // cFileTxt1Stand
   TX_White_on_Black,                           // cFileTxt1Focus
   TX_Black_on_White,                           // cFileTxt2Stand
   TX_White_on_Black,                           // cFileTxt2Focus
   TX_Black_on_White,                           // cFileTxt3Stand
   TX_White_on_Black,                           // cFileTxt3Focus
   TX_Black_on_White,                           // cFileSelectStand
   TX_White_on_Black,                           // cFileSelectFocus
   TX_Black_on_White,                           // cFileMarkStand     (DIR/Browser mark line/area)
   TX_White_on_Black,                           // cFileMarkFocus     (DIR/Browser cursor line)
   TX_Black_on_White,                           // cFileDisableStand
   TX_White_on_Black,                           // cFileDisableFocus
   TX_Lwhite_on_White,                          // cFileSeparatStand
   TX_Lwhite_on_White,                          // cFileSeparatFocus
   TX_Lwhite_on_Black,                          // cFileCountStand
   TX_Lwhite_on_Black,                          // cFileCountFocus
   TX_Black_on_White,                           // cFileBorder_top
   TX_White_on_White,                           // cFileBorder_trc
   TX_Lwhite_on_White,                          // cFileBorder_rgt
   TX_Lwhite_on_White,                          // cFileBorder_brc
   TX_Lwhite_on_White,                          // cFileBorder_bot
   TX_White_on_White,                           // cFileBorder_blc
   TX_Black_on_White,                           // cFileBorder_lft
   TX_Black_on_White,                           // cFileBorder_tlc
   TX_White_on_Black,                           // cFileTitleStand
   TX_Lwhite_on_Black,                          // cFileTitleFocus
   TX_White_on_Black,                           // cFileFooterStand
   TX_Lwhite_on_Black,                          // cFileFooterFocus
   TX_Black_on_White,                           // cMenuTextStand
   TX_White_on_Black,                           // cMenuTextFocus
   TX_Black_on_White,                           // cMenuTxt1Stand
   TX_White_on_Black,                           // cMenuTxt1Focus
   TX_Black_on_White,                           // cMenuTxt2Stand
   TX_White_on_Black,                           // cMenuTxt2Focus
   TX_Black_on_White,                           // cMenuTxt3Stand
   TX_White_on_Black,                           // cMenuTxt3Focus
   TX_Lwhite_on_White,                          // cMenuSelectStand
   TX_Lwhite_on_Black,                          // cMenuSelectFocus
   TX_Black_on_White,                           // cMenuMarkStand
   TX_White_on_Black,                           // cMenuMarkFocus
   TX_Black_on_White,                           // cMenuDisableStand
   TX_White_on_Black,                           // cMenuDisableFocus
   TX_Lwhite_on_White,                          // cMenuSeparatStand
   TX_Lwhite_on_White,                          // cMenuSeparatFocus
   TX_Lwhite_on_White,                          // cMenuBorder_top
   TX_Lwhite_on_White,                          // cMenuBorder_trc
   TX_Black_on_White,                           // cMenuBorder_rgt
   TX_Black_on_White,                           // cMenuBorder_brc
   TX_Black_on_White,                           // cMenuBorder_bot
   TX_Lwhite_on_White,                          // cMenuBorder_blc
   TX_Lwhite_on_White,                          // cMenuBorder_lft
   TX_Lwhite_on_White,                          // cMenuBorder_tlc
   TX_Black_on_White,                           // cMbarBorder_top
   TX_Black_on_White,                           // cMbarBorder_trc
   TX_Black_on_White,                           // cMbarBorder_rgt
   TX_Black_on_White,                           // cMbarBorder_brc
   TX_Black_on_White,                           // cMbarBorder_bot
   TX_Black_on_White,                           // cMbarBorder_blc
   TX_Black_on_White,                           // cMbarBorder_lft
   TX_Black_on_White,                           // cMbarBorder_tlc
   TX_Black_on_White,                           // cMbarTextStand
   TX_Black_on_White,                           // cMbarTextFocus
   TX_Black_on_White,                           // cMbarHeadStand
   TX_Lwhite_on_Black,                          // cMbarHeadFocus
   TX_Black_on_White,                           // cSpinTextStand
   TX_White_on_Black,                           // cSpinTextFocus
   TX_Lwhite_on_Black,                          // cSpinSelectStand
   TX_Lwhite_on_Black,                          // cSpinSelectFocus
   TX_Black_on_White,                           // cSpinMarkStand
   TX_White_on_Black,                           // cSpinMarkFocus
   TX_Black_on_White,                           // cSpinDisableStand
   TX_White_on_Black,                           // cSpinDisableFocus
   TX_Lwhite_on_White,                          // cSpinSeparatStand
   TX_Lwhite_on_White,                          // cSpinSeparatFocus
   TX_White_on_Black,                           // cSpinIndcStand
   TX_Black_on_White,                           // cSpinIndcFocus
   TX_Black_on_White,                           // cPushTextStand
   TX_White_on_Black,                           // cPushTextFocus
   TX_Black_on_White,                           // cRadioValueStand
   TX_Black_on_White,                           // cRadioValueFocus
   TX_Black_on_White,                           // cRadioTextStand
   TX_White_on_Black,                           // cRadioTextFocus
   TX_Black_on_White,                           // cCheckValueStand
   TX_Black_on_White,                           // cCheckValueFocus
   TX_Black_on_White,                           // cCheckTextStand
   TX_White_on_Black,                           // cCheckTextFocus
   TX_White_on_Black,                           // cDlgEfTextStand
   TX_Lwhite_on_Black,                          // cDlgEfTextFocus
   TX_White_on_Black,                           // cEntryTextStand
   TX_Lwhite_on_Black,                          // cEntryTextFocus
   TX_Black_on_Black,                           // cEntryHistStand
   TX_White_on_Black,                           // cEntryHistFocus
   TX_Lwhite_on_White,                          // cEntrBorder_top
   TX_Lwhite_on_White,                          // cEntrBorder_trc
   TX_Black_on_White,                           // cEntrBorder_rgt
   TX_Black_on_White,                           // cEntrBorder_brc
   TX_Black_on_White,                           // cEntrBorder_bot
   TX_Lwhite_on_White,                          // cEntrBorder_blc
   TX_Lwhite_on_White,                          // cEntrBorder_lft
   TX_Lwhite_on_White,                          // cEntrBorder_tlc
   TX_White_on_Black,                           // cEntrTitleStand
   TX_Lwhite_on_Black,                          // cEntrTitleFocus
   TX_White_on_Black,                           // cEntrFooterStand
   TX_Lwhite_on_Black,                          // cEntrFooterFocus
   TX_Lwhite_on_White,                          // cHexEdAscBracket
   TX_White_on_Black,                           // cHexEdRelPosPrev
   TX_Lwhite_on_Black,                          // cHexEdRelPosCurr
   TX_White_on_Black,                           // cHexEdRelPosNext
   TX_White_on_Black,                           // cHexEdAbsBytePos
   TX_White_on_Black,                           // cHexEdAbsByteCur
   TX_White_on_Black,                           // cHexEdRelCursorP
   TX_Lwhite_on_Black,                          // cHexEdButtonText
   TX_White_on_Black,                           // cHexEdButBracket
   TX_White_on_Black,                           // cHexEdByteNumber
   TX_White_on_Black,                           // cHexEdItemSnText
   TX_Lwhite_on_Black,                          // cHexEdItemHlight
   TX_Lwhite_on_Black,                          // cHexEdModifyText
   TX_Black_on_White,                           // c1NomarkActiveOrgStd
   TX_White_on_Black,                           // c1NomarkActiveOrgCur
   TX_Lwhite_on_White,                          // c1NomarkActiveModStd
   TX_Lwhite_on_Black,                          // c1NomarkActiveModCur
   TX_Black_on_White,                           // c1NomarkDimmedOrgStd
   TX_White_on_Black,                           // c1NomarkDimmedOrgCur
   TX_Lwhite_on_Black,                          // c1NomarkDimmedModStd
   TX_White_on_Black,                           // c1NomarkDimmedModCur
   TX_Lwhite_on_Black,                          // c1MarkedActiveOrgStd
   TX_Lwhite_on_Black,                          // c1MarkedActiveOrgCur
   TX_Lwhite_on_White,                          // c1MarkedActiveModStd
   TX_Lwhite_on_White,                          // c1MarkedActiveModCur
   TX_Lwhite_on_White,                          // c1MarkedDimmedOrgStd
   TX_Lwhite_on_White,                          // c1MarkedDimmedOrgCur
   TX_Lwhite_on_White,                          // c1MarkedDimmedModStd
   TX_Lwhite_on_White,                          // c1MarkedDimmedModCur
   TX_Black_on_White,                           // c2NomarkActiveOrgStd
   TX_White_on_Black,                           // c2NomarkActiveOrgCur
   TX_Lwhite_on_White,                          // c2NomarkActiveModStd
   TX_Lwhite_on_Black,                          // c2NomarkActiveModCur
   TX_Black_on_White,                           // c2NomarkDimmedOrgStd
   TX_White_on_Black,                           // c2NomarkDimmedOrgCur
   TX_Lwhite_on_Black,                          // c2NomarkDimmedModStd
   TX_White_on_Black,                           // c2NomarkDimmedModCur
};

//- Black & White scheme with Black menus and White Windows, for MONOCHROME use
static TXW_COLORMAP    txwcm_bw =
{
   0,                                           // cSchemeColor
   TX_Black_on_White,                           // cWinClientClr
   TX_Black_on_White,                           // cWinClientErr
   TX_Black_on_White,                           // cWinBorder_top
   TX_Black_on_White,                           // cWinBorder_trc
   TX_Black_on_White,                           // cWinBorder_rgt
   TX_Black_on_White,                           // cWinBorder_brc
   TX_Black_on_White,                           // cWinBorder_bot
   TX_Black_on_White,                           // cWinBorder_blc
   TX_Black_on_White,                           // cWinBorder_lft
   TX_Black_on_White,                           // cWinBorder_tlc
   TX_Black_on_White,                           // cWinTitleStand
   TX_Black_on_White,                           // cWinTitleFocus
   TX_Black_on_White,                           // cWinFooterStand
   TX_Black_on_White,                           // cWinFooterFocus
   TX_Black_on_White,                           // cDlgBorder_top
   TX_Black_on_White,                           // cDlgBorder_trc
   TX_Black_on_White,                           // cDlgBorder_rgt
   TX_Black_on_White,                           // cDlgBorder_brc
   TX_Black_on_White,                           // cDlgBorder_bot
   TX_Black_on_White,                           // cDlgBorder_blc
   TX_Black_on_White,                           // cDlgBorder_lft
   TX_Black_on_White,                           // cDlgBorder_tlc
   TX_Black_on_White,                           // cDlgTitleStand
   TX_Black_on_White,                           // cDlgTitleFocus
   TX_Black_on_White,                           // cDlgFooterStand
   TX_Black_on_White,                           // cDlgFooterFocus
   TX_Black_on_White,                           // cPushBorder_top
   TX_Black_on_White,                           // cPushBorder_trc
   TX_Black_on_White,                           // cPushBorder_rgt
   TX_Black_on_White,                           // cPushBorder_brc
   TX_Black_on_White,                           // cPushBorder_bot
   TX_Black_on_White,                           // cPushBorder_blc
   TX_Black_on_White,                           // cPushBorder_lft
   TX_Black_on_White,                           // cPushBorder_tlc
   TX_Black_on_White,                           // cPushTitleStand
   TX_Black_on_White,                           // cPushTitleFocus
   TX_Black_on_White,                           // cPushFooterStand
   TX_Black_on_White,                           // cPushFooterFocus
   TX_Black_on_White,                           // cViewBorder_top
   TX_Black_on_White,                           // cViewBorder_trc
   TX_Black_on_White,                           // cViewBorder_rgt
   TX_Black_on_White,                           // cViewBorder_brc
   TX_Black_on_White,                           // cViewBorder_bot
   TX_Black_on_White,                           // cViewBorder_blc
   TX_Black_on_White,                           // cViewBorder_lft
   TX_Black_on_White,                           // cViewBorder_tlc
   TX_Black_on_White,                           // cViewTitleStand
   TX_Black_on_White,                           // cViewTitleFocus
   TX_Black_on_White,                           // cViewFooterStand
   TX_Black_on_White,                           // cViewFooterFocus
   TX_Black_on_White,                           // cSbvBorder_top
   TX_Black_on_White,                           // cSbvBorder_trc
   TX_Black_on_White,                           // cSbvBorder_rgt
   TX_Black_on_White,                           // cSbvBorder_brc
   TX_Black_on_White,                           // cSbvBorder_bot
   TX_Black_on_White,                           // cSbvBorder_blc
   TX_Black_on_White,                           // cSbvBorder_lft
   TX_Black_on_White,                           // cSbvBorder_tlc
   TX_Black_on_White,                           // cSbvTitleStand
   TX_Black_on_White,                           // cSbvTitleFocus
   TX_Black_on_White,                           // cSbvFooterStand
   TX_Black_on_White,                           // cSbvFooterFocus
   TX_Black_on_White,                           // cSbvStatusStand
   TX_Black_on_White,                           // cSbvStatusFocus
   TX_Lwhite_on_White,                          // cSbvProgreStand
   TX_Lwhite_on_White,                          // cSbvTraceStand
   TX_Black_on_White,                           // cSbvMarkedArea
   TX_Black_on_White,                           // cDskTraceStand
   TX_Black_on_White,                           // cDskBorder_top
   TX_Black_on_White,                           // cDskBorder_trc
   TX_Black_on_White,                           // cDskBorder_rgt
   TX_Black_on_White,                           // cDskBorder_brc
   TX_Black_on_White,                           // cDskBorder_bot
   TX_Black_on_White,                           // cDskBorder_blc
   TX_Black_on_White,                           // cDskBorder_lft
   TX_Black_on_White,                           // cDskBorder_tlc
   TX_Black_on_White,                           // cDskTitleStand
   TX_Black_on_White,                           // cDskTitleFocus
   TX_Black_on_White,                           // cDskFooterStand
   TX_Black_on_White,                           // cDskFooterFocus
   TX_Black_on_White,                           // cLineTextStand
   TX_Black_on_White,                           // cLineTextNr0
   TX_Black_on_White,                           // cLineTextNr1
   TX_Black_on_White,                           // cLineTextNr2
   TX_Black_on_White,                           // cLineTextNr3
   TX_Black_on_White,                           // cHelpTextStand
   TX_Black_on_White,                           // cHelpTextHelp
   TX_Black_on_White,                           // cViewTextStand
   TX_Lwhite_on_Black,                          // cViewTextMark
   TX_Black_on_White,                           // cViewTextNr1
   TX_Black_on_White,                           // cViewTextNr2
   TX_Black_on_White,                           // cViewTextNr3
   TX_Black_on_White,                           // cListTextStand
   TX_White_on_Black,                           // cListTextFocus
   TX_Black_on_White,                           // cListTxt1Stand
   TX_White_on_Black,                           // cListTxt1Focus
   TX_Black_on_White,                           // cListTxt2Stand
   TX_White_on_Black,                           // cListTxt2Focus
   TX_Black_on_White,                           // cListTxt3Stand
   TX_White_on_Black,                           // cListTxt3Focus
   TX_Lwhite_on_Black,                          // cListSelectStand
   TX_Lwhite_on_Black,                          // cListSelectFocus
   TX_Black_on_White,                           // cListMarkStand
   TX_White_on_Black,                           // cListMarkFocus
   TX_Black_on_White,                           // cListDisableStand
   TX_White_on_Black,                           // cListDisableFocus
   TX_Lwhite_on_White,                          // cListSeparatStand
   TX_Lwhite_on_White,                          // cListSeparatFocus
   TX_Lwhite_on_Black,                          // cListCountStand
   TX_Lwhite_on_Black,                          // cListCountFocus
   TX_Black_on_White,                           // cFileTextStand
   TX_White_on_Black,                           // cFileTextFocus
   TX_Black_on_White,                           // cFileTxt1Stand
   TX_White_on_Black,                           // cFileTxt1Focus
   TX_Black_on_White,                           // cFileTxt2Stand
   TX_White_on_Black,                           // cFileTxt2Focus
   TX_Black_on_White,                           // cFileTxt3Stand
   TX_White_on_Black,                           // cFileTxt3Focus
   TX_Black_on_White,                           // cFileSelectStand
   TX_White_on_Black,                           // cFileSelectFocus
   TX_Black_on_White,                           // cFileMarkStand     (DIR/Browser mark line/area)
   TX_White_on_Black,                           // cFileMarkFocus     (DIR/Browser cursor line)
   TX_Black_on_White,                           // cFileDisableStand
   TX_White_on_Black,                           // cFileDisableFocus
   TX_Lwhite_on_White,                          // cFileSeparatStand
   TX_Lwhite_on_White,                          // cFileSeparatFocus
   TX_Lwhite_on_Black,                          // cFileCountStand
   TX_Lwhite_on_Black,                          // cFileCountFocus
   TX_Black_on_White,                           // cFileBorder_top
   TX_Black_on_White,                           // cFileBorder_trc
   TX_Black_on_White,                           // cFileBorder_rgt
   TX_Black_on_White,                           // cFileBorder_brc
   TX_Black_on_White,                           // cFileBorder_bot
   TX_Black_on_White,                           // cFileBorder_blc
   TX_Black_on_White,                           // cFileBorder_lft
   TX_Black_on_White,                           // cFileBorder_tlc
   TX_Black_on_White,                           // cFileTitleStand
   TX_Lwhite_on_Black,                          // cFileTitleFocus
   TX_White_on_Black,                           // cFileFooterStand
   TX_Lwhite_on_Black,                          // cFileFooterFocus
   TX_White_on_Black,                           // cMenuTextStand
   TX_Black_on_White,                           // cMenuTextFocus
   TX_White_on_Black,                           // cMenuTxt1Stand
   TX_Black_on_White,                           // cMenuTxt1Focus
   TX_White_on_Black,                           // cMenuTxt2Stand
   TX_Black_on_White,                           // cMenuTxt2Focus
   TX_White_on_Black,                           // cMenuTxt3Stand
   TX_Black_on_White,                           // cMenuTxt3Focus
   TX_Lwhite_on_Black,                          // cMenuSelectStand
   TX_Lwhite_on_White,                          // cMenuSelectFocus
   TX_White_on_Black,                           // cMenuMarkStand
   TX_Black_on_White,                           // cMenuMarkFocus
   TX_White_on_Black,                           // cMenuDisableStand
   TX_Black_on_White,                           // cMenuDisableFocus
   TX_White_on_Black,                           // cMenuSeparatStand
   TX_Black_on_White,                           // cMenuSeparatFocus
   TX_White_on_Black,                           // cMenuBorder_top
   TX_White_on_Black,                           // cMenuBorder_trc
   TX_White_on_Black,                           // cMenuBorder_rgt
   TX_White_on_Black,                           // cMenuBorder_brc
   TX_White_on_Black,                           // cMenuBorder_bot
   TX_White_on_Black,                           // cMenuBorder_blc
   TX_White_on_Black,                           // cMenuBorder_lft
   TX_White_on_Black,                           // cMenuBorder_tlc
   TX_Black_on_White,                           // cMbarBorder_top
   TX_Black_on_White,                           // cMbarBorder_trc
   TX_Black_on_White,                           // cMbarBorder_rgt
   TX_Black_on_White,                           // cMbarBorder_brc
   TX_Black_on_White,                           // cMbarBorder_bot
   TX_Black_on_White,                           // cMbarBorder_blc
   TX_Black_on_White,                           // cMbarBorder_lft
   TX_Black_on_White,                           // cMbarBorder_tlc
   TX_Black_on_White,                           // cMbarTextStand
   TX_Black_on_White,                           // cMbarTextFocus
   TX_Black_on_White,                           // cMbarHeadStand
   TX_Lwhite_on_Black,                          // cMbarHeadFocus
   TX_Black_on_White,                           // cSpinTextStand
   TX_White_on_Black,                           // cSpinTextFocus
   TX_Lwhite_on_Black,                          // cSpinSelectStand
   TX_Lwhite_on_Black,                          // cSpinSelectFocus
   TX_Black_on_White,                           // cSpinMarkStand
   TX_White_on_Black,                           // cSpinMarkFocus
   TX_Black_on_White,                           // cSpinDisableStand
   TX_White_on_Black,                           // cSpinDisableFocus
   TX_Lwhite_on_White,                          // cSpinSeparatStand
   TX_Lwhite_on_White,                          // cSpinSeparatFocus
   TX_White_on_Black,                           // cSpinIndcStand
   TX_Black_on_White,                           // cSpinIndcFocus
   TX_Black_on_White,                           // cPushTextStand
   TX_White_on_Black,                           // cPushTextFocus
   TX_Black_on_White,                           // cRadioValueStand
   TX_White_on_Black,                           // cRadioValueFocus
   TX_Black_on_White,                           // cRadioTextStand
   TX_Black_on_White,                           // cRadioTextFocus
   TX_Black_on_White,                           // cCheckValueStand
   TX_White_on_Black,                           // cCheckValueFocus
   TX_Black_on_White,                           // cCheckTextStand
   TX_Black_on_White,                           // cCheckTextFocus
   TX_White_on_Black,                           // cDlgEfTextStand
   TX_Lwhite_on_Black,                          // cDlgEfTextFocus
   TX_White_on_Black,                           // cEntryTextStand
   TX_Lwhite_on_Black,                          // cEntryTextFocus
   TX_Black_on_Black,                           // cEntryHistStand
   TX_White_on_Black,                           // cEntryHistFocus
   TX_White_on_Black,                           // cEntrBorder_top
   TX_White_on_Black,                           // cEntrBorder_trc
   TX_White_on_Black,                           // cEntrBorder_rgt
   TX_White_on_Black,                           // cEntrBorder_brc
   TX_White_on_Black,                           // cEntrBorder_bot
   TX_White_on_Black,                           // cEntrBorder_blc
   TX_White_on_Black,                           // cEntrBorder_lft
   TX_White_on_Black,                           // cEntrBorder_tlc
   TX_White_on_Black,                           // cEntrTitleStand
   TX_Lwhite_on_Black,                          // cEntrTitleFocus
   TX_White_on_Black,                           // cEntrFooterStand
   TX_Lwhite_on_Black,                          // cEntrFooterFocus
   TX_Lwhite_on_White,                          // cHexEdAscBracket
   TX_White_on_Black,                           // cHexEdRelPosPrev
   TX_Lwhite_on_Black,                          // cHexEdRelPosCurr
   TX_White_on_Black,                           // cHexEdRelPosNext
   TX_White_on_Black,                           // cHexEdAbsBytePos
   TX_White_on_Black,                           // cHexEdAbsByteCur
   TX_White_on_Black,                           // cHexEdRelCursorP
   TX_Lwhite_on_Black,                          // cHexEdButtonText
   TX_White_on_Black,                           // cHexEdButBracket
   TX_White_on_Black,                           // cHexEdByteNumber
   TX_White_on_Black,                           // cHexEdItemSnText
   TX_Lwhite_on_Black,                          // cHexEdItemHlight
   TX_Lwhite_on_Black,                          // cHexEdModifyText
   TX_Black_on_White,                           // c1NomarkActiveOrgStd
   TX_White_on_Black,                           // c1NomarkActiveOrgCur
   TX_Lwhite_on_White,                          // c1NomarkActiveModStd
   TX_Lwhite_on_Black,                          // c1NomarkActiveModCur
   TX_Black_on_White,                           // c1NomarkDimmedOrgStd
   TX_White_on_Black,                           // c1NomarkDimmedOrgCur
   TX_Lwhite_on_Black,                          // c1NomarkDimmedModStd
   TX_White_on_Black,                           // c1NomarkDimmedModCur
   TX_Lwhite_on_Black,                          // c1MarkedActiveOrgStd
   TX_Lwhite_on_Black,                          // c1MarkedActiveOrgCur
   TX_Lwhite_on_White,                          // c1MarkedActiveModStd
   TX_Lwhite_on_White,                          // c1MarkedActiveModCur
   TX_Lwhite_on_White,                          // c1MarkedDimmedOrgStd
   TX_Lwhite_on_White,                          // c1MarkedDimmedOrgCur
   TX_Lwhite_on_White,                          // c1MarkedDimmedModStd
   TX_Lwhite_on_White,                          // c1MarkedDimmedModCur
   TX_Black_on_White,                           // c2NomarkActiveOrgStd
   TX_White_on_Black,                           // c2NomarkActiveOrgCur
   TX_Lwhite_on_White,                          // c2NomarkActiveModStd
   TX_Lwhite_on_Black,                          // c2NomarkActiveModCur
   TX_Black_on_White,                           // c2NomarkDimmedOrgStd
   TX_White_on_Black,                           // c2NomarkDimmedOrgCur
   TX_Lwhite_on_Black,                          // c2NomarkDimmedModStd
   TX_White_on_Black,                           // c2NomarkDimmedModCur
};

//- define colorschemes using the color-maps defined above ...

static  TXW_COLORSCHEME txwcs_3g =
{
   TXW_CS_SIGNATURE,
   TXW_CS_3D_LINES,
   TXSB_COLOR_B2BLUE,
   TXW_CSF_NORMAL,
   "Grey 3-dimensional",
   "New default scheme, a 3D-look with Grey menus, Cyan borders and White Windows",
   txwcm_3g
};

static  TXW_COLORSCHEME txwcs_3c =
{
   TXW_CS_SIGNATURE,
   TXW_CS_3D_LINES,
   TXSB_COLOR_B2BLUE | TXSB_COLOR_BRIGHT,
   TXW_CSF_NORMAL,
   "3D-style Commander",
   "Commander scheme with a 3D-look in Cyan/Black menus and Blue/White Windows",
   txwcm_3c
};

static TXW_COLORSCHEME txwcs_st =
{
   TXW_CS_SIGNATURE,
   TXW_CS_STDLINES,
   TXSB_COLOR_B2BLUE,
   TXW_CSF_NORMAL,
   "DFSee classic Cyan",
   "Classic color scheme, very close to the original fixed scheme used by DFSee",
   txwcm_st
};

static  TXW_COLORSCHEME txwcs_cm =
{
   TXW_CS_SIGNATURE,
   TXW_CS_STDLINES,
   TXSB_COLOR_B2BLUE | TXSB_COLOR_BRIGHT,
   TXW_CSF_NORMAL,
   "Commander NC/FC/MC",
   "Color scheme inspired by the Norton Commander and clones, very Cyan/Blue",
   txwcm_cm
};

static  TXW_COLORSCHEME txwcs_nb =
{
   TXW_CS_SIGNATURE,
   TXW_CS_STDLINES,
   TXSB_COLOR_B2BLUE,
   TXW_CSF_NORMAL,
   "Non-blinking Brown",
   "Color scheme that avoids the 'bright backgrounds' that may cause blinking",
   txwcm_nb
};

static  TXW_COLORSCHEME txwcs_3w =
{
   TXW_CS_SIGNATURE,
   TXW_CS_3D_LINES,
   TXSB_COLOR_INVERT | TXSB_COLOR_BRIGHT,
   TXW_CSF_LIST_UNDERLINE,
   "Black and White 3D",
   "A mainly Black & White scheme with a 3D-look using White menus and Windows",
   txwcm_3w
};

static  TXW_COLORSCHEME txwcs_bw =
{
   TXW_CS_SIGNATURE,
   TXW_CS_STDLINES,
   TXSB_COLOR_INVERT | TXSB_COLOR_BRIGHT,
   TXW_CSF_LIST_UNDERLINE,
   "Black & White only",
   "Black & White scheme with Black menus and White Windows, for MONOCHROME use",
   txwcm_bw
};

//- custom colorscheme to be refined (set by APP or through INI file ?)

#endif
