
#ifndef WPSystem_Source
#define WPSystem_Source

#include <wpabs.hh>
#pragma off(dts_class);
#pragma on(somobject_assignment_operators);
#pragma on(somobject_constructors);
#pragma on(somobject_destructor);
#pragma off(case_insensitive_class_names);

#pragma on(som_bindings);
class WPSystem : public WPAbstract {

     #pragma SOMMap (WPSystem, "WPSystem", "M_WPSystem")

     #pragma SOMClassVersion (WPSystem, 1, 2)

     #pragma SOMCallstyle (WPSystem, oidl)

     #pragma off(som_bindings);
     #pragma pop(som_bindings);
  public :

#pragma off(use_override_signature)
     virtual ULONG wpAddSystemWindowPage(HWND hwndNotebook);
     virtual ULONG wpAddSystemLogoPage(HWND hwndNotebook);
     virtual ULONG wpAddSystemPrintScreenPage(HWND hwndNotebook);
     virtual ULONG wpAddSystemConfirmationPage(HWND hwndNotebook);
     virtual ULONG wpAddTitleConfirmationPage(HWND hwndNotebook);
     virtual ULONG wpAddSystemScreenPage(HWND hwndNotebook);
     virtual ULONG wpAddDMQSDisplayTypePage(HWND hwndNotebook);
     virtual BOOL wpAddSettingsPages(HWND hwndNotebook);
     virtual ULONG wpAddObjectWindowPage(HWND hwndNotebook);
     virtual ULONG wpFilterPopupMenu(ULONG ulFlags, HWND hwndCnr,
                                     BOOL fMultiSelect);
     virtual BOOL wpRestoreState(ULONG ulReserved);
     virtual BOOL wpSaveState();
#pragma pop(use_override_signature)

     #pragma SOMReleaseOrder ( \
                              wpAddSystemWindowPage, \
                              wpAddSystemLogoPage, \
                              wpAddSystemPrintScreenPage, \
                              wpAddSystemConfirmationPage, \
                              wpAddTitleConfirmationPage, \
                              wpAddSystemScreenPage, \
                              wpAddDMQSDisplayTypePage)
};
#pragma pop(som_bindings);

#pragma pop(dts_class);
#pragma pop(somobject_assignment_operators);
#pragma pop(somobject_constructors);
#pragma pop(somobject_destructor);
#pragma pop(case_insensitive_class_names);
#endif /* WPSystem_Source */

#ifndef M_WPSystem_Source
#define M_WPSystem_Source

#include <wpabs.hh>
#include <somcls.hh>
#pragma off(dts_class);
#pragma on(somobject_assignment_operators);
#pragma on(somobject_constructors);
#pragma on(somobject_destructor);
#pragma off(case_insensitive_class_names);

#pragma on(som_bindings);
class M_WPSystem : public M_WPAbstract {

     #pragma SOMClassVersion (M_WPSystem, 1, 2)

     #pragma SOMCallstyle (M_WPSystem, oidl)

     #pragma off(som_bindings);
     #pragma pop(som_bindings);
  public :

#pragma off(use_override_signature)
     virtual PSZ wpclsQueryTitle();
     virtual BOOL wpclsQueryDefaultHelp(PULONG pHelpPanelId,
                                        PSZ pszHelpLibrary);
     virtual ULONG wpclsQueryDefaultView();
     virtual ULONG wpclsQueryStyle();
     virtual ULONG wpclsQueryIconData(PICONINFO pIconInfo);
     virtual BOOL wpclsQuerySettingsPageSize(PSIZEL pSizl);
#pragma pop(use_override_signature)

     #pragma SOMReleaseOrder ()

};
#pragma pop(som_bindings);

#pragma pop(dts_class);
#pragma pop(somobject_assignment_operators);
#pragma pop(somobject_constructors);
#pragma pop(somobject_destructor);
#pragma pop(case_insensitive_class_names);
#endif /* M_WPSystem_Source */

