#include "mglserver_internal.h"

#define TIMEOUT 5 // seconds before giving up on the sound server daemon

static char vidmode = 0;  // 0 is PM, 1 is FS
static HQUEUE command_queue = 0, listener_queue = 0;
static HEV server_request_processed = 0;
static ULONG junk;

#define maker565( r, g, b ) (unsigned short) (((unsigned short)(b)>>3) | ((unsigned short)(g)&0x00fc)<<3 | ((unsigned short)(r)&0x00f8)<<8)

void ClientListenerThread( void *unused )
{
	REQUESTDATA request;
        ULONG reqlen, information, rc;
        char priority;

        fprintf( stderr, "Client listener thread is alive.\n" );

        rc = DosReadQueue( listener_queue, &request, &junk, (void **) &information, 
          0, 0, &priority, 0 );

        while ( !rc ) // While queue handle is valid
        {
                switch ( request.ulData )
                {
                        case MGLC_VIDEO_SWITCH_NOTIFICATION:
                                vidmode = information;
                                fprintf( stderr, "Video mode switch notification: %d\n", vidmode );
                        break;
                        default:
                }
                rc = DosReadQueue( listener_queue, &request, &junk, (void **) &information, 
                  0, 0, &priority, 0 );
        }

        fprintf( stderr, "Client listener thread is dead.  DosReadQueue rc=%d.\n", rc );
        fflush( stderr );

        DosPostEventSem( server_request_processed );
        // Tell the main thread that we're done.

        _endthread();
}

inline void MGLS_synchronous_command( int command, int packetsize, void *packet )
{
        while ( vidmode == 0 ) DosSleep( 1000 );
        DosResetEventSem( server_request_processed, &junk );
	DosWriteQueue( command_queue, command, packetsize, packet, 0 );
        DosWaitEventSem( server_request_processed, -1 );
}

int main( void )
{
	PID queue_daemon_pid;
	ULONG rc, i, j, pid, sesID, listener_thread;
	STARTDATA sd;
        RESULTCODES res;
	void *sharedmem = NULL;
        char esemname[100];
        int esemnum = 0;

        short *vidbuffer;

        MGL_SERVER_INIT_PACKET *ip;
        MGL_SERVER_SHUTDOWN_PACKET *sp;
        MGL_SERVER_INIT_VIDMODE_PACKET *iv;
        MGL_SERVER_SHUTDOWN_VIDMODE_PACKET *sv;
        MGL_SERVER_INIT_BUFFER_PACKET *ib;
        MGL_SERVER_FREE_BUFFER_PACKET *fb;
        MGL_SERVER_BLIT_BUFFER_PACKET *bb;

        sprintf( esemname, "\\SEM32\\MGLS_Client_tester_data_valid%d", esemnum );

        rc = DosCreateEventSem( esemname, 
          &server_request_processed, DC_SEM_SHARED, FALSE );

        while ( rc == 285 )
        {
                // Duplicate semaphore name
                esemnum++;
                sprintf( esemname, "\\SEM32\\MGLS_Client_tester_data_valid%d", esemnum );
                rc = DosCreateEventSem( esemname, 
                  &server_request_processed, DC_SEM_SHARED, FALSE );
        }

        if ( rc )
        {
                printf( "Could not create client event semaphore.  Error %ld.\n", rc );
                return 1;
        }

        printf( "Client wakeup semaphore name is %s.\n", esemname );

	rc = DosOpenQueue( &queue_daemon_pid, &command_queue, MGLS_COMMAND_QUEUE_NAME );

	if ( !rc )
        {
                printf( "An existing server is still running!  Please kill it off before attempting to run again.\n" );
		DosCloseQueue( command_queue );
                DosCloseEventSem( server_request_processed );
                return 1;
        }

        if ( rc != 343 )
        {
                printf( "Could not open command queue.  Error %ld.\n", rc );
                return 1;
        }

        printf( "Trying to spawn the daemon.\n" );

	sd.Length = 32;
	sd.Related = 1;
	sd.FgBg = SSF_FGBG_BACK;
	sd.TraceOpt = SSF_TRACEOPT_NONE;
	sd.PgmTitle = NULL;
	sd.PgmName = "mglserver.exe";
      	sd.PgmInputs = NULL;
	sd.TermQ = NULL;
	sd.Environment = 0;
	sd.InheritOpt = SSF_INHERTOPT_PARENT;
	sd.SessionType = SSF_TYPE_FULLSCREEN;

        rc = DosStartSession( &sd, &sesID, &pid );

        if ( rc ) { 
                printf( "DosStartSession returned %ld.  Can't continue.\n", rc );
                DosCloseEventSem( server_request_processed );
                return 1;
        }
        printf( "Server was spawned.  Waiting for server to start.\n" );

        for (i=0; i<TIMEOUT; ++i)
        {
                rc = DosOpenQueue( &queue_daemon_pid, &command_queue, MGLS_COMMAND_QUEUE_NAME );
                if ( !rc ) break;
                DosSleep(1000);
        }

        if ( rc )
        {
                printf( "I got bored waiting for the server to start up.\n" );
                DosCloseEventSem( server_request_processed );
                return 1;
        }

	printf("Creating first shared memory chunk.\n");

	rc = DosAllocSharedMem( &sharedmem, NULL, 1048576, OBJ_GETTABLE | PAG_READ | PAG_WRITE | PAG_COMMIT );

	if ( rc )
        {
		printf( "Error allocating shared memory.  RC = %ld.\n", rc );
		DosCloseQueue( command_queue );
                DosCloseEventSem( server_request_processed );
                return 1;
	}

        ip = sharedmem;
        sp = sharedmem;
        iv = sharedmem;
        sv = sharedmem;
        ib = sharedmem;
        fb = sharedmem;
        bb = sharedmem;

        strcpy( ip->client_semaphore_name, esemname );
        sprintf( ip->input_queue_name, "\\QUEUES\\MGLS_client_listener" );

        rc = DosCreateQueue( &(listener_queue), QUE_FIFO, ip->input_queue_name );
        if ( rc == 332 ) { // Queue is a duplicate
                printf( "Client queue (%s) is a duplicate!?!\n", ip->input_queue_name );
		DosCloseQueue( command_queue );
                DosCloseEventSem( server_request_processed );
                return 1;
        } else if ( rc != 0 ) {
                printf( "Error %ld creating client queue.\n", rc );
		DosCloseQueue( command_queue );
                DosCloseEventSem( server_request_processed );
                return 1;
        }

        printf( "About to kick full screen and initialize the server.\n" );

        listener_thread = _beginthread( ClientListenerThread, NULL, 16384, NULL );
        // Fire off the listener thread to get feedback from the daemon.
        // Needed for mode switch notification and input device notifications.

        DosSleep( 5000 );

        rc = DosSelectSession( sesID );
        if ( rc )
        {
                printf( "DosSelection session returned %d.  Exiting.\n" );
                return 1;
        }

        vidmode = 1;
        // We forced it into full screen mode.  Make sure the current state is
        // properly reflected in this variable when we start.

        printf( "Telling server to initialize and waiting for response.\n" );

        MGLS_synchronous_command( MGLS_INIT, sizeof(MGL_SERVER_INIT_PACKET), ip );

        printf( "Server responded to the initialization.\n" );

        if ( ip->input_queue_name[0] != '\\' )
        {
                printf( "Server initialization failed.  %s\n", ip->input_queue_name );
                DosFreeMem( sharedmem );
		DosCloseQueue( command_queue );
                DosCloseEventSem( server_request_processed );
                return 1;
        }

        printf( "Initialization was successful.\n" );

        iv->width = 320;
        iv->height = 200;
        iv->depth = 16;
        iv->flags = MGLS_VMIFLAG_USE_CUSTOM;

        MGLS_synchronous_command( MGLS_INIT_VIDMODE, 
          sizeof(MGL_SERVER_INIT_VIDMODE_PACKET), iv );
        // Kick into 320x200 16bpp

        if ( !(iv->flags & MGLS_VMOFLAG_SUCCESS) )
        {
                printf( "Failed to init video mode.  Shutting down server.\n" );
                MGLS_synchronous_command( MGLS_SHUTDOWN, 
                  sizeof(MGL_SERVER_SHUTDOWN_PACKET), sp );

                DosSelectSession( 0 );
                DosFreeMem( sharedmem );
		DosCloseQueue( command_queue );
                DosCloseEventSem( server_request_processed );
                return 1;
        }

	rc = DosAllocSharedMem( (void **)&vidbuffer, NULL, 320*200*2, 
          OBJ_GETTABLE | PAG_READ | PAG_WRITE | PAG_COMMIT );

	if ( rc )
        {
		printf( "Error allocating shared memory for video buffer.  RC = %ld.\n", rc );
                MGLS_synchronous_command( MGLS_SHUTDOWN, 
                  sizeof(MGL_SERVER_SHUTDOWN_PACKET), sp );

                DosSelectSession( 0 );
                DosFreeMem( sharedmem );
		DosCloseQueue( command_queue );
                DosCloseEventSem( server_request_processed );
                return 1;
	}

        ib->buffer = vidbuffer;
        ib->width = 320;
        ib->height = 200;
        ib->depth = 16;

        MGLS_synchronous_command( MGLS_INIT_BUFFER, 
          sizeof(MGL_SERVER_INIT_BUFFER_PACKET), ib );
        // Buffer is now ready for use by MGL

        for ( i=0; i<200; ++i )
        {
                for ( j=0; j<320; ++j )
                {
                        vidbuffer[ (i*320)+j ] = maker565( (i*255) / 200, ((i+j)*255 / 520), (j*255) / 320 );
                }
        }
        // Fill in buffer with a nice pattern

        bb->left = 0;
        bb->top = 0;
        bb->right = 320;
        bb->bottom = 200;
        bb->destx = 0;
        bb->desty = 0;

        MGLS_synchronous_command( MGLS_BLIT_BUFFER, 
          sizeof(MGL_SERVER_BLIT_BUFFER_PACKET), bb );
        // Blit the pretty pattern

        DosSleep( 5000 );

        for ( i=0; i<200; ++i )
        {
                for ( j=0; j<320; ++j )
                {
                        vidbuffer[ (i*320)+j ] = maker565( (j*255) / 320, ((i+j)*255 / 520), (i*255) / 200 );
                }
        }
        // Fill in buffer with another nice pattern
        
        MGLS_synchronous_command( MGLS_BLIT_BUFFER, 
          sizeof(MGL_SERVER_BLIT_BUFFER_PACKET), bb );
        // Blit the pretty pattern

        DosSleep( 5000 );

        printf( "Popping back into the PM app.\n" );
        DosSelectSession( 0 );

        printf( "Going to sleep for a bit.\n" );
        DosSleep( 5000 );

        printf( "Kicking back into full screen session and repainting.\n" );
        DosSleep( 5000 );
        rc = DosSelectSession( sesID );

        MGLS_synchronous_command( MGLS_BLIT_BUFFER, 
          sizeof(MGL_SERVER_BLIT_BUFFER_PACKET), bb );
        // Blit the pretty pattern

        DosSleep( 5000 );

        MGLS_synchronous_command( MGLS_FREE_BUFFER, 
          sizeof(MGL_SERVER_FREE_BUFFER_PACKET), fb );
        // Free the buffer

        MGLS_synchronous_command( MGLS_SHUTDOWN_VIDMODE, 
          sizeof(MGL_SERVER_SHUTDOWN_VIDMODE_PACKET), sv );
        // Shut down the video mode.  We're done here.

        printf( "Popping back into the PM app.\n" );
        DosSelectSession( 0 );

        printf( "Going to sleep for a bit.\n" );
        DosSleep( 5000 );

        printf( "Shutting down.\n" );
        
        MGLS_synchronous_command( MGLS_SHUTDOWN, sizeof(MGL_SERVER_SHUTDOWN_PACKET), sp );

        DosFreeMem( sharedmem );
        DosFreeMem( vidbuffer );
        DosCloseQueue( command_queue );
        DosCloseQueue( listener_queue );

        DosWaitEventSem( server_request_processed, -1 );
        // Wait for listener thread to exit gracefully.

        DosCloseEventSem( server_request_processed );

        printf( "Shutdown complete.\n" );

        return 0;
}

