unit pgraph1;

interface

uses Os2Base, Os2Def;

type s127 = string[127];
     PointType = record x,y:integer end;

const NORMALPUT=0;
      COPYPUT=0;
      XORPUT=1;
      ORPUT=2;
      ANDPUT=3;
      NOTPUT=4;
      NOTXORPUT=5;
      NOTORPUT=6;
      NOTANDPUT=7;

      GCPORT=$3CE;
      RGBPORT=$3C8;

      MAX_X=639;
      MAX_Y=479;
      BYTEWIDTH=80;

      WMODEOUT:word=$0003;
      NOTFLAG:boolean=false;
      WCOLORPUT:byte=15;

{User's variables}
var LiWi:byte;
    dot,pxm:boolean;
    rst:word;
    crx,cry,crs:integer;
    whx,why:byte;
    ntextrow:byte;
    GFDir:s127;
    fkl:boolean;
    shi,ins:byte;
    ch:char;

function  ReadKey: Char;
function  KeyPressed: Boolean;
procedure PlaySound(Freq,Duration: Longint);
procedure Pip;

function  Klic: char;
procedure Editg(x1,x2,y:byte; var st:string);
procedure Num(x,y:byte; var n; t:char; k,l:integer);
procedure WriteNum(var n; t:char; k,l:integer);
procedure GraphInit(s:s127);
procedure Lock_On;
procedure Lock_Off;
procedure SetGraphMode;
procedure RestoreCrtMode;
procedure ClearDevice;
procedure SetColor(color:word);
procedure BackColor(color:word);
procedure FBC(fcolor,bcolor:word);
function  GetColor:word;
procedure SetWriteMode(mode:integer);
procedure SetRGBPalette(color,red,green,blue:integer);
function  GetPixel(x,y:integer):word;
procedure PutPixel(x,y:integer; color:word);
procedure Pixel(x,y:integer);
procedure PixelMode_On;
procedure PixelMode_Off;
procedure LineMode_On;
procedure LineMode_Off;
procedure Vline(x1,y1,y2:integer);
procedure Hline(x1,x2,y1:integer);
procedure Line(x1,y1,x2,y2:integer);
procedure MoveTo(x,y:integer);
procedure LineTo(x,y:integer);
procedure MoveRel(x,y:integer);
procedure LineRel(x,y:integer);
procedure Sym0(x,y:integer);
procedure Rectangle(x1,y1,x2,y2:integer);
procedure FillRectangle(x1,y1,x2,y2:integer);
procedure Triangle(x1,y1,x2,y2,x3,y3:integer);
procedure FillTriangle(p1,q1,p2,q2,p3,q3:integer);
procedure Ellipse(xc,yc:integer; xrad,yrad:integer);
procedure FillEllipse(xc,yc:integer; xrad,yrad:integer);
procedure FillPolygon(n: integer; var p);
function  AreaSize(x1,y1,x2,y2:integer):longint;
procedure GetArea(x1,y1,x2,y2:integer; var b);
procedure PutArea(x1,y1:integer; var b);
procedure Cursor;
procedure MoveCross(ch:char; fkl:boolean);
procedure GrafFont(r:byte);
procedure CesChar(ch:char);
procedure CesTextC(x,y:integer; s:s127; d:boolean);
procedure ClrText(x,y,d:byte);
procedure ClrEolG;
procedure GotoXYG(x,y:byte);
procedure WriteG(s:s127);
procedure WriteGn(s:s127);
procedure LineFont(l:byte);
procedure CesLText(x0,y0:integer; s:s127; zv:single; d:boolean);


implementation

type
  Ptr16Rec = record Ofs,Sel:SmallWord end;
       tzb = record a:longint; r:byte; b:boolean end;
       tco = record x,y:integer end;
       tri = array[0..4*360] of tco;

var VioBufOfs,PixAddr:longint;
    Xmvt,Ymvt,i:integer;
    Locked:boolean;
    fcolor,bcolor:byte;
    Status,FontHeight,FontHeight0 : byte;
    LFont:string[1];
    ca,ha,sp:string[1];
    cosi:tri;
    gfont:array[1..6144] of byte;
    plfont:array[32..255] of integer;
    blfont:array[1..3333] of shortint;
    OrgMode:VioModeInfo;
    zb:array[0..4*max_y] of tzb;
    nzb:integer;
    xx,yy:integer;
    hfx1,hfx2,hfy1:integer;

const

  VioMode: VioModeInfo =
   ( cb:     SizeOf(VioModeInfo);
     fbType: vgmt_Other + vgmt_Graphics;
     Color:  colors_16;
     Col:    80;
     Row:    25;
     HRes:   640;
     VRes:   480
   );

  VioBuf: VioPhysBuf =
   ( pBuf: Ptr($A0000);
     cb:   64*1024
   );

  ScanCode: Byte = 0;

  ZNC : set of char = [' ','+','-','.'];

function KeyPressed: Boolean;
var
  Key: KbdKeyInfo;
begin
  KbdPeek(Key,0);
  KeyPressed := (ScanCode <> 0) or ((Key.fbStatus and kbdtrf_Final_Char_In) <> 0);
end;

function ReadKey: Char;
var
  Key: KbdKeyInfo;
begin
  If ScanCode <> 0 then
  begin
    ReadKey  := Chr(ScanCode);
    ScanCode := 0;
  end
 else
  begin
    KbdCharIn(Key,io_Wait,0);
    case Key.chChar of
      #0: ScanCode := Key.chScan;
      #$E0:           {   Up, Dn, Left Rt Ins Del Home End PgUp PgDn C-Home C-End C-PgUp C-PgDn C-Left C-Right C-Up C-Dn }
        if Key.chScan in [$48,$50,$4B,$4D,$52,$53,$47, $4F,$49, $51, $77,   $75,  $84,   $76,   $73,   $74,    $8D, $91] then
        begin
          ScanCode := Key.chScan;
          Key.chChar := #0;
        end;
    end;
    ReadKey := Key.chChar;
  end;
end;


procedure PlaySound(Freq,Duration: Longint);
begin DosBeep(Freq,Duration) end;


procedure Pip;
begin playsound(440,100) end;


function  Klic: char;
var ch : char; StatData:KbdInfo; rc:ApiRet;
begin
 repeat until keypressed; ch:=readkey; fkl:=false;
 if ch=#0 then begin ch:=readkey; fkl:=true end;
 StatData.cb:=Sizeof(StatData);
 rc:=KbdGetStatus(StatData,0);
 shi:=StatData.fsState; klic:=ch
end;

procedure Carka;
begin
 ch:=klic; case ch of
 'a':ch:=''; 'A':ch:='';
 'e':ch:=''; 'E':ch:='';
 'i':ch:=''; 'I':ch:='';
 'o':ch:=''; 'O':ch:='';
 'u':ch:=''; 'U':ch:='';
 'y':ch:=''; 'Y':ch:='' else ch:=ca[1] end
end;

procedure Hacek;
begin
 ch:=klic; case ch of

 'c':ch:=''; 'C':ch:='';
 'd':ch:=''; 'D':ch:='';
 'e':ch:=''; 'E':ch:='';
 'n':ch:=''; 'N':ch:='';
 'r':ch:=''; 'R':ch:='';
 's':ch:=''; 'S':ch:='';
 't':ch:=''; 'T':ch:='';
 'u':ch:=''; 'U':ch:='';
 'z':ch:=''; 'Z':ch:='';

 '1':ch:=''; '2':ch:='';
 '3':ch:=''; '4':ch:='';
 '5':ch:=''; ' ':ch:='';
 '[':ch:=''; ']':ch:='';
 '(':ch:=''; ')':ch:='';
 #72:ch:=chr(147); #80:ch:=chr(167);
 #77:ch:=chr(170); #75:ch:=chr(171);
'''':ch:='';
 else ch:=ha[1] end
end;

procedure Prona;
begin
 ch:=klic; case ch of
 'a':ch:=''; 'd':ch:='';
 'e':ch:=''; 'E':ch:='';
 'n':ch:=''; 't':ch:='';
 'c':ch:=#3 ; 'p':ch:=#16; 's':ch:=#19 else ch:=sp[1] end
end;


procedure Editg(x1,x2,y:byte; var st:string);
label 1;
var ip,d,l,ipx1,ipx11:byte; b:boolean;

procedure edi(var st:string);
label 1;
begin
 ipx1:=ip-x1; ipx11:=ipx1+1;
 if fkl then
  case ch of
   #24 : begin ch:=chr(247); goto 1 end;
   #75 : if ip>x1 then dec(ip);
   #77 : if ip<x1+length(st) then inc(ip);
   #79 : ip:=x1+length(st);
   #71 : ip:=x1;
   #82 : if ins=1 then ins:=0 else ins:=1;
   #83 : if ipx1<length(st) then delete(st,ipx11,1);
   else ; end
        else begin
  if ch=ca[1] then begin carka; goto 1 end;
  if ch=ha[1] then begin hacek; goto 1 end;
  if ch=sp[1] then begin prona; goto 1 end;
  case ch of
   #13 : exit;
   #27 : begin st:=''; ip:=x1 end;
    #8 : if ip>x1 then begin delete(st,ipx1,1); dec(ip) end;
  else begin
   1: l:=length(st);
   if ipx11>l then begin if l<d then st:=st+ch else dec(ip) end
              else begin if ins=0 then st[ipx11]:=ch
                                  else if l<d then insert(ch,st,ipx11)
                                              else dec(ip) end;
   inc(ip) end end end
end;

begin
 ip:=x1+length(st); d:=x2-x1; b:=true;
 1: clrtext(x1,y,d);
 gotoxyg(x1,y); writeg(st); gotoxyg(ip,y);
 Cursor; ch:=klic; Cursor;
 if b then if not fkl and (ch in [#33..#254]) then begin
  st:=ch; ip:=x1+1; b:=false; goto 1 end else b:=false;
 edi(st); if ch=#13 then exit; goto 1
end;

procedure Num(x,y:byte; var n; t:char; k,l:integer);
label 1;
var ch:longint; st:string[17];
begin
 ins:=0;
 case t of
  'b': str(byte(n):k,st);          's': str(single(n):k:l,st);
  'i': str(integer(n):k,st);       'r': str(real(n):k:l,st);
  'w': str(word(n):k,st);          'd': str(double(n):k:l,st);
  'l': str(longint(n):k,st);       'e': str(extended(n):k:l,st);
  'h': str(shortint(n):k,st) end;
 1: editg(x,x+k,y,st);
 case t of
  'b': val(st,byte(n),ch);         's': val(st,single(n),ch);
  'i': val(st,integer(n),ch);      'r': val(st,real(n),ch);
  'w': val(st,word(n),ch);         'd': val(st,double(n),ch);
  'l': val(st,longint(n),ch);      'e': val(st,extended(n),ch);
  'h': val(st,shortint(n),ch) end;
 if (ch>1) or not (st[1] in ['0'..'9']+znc) then begin pip; goto 1 end;
 ins:=1;
end;

procedure WriteNum(var n; t:char; k,l:integer);
label 1;
var ch:longint; st:string[17];
begin
 case t of
  'b': str(byte(n):k,st);          's': str(single(n):k:l,st);
  'i': str(integer(n):k,st);       'r': str(real(n):k:l,st);
  'w': str(word(n):k,st);          'd': str(double(n):k:l,st);
  'l': str(longint(n):k,st);       'e': str(extended(n):k:l,st);
  'h': str(shortint(n):k,st) end;
 writeg(st)
end;



procedure HaltError(const ErrMsg: String);
begin
 RestoreCrtMode;
 WriteLn('**Error**  ', ErrMsg);
 Halt(1);
end;

procedure SetGraphMode;
begin
 OrgMode.cb:=SizeOf(VioModeInfo); VioGetMode(OrgMode, 0);
 if VioSetMode(VioMode, 0) <> 0 then HaltError('VGA display required.');
end;

procedure RestoreCrtMode;
begin
 VioSetMode(OrgMode, 0);
 if Locked then VioScrUnLock(0);
end;

procedure GraphInit(s:s127);
var f:file;
begin
 gfdir:=s;
 if (gfdir[length(gfdir)]<>'\') and (gfdir<>'') then gfdir:=gfdir+'\';
 assign(f,gfdir+'ZNC0'); reset(f);
 if ioresult>0 then begin
  write('Wrong path to the graphics files'); halt end
                    else close(f);

 setgraphmode;
 (*
 if (VioScrLock(lockIO_noWait, Status, 0) <> 0) or
  (Status <> lock_Success) then HaltError('Cannot lock the screen.');
 Locked := True;
 *)
 Locked:=False;
 if VioGetPhysBuf(VioBuf, 0) <> 0 then HaltError('Cannot access video screen selector.');
 Ptr16Rec(VioBufOfs).Ofs:=0; Ptr16Rec(VioBufOfs).Sel:=VioBuf.Sel;
 SelToFlat(Pointer(VioBufOfs));
 cleardevice; graffont(14); linefont(1);
end;

procedure Lock_On;
begin VioScrLock(lockIO_noWait,Status,0) end;

procedure Lock_Off;
begin VioScrUnlock(0) end;

procedure ClearDevice;
begin
 linemode_on;
 FillChar(Pointer(VioBufOfs)^,64*1024,0);
 linemode_off;
 whx:=1; why:=1
end;

procedure SetColor(color:word);
begin
 fcolor:=color and 15;
 if notflag then wcolorput:=15-fcolor else wcolorput:=fcolor
end;

procedure BackColor(color:word);
begin bcolor:=color and 15 end;

procedure FBC(fcolor,bcolor:word);
begin setcolor(fcolor); backcolor(bcolor) end;

function  GetColor:word;
begin getcolor:=fcolor end;

procedure SetWriteMode(mode:integer);
begin
 wmodeout:=((4 - (mode and 3) and 3) shl 11) or $0003;
 notflag:=(mode and 4)<>0;
 if notflag then wcolorput:=15-fcolor else wcolorput:=fcolor
end;

var BITSHIFT:byte;

function XYAddr(x,y:integer):boolean;
begin
 XYAddr:=(word(x)<=max_x) and (word(y)<=max_y);
 PixAddr:=VioBufOfs + y*bytewidth + x shr 3;
 BitShift:=7 - (x and 7);
end;

procedure SetRGBPalette(color,red,green,blue:integer);
begin
 port[rgbport]:=color and $FF;
 port[rgbport+1]:=red;
 port[rgbport+1]:=green;
 port[rgbport+1]:=blue
end;

function  GetPixel(x,y:integer):word;
var N:byte; color:byte;
begin
 color:=0;
 if xyaddr(x,y) then
  for n:=3 downto 0 do begin
   portw[gcport]:=n shl 8 or $04;
   color:=(color shl 1) or (mem[PixAddr] shr bitshift) end;
  getpixel:=color
end;

procedure PutPixel(x,y:integer;color:word);
var b:integer;
begin
 if (word(x)<=max_x) and (word(y)<=max_y) then begin
  PixAddr:=VioBufOfs + y*bytewidth + x shr 3;
  BitShift:=7 - (x and 7);
  portw[gcport]:=$0205;
  portw[gcport]:=($0100 shl bitshift) or $08;
  asm
   mov dx,color
   and dx,$0F
   mov eax,PixAddr
   cmp dl,[eax]
   mov [eax],dl
  end;
  portw[gcport]:=$0005;
  portw[gcport]:=$FF08 end
end;

(*
procedure PutPixelp(x,y:integer;color:word); {ignoruje zapisovy mod (vyplyva z TP6)}
var b:integer; {p:^byte;}
begin
 if (word(x)<=max_x) and (word(y)<=max_y) then begin
  PixAddr:=VioBufOfs + y*bytewidth + x shr 3;
  BitShift:=7 - (x and 7);
  portw[gcport]:=$0205;
  portw[gcport]:=($0100 shl bitshift) or $08;
  b:=mem[PixAddr]; mem[PixAddr]:= color and 15;
  {p:=ptr(PixAddr); b:=p^; p^:=color and 15;}
  portw[gcport]:=$0005;
  portw[gcport]:=$FF08 end
end;
*)

procedure Pixel(x,y:integer);
begin
  asm
   mov   cx,x
   movsx eax,y

   cmp   cx,27fh
   ja    @kon
   cmp   ax,1dfh
   ja    @kon

   and   cl,7
   mov   ch,128
   shr   ch,cl

   mov   dx,50h
   mul   dx

   mov   dx,x
   shr   dx,3
   add   ax,dx
   add   eax,VioBufOfs

   cmp   ch,[eax]
   mov   [eax],ch
  @kon:
  end
end;


procedure Pixel0;
begin
  asm
   mov   cx,xx

   cmp   cx,27fh
   ja    @kon
   cmp   edx,38320
   ja    @kon

   movsx eax,cx

   and   cl,7
   mov   ch,128
   shr   ch,cl

   shr   ax,3
   add   ax,dx
   add   eax,VioBufOfs

   cmp   ch,[eax]
   mov   [eax],ch
  @kon:
  end
end;

(*
procedure Pixelp(x,y:integer);
var b:byte;
begin
 if (word(x)<=max_x) and (word(y)<=max_y) then begin
  PixAddr:=VioBufOfs + y*bytewidth + x shr 3;
  b:=mem[PixAddr]; mem[PixAddr]:=$01 shl (7 - (x and 7)) end
end;
*)

procedure PixelMode_on;
begin
 portw[gcport]:=$0305;
 portw[gcport]:=wmodeout;
 portw[gcport]:=(wcolorput) shl 8
end;

procedure PixelMode_Off;
begin
 portw[gcport]:=$0005;
 portw[gcport]:=$0003;
 portw[gcport]:=$0000
end;

procedure LineMode_On;
var n:byte;
begin
 n:=fcolor xor $F;
 portw[$3CE]:=(n and bcolor) shl 8;
 portw[$3CE]:=$0F01;
 mem[VioBufOfs+$FFFF]:=0; if mem[VioBufOfs+$FFFF]=0 then;
 portw[$3CE]:=(fcolor and bcolor) shl 8;
 portw[$3CE]:=((n xor bcolor) shl 8) or 1;
 portw[$3CE]:=$1803
end;

procedure LineMode_Off;
begin portw[$3CE]:=$0000; portw[$3CE]:=$0001; portw[$3CE]:=$0003 end;


procedure Vline0(x1,y1,y2:integer);
label 1;
var x:byte; p:integer;
begin
 if (x1<0) or (x1>max_x) then exit;
 if y1>y2 then asm mov cx,y2; mov y2,ax; mov y1,cx end;
 if y1>max_y then exit;
 if y2<    0 then exit;
 if pxm then pixelmode_on;
 if y1<    0 then y1:=0;
 if y2>max_y then y2:=max_y;
 if xyaddr(x1,y1) then begin
  asm mov cl,bitshift; mov ch,1; shl ch,cl; mov edx,PixAddr end;
  for p:=y1 to y2 do begin
   asm cmp ch,[edx]; mov [edx],ch; add edx,80 end;
   if dot then begin asm add edx,80; inc p end end end end;
 if pxm then pixelmode_off
end;

procedure Vline(x1,y1,y2:integer);
begin
 vline0(x1,y1,y2);
 if (liwi>1) and (x1<max_x) then vline0(x1+1,y1,y2);
 if (liwi>2) and (x1>    0) then vline0(x1-1,y1,y2)
end;


procedure Zbfill;
label 1;
var i:integer; aa:longint; f,c,rr:byte;
begin

 pixelmode_on;
 for i:=1 to nzb do
  with zb[i] do begin
   if     b then
    asm mov bl,[eax+4];
    mov eax,[eax];
    cmp bl,[eax];
    mov [eax],bl end end;
 pixelmode_off;

 if rst=$FFFF then goto 1; c:=fcolor; setcolor(bcolor);

 pixelmode_on;
 for i:=1 to nzb do
  with zb[i] do begin
   if not b then
    asm mov bl,[eax+4];
    mov eax,[eax];
    cmp bl,[eax];
    mov [eax],bl end end;
 pixelmode_off;

 setcolor(c); 1: nzb:=0;
end;


procedure Hlinef;
label 1;
const c1:array[0..7] of byte = (255,127, 63, 31, 15,  7,  3,  1);
      c2:array[0..7] of byte = (128,192,224,240,248,252,254,255);
var a1,a2,b1,b2,y2:integer; a,aa1,aa2:longint; b,c:byte;

procedure sfill(d:boolean; rst:byte);
begin
 inc(nzb);
 with zb[nzb] do begin a:=aa1; r:=c1[b1] and c2[b2] and rst; b:=d end
end;

procedure rfill(d:boolean; rst:byte);
begin
 if hfx1< a1 shl 3 then begin
  inc(nzb); with zb[nzb] do begin a:=aa1-1; r:=c1[b1] and rst; b:=d end end;
 if hfx2> a2 shl 3 - 1 then begin
  inc(nzb); with zb[nzb] do begin a:=aa2;   r:=c2[b2] and rst; b:=d end end;
end;

begin
 rst:=swap(rst);
 if (hfy1<0) or (hfy1>max_y) then exit;
 if hfx1=hfx2 then exit;
 if hfx1>hfx2 then begin a1:=hfx2; hfx2:=hfx1; hfx1:=a1 end; {!!!}
 if hfx1>max_x then exit;
 if hfx2<    0 then exit;
 if hfx1<    0 then hfx1:=    0;
 if hfx2>max_x then hfx2:=max_x;

 a:=VioBufOfs+hfy1*80; b1:=hfx1 and $07; b2:=hfx2 and $07; y2:=max_y shl 2;

 a1:=hfx1 shr 3;
 if a1=hfx2 shr 3 then begin
  aa1:=a+a1;
  if (b1=0) and (b2=7) then begin a2:=a1+1; goto 1 end;
  sfill(true,byte(rst));
  if byte(rst)<>$FF then sfill(false, not byte(rst));
  exit end;

 if hfx1>0 then a1:=((hfx1-1) shr 3) + 1 else a1:=0; a2:=(hfx2+1) shr 3;

 aa1:=a+a1; aa2:=a+a2;

 rfill(true,byte(rst));
 if byte(rst)<>$FF then rfill(false, not byte(rst));

 if nzb+5>y2 then begin linemode_off; zbfill; linemode_on end;

 if hfx2-hfx1<8 then exit;
 1: fillchar(mem[aa1],a2-a1,byte(rst))
end;

procedure Hline(x1,x2,y1:integer);
begin
 if (y1<0) or (y1>max_y) then exit;
 if x1>x2 then asm mov cx,x2; mov x2,ax; mov x1,cx end;
 if x1>max_x then exit;
 if x2<    0 then exit;
 if pxm then pixelmode_on;
 if x1<    0 then x1:=0;
 if x2>max_x then x2:=max_x;
 if xyaddr(x1,y1) then begin
  asm
   mov cl,bitshift;
   mov ch,1;
   shl ch,cl;
   mov eax,PixAddr;
   mov bl,liwi;
   mov bh,dot;
   mov dx,x2;
   sub dx,x1;
@c:cmp dx,0;
   jl  @hlkon;
   cmp [eax],ch; mov [eax],ch
   cmp bl,1;
   jle @b;
   cmp y1,max_y
   jge @a;
   mov [eax+50h],ch
@a:cmp bl,2;
   jle @b;
   cmp y1,1;
   jle @b;
   mov [eax-50h],ch
@b:dec dx; ror ch,1; cmp ch,128; jne @kkk; inc eax; @kkk:
   and bh,bh;
   jz @c;
   dec dx; ror ch,1; cmp ch,128; jne @lll; inc eax; @lll:
   jmp @c;
   @hlkon:
  end end;
 if pxm then pixelmode_off
end;


procedure Line(x1,y1,x2,y2:integer);
label 1,2,3,d1,d2;
var x21,y21,k:integer; b:longint; kx,zz:longint;

begin
 asm mov b,ebx end;
 if pxm then pixelmode_on;
 x21:=abs(x2-x1); y21:=abs(y2-y1);
 if x21>y21 then begin
  if x1>x2 then
  asm mov cx,x2; mov x2,ax; mov x1,cx;
      mov ax,y2; mov cx,y1; mov y1,ax; mov y2,cx end;
  if (x1>max_x) or (x2<0) then goto 1; if x2>max_x then x2:=max_x;
  xx:=x1; if y1>y2 then kx:=-80 else kx:=80;
  asm movsx edx,y1; mov eax,edx; shl edx,2; add edx,eax; shl edx,4;
      call pixel0 end;
  if liwi<2 then goto d1; asm add edx,80; call pixel0; sub edx,80 end;
  if liwi>2 then asm sub edx,80; call pixel0; add edx,80 end;

  d1: asm mov bx,x21; inc bx; shr bx,1; inc xx end;
  while xx<=x2 do begin
   asm sub bx,y21; jg @k1; add edx,kx; add bx,x21; @k1:

   mov cx,xx; cmp cx,27fh; ja @kon1; cmp edx,38320; ja @kon1;
   movsx eax,cx; and cl,7; mov ch,128; shr ch,cl; shr ax,3; add ax,dx;
   add eax,VioBufOfs; cmp ch,[eax]; mov [eax],ch; @kon1: end;

   if liwi<2 then goto 2;
   asm add edx,80; cmp edx,38320; ja @ko1;
   add eax,80; cmp ch,[eax]; mov [eax],ch; sub eax,80;
   @ko1: sub edx,80 end;

   if liwi>2 then
   asm sub edx,80; cmp edx,38320; ja @ko2;
   sub eax,80; cmp ch,[eax]; mov [eax],ch; add edx,80;
   @ko2: add eax,80 end;

   2: if dot then begin
    inc(xx); if xx>x2 then goto 1;
    asm sub bx,y21; jg @l1; add edx,kx; add bx,x21; @l1: end end;
   inc(xx) end end

            else begin

  if y1>y2 then
   asm mov cx,y2; mov y2,ax; mov y1,cx;
       mov ax,x2; mov cx,x1; mov x1,ax; mov x2,cx end;
  if (y1>max_y) or (y2<0) then goto 1; if y2>max_y then y2:=max_y;
  xx:=x1; yy:=y1; if x1>x2 then k:=-1 else k:=1;
  asm movsx edx,y1; mov eax,edx; shl edx,2; add edx,eax; shl edx,4;
      call pixel0 end;
  if liwi<2 then goto d2; asm inc xx; call pixel0; dec xx end;
  if liwi>2 then asm dec xx; call pixel0; inc xx end;

  d2: asm mov bx,y21; inc bx; shr bx,1; add edx,80; inc yy end;
  while yy<=y2 do begin
   asm sub bx,x21; jg @k2; mov ax,k; add xx,ax; add bx,y21; @k2:

   mov cx,xx; cmp cx,27fh; ja @kon2; cmp edx,38320; ja @kon2;
   movsx eax,cx; and cl,7; mov ch,128; shr ch,cl; shr ax,3; add ax,dx;
   add eax,VioBufOfs; cmp ch,[eax]; mov [eax],ch; @kon2: end;

   if liwi<2 then goto 3; asm inc xx; call pixel0; dec xx end;
   if liwi>2 then         asm dec xx; call pixel0; inc xx end;
   3: if dot then begin
    inc(yy); asm add edx,80 end; if yy>y2 then goto 1;
    asm sub bx,x21; jg @l2; mov ax,k; add xx,ax; add bx,y21; @l2: end end;
   inc(yy); asm add edx,80 end end end;
  1: asm mov ebx,b end; if pxm then pixelmode_off
end;


procedure MoveTo(x,y:integer);
begin xmvt:=x; ymvt:=y end;

procedure LineTo(x,y:integer);
begin line(xmvt,ymvt,x,y); xmvt:=x; ymvt:=y end;

procedure MoveRel(x,y:integer);
begin inc(xmvt,x); inc(ymvt,y) end;

procedure LineRel(x,y:integer);
var x1,y1:integer;
begin x1:=xmvt+x; y1:=xmvt+y; line(xmvt,ymvt,x1,y1); xmvt:=x1; ymvt:=y1 end;


procedure Sym0(x,y:integer);
begin
 if (word(x)<=max_x) and (word(y)<=max_y) then begin
  xx:=x;
  asm movsx edx,y; mov eax,edx; shl edx,2; add edx,eax; shl edx,4 end;
  {pixel0;}
  asm inc xx;     call pixel0; add edx,80; call pixel0;
      dec xx;     call pixel0; dec xx;     call pixel0;
      sub edx,80; call pixel0; sub edx,80; call pixel0;
      inc xx;     call pixel0; inc xx;     call pixel0 end end;
end;

procedure Rectangle(x1,y1,x2,y2:integer);
begin
 pxm:=false; pixelmode_on;
 hline(x1,x2,y1); hline(x1,x2,y2);
 vline(x1,y1,y2); vline(x2,y1,y2);
 pxm:=true; pixelmode_off
end;

procedure FillRectangle(x1,y1,x2,y2:integer);
var y:integer;
begin
 if y1>y2 then begin y:=y1; y1:=y2; y2:=y end;
 hfx1:=x1; hfx2:=x2;
 linemode_on;
 for hfy1:=y1 to y2 do hlinef;
 linemode_off;
 if nzb>0 then zbfill
end;


procedure Triangle(x1,y1,x2,y2,x3,y3:integer);
begin
 pxm:=false; pixelmode_on;
 moveto(x1,y1); lineto(x2,y2); lineto(x3,y3); lineto(x1,y1);
 pxm:=true; pixelmode_off
end;

procedure FillTriangle(p1,q1,p2,q2,p3,q3:integer);
label 1,2;
var a,b,c,n,x1,y1,x2,y2,x3,y3:integer;
    pf,pl,p0:single; xf,xl,i,j,pp,po:integer;

begin
 a:=abs(q1-q2); b:=abs(q2-q3); c:=abs(q1-q3); n:=0;
 if a>b then begin if a>c then n:=1 else n:=3 end
        else begin if b>c then n:=2 else n:=3 end;
 case n of
 1: begin x1:=p1; y1:=q1; x2:=p2; y2:=q2; x3:=p3; y3:=q3 end;
 2: begin x1:=p2; y1:=q2; x2:=p3; y2:=q3; x3:=p1; y3:=q1 end;
 3: begin x1:=p1; y1:=q1; x2:=p3; y2:=q3; x3:=p2; y3:=q2 end end;
 if (n=0) or (y1=y2) then exit;
 linemode_on;
 if y1>y2 then asm mov cx,y2; mov y2,ax; mov y1,cx;
                   mov ax,x2; mov cx,x1; mov x1,ax; mov x2,cx end;
 asm
  mov   ax,x2
  sub   ax,x1
  mov   pp,ax
  fild  pp
  mov   ax,y2
  sub   ax,y1
  mov   pp,ax
  fild  pp
  fdivp st(1),st
 end;
 if y1=y3 then goto 1;
 asm
  mov   ax,x3
  sub   ax,x1
  mov   pp,ax
  fild  pp
  mov   ax,y3
  sub   ax,y1
  mov   pp,ax
  fild  pp
  fdivp st(1),st
  mov   si,0
  mov   po,si
 end;
 for hfy1:=y1 to y3 do begin
 asm
   fild  po
   fmul  st,st(1)
   fistp pp
   mov   ax,pp
   add   ax,x1
   mov   hfx1,ax

   fild  po
   fmul  st,st(2)
   fistp pp
   mov   ax,pp
   add   ax,x1
   mov   hfx2,ax
   inc   po
   call  hlinef
  end end;
 asm fistp pp end;
 1: if y2=y3 then goto 2;
 asm
  mov   ax,x2
  sub   ax,x3
  mov   pp,ax
  fild  word ptr pp
  mov   ax,y2
  sub   ax,y3
  mov   pp,ax
  fild  word ptr pp
  fdivp st(1),st
  mov   si,1
  mov   po,si
 end;
 i:=y3-y1;
 for hfy1:=y3+1 to y2 do begin
 asm
   fild  po
   fmul  st,st(1)
   fistp pp
   mov   ax,pp
   add   ax,x3
   mov   hfx1,ax

   fild  i
   fmul  st,st(2)
   fistp pp
   mov   ax,pp
   add   ax,x1
   mov   hfx2,ax
   inc   po
   inc   i
   call hlinef
  end end;
 2: asm finit end; linemode_off; if nzb>0 then zbfill
end;


procedure Ellipse(xc,yc:integer; xrad,yrad:integer);
var x,y,x1,y1,x2,y2,v: integer; xr,yr:longint;
begin
 pxm:=false; pixelmode_on;
 xr:=xrad; yr:=yrad; x2:=0; y2:=yr; v:=364;
 while v<=720 do begin
  x1:=x2; y1:=y2;
  with cosi[v] do begin
   x2:=(xr*x shr 10)-xr;
   y2:=(yr*y shr 10)-yr end;
  if (x1<>x2) or (y1<>y2) then begin
   line(xc+x1,yc-y1,xc+x2,yc-y2);
   line(xc-x1,yc-y1,xc-x2,yc-y2);
   line(xc-x1,yc+y1,xc-x2,yc+y2);
   line(xc+x1,yc+y1,xc+x2,yc+y2) end;
  inc(v,4) end;
 pxm:=true; pixelmode_off
end;

procedure FillEllipse(xc,yc:integer; xrad,yrad:integer);
var x,y,x1,y1,x2,y2,v,xelps,yelps:integer; xr,yr:longint;
begin
 linemode_on;
 xr:=xrad; yr:=yrad; xelps:=2*xc; yelps:=2*yc;
 x2:=0; y2:=yr;
 for v:=361 to 720 do begin
  y1:=y2; x1:=x2;
  with cosi[v] do begin
   y2:=(yr*y shr 10)-yr;
   if (y1<>y2) then begin
    if abs(y1-y2)>1 then begin
     hfx1:=xc+x1; hfx2:=xelps-hfx1; hfy1:=yc-y1+1; hlinef;
     rst:=swap(rst); hfy1:=yelps-hfy1; hlinef end;
    x2:=(xr*x shr 10)-xr;
    hfx1:=xc+x2; hfx2:=xelps-hfx1; hfy1:=yc-y2; hlinef;
    rst:=swap(rst); hfy1:=yelps-hfy1; hlinef;
    end end end;
 linemode_off;
 if nzb>0 then zbfill
end;


var xi: array[0..11] of integer;
    qf: array[0..11] of single;
const aqf:pointer=@qf[1];

Procedure FillPolygon(n: integer; var p);
type pa=array[0..16000] of PointType;

var i,j,k,c,pm,y1,y2,pp,xx:integer;
    dis,bs:longint; ps:pointer;

begin
 pm:=n*Sizeof(Integer); fillchar(xi,pm,0);

 y1:=32000; y2:=-32000;
 for i:=0 to n-1 do
  with pa(p)[i] do begin if y<y1 then y1:=y; if y>y2 then y2:=y end;

 if y2<0 then exit; if y1>max_y then exit; linemode_on;

 asm
  mov dx,y1;
  mov edi,[ebp+8];
  mov ebx,aqf
  mov i,1;
 end;

 while i<n do
  asm
   mov     ax,[edi+2]
   sub     ax,[edi+6]
   jz      @fpkon
   mov     pp,ax
   fild    pp
   mov     ax,[edi]
   sub     ax,[edi+4]
   mov     pp,ax
   fidivr  pp
   fstp    dword ptr [ebx]
   @fpkon: add edi,4
   inc     i
   add     ebx,4
  end;

 asm mov hfy1,dx end;
 while hfy1<=y2 do begin
  asm
   xor ax,ax;
   mov j,ax;
   inc ax;
   mov i,ax;
   mov edi,[ebp+8]
   mov ebx,aqf
  end;
  while i<n do begin
   asm
    mov   ax,hfy1
    mov   cx,ax
    sub   ax,[edi+2]
    sub   cx,[edi+6]
    xor   ch,ah
    mov   pp,cx
   end;
   if pp<0 then begin
    asm
     mov   pp,ax
     fild  pp
     fmul  dword ptr [ebx]
     fistp pp
     mov   ax,pp
     add   ax,[edi]
     mov   c,ax
    end;
    k:=0; while (k<>j) and (c>=xi[k]) do inc(k);
    if k<j then move(xi[k],xi[succ(k)],(j-k)*sizeof(integer)); xi[k]:=c;
    asm inc j end end;
   asm inc i; add edi,4; add ebx,4 end end;
  i:=0;
  while i<j-1 do begin
   hfx1:=xi[i]; hfx2:=xi[succ(i)]; hlinef;
   if i<j then inc(i); inc(i) end;
  inc(hfy1) end;

 linemode_off; if nzb>0 then zbfill
end;


function AreaSize(x1,y1,x2,y2:integer):longint;
begin AreaSize:=4*(y2-y1+1)*((x2 shr 3)-(x1 shr 3)+1)+8 end;

procedure GetArea(x1,y1,x2,y2:integer; var b);
type tb=array[0..64000] of byte;
     tw=array[0..32000] of word;
var  p:^tb; x,z1,z2,w,l:integer; m:byte; y,k,ega:word;
begin
 {exchange ???}
 z1:=x1 shr 3; z2:=x2 shr 3;
 w:=y2-y1+1;   l:=z2-z1+1;
 tw(b)[0]:=x1; tw(b)[1]:=y1;
 tw(b)[2]:=l;  tw(b)[3]:=w;

 p:=@tb(b)[8]; k:=0;

 for m:=0 to 3 do begin
  asm mov ax,0004h; mov ah,m; mov ega,ax end;
  portw[$3CE]:=ega;
  PixAddr:=VioBufOfs+y1*80;
  for y:=y1 to y2 do begin
   for x:=z1 to z2 do begin
    tb(p^)[k]:=mem[PixAddr+x]; inc(k) end;
  inc(PixAddr,80) end end;
 portw[$3c4]:=$FF02
end;

procedure PutArea(x1,y1:integer; var b);
type tb=array[0..64000] of byte;
     tw=array[0..32000] of word;
var  p:^tb; x,xn,yn,y2,z1,z2,w,l:integer; m,c:byte; y,k,ega:word;
begin
 xn:=tw(b)[0]; yn:=tw(b)[1];
 l:=tw(b)[2];  w:=tw(b)[3];
 z1:=x1 shr 3; z2:=z1+l-1;
 y2:=y1+w-1;

 p:=@tb(b)[8]; k:=0;

 for m:=0 to 3 do begin
  asm mov dl,1; mov cl,m; shl dl,cl;
      mov ax,0002h; mov ah,dl; mov ega,ax end;
  portw[$3C4]:=ega;
  PixAddr:=VioBufOfs+y1*80;
  for y:=y1 to y2 do begin
   for x:=z1 to z2 do begin
    mem[PixAddr+x]:=tb(p^)[k]; inc(k) end;
  inc(PixAddr,80) end end;
  portw[$3c4]:=$FF02
end;


procedure Cursor;
var j,l,m,x,y:integer; c:byte;
begin
 c:=fcolor; setcolor(15); setwritemode(1); pixelmode_on;
 x:=(whx-1)*8; y:=(why-1)*(fontheight+2);
 for l:=0 to fontheight+1 do for j:=0 to 7 do pixel(x+j,y+l);
 setwritemode(0); pixelmode_off; setcolor(c)
end;


procedure MoveCross(ch:char; fkl:boolean);
procedure Cross; begin vline0(crx,cry-9,cry+9); hline(crx-9,crx+9,cry) end;
var c,l:byte;
begin
 c:=fcolor; l:=liwi; liwi:=1; setcolor(15); pxm:=false;
 setwritemode(1); pixelmode_on; if ch<>#0 then Cross;
 if fkl then case ch of
  #77: if crx<639-crs then inc(crx,crs);
  #75: if crx>    crs then dec(crx,crs);
  #80: if cry<479-crs then inc(cry,crs);
  #72: if cry>    crs then dec(cry,crs) end
        else case ch of
  '1': crs:=1; '2': crs:=4; '3': crs:=9; '4': crs:=16; '5': crs:=25 end;
 Cross; setwritemode(0); pixelmode_off; setcolor(c); pxm:=true; liwi:=l
end;


procedure GrafFont(r:byte);
var f:file; s:string[2]; db:integer;
begin
 if not (r in [14,16,24]) then exit;
 str(r:2,s); fontheight:=r; fontheight0:=r-1; ntextrow:=480 div r;
 case r of 14: db:=3584; 16: db:=4096; 24: db:=6144 end;
 assign(f,gfdir+'csa'+s+'.fnt'); reset(f,db);
 blockread(f,gfont,1); close(f);
end;

procedure CesChar(ch:char);
const m2:array[0..7] of byte = (128,64,32,16,8,4,2,1);
type tp = array[0..6144] of byte;
var j,k,l,m,px,py,x,y:integer; p:pointer; c:byte;
begin
 p:=@gfont; x:=(whx-1)*8; y:=(why-1)*(fontheight+2)+1;
  k:=ord(ch)*fontheight; m:=x+8;
  for l:=0 to fontheight0 do
   for j:=0 to 7 do begin
    px:=m+j; py:=y+l;
    if (tp(p^)[k+l] and m2[j]) = m2[j] then c:=fcolor else c:=bcolor;
    putpixel(px,py,c) end;
 if whx<80 then inc(whx)
end;

procedure CesTextC(x,y:integer; s:s127; d:boolean);
const m2:array[0..7] of byte = (128,64,32,16,8,4,2,1);
type tp = array[0..6144] of byte;
var i,j,k,l,m,i8,px,py:integer; p:pointer; c:byte;
begin
 p:=@gfont;
 for i:=1 to length(s) do begin
  k:=ord(s[i])*fontheight;
  i8:=(i-1)*8; if d then m:=x+i8 else m:=y-i8;
  for l:=0 to fontheight0 do
   for j:=0 to 7 do begin
    if d then begin px:=m+j; py:=y+l end
         else begin px:=x+l; py:=m-j end;
    if (tp(p^)[k+l] and m2[j]) = m2[j] then c:=fcolor else c:=bcolor;
    putpixel(px,py,c) end end;
end;

procedure CesTextF(x,y:byte; s:s127);
type tp = array[0..6144] of byte;
var i,j,k,l:integer; li:array[1..80] of byte; b:^byte; p:pointer;
begin
 linemode_on;
 p:=@gfont; l:=length(s);
 b:=ptr(VioBufOfs+(y-1)*80*(fontheight+2)+(x-1));
 fillchar(b^,l,0); inc(b,80);
 for j:=0 to fontheight0 do begin
  for i:=1 to l do begin
   k:=ord(s[i])*fontheight; li[i]:=tp(p^)[k+j] end;
  move(li[1],b^,l); inc(b,80) end;
 fillchar(b^,l,0);
 linemode_off
end;

procedure ClrText(x,y,d:byte);
var i,b:byte; p:^byte;
begin
 linemode_on;
 if x+d>81 then dec(d,x+d-81);
 p:=ptr(VioBufOfs+(y-1)*80*(fontheight+2)+(x-1));
 for i:=1 to fontheight+2 do begin fillchar(p^,d,byte(rst)); inc(p,80) end;
 linemode_off
end;

procedure ClrEolG;
begin ClrText(whx,why,80) end;

procedure GotoXYG(x,y:byte);
begin whx:=x; why:=y end;

procedure WriteG(s:s127);
var l,c:byte;
begin
 l:=length(s);
 if whx+l>80 then begin l:=81-whx; s[0]:=char(l) end;
 CesTextF(whx,why,s); whx:=whx+l
end;

procedure WriteGn(s:s127);
begin writeg(s); whx:=1; if why<ntextrow then inc(why) end;


procedure LineFont(l:byte);
var s:string[1]; f:file; n:integer;
begin
 if not (l in [0,1]) then exit; str(l:1,LFont);
 assign(f,gfdir+'ZNC'+Lfont); reset(f,1);
 blockread(f,n,2); blockread(f,plfont[32],n*2);
 blockread(f,blfont,filesize(f)-(n+1)*2);
 close(f); {n:=n+31;}
end;

procedure CesLText(x0,y0:integer; s:s127; zv:single; d:boolean);
var i,j,k,l,x,y:integer; m:shortint; mv:boolean;

begin
 l:=length(s);
 for i:=1 to l do begin
  k:=ord(s[i]);
  k:=plfont[k];
  while blfont[k+1]<127 do begin
   inc(k); m:=blfont[k];
   mv:=false; if m<0 then begin mv:=true; m:=-m end;
   x:=m mod 5; y:=m div 5;
   x:=round(x*zv); y:=round((y-3)*zv);
   if not d then begin j:=x; x:=-y; y:=j end;
   if mv then moveto(x0+x,y0-y) else lineto(x0+x,y0-y) end;
   if s[i] in ['i','j'] then lineto(x0+x-1,y0-y);
  if d then inc(x0,round(5.5*zv)) else dec(y0,round(5.5*zv)) end;
end;


begin
 liwi:=1; xmvt:=0; ymvt:=0; dot:=false; pxm:=true;
 whx:=1; why:=1; fcolor:=15; bcolor:=0; rst:=$FFFF; nzb:=0;
 crx:=320; cry:=240; crs:=4; ins:=1;
 for i:=0 to 4*360 do
  with cosi[i] do begin
   y:=Round((Sin(i*pi/(4*180.0))+1)*1024);
   x:=Round((Cos(i*pi/(4*180.0))+1)*1024) end;
end.

