/*
 * This is the equivalent demo program that comes with gd-1.8.3
 */
Call RxFuncAdd 'GdLoadFuncs', 'rexxgd', 'GdLoadFuncs'
Call GdLoadFuncs

Parse Version ver
Say 'Rexx/gd version:' gdVariable( 'VERSION' ) 'libgd version:' gdVariable( 'GDVERSION' ) 'on' ver

/* Create output image, 256 by 256 pixels, true color. */
im_out = gdImageCreateTrueColor(256 + 384, 384)

/* First color allocated is background. */
white = gdImageColorAllocate(im_out, 255, 255, 255)

Call gdImageFilledRectangle im_out, 0, 0, gdImageGetWidth( im_out ), gdImageGetHeight( im_out ), white

/* Set transparent color. */
Call gdImageColorTransparent im_out, white

/* Try to load demoin.png and paste part of it into the output image. */

im_in = gdImageCreateFromPng("demoin.png")
If im_in = '' Then
   Do
      Say "Can't load source image; this demo"
      Say "is much more impressive if demoin.png"
      Say "is available."
      im_in = 0
   End
Else
   Do
      /* if we have the rxmath library, do some cool rotations */
/*
      If rxfuncadd( 'mathloadfuncs', 'rxmath', 'mathloadfuncs' ) = 0 Then
         Do
            Call MathLoadFuncs
             * Now copy, and magnify as we do so *
            Call gdImageCopyResampled im_out, im_in, 32, 32, 0, 0, 192, 192, 255, 255
            Do i = 1 To 360 By 45
               cx = RxCalcCos( (i-1) * .0174532925, 'r') * 128
               cy = (RxCalcSin((i-1) * .0174532925, 'r') * 128 ) * -1
               Call gdImageCopyRotated im_out, im_in, 256 + 192 + cx, 192 + cy, 0, 0, gdImageGetWidth(im_in), gdImageGetHeight(im_in), i-1
            End
         End
*/
   End
red = gdImageColorAllocate(im_out, 255, 0, 0)
green = gdImageColorAllocate(im_out, 0, 255, 0)
blue = gdImageColorAllocate(im_out, 0, 0, 255)
yellow = gdImageColorAllocate(im_out, 255, 255,0)
/* Fat Rectangle */
Call gdImageSetThickness im_out, 4
Call gdImageLine im_out, 16, 16, 240, 16, green
Call gdImageLine im_out, 240, 16, 240, 240, green
Call gdImageLine im_out, 240, 240, 16, 240, green
Call gdImageLine im_out, 16, 240, 16, 16, green
Call gdImageSetThickness im_out, 1
/* Circle */
Call gdImageArc im_out, 128, 128, 60, 20, 0, 720, blue
/* Arc */
Call gdImageArc im_out, 128, 128, 40, 40, 90, 270, blue
/* Flood fill */
Call gdImageFill im_out, 8, 8, blue
/* Polygon */
xpoints.1 = 64
ypoints.1 = 0
xpoints.2 = 0
ypoints.2 = 128
xpoints.3 = 128
ypoints.3 = 128
xpoints.0 = 3
ypoints.0 = 3
Call gdImageFilledPolygon im_out, 'xpoints.', 'ypoints.', green
/* 2.0.12: Antialiased Polygon */
Call gdImageSetAntiAliased im_out, green
Do i = 1 To 3
   xpoints.i = xpoints.i + 128
End
Call gdImageFilledPolygon im_out, 'xpoints.', 'ypoints.', 'GDANTIALIASED'
/* Brush. A fairly wild example also involving a line style! */
If im_in \= 0 Then
   Do
      brush = gdImageCreateTrueColor(16, 16)
      Call gdImageCopyResized brush, im_in, 0, 0, 0, 0, gdImageGetWidth(brush), gdImageGetHeight(brush), gdImageGetWidth(im_in), gdImageGetHeight(im_in)
      Call gdImageSetBrush im_out, brush
      /* With a style, so they won't overprint each other.
         Normally, they would, yielding a fat-brush effect. */
      style.1 = 0
      style.2 = 0
      style.3 = 0
      style.4 = 0
      style.5 = 0
      style.6 = 0
      style.7 = 0
      style.8 = 1
      style.0 = 8
      Call gdImageSetStyle im_out, 'style.'
      /* Draw the styled, brushed line */
      Call gdImageLine im_out, 0, 255, 255, 0, "GDSTYLEDBRUSHED"
   End
/* Text (non-truetype) */
fonts.1 = 'GDFONTTINY'
fonts.2 = 'GDFONTSMALL'
fonts.3 = 'GDFONTMEDIUMBOLD'
fonts.4 = 'GDFONTLARGE'
fonts.5 = 'GDFONTGIANT'
y = 0
Do i = 1 To 5
   Call gdImageString im_out, fonts.i, 32, 32 + y, "hi", red
   y = y + gdFontGetHeight( fonts.i )
End
y = 0
Do i = 1 To 5
   Call gdImageString im_out, fonts.i, 64 + y, 64, "hi", red
   y = y + gdFontGetHeight( fonts.i )
End
/*
 * Draw some Freetype text around a circle...
 */
If gdQueryFunction( 'GDIMAGESTRINGFTCIRCLE' ) = 0 Then
   Do
      font = FindAFont()
      ret = gdImageStringFTCircle( im_out, 300, 300, 100, 30, 0.8, font, 40, 'top text', 'bottom text', yellow )
      If ret \= '' Then say ret 'font:' font
   End
Else Say 'No support for GDIMAGESTRINGFTCIRCLE.'
/*
 * Draw some Freetype text horizontally...
 */
If gdQueryFunction( 'GDIMAGESTRINGFT' ) = 0 Then
   Do
      font = FindAFont()
      ret = gdImageStringFT( im_out, 'brect.', red, font, 25, 0, 300, 300, 'middle string' )
      If ret \= '' Then say ret 'font:' font
   End
Else Say 'No support for GDIMAGESTRINGFT.'


/* Random antialiased lines; coordinates all over the image,
   but the output will respect a small clipping rectangle */
Call gdImageSetClip im_out, 0, gdImageGetHeight(im_out) - 100, 100, gdImageGetHeight(im_out)

/* Fixed seed for reproducibility of results */
/*  srand(100);*/
Do i = 1 To 100
   x1 = random() // gdImageGetWidth(im_out)
   y1 = random() // gdImageGetHeight(im_out)
   x2 = random() // gdImageGetWidth(im_out)
   y2 = random() // gdImageGetHeight(im_out)
   Call gdImageSetAntiAliased im_out, white
   Call gdImageLine im_out, x1, y1, x2, y2, 'GDANTIALIASED'
End

/* Make output image interlaced (allows "fade in" in some viewers,
   and in the latest web browsers) */
Call gdImageInterlace im_out, 1
/* Write PNG */
Call gdImagePng im_out, "demoout.png"
If gdQueryFunction( 'GDIMAGEGIF' ) = 0 Then Call gdImageGif im_out, "demoout.gif"
Else Say 'No support for GDIMAGEGIF.'
Call gdImageJpeg im_out, "demoout.jpeg", 8
If gdQueryFunction( 'GDIMAGETRUECOLORTOPALETTE' ) = 0 Then
   Do
      Call gdImageTrueColorToPalette im_out, 0, 256
      Call gdImagePng im_out, "demooutp.png"
   End
Else Say 'No support for GDIMAGETRUECOLORTOPALETTE.'
Call gdImageDestroy im_out
If im_in \= 0 Then Call gdImageDestroy im_in
return 0

FindAFont:
/*
 * Find a suitable FreeType font
 */
fonts = 'VeraBd verdanab'
Parse Source os .
Select
   When os = 'WIN32' | os = 'WindowsNT' | os = 'Windows95' Then
      Do
         font = 'c:\windows\fonts\verdanab.ttf'
      End
   When os = 'OS/2' | os = 'OS2' Then
      Do
         font = 'c:\psfonts\mtsansdj.ttf'
      End
   Otherwise
      Do
         If Value( 'GDFONTPATH', , 'ENVIRONMENT' ) = '' Then font = '' /* no font */
         Else
            Do
               fp = Value( 'GDFONTPATH', , 'ENVIRONMENT' )
               Do Forever
                  Parse Var fp dir ':' fp
                  If Right( dir, 1 ) \= '/' Then dir = dir'/'
                  Do i = 1 To Words( fonts )
                     ffn = dir||Word( fonts, i )||'.ttf'
                     If Stream( ffn, 'C', 'QUERY EXISTS' ) \= '' Then
                        Do
                           font = ffn
                           fp = ''
                           Leave i
                        End
                  End
                  If fp = '' Then Leave
               End
            End
      End
End
Return font
