#define INCL_WIN
#include <os2.h>
#include <string.h>
#include <stdio.h>
#include "calendar.h"
#include "calres.h"

extern "C" {
MRESULT EXPENTRY DlgWndProc(HWND hwnd, ULONG ulMsg, MPARAM mp1, MPARAM mp2);
}

int main(void)
{
	HAB	hab;
	HMQ	hmq;
	
	hab = WinInitialize(0);
	hmq = WinCreateMsgQueue(hab, 0);

	WinDlgBox(HWND_DESKTOP,HWND_DESKTOP,DlgWndProc, NULLHANDLE,
	            DLG_DEMO, NULL );
	
	WinDestroyMsgQueue(hmq);
	WinTerminate(hab);
	return(0);
}



MRESULT EXPENTRY DlgWndProc(HWND hwnd, ULONG ulMsg, MPARAM mp1, MPARAM mp2)
{
	char	tmp[60];
	
	switch(ulMsg)
	{
		case WM_COMMAND:
		if(SHORT1FROMMP(mp1) == BTN_CALENDAR)
		{
         Date d;
			Calendar *cal;
			
			//Stop multipule instance
			WinEnableControl(hwnd, BTN_CALENDAR, FALSE);

			cal = new Calendar;
			cal->show();
			cal->getDate(&d);
			sprintf(tmp, "%s, %i %s %i", d.dow, d.day, d.mnth, d.year);
			WinSetWindowText(WinWindowFromID(hwnd, EF_DATE), tmp);
			delete cal;
			WinEnableControl(hwnd, BTN_CALENDAR, TRUE);
			// keep dialog alive
			return MRFROMSHORT(TRUE);
		}
		default:
		 
		return WinDefDlgProc(hwnd, ulMsg, mp1, mp2);
	}
}

