{
HALKBD provides REXX with access to OS/2's Kbd... functions.
}

Library halkbd;

{$CDecl+,OrgName+,I-,S-,Delphi+,Use32+}

Uses
  Dos, Os2Def, Rexx, Strings, Os2Base;

{$LINKER
  DESCRIPTION      "HALKBD - Access to OS/2's Kbd... functions for REXX"
  DATA MULTIPLE NONSHARED

  EXPORTS
    HALKBDCHARIN        = HALKbdCharIn
    HALKBDFLUSHBUFFER   = HALKbdFlushBuffer
    HALKBDFREEFOCUS     = HALKbdFreeFocus
    HALKBDPEEK          = HALKbdPeek
    HALKBDLOADFUNCS     = HALKbdLoadFuncs
}

Const FunctionTable : Array[ 0..3 ] of pChar =
(
  'HALKbdCharIn',
  'HALKbdFlushBuffer',
  'HALKbdFreeFocus',
  'HALKbdPeek'
);

Function HALKbdLoadFuncs( FuncName : PChar; ArgC : ULong; Args : pRxString; QueueName : pChar; Var Ret : RxString ) : ULong; export;
Var
  j       : Integer;
begin
  Ret.strLength := 0;
  If ArgC > 0 then                        { Do not allow parameters }
    HALKbdLoadFuncs := 40
  else
    begin
      For j := Low( FunctionTable ) to High( FunctionTable ) do
        RexxRegisterFunctionDLL( FunctionTable[j],
                                 'HALKBD',
                                 FunctionTable[j] );
      HALKbdLoadFuncs := 0;
    end;

end;

Function Str2Int( s : String) : Integer;
var
  int,i : Integer;
begin
  int:=0;
  for i := 1 to length(s) do
    int:=int*10+ord(s[i])-ord('0');
  Str2Int:=int;
end;

Function HALKbdFlushBuffer( FuncName : PChar; ArgC : ULong; Args : pRxString; QueueName : pChar; Var Ret : RxString ) : ULong; export;
var
  handle : Integer;
begin
  If ArgC < 1 then handle:=0 {If no args, get from stdin}
  else handle:= Str2Int(StrPas( Args^.strptr ));
  KbdFlushBuffer(handle);
  HALKbdFlushBuffer:=0;
end;

Function HALKbdCharIn( FuncName : PChar; ArgC : ULong; Args : pRxString; QueueName : pChar; Var Ret : RxString ) : ULong; export;
var
  Key : KbdKeyInfo;
  wait : Integer;
  s,tmp : String;
  handle : Integer;
begin
  If ArgC < 1 then wait:=0 {If no args, wait for key}
  else begin wait:= Str2Int(StrPas( Args^.strptr )); Inc(Args); end;
  If ArgC < 2 then handle:=0 {If 0 or 1 args, get from stdin}
  else begin handle:= Str2Int(StrPas( Args^.strptr )); Inc(Args); end;
  KbdCharIn(Key, wait, handle);
  Ret.strLength := 0;
  str( Key.fsState, s );
  tmp:=s;
  str( Key.chScan, s );
  tmp:=tmp+'~'+s;
  str( ord(Key.chChar), s );
  tmp:=tmp+'~'+s;
  strpcopy( Ret.strptr, tmp );
  Ret.strLength := strlen(Ret.strptr);
  HALKbdCharIn := 0;
end;

Function HALKbdPeek( FuncName : PChar; ArgC : ULong; Args : pRxString; QueueName : pChar; Var Ret : RxString ) : ULong; export;
var
  Key : KbdKeyInfo;
  s,tmp : String;
  handle : Integer;
begin
  If ArgC < 1 then handle:=0 {If no args, get from stdin}
  else handle:= Str2Int(StrPas( Args^.strptr ));
  KbdPeek(Key,handle);
  Ret.strLength := 0;
  str( Key.fsState, s );
  tmp:=s;
  str( Key.chScan, s );
  tmp:=tmp+'~'+s;
  str( ord(Key.chChar), s );
  tmp:=tmp+'~'+s;
  strpcopy( Ret.strptr, tmp );
  Ret.strLength := strlen(Ret.strptr);
  HALKbdPeek := 0;
end;

Function HALKbdGetFocus( FuncName : PChar; ArgC : ULong; Args : pRxString; QueueName : pChar; Var Ret : RxString ) : ULong; export;
var
  handle : Integer;
  wait : Integer;
begin
  If ArgC < 1 then handle:=0 {If no args, get from stdin}
  else begin
    handle:= Str2Int(StrPas( Args^.strptr ));
    inc(args);
    if argc<2 then wait:=0
    else wait:= Str2Int(StrPas( Args^.strptr ));
  end;
  KbdGetFocus(wait,handle);
  Ret.strLength := 0;
  result := 0;
end;

Function HALKbdFreeFocus( FuncName : PChar; ArgC : ULong; Args : pRxString; QueueName : pChar; Var Ret : RxString ) : ULong; export;
var
  handle : Integer;
begin
  If ArgC < 1 then handle:=0
  else handle:= Str2Int(StrPas( Args^.strptr ));
  KbdFreeFocus(handle);
  result:=0;
end;

initialization
end.

