/* example of clipboard functions
 * $Header: C:/ptjm/rexx/w32funcs/RCS/clipex.rex 1.1 2003/02/27 16:39:46 ptjm Rel $
 */

call rxfuncadd 'w32loadfuncs', 'w32util', 'w32loadfuncs'
call w32loadfuncs

/* see if there's anything in the clipboard right now */

if w32ClipGetStem('x') then
  say 'replacing text starting with' x.1

/* open the clipboard to make everything else atomic */
if \w32ClipOpen() then do
  say 'unable to open clipboard'
  exit 1
  end

/* remove the current data */
call w32ClipEmpty


/* and write data in two formats: RTF and text */

call w32ClipSet '{\rtf This is a {\i great} example.\par}', 'Rich Text Format'

if result \= 0 then
  say 'error' result 'setting RTF data'

call w32ClipSet 'This is a great example'

if result \= 0 then
  say 'error' result 'setting text data'


call w32ClipClose

/* normally this bit would be in a different program ... */

if w32ClipEnumFormat('fmts.') then
  do i = 1 to fmts.0
    say w32ClipFormatName(fmts.i)
    end
