/* program to list the paragraphs in a word document
 * copyright 2001 patrick tj mcphee
 * disributed under the mozilla public licence
 * $Header: C:/ptjm/rexx/w32funcs/RCS/enumword.rex 1.1 2001/12/23 07:37:56 pmcphee Rel $
 */

if rxfuncadd('w32loadfuncs','w32util','w32loadfuncs') > 0 then do
  say rxfuncerrmsg()
  exit 1
  end
call w32loadfuncs

signal on halt
signal on syntax name halt
signal on error name halt

wrd = w32createobject('Word.Application')

if wrd = 0 | wrd = '' then do
 say 'wrd:' w32olegeterror()
 exit 1
 end

/*
docs = w32getsubobj(wrd, 'Documents')
if docs = 0 | docs = '' then do
  say 'docs:' w32olegeterror()
  call w32olecleanup
  exit 1
  end

doc = w32olenext(docs)
do while doc \= 0
*/

doc = w32getsubobj(wrd, 'ActiveDocument')

if doc = 0 | doc = '' then do
 say 'doc:' w32olegeterror()
 call w32olecleanup
 exit 1
 end

/* now walk through the entire list of paragraphs and print them to
 * a file */

graphs = w32getsubobj(doc, 'Paragraphs')

graph = w32olenext(graphs)

/* look up names now so we don't have to do it repeatedly */
if graph \= 0 then do
  idRange = w32olegetid(graph, 'Range')
  range = w32getsubobj(graph, idRange)
  idText = w32olegetid(range, 'Text')
  call w32releaseobject range
  end

do while graph \= 0
  range = w32getsubobj(graph, idRange);
  text = w32getproperty(range, idText)
  say text
  call w32releaseobject graph,range
  graph = w32olenext(graphs)
  end

call w32releaseobject graphs, doc, wrd

exit 0

/* need to call w32olecleanup, or the calling application can never exit */
halt:
   say sigl condition('Description')
   call w32olecleanup
   return
