# makefile for ptjmc.exe
#  The contents of this file are subject to the Mozilla Public License
#  Version 1.0 (the "License"); you may not use this file except in
#  compliance with the License. You may obtain a copy of the License at
#  http://www.mozilla.org/MPL/

#  Software distributed under the License is distributed on an "AS IS"
#  basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
#  License for the specific language governing rights and limitations
#  under the License.

#  The Original Code is regutil.

#  The Initial Developer of the Original Code is Patrick TJ McPhee.
#  Portions created by Patrick McPhee are Copyright  2003
#  Patrick TJ McPhee. All Rights Reserved.

#  Contributors:

# $Header: C:/ptjm/rexx/w32funcs/RCS/ptjmc.mak 1.4 2003/02/27 17:37:11 ptjm Rel $

OPT=-Ox -G5
DEBUG=#-Zi
CFLAGS=-MD $(OPT) $(DEBUG)
CC=cl

all : ptjmc.exe wrevlog.dll

ptjmc.exe : ptjmc.obj ptjmc.res
	$(CC) $(CFLAGS) ptjmc.obj ptjmc.res -optjmc.exe

ptjmc.obj : ptjmc.c
	$(CC) $(CFLAGS) -c ptjmc.c

ptjmc.res : ptjmc.rc w32ver.h
	rc ptjmc.rc

ptjmc.c : ptjmc.l
	flex -optjmc.c ptjmc.l

wrevlog.res : wrevlog.rc wrevlog.bin
	rc wrevlog.rc

wrevlog.h wrevlog.rc wrevlog.bin : wrevlog.mc
	ptjmc wrevlog.mc

wrevlog.dll : wrevlog.res
	link /dll wrevlog.res msvcrt.lib

clean :
	-del ptjmc.exe ptjmc.c ptjmc.obj ptjmc.res wrevlog.rc wrevlog.dll\
 wrevlog.h wrevlog.bin wrevlog.res
