;;
;; sample message file for the ptjmc message compiler
;;
;; compile with ptjmc <file>.mc
;; build message dll with
;;  windres <file>.rc <file>.o
;;  ld -dll -o <file>.dll <file>.o
;;
;; where windres and ld are part of the mingw toolkit
;; $Header: C:/ptjm/rexx/w32funcs/RCS/wrevlog.mc 1.2 2003/02/27 18:52:32 ptjm Rel $

FacilityNames=(Runtime=1
               Catalogue=2
              )

;;
;; category definitions -- these use Severity Success and no Facility, so the
;; messageid ends up the same as the FacilityName definition
;;

MessageId=1
Severity=Success
Language=English
Runtime%0
.
MessageId=2
Severity=Success
Language=English
Catalogue%0
.

;;
;; actual message definitions
;;

;; start and stop
MessageId=3
Severity=Success
SymbolicName=MSG_STARTUP
Language=English
Rexx example program starting.
.
MessageId=4
Severity=Success
SymbolicName=MSG_ENDING
Language=English
Rexx example program ending.
.

;;
;; here are a warning and an error message which refer to the same problem,
;; so they use the same id. I suggest restricting things like this to
;; cases when the user is able to determine the severity of problems

MessageId=101
Severity=Warning
SymbolicName=MSG_BAD_THING_WARNING
Language=English
Something has gone wrong at %1, but not so terribly wrong that you should
feel overly concerned. You might want to check on things, though.
.
MessageId=101
Severity=Error
SymbolicName=MSG_BAD_THING_ERROR
Language=English
Something has gone wrong at %1, and the situation is horrible. Be afraid.
Be very afraid.
.

;; I think it's a good idea to put messages for different components into
;; different ranges. You might want to have shared ranges for common sorts
;; of messages, for instance if each component has a start-up message, it
;; might be 1 for all (but note that you need to define a separate message
;; due to the way messages are resolved). Keep in mind how irritating it is
;; to have too many messages in your log.

;; this shows that the arguments can be repeated
MessageId=1001
Severity=Success
Facility=Runtime
SymbolicName=MSG_RUNTIME_USER
Language=English
Running under user %1. I repeat, user %1.
.

;; this shows that the arguments can come in any order
MessageId=2001
Severity=Success
Facility=Catalogue
SymbolicName=MSG_CATALOGUE_VERSION
Language=English
The clipboard contains the text %2. Running under version %1.
.
