;Variable lister - usage:
;DO WHILE VARLIST("NAME","VALUE")=0
;	SAY NAME VALUE
;END
;
;VARLIST() lists all variables on first call, storing them in memory; on all calls (first and subsequent) stores data in variables and returns zero, or returns error code.

%include "..\s2macros.asm" ;Handy macros

section _TEXT class=CODE use32 flat

func VARLIST
mov eax,[ebp+0Ch] ;Get argc in eax
sub eax,2
jnz near .err
cmp dword[VarCount],0
jnz near .justreturn
;There aren't any variable names stored, so fetch from RexxVariablePool
mov dword[UsedCount],0
.getvars:
callos2 RexxVariablePool,ListVarPool

or eax,eax
jnz near .justreturn
mov edi,[VarCount]
inc dword[VarCount]
cmp edi,MaxVars
jae near .justreturn
shl edi,4
add edi,Vars
mov eax,[ListVarPool.namelen]
stosd
mov eax,[ListVarPool.nameptr]
stosd
mov eax,[ListVarPool.vallen]
stosd
mov eax,[ListVarPool.valptr]
stosd
;Free memory and clear pointers
mov dword[ListVarPool.nameptr],0
mov dword[ListVarPool.namelen],0
mov dword[ListVarPool.namealloc],0
mov dword[ListVarPool.valptr],0
mov dword[ListVarPool.vallen],0
mov dword[ListVarPool.valalloc],0
jmp .getvars

.justreturn:
dec dword[VarCount]
mov esi,[UsedCount]
inc dword[UsedCount]
shl esi,4
add esi,Vars

;Now return the values into the specified variables
mov ebx,[ebp+10h]
mov eax,[ebx]
mov [SetVarPool1.namelen],eax
mov eax,[ebx+4]
mov [SetVarPool1.nameptr],eax
mov edi,SetVarPool1.vallen
movsd
movsd

mov ebx,[ebp+10h]
mov eax,[ebx+8]
mov [SetVarPool2.namelen],eax
mov eax,[ebx+12]
mov [SetVarPool2.nameptr],eax
mov edi,SetVarPool2.vallen
movsd
movsd

callos2 RexxVariablePool,SetVarPool1 ;Do both SETs at once

callos2 DosFreeMem,[SetVarPool1.valptr]
callos2 DosFreeMem,[SetVarPool2.valptr]

.fin:
mov eax,[VarCount]
;mov eax,[UsedCount]
;mov eax,[SetVarPool2.vallen]
jmp returneax

.err:
mov esp,ebp
pop ebp
ret

returneax: ;JMP here after setting EAX to return that value (for REXX-callable external function)
mov ebx,[ebp+18h]
mov edi,[ebx+4]
..@storenum:
mov ebx,10 ;Return in decimal - change this for diff radix, but if >10 must uncomment code for alpha digits
xor ecx,ecx
.moredigits:
xor edx,edx
div ebx
push edx
inc ecx
or eax,eax
jnz .moredigits
mov ebx,[ebp+18h]
mov [ebx],ecx
.getdigits:
pop eax
add al,0x30
;Below four lines for alpha digits
;cmp al,0x39
;jbe .notalpha
;add al,7
;.notalpha:
;End alpha digit code
stosb
loop .getdigits
xor eax,eax
mov esp,ebp
pop ebp
ret

section _DATA dword public class=DATA use32 flat
ListVarPool:
.next dd 0
.namelen dd 0
.nameptr dd 0
.vallen dd 0
.valptr dd 0 ;Let OS/2 allocate buffers
.namealloc dd 0
.valalloc dd 0
.code db 6 ;RXSHV_NEXTV
.ret db 0

SetVarPool1:
.next dd SetVarPool2
.namelen dd 0
.nameptr dd 0
.vallen dd 0
.valptr dd 0
.namealloc dd 0
.valalloc dd 0
.code db 0 ;RXSHV_SET
.ret db 0

SetVarPool2:
.next dd 0
.namelen dd 0
.nameptr dd 0
.vallen dd 0
.valptr dd 0
.namealloc dd 0
.valalloc dd 0
.code db 0 ;RXSHV_SET
.ret db 0

VarCount dd 0
UsedCount dd 0
MaxVars equ 1272 ;Reserve space for 1272 vars - each one needs 4 dwords (namelen, nameptr, vallen, valptr)
Vars resd MaxVars*4
