#include <kentryfd.hpp>
#include <kvalid.hpp>
#include <istring.hpp>


KEntryField::KEntryField(unsigned long id,
                  IWindow *wndParent,
                  IWindow *wndOwner,
                  const IRectangle &initial,
                  const IResourceId &resText,
                  const IEntryField::Style style)
  : IEntryField(id, wndParent, wndOwner, initial, style)
  , _validator(0)
{
   setText(resText);
}

KEntryField::KEntryField(unsigned long id,
                  IWindow *wndParent,
                  IWindow *wndOwner,
                  const IRectangle &initial,
                  const IEntryField::Style style)
  : IEntryField(id, wndParent, wndOwner, initial, style)
  , _validator(0)
{
}

KValidator* KEntryField::validator() const
{
   return _validator;
}

KEntryField& KEntryField::setValidator(KValidator *val) 
{ 
   _validator = val;
   return *this;
}

Boolean KEntryField::validate(unsigned long pos)
{
   if (validator())
     return validator()->isValid(text());
}

ITextControl &KEntryField::setText(const IResourceId &text)
{
  return Inherited::setText(text);
}

ITextControl &KEntryField::setText(const char *text)
{
  IString string(text);

//  if (validator())
//    validator()->fill(string);

  return Inherited::setText(string);
}

IString KEntryField::text() const
{
  IString string(Inherited::text());

  if (validator())
    validator()->strip(string);

  return string;
}
