#include <kvaldate.hpp>
#include <ikeyevt.hpp>
#include <kentryfd.hpp>
#include <istring.hpp>
#include <istrtest.hpp>
#include <ctype.h>
#include <iexcept.hpp>
#include <iprofile.hpp>
#include <idate.hpp>

KDateValidator::Settings KDateValidator::settings;

KDateValidator::Settings::Settings()
{
   // get the date separator character from the profile
   // default to "-"
   try
   {
      separator = IProfile::userProfile().elementWithKey("sDate", 
                                                      "PM_National");
   }
   catch(...)
   {
      separator = "-";
   }
   mask = "99" + separator + "99" + separator + "99";

   // get the date format from the profile
   // default to 0
   unsigned dateFormat;
   try
   {
      IProfile::userProfile().elementWithKey("iDate", 
                                             "PM_National").asUnsigned();
   }
   catch(...)
   {
     dateFormat = 0;
   }

   // set up the position indexes
   switch(dateFormat)
   {
      case 0:      // MM/DD/YY
         dayPos = 3;
         monthPos = 0;
         yearPos = 6;
         break;

      case 1:     // DD/MM/YY
         dayPos = 0;
         monthPos = 3;
         yearPos = 6;
         break;

      case 2:     // YY/MM/DD
         dayPos = 6;
         monthPos = 3;
         yearPos = 0;
         break;

      default:
         break;
   }
}

KDateValidator::KDateValidator()
  : KMaskValidator(settings.mask)
{
}

Boolean KDateValidator::isValid(const char *text, Boolean fill) const
{
   if (!Inherited::isValid(text, fill))
      return false;

   IString strText(text);
   int nDay = strText.subString(settings.dayPos, 2).asUnsigned();
   IDate::Month month = (IDate::Month)strText.subString(settings.monthPos, 2).asUnsigned();
   int nYear = strText.subString(settings.yearPos, 2).asUnsigned();
   return IDate::isValid(month, nDay, nYear+1900);
}
