#ifndef _KVALID_
#define _KVALID_

#ifndef _IKEYHDR_
   #include <ikeyhdr.hpp>
#endif

class IKeyboardEvent;

/*----------------------------------------------------------------------
 * Class: KValidator
 *
 * Implementation File: kvalid.cpp
 *
 * Base Class: Derived from IKeyboardHandler
 *
 * Purpose: Serves as a base class for entry field validator classes.  
 *          Derived classes implement only the functions necessary to
 *          validate the content of characters entered by the user and
 *          the overall format of the data in the entry field.
 *
 * Notes:  KValidator objects may or may not be used as event handlers
 *         for entry fields.  If they are not used as an event handler,
 *         the string validation function is used for field-level 
 *         validation.
 *--------------------------------------------------------------------*/
class _Export KValidator : public IKeyboardHandler
{
   typedef IKeyboardHandler Inherited;
   public:
      virtual ~KValidator();
      virtual void error();
      virtual Boolean isValid(const char *text, Boolean fill=false) const;
      virtual IString &strip(IString &text);
      virtual IString &fill(IString &text);

   protected:
      KValidator(Boolean val=true);
      virtual Boolean characterKeyPress(IKeyboardEvent& event);
      virtual Boolean virtualKeyPress(IKeyboardEvent& event);
      virtual Boolean test(int c) const;

   private:
      Boolean validateContentOnChar;
};


/*----------------------------------------------------------------------
 * Class: KAlphaValidator
 *
 * Implementation File: kvalid.cpp
 *
 * Base Class: Derived from KValidator
 *
 * Purpose: Allows only alphabetic and space characters in an entry
 *          field.  
 *
 * Notes:
 *--------------------------------------------------------------------*/
class _Export KAlphaValidator : public KValidator
{
   typedef KValidator Inherited;

   public:
      KAlphaValidator();

   protected:
      virtual Boolean test(int c) const;
};


/*----------------------------------------------------------------------
 * Class: KNumericValidator
 *
 * Implementation File: kvalid.cpp
 *
 * Base Class: Derived from KValidator
 *
 * Purpose: Allows only numeric characters and a leading sign in an 
 *          entry field.  
 *
 * Notes:
 *--------------------------------------------------------------------*/
class _Export KNumericValidator : public KValidator
{
   typedef KValidator Inherited;

   public:
      KNumericValidator();
      void enableSign(Boolean val);
      void disableSign();

   protected:
      virtual Boolean isValid(const char *text,
                              Boolean fill=false) const;
      virtual Boolean test(int c) const;

   private:
      Boolean allowSign;
};


/*----------------------------------------------------------------------
 * Class: KAlphaNumericValidator
 *
 * Implementation File: kvalid.cpp
 *
 * Base Class: Derived from KValidator
 *
 * Purpose: Allows only numeric characters and a leading sign in an 
 *          entry field.  
 *
 * Notes:
 *--------------------------------------------------------------------*/
class _Export KAlphaNumericValidator : public KValidator
{
   typedef KValidator Inherited;

   public:
      KAlphaNumericValidator();

   protected:
      virtual Boolean test(int c) const;
};


/*----------------------------------------------------------------------
 * Class: KRealValidator
 *
 * Implementation File: kvalid.cpp
 *
 * Base Class: Derived from KValidator
 *
 * Purpose: Allows real numbers in an entry field.  Valid format for a
 *          real number is:
 *        
 *          [sign][digits][.digits][{e|E|d|D}[sign]digits]
 *
 * Notes:
 *--------------------------------------------------------------------*/
class _Export KRealValidator : public KValidator
{
   typedef KValidator Inherited;

   public:
      KRealValidator();

   protected:
      virtual Boolean isValid(const char *text, 
                              Boolean fill=false) const;
      virtual Boolean test(int c) const;
};

#endif

