//===============================================================
// vcmdpane.h - Command Pane class .h file - Windows
//
// Copyright (C) 1995,1996  Bruce E. Wampler
//
// This file is part of the V C++ GUI Framework, and is covered
// under the terms of the GNU Library General Public License,
// Version 2. This library has NO WARRANTY. See the source file
// vapp.cxx for more complete information about license terms.
//===============================================================

#ifndef VCMDPANE_H
#define VCMDPANE_H

#include <v/v_defs.h>

#include <v/vpane.h>		// we are derived from a pane
#include <v/vcmdprnt.h>		// and from cmdParent

/* Undocumented WinDrawBorder flags - use with extreme care!!!! */
#define DB_RAISED       0x0400
#define DB_DEPRESSED    0x0800
#define DB_TROUGH       0x1000
#define DB_FENCE        0x2000
#define DB_FIELD        0x4000
#define DB_CORNERBORDER 0x8000


  class vWindow;		// we are part-of a vWindow

  class vCommandPane : public vPane, public vCmdParent
  {
    friend vCommandPane* vGetLowestCmdPane();
    friend void vSetShownCmdPane(HWND MdiWindow, int OnOff);
    friend class vApp;
    friend class vWindow;

    public:		//---------------------------------------- public

      vCommandPane(CommandObject* cList);
      vCommandPane(vStatus* s_bar);		// status bar version
      ~vCommandPane();

      virtual void ProcessCmd(ItemVal id, ItemVal rv, CmdType ct);
      virtual void initialize(vWindow* pWin, HWND mdiChildWin);
      virtual void ShowPane(int OnOrOff);

      // Windows utility

      int DynamicDlgProc(HWND hDlg, UINT uMsg, MPARAM mp1, MPARAM mp2);

    protected:	//--------------------------------------- protected

      virtual int GetPaneValue(ItemVal id, int& val);
      virtual void SetPaneValue(ItemVal id, int val, ItemSetType setType);
      virtual void SetPaneString(ItemVal id, char* str);


    private:		//--------------------------------------- private

      int OnInitDialog (HWND hwnd, MPARAM mp1, MPARAM mp2);
      void OnEnable (HWND hwnd, BOOL fEnable);
      int OnPaint (HWND hwnd);
      void OnCommand (vCmd *UseThis, int uMsg, MPARAM mp1, MPARAM mp2);

      CommandObject* _origList;	      // handle to list of commands
      CommandObject* _cmdObj;	      // for translated status pane
      int _cmdObjCount;

      HWND _barHwnd;                  // handle of bar
      HWND _hOwner;                   // handle of bar owner

      int _isDisplayed;		      // set if pane is visible
//      int _isShown;		        // If it has been drawn
      int _TextInActive;

  };
#endif
