//===============================================================
// vwinprtr.h: Windows Printer class .h file - Windows
//
// Copyright (C) 1995,1996  Bruce E. Wampler
//
// This file is part of the V C++ GUI Framework, and is covered
// under the terms of the GNU Library General Public License,
// Version 2. This library has NO WARRANTY. See the source file
// vapp.cxx for more complete information about license terms.
//===============================================================

#ifndef VWINPRTR_H
#define VWINPRTR_H

#include <v/v_defs.h>
#include <v/vmodald.h>

#define vPaperLetter 0
#define vPaperLegal 1
#define vPaperTabloid 2
#define vPaperLedger 3
#define vPaperStatement 4
#define vPaperExecutive 5
#define vPaperA3 6
#define vPaperA4 7
#define vPaperA5 8
#define vPaperB4 9
#define vPaperB5 10
#define vPaperFolio 11
#define vPaperQuarto 12
#define vPaper10x14 13

#define vPaperDefault vPaperLetter              // Index to default paper

// this stuff specific to OS/2 printers
#define MAX_DEVICENAME        32
#define MAX_QUEUENAME         10
#define MAX_QUEUEDESC         64
#define MAX_DRIVERNAME        128
#define MAX_BUFF              256

#define QUEUENAME_LENGTH      10
#define QUEUEDESC_LENGTH      64
#define DEVICENAME_LENGTH     32
#define DRIVERNAME_LENGTH     128

  class vWinPrinter
  {
    public:           //---------------------------------------- public
      vWinPrinter();
      virtual ~vWinPrinter();
      vWinPrinter(const vWinPrinter& pr);

      vWinPrinter& operator =(const vWinPrinter& pr);

      int GetHeight() {return _height;}
      int GetWidth() {return _width;}

      char* GetDocName() {return _name;}

      int GetPortrait(){return _portrait;}
      void SetPortrait(int p) {_portrait = p;}

      int GetUseColors() {return _useColor;}
      void SetUseColors(int c) {_useColor = c;}

      int GetPaper() {return _paperType;}
      char* GetPaperName();

      int GetCopies() {return _copies;}
      void SetCopies(int s) {_copies = s;}

      int GetToFile() {return _toFile;}
      int Setup(char* fn = 0);

      int GetJobID() {return _jobID;}
      void SetJobID(int s) {_jobID = s;}

      HPS GetHDC() { return _printhDC; }

      // intended for internal use only, minimal error checking
      HPS GetHDevC() { return _hPrintDevC; }
      HPS CreateHDC(void);
      VOID DestroyHDC(void);

      // os/2 callback
      int DynamicDlgProc(HWND hwnd, UINT msg, MPARAM mp1, MPARAM mp2);

    protected:        //--------------------------------------- protected

    private:          //--------------------------------------- private

      // these functions are for internal use only
      VOID EnumPrintQueues(HWND hWnd);
      VOID GetJobProps(PPRQINFO3 pPRQ, ULONG Option);
      BOOL CreateInfoDC(void);

      static int _instances;
      HPS _printhDC;

      // Printer attributes
      char* _name;            // name of stream
      LONG _copies;
      int _width;             // width of printer
      int _height;            // height of printer
      int _portrait;          // true if portrait, else landscape
      int _useColor;          // true if printer supports colors

      int _paperType;
      int _toFile;
      PVOID     _pMem;               // base pointer for printer info
      // OS/2 variables
      HDC       _hInfoDevC;
      HPS       _hInfoPS;
      HDC       _hPrintDevC;
      SIZEL     _PageSizel;          // size in PU_LOENGLISH (100dpi)
      SIZEL     _PhyPagePels;        // size in pixels
      SIZEL     _PrintOffsetSizel;
      LONG      _PrintRange;
      BOOL      _Collate;
      LONG      _Priority;
      CHAR      _QueueDesc[MAX_QUEUEDESC];
      CHAR      _QueueName[MAX_QUEUENAME];
      PPRQINFO3 _pPRQCurrent;
      ULONG     _SizePRQCurrent;
      PDRIVDATA _pDDCurrent;
      ULONG     _SizeDDCurrent;
      PPRQINFO3 _pPRQArray;
      ULONG     _SizePRQArray;
      PHCINFO   _pHCInfo;
      LONG      _SizeHC;
      ULONG     _ixCurrent;
      USHORT    _jobID;
  };

#endif
