//===============================================================
// vfilesel.cpp - vFileSelect class functions - Windows
//
// Copyright (C) 1995,1996,1997,1998  Bruce E. Wampler
//
// This file is part of the V C++ GUI Framework, and is covered
// under the terms of the GNU Library General Public License,
// Version 2. This library has NO WARRANTY. See the source file
// vapp.cxx for more complete information about license terms.
//===============================================================
#include <v/vos2.h>		// for OS/2 stuff
#include <v/vfilesel.h>		// our header
#include <v/vapp.h>
#include <v/vbasewin.h>

//===================>>> vFileSelect::vFileSelect <<<=======================
  vFileSelect::vFileSelect(vBaseWindow* bw, char* title) // constructor
  {
     _parentHWND = bw->winHwnd();	// track parent's HWND
     init();
  }
//===================>>> vFileSelect::vFileSelect <<<=======================
  vFileSelect::vFileSelect(vApp* aw, char* title)
  {
     _parentHWND = aw->winHwnd();	// track parent's HWND
     init();
  }
//===================>>> vFileSelect::init <<<=======================
  void vFileSelect::init()
  {
    memset(&fldlg,0,sizeof(FILEDLG));	// zap entire thing
    fldlg.cbSize = sizeof(FILEDLG);
  }
//======================>>> vFileSelect::FileSelect <<<=======================
  int vFileSelect::FileSelect(const char* msg, char* filename,
	const int maxlen, char** filter, int& filterIndex)
  {
    //	Show the file selection (open) dialog.
    //	returns 0 on cancel, 1 otherwise
    char title[sizeof(msg)+1];
    char fmask[CCHMAXPATH];
    fmask[0] = 0;

    buildFilter(fmask,filter,filterIndex);	// build a proper filter string
    strcpy(fldlg.szFullFile, fmask);

    fldlg.fl = FDS_CENTER | FDS_OPEN_DIALOG;
    strcpy(title, msg);
    fldlg.pszTitle = title;

    if (WinFileDlg (HWND_DESKTOP, _parentHWND, &fldlg) && fldlg.lReturn == DID_OK)
    {
	strncpy(filename, (char*)fldlg.szFullFile, maxlen);
	filterIndex = 0;           // filter index not supported in OS/2
	return 1;
    }
    return 0;   // user punted during selection
  }
//======================>>> vFileSelect::FileSelectSave <<<=======================
  int vFileSelect::FileSelectSave(const char* msg, char* filename,
	const int maxlen, char** filter, int& filterIndex)
  {
    //	Show the file selection (save as) dialog.
    //	returns 0 on cancel, 1 otherwise
    char title[sizeof(msg)+1];

    char fmask[CCHMAXPATH];
    fmask[0] = 0;
    buildFilter(fmask,filter,filterIndex);	// build a proper filter string
    strcpy(fldlg.szFullFile, fmask);

    strcpy(fldlg.szFullFile, filename);

    fldlg.fl = FDS_CENTER | FDS_SAVEAS_DIALOG | FDS_ENABLEFILELB;
    strcpy(title, msg);
    fldlg.pszTitle = title;

    if (WinFileDlg (HWND_DESKTOP, _parentHWND, &fldlg) && fldlg.lReturn == DID_OK)
    {
	strncpy(filename, (char*)fldlg.szFullFile, maxlen);
	filterIndex = 0;           // filter index not supported in OS/2
	return 1;
    }

    filename[0] = 0;    // user punted during selection
    return 0;
  }
//======================>>> vFileSelect::buildFilter <<<=======================
// OS/2 does not support a conventional filter list like the V model
// wants.  Filtering is done primarily on extended attributes of the
// file, rather than file name or extension.  OS/2 does support
// a single filename filter (eg. "*.c;*.cpp") so we can at least
// use the first entry in the filter list array.

void vFileSelect::buildFilter(char* fbuff, char** filter, int& fi)
{
  if (filter == 0 || *filter[0] == 0)
  {
    strcpy(fbuff,"");           // default is all files
    fi = 0;
  }
  else			        // copy the first line of filter over
  {
    strcpy(fbuff, filter[0]);
    fi = 0;
  }
}
