/*
 * This file is part of the portable Forth environment written in ANSI C.
 * Copyright (C) 1993  Dirk Uwe Zoller
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This file is version 0.9.5 of 15-May-94
 * Check for the latest version of this package via anonymous ftp at
 *	roxi.rz.fht-mannheim.de
 *	/pub/unix/languages/pfe-VERSION.tar.gz
 * Please direct any comments via internet to
 *	duz@roxi.rz.fht-mannheim.de.
 * Thank You.
 */
/*
 * block.c ---		The Optional Block Word Set
 * (duz 19Jul93)
 */

#include <string.h>
#include <limits.h>

#include "config.h"
#include "forth.h"
#include "support.h"


Code (block)
{
  *sp = (Cell)block (*sp);
}

Code (buffer)
{
  int n;
  *sp = (Cell)buffer (*sp, &n);
}

Code (empty_buffers)
{
  File *f = BLOCK_FILE;

  question_file_open (f);
  ZERO (f->buffer);
  f->n = UINT_MAX;
  f->updated = 0;
}

Code (flush)
{
  save_buffers_();
  empty_buffers_();
}

Code (list)
{
  int i;

  for (i = 0; i < 16; i++)
    {
      cr_();
      outf ("%2d: ", i);
      dot_line (*sp, i);
    }
  SCR = *sp++;
}

Code (load)
{
  load (*sp++);
}

code (save_buffers)
{
  File *f = BLOCK_FILE;
  if (f && f->updated)
    {
      read_write (f, f->buffer, f->n, FALSE);
      fflush (f->f);
      f->updated = 0;
    }
}

Code (thru)
{
  Cell i = sp [1];
  Cell n = sp [0];
  sp += 2;
  while (i <= n)
    load (i++);
}

code (update)
{
  question_file_open (BLOCK_FILE);
  BLOCK_FILE->updated = 1;
}

LISTWORDS (block) =
{
  SV ("BLK",		BLK),
  CO ("BLOCK",		block),
  CO ("BUFFER",		buffer),
  CO ("EMPTY-BUFFERS",	empty_buffers),
  CO ("FLUSH",		flush),
  CO ("LIST",		list),
  CO ("LOAD",		load),
  CO ("SAVE-BUFFERS",	save_buffers),
  SV ("SCR",		SCR),
  CO ("THRU",		thru),
  CO ("UPDATE",		update),
};
COUNTWORDS (block, "Block + extensions");
