/*
 * This file is part of the portable Forth environment written in ANSI C.
 * Copyright (C) 1993  Dirk Uwe Zoller
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This file is version 0.9.5 of 15-May-94
 * Check for the latest version of this package via anonymous ftp at
 *	roxi.rz.fht-mannheim.de
 *	/pub/unix/languages/pfe-VERSION.tar.gz
 * Please direct any comments via internet to
 *	duz@roxi.rz.fht-mannheim.de.
 * Thank You.
 */
/*
 * forth.h ---	gathers some common includes, types and variables for main.c .
 * (duz 08Feb93)
 */

#ifndef __FORTH_H
#define __FORTH_H

#ifndef FILE
#include <stdio.h>
#endif

#ifndef __CONFIG_H
#include "config.h"
#endif

#ifndef __CONST_H
#include "const.h"
#endif

#ifndef __TYPES_H
#include "types.h"
#endif

#ifndef __MACROS_H
#include "macros.h"
#endif

#ifndef __PRELOAD_H
#include "preload.h"
#endif


/* variables declared globally */

extern struct memory
	membot,			/* start of each area */
	memtop;			/* end of each area */

extern struct memsiz
	memsiz;			/* size of each area in cells */

extern Xt *	ip;		/* the instruction pointer */
extern Xt	w;		/* used inside the inner interpreter */
extern Cell *	sp;		/* the stack pointer */
extern Xt **	rp;		/* the return stack pointer */
extern Cell *	lp;		/* pointer to local variables */
extern double *	fp;		/* the floating point stack pointer */

extern int _argc;		/* exported command line options */
extern char **_argv;

extern struct sysvar sys;	/* all other FORTH variables */

extern struct options		/* this aggregate communicates command line */
{				/* options to the rest of the program */
	int	caps_on:1,	/* exchange lower and upper case chars */
		lower_case_on:1,/* make lower case words find upper case */
		lowcfn:1,	/* lower case file names */
		license:1,	/* show license string at startup */
		warranty:1,	/* show warranty string at startup */
		quiet:1,	/* no messages */
		verbose:1,	/* more messages */
		stdio:1,	/* standard input isn't-tty: work as filter */
		debug:1;	/* enable a few more outputs */
	int	cols, rows;	/* size of screen */
	uCell	total_size;
	uCell	stack_size;
	uCell	flt_stack_size;
	uCell	ret_stack_size;
	uCell	max_files;
	char *	save_dict;	/* dictionary image to build or NULL */
	char *	load_dict;	/* dictionary image to load or NULL */
	char *	pferc_file;	/* normally "~/.pferc" */
	char *	block_file;	/* block file to use initially */
	char *	include_file;	/* file to include initially */
	char *	incpaths;
	char *	incext;
	char *	blkpaths;
	char *	blkext;
	char *	editor;		/* preferred ASCII text file editor */
}
option;

extern char	version_string [],
		copyright_string [],
		license_string [],
		warranty_string [],
		compile_date [],
		compile_time [];

code (dot_memory);

void fatal (char *msg, ...);
Xt forth_signal (int sig, Xt xt);

#endif
