/*
 * This file is part of the portable Forth environment written in ANSI C.
 * Copyright (C) 1993  Dirk Uwe Zoller
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This file is version 0.9.5 of 15-May-94
 * Check for the latest version of this package via anonymous ftp at
 *	roxi.rz.fht-mannheim.de
 *	/pub/unix/languages/pfe-VERSION.tar.gz
 * Please direct any comments via internet to
 *	duz@roxi.rz.fht-mannheim.de.
 * Thank You.
 */
/*
 * preload.h ---	types, codes and macros for initial symbol table load
 * (duz 09Jul93)
 */

#ifndef __CONFIG_H
#include "config.h"
#endif

typedef struct			/* describe a word for registration */
{				/* in the dictionary */
  const char *name;		/* name of word */
  pCode ptr;			/* code it executes or something */
}				/* according to spc@pineal.math.fau.edu: */
Word;				/* 'void *' doesn't work here on SGI */

typedef struct			/* describes the set of words */
{				/* a module loads into the dictionary */
  int n;			/* how many words? */
  const Word *w;		/* pointer to vector of words */
#if DEBUG
  const char *name;		/* name of word set */
#endif
}
Words;

typedef struct			/* list of word sets to load into */
{				/* a word list */
  int n;			/* how many word lists? */
  const Words *const *ws;	/* pointer to vector of word sets */
  Wordl *wid;			/* pointer to word list */
}
preloadList;

extern preloadList only_list;
extern preloadList forth_list;
extern preloadList extensions_list;
extern const preloadList *preload_list [];
extern const int preload_lists;

#ifdef OLDCPP

#define LISTWORDS(SET)\
	static Word SET/**/_word []
#if DEBUG
#define COUNTWORDS(SET,NAME)\
	Words SET/**/_words = { DIM (SET/**/_word), SET/**/_word, NAME }
#else
#define COUNTWORDS(SET,NAME)\
	Words SET/**/_words = { DIM (SET/**/_word), SET/**/_word }
#endif

#elif defined (__cplusplus)

#define LISTWORDS(SET)\
	static const Word SET##_word []
#if DEBUG
#define COUNTWORDS(SET,NAME)\
	extern const Words SET##_words = { DIM (SET##_word), SET##_word, NAME }
#else
#define COUNTWORDS(SET,NAME)\
	extern const Words SET##_words = { DIM (SET##_word), SET##_word }
#endif

#else

#define LISTWORDS(SET)\
	static const Word SET##_word []
#if DEBUG
#define COUNTWORDS(SET,NAME)\
	const Words SET##_words = { DIM (SET##_word), SET##_word, NAME }
#else
#define COUNTWORDS(SET,NAME)\
	const Words SET##_words = { DIM (SET##_word), SET##_word }
#endif

#endif

enum				/* encoding the kind of definition */
{				/* i.e. which runtime to fill into the cfa: */
  CO_def = 0100,		/*  code definition */
  CI_def,			/*  immediate code definition */
  CS_def,			/*  immediate state smart words */
  SV_def,			/*  system variable */
  SD_def,			/*  dictionary related system variable */
  SC_def,			/*  system constant */
  OC_def,			/*  ordinary constant */
  VO_def,			/*  vocabulary */
  OY_def			/*  the special only vocabulary */
};

/* macros to build entries in the wordlists: */
#ifdef OLDCPP
#define	CO(NM,PCODE)		{ "\100"NM, PCODE/**/_ }
#define	CI(NM,PCODE)		{ "\101"NM, PCODE/**/_ }
#define CS(NM,SEM)		{ "\102"NM, (pCode)&SEM/**/_semantics }
#else
#define	CO(NM,PCODE)		{ "\100"NM, PCODE##_ }
#define	CI(NM,PCODE)		{ "\101"NM, PCODE##_ }
#define CS(NM,SEM)		{ "\102"NM, (pCode)&SEM##_semantics }
#endif
#define	SV(NM,VAR)		{ "\103"NM, (pCode)&(VAR) }
#define	SD(NM,COMPONENT)	{ "\104"NM, (pCode)OFFSET_OF(Dict, COMPONENT) }
#define	SC(NM,VAR)		{ "\105"NM, (pCode)&(VAR) }
#define	OC(NM,VAL)		{ "\106"NM, (pCode)(VAL) }
#define	VO(NM,LIST)		{ "\107"NM, (pCode)(LIST) }
#define	OY(NM,LIST)		{ "\110"NM, (pCode)(LIST) }
