/*
 * This file is part of the portable Forth environment written in ANSI C.
 * Copyright (C) 1993  Dirk Uwe Zoller
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This file is version 0.9.5 of 15-May-94
 * Check for the latest version of this package via anonymous ftp at
 *	roxi.rz.fht-mannheim.de
 *	/pub/unix/languages/pfe-VERSION.tar.gz
 * Please direct any comments via internet to
 *	duz@roxi.rz.fht-mannheim.de.
 * Thank You.
 */
/*
 * term-emx.c ---	Terminal driver for DOS and OS/2 with EMX,
 *			there is almost nothing to do.
 * (duz 24Feb94)
 */

#include <stdlib.h>		/* _read_kbd() */
#include <sys/video.h>		/* all those v_...() functions */

#include "forth.h"
#include "term.h"

Byte *
rawkey_string [NO_OF_KEYS] =	/* what function keys send */
{
  "\377;", "\377<", "\377=", "\377>", "\377?",
  "\377@", "\377A", "\377B", "\377C", "\377D",
  "\377K", "\377M", "\377H", "\377P",
  "\377G", "\377O", "\377Q", "\377I",
  NULL,	   "\377S", NULL,    "\377R",
  NULL,    NULL,    NULL,    NULL,    /*"\r"*/
};

int set_interrupt_key (char ch)		{ return 0; }
void interactive_terminal (void)	{ v_init (); }
void system_terminal (void)		{}
void query_winsize (void)		{}

int
prepare_terminal (void)
{
  v_init ();
  v_dimen (&cols, &rows);
  return 1;
}

#define NOCH 0x789ABCDE
static int nxch = NOCH;

int
keypressed (void)
{
  int c;

  if (nxch != NOCH)
    return 1;
  c = _read_kbd (0, 0, 0);
  if (c == -1)
    return 0;
  nxch = c;
  return 1;
}

static int
getch0 (void)
{
  if (nxch != NOCH)
    {
      int ch = nxch;
      nxch = NOCH;
      return ch;
    }
  return _read_kbd (0, 1, 0);
}

int				/* return '\377' instead of DOS' '\0' */
getkey (void)			/* for function keys. */
{
  int c = getch0 ();
  return c == 0 ? '\377' : c;
}

void cputc (int c)		{ v_putc (c); }
void cputs (const char *s)	{ v_puts (s); }

void gotoxy (int x, int y)	{ v_gotoxy (x, y); }
void wherexy (int *x, int *y)	{ v_getxy (x, y); }

static void
addxy (int x, int y)
{
  int col, row;
  v_getxy (&col, &row);
  v_gotoxy (col + x, row + y);
}

void goleft (void)		{ addxy (-1,  0); }
void goright (void)		{ addxy ( 1,  0); }
void goup (void)		{ addxy ( 0, -1); }
void godown (void)		{ addxy ( 0,  1); }

/*void clrscr (void)		{ v_clear (); }*/
void clrscr (void)		{ home (); clrdown (); }
void home (void)		{ v_gotoxy (0, 0); }
void clreol (void)		{ v_clreol (); }

void
clrdown (void)
{
  int i, row, col;

  v_getxy (&col, &row);
  v_clreol ();
  for (i = row + 1; i < rows; i++)
    {
      gotoxy (0, i);
      clreol ();
    }
  gotoxy (col, row);
}

void bing (void)		{ putchar ('\a'); }

void standout_on (void)		{ v_attrib (v_getattr () | INTENSITY); }
void standout_off (void)	{ v_attrib (v_getattr () & ~INTENSITY); }
void bright (void)		{ standout_on (); }
void reverse (void)		{ v_attrib (BW_REVERSE); }
void blinking (void)		{ v_attrib (v_getattr () | BLINK); }
void normal (void)		{ v_attrib (BW_NORMAL); }
void underline_on (void)	{ v_attrib (BW_UNDERLINE); }
void underline_off (void)	{ v_attrib (BW_NORMAL); }
