package bench;
import java.util.Vector;


public class RunTests
{
    public static void main(String argv[])
        throws InstantiationException,
               ClassNotFoundException,
               IllegalAccessException
    {
        long totalTime = 0;
        TestData tests[] = {
          new TestData(new Dhrystone(), 30000, 10),
          new TestData(new BubbleSortAlgorithm(), 10000, 0),
          new TestData(new BidirectionalBubbleSortAlgorithm(), 10000, 0),
          new TestData(new HeapSortAlgorithm(), 500000, 0),
          new TestData(new QSortAlgorithm(), 500000, 0),
          new TestData(new Sieve(), 4095, 1000),
          new TestData(new Hanoi(), 22, 22),
          new TestData(new Fibonacchi(), 12000, 1500),
          new TestData(new Tree(), 200000, 0) };

        int i =0; 

        while ( i < tests.length)
        {
            totalTime += runTest(tests[i]);
            System.gc();

            i++;
        }

        System.out.println("Total   Time = " + totalTime);

    }

    static long runTest(TestData data)
    {
        TestBase test=data.test;
        long     time;

        test.setData(data.p1, data.p2);
        System.out.println("Running " + data.test + "...");
        time = test.runTest();
        System.out.println("   Test took " + time + " milliseconds to execute.\n");

        return time;
    }
}


class TestData
{
    TestBase test;
    int p1;
    int p2;

    TestData(TestBase t, int x, int y)
    {
        test = t;
        p1   = x;
        p2   = y;
    }
}
