implementation module deltaIOState

import StdBool
import windowDevice, ioState, deltaIOSystem

/*	Set the shape of the cursor globally. This shape overrules the local cursor
		  shapes of windows. */
SetGlobalCursor:: !CursorShape !(IOState s) -> IOState s
SetGlobalCursor cursor io = io

/*	ResetCursor undoes the effect of SetGlobalCursor. */
ResetCursor	:: !(IOState s) -> IOState s
ResetCursor io = io

/*	ObscureCursor hides the cursor until the mouse is moved. */

ObscureCursor	:: !(IOState s) -> IOState s
ObscureCursor io = io

/*	SetDoubleDownDistance sets the double down distance of the mouse. Negative values are
		  set to zero. */

SetDoubleDownDistance	:: !Int !(IOState s) -> IOState s
SetDoubleDownDistance new_dddist io
		= io

